/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SingleCharacterPrefixRule
implements IRule {
    protected char fPrefix;
    protected IToken fToken;
    protected int fMinLength;
    protected int fMaxLength;
    private StringBuffer fWord;

    public SingleCharacterPrefixRule(char c, IToken iToken, int n, int n2) {
        this.fPrefix = c;
        Assert.isNotNull((Object)iToken);
        this.fToken = iToken;
        Assert.isLegal((n >= 1 ? 1 : 0) != 0);
        this.fMinLength = n;
        Assert.isLegal((n2 >= 1 ? 1 : 0) != 0);
        this.fMaxLength = n2;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        int n2 = 1;
        this.fWord = new StringBuffer();
        if ((char)n == this.fPrefix) {
            this.fWord.append((char)n);
            while (true) {
                if (!this.isValidCharacter(n = iCharacterScanner.read(), n2)) {
                    if (!this.isValidEndCharacter(n, n2)) {
                        iCharacterScanner.unread();
                    } else {
                        this.fWord.append((char)n);
                        ++n2;
                    }
                    if (!this.lengthInRange(n2) || !this.wordValid(this.fWord.toString())) {
                        return Token.UNDEFINED;
                    }
                    return this.fToken;
                }
                this.fWord.append((char)n);
                ++n2;
            }
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    protected boolean wordValid(String string) {
        return true;
    }

    protected boolean isValidEndCharacter(int n, int n2) {
        return false;
    }

    protected boolean isValidCharacter(int n, int n2) {
        return n != -1 && !Character.isWhitespace((char)n);
    }

    protected boolean lengthInRange(int n) {
        return n >= this.fMinLength && n <= this.fMaxLength;
    }
}

