/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.symbols.ClassSymbol;
import org.rubypeople.rdt.internal.core.symbols.ISymbolFinder;
import org.rubypeople.rdt.internal.core.symbols.Symbol;
import org.rubypeople.rdt.testunit.views.OpenSymbolAction;
import org.rubypeople.rdt.testunit.views.RerunAction;
import org.rubypeople.rdt.testunit.views.TestRunInfo;
import org.rubypeople.rdt.testunit.views.TestRunTab;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;
import org.rubypeople.rdt.testunit.views.TestUnitView;

public class TestHierarchyTab
extends TestRunTab
implements IMenuListener {
    private Tree fTree;
    private TreeItem fCachedParent;
    private TreeItem[] fCachedItems;
    private TreeItem fLastParent;
    private List fExecutionPath;
    private boolean fMoveSelection = false;
    private Vector fSuiteInfos = new Vector();
    private Map fTreeItemMap = new HashMap();
    private TestUnitView fTestRunnerPart;
    private final Image fOkIcon = TestUnitView.createImage("obj16/testok.gif");
    private final Image fErrorIcon = TestUnitView.createImage("obj16/testerr.gif");
    private final Image fFailureIcon = TestUnitView.createImage("obj16/testfail.gif");
    private final Image fHierarchyIcon = TestUnitView.createImage("obj16/testhier.gif");
    private final Image fSuiteIcon = TestUnitView.createImage("obj16/tsuite.gif");
    private final Image fSuiteErrorIcon = TestUnitView.createImage("obj16/tsuiteerror.gif");
    private final Image fSuiteFailIcon = TestUnitView.createImage("obj16/tsuitefail.gif");
    private final Image fTestIcon = TestUnitView.createImage("obj16/test.gif");
    private final Image fTestRunningIcon = TestUnitView.createImage("obj16/testrun.gif");
    private final Image fSuiteRunningIcon = TestUnitView.createImage("obj16/tsuiterun.gif");

    public void createTabControl(CTabFolder cTabFolder, Clipboard clipboard, TestUnitView testUnitView) {
        this.fTestRunnerPart = testUnitView;
        CTabItem cTabItem = new CTabItem(cTabFolder, 0);
        cTabItem.setText(this.getName());
        cTabItem.setImage(this.fHierarchyIcon);
        Composite composite = new Composite((Composite)cTabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1536);
        composite.setLayoutData((Object)gridData);
        cTabItem.setControl((Control)composite);
        cTabItem.setToolTipText(TestUnitMessages.getString("HierarchyRunView.tab.tooltip"));
        this.fTree = new Tree(composite, 516);
        gridData = new GridData(1808);
        this.fTree.setLayoutData((Object)gridData);
        this.initMenu();
        this.addListeners();
    }

    void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        this.fOkIcon.dispose();
        this.fHierarchyIcon.dispose();
        this.fTestIcon.dispose();
        this.fTestRunningIcon.dispose();
        this.fSuiteRunningIcon.dispose();
        this.fSuiteIcon.dispose();
        this.fSuiteErrorIcon.dispose();
        this.fSuiteFailIcon.dispose();
    }

    private void initMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu((Control)this.fTree);
        this.fTree.setMenu(menu);
    }

    private String getTestMethod() {
        return this.getTestInfo().getTestMethodName();
    }

    private TestRunInfo getTestInfo() {
        TreeItem[] treeItemArray = this.fTree.getSelection();
        if (treeItemArray.length == 0) {
            return null;
        }
        return (TestRunInfo)treeItemArray[0].getData();
    }

    private boolean isSuiteSelected() {
        TreeItem[] treeItemArray = this.fTree.getSelection();
        if (treeItemArray.length != 1) {
            return false;
        }
        return treeItemArray[0].getItemCount() > 0;
    }

    private String getClassName() {
        return this.getTestInfo().getClassName();
    }

    public String getSelectedTestId() {
        TestRunInfo testRunInfo = this.getTestInfo();
        if (testRunInfo == null) {
            return null;
        }
        return testRunInfo.getTestId();
    }

    public String getName() {
        return TestUnitMessages.getString("HierarchyRunView.tab.title");
    }

    public void setSelectedTest(String string) {
        TreeItem treeItem = this.findTreeItem(string);
        if (treeItem != null) {
            this.fTree.setSelection(new TreeItem[]{treeItem});
        }
    }

    public void startTest(String string) {
        TreeItem treeItem = this.findTreeItem(string);
        if (treeItem == null) {
            return;
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        if (this.fLastParent != treeItem2) {
            this.updatePath(treeItem2);
            this.fLastParent = treeItem2;
        }
        this.setCurrentItem(treeItem);
    }

    private void updatePath(TreeItem treeItem) {
        ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
        while (treeItem != null) {
            arrayList.add(treeItem);
            treeItem = treeItem.getParentItem();
        }
        Collections.reverse(arrayList);
        ListIterator listIterator = this.fExecutionPath.listIterator();
        ListIterator listIterator2 = arrayList.listIterator();
        int n = 0;
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            if (listIterator.next() != listIterator2.next()) break;
            ++n;
        }
        ListIterator listIterator3 = this.fExecutionPath.listIterator(n);
        while (listIterator3.hasNext()) {
            this.refreshItem((TreeItem)listIterator3.next(), false);
        }
        listIterator3 = arrayList.listIterator(n);
        while (listIterator3.hasNext()) {
            this.refreshItem((TreeItem)listIterator3.next(), true);
        }
        this.fExecutionPath = arrayList;
    }

    private void refreshItem(TreeItem treeItem, boolean bl) {
        if (bl) {
            treeItem.setImage(this.fSuiteRunningIcon);
        } else {
            TestRunInfo testRunInfo = this.getTestRunInfo(treeItem);
            switch (testRunInfo.getStatus()) {
                case 1: {
                    treeItem.setImage(this.fSuiteErrorIcon);
                    break;
                }
                case 2: {
                    treeItem.setImage(this.fSuiteFailIcon);
                    break;
                }
                default: {
                    treeItem.setImage(this.fSuiteIcon);
                }
            }
        }
    }

    private void setCurrentItem(TreeItem treeItem) {
        treeItem.setImage(this.fTestRunningIcon);
        TreeItem treeItem2 = treeItem.getParentItem();
        if (this.fTestRunnerPart.isAutoScroll()) {
            this.fTree.showItem(treeItem);
            while (treeItem2 != null) {
                if (treeItem2.getExpanded()) break;
                treeItem2.setExpanded(true);
                treeItem2 = treeItem2.getParentItem();
            }
        }
    }

    public void endTest(String string) {
        TreeItem treeItem = this.findTreeItem(string);
        if (treeItem == null) {
            return;
        }
        TestRunInfo testRunInfo = this.fTestRunnerPart.getTestInfo(string);
        if (testRunInfo == null) {
            return;
        }
        this.updateItem(treeItem, testRunInfo);
        if (this.fTestRunnerPart.isAutoScroll()) {
            this.fTree.showItem(treeItem);
            this.cacheItems(treeItem);
            this.collapsePassedTests(treeItem);
        }
    }

    private void cacheItems(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 == this.fCachedParent) {
            return;
        }
        this.fCachedItems = treeItem2.getItems();
        this.fCachedParent = treeItem2;
    }

    private void collapsePassedTests(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 != null) {
            TreeItem[] treeItemArray = null;
            treeItemArray = treeItem2 == this.fCachedParent ? this.fCachedItems : treeItem2.getItems();
            if (this.isLast(treeItem, treeItemArray)) {
                boolean bl = true;
                int n = 0;
                while (n < treeItemArray.length) {
                    if (this.isFailure(treeItemArray[n])) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    treeItem2.setExpanded(false);
                    this.collapsePassedTests(treeItem2);
                }
            }
        }
    }

    private boolean isLast(TreeItem treeItem, TreeItem[] treeItemArray) {
        return treeItemArray[treeItemArray.length - 1] == treeItem;
    }

    private void updateItem(TreeItem treeItem, TestRunInfo testRunInfo) {
        treeItem.setData((Object)testRunInfo);
        if (testRunInfo.getStatus() == 0) {
            treeItem.setImage(this.fOkIcon);
            return;
        }
        if (testRunInfo.getStatus() == 2) {
            treeItem.setImage(this.fFailureIcon);
        } else if (testRunInfo.getStatus() == 1) {
            treeItem.setImage(this.fErrorIcon);
        }
        this.propagateStatus(treeItem, testRunInfo.getStatus());
    }

    private void propagateStatus(TreeItem treeItem, int n) {
        TreeItem treeItem2 = treeItem.getParentItem();
        TestRunInfo testRunInfo = this.getTestRunInfo(treeItem);
        if (treeItem2 == null) {
            return;
        }
        TestRunInfo testRunInfo2 = this.getTestRunInfo(treeItem2);
        int n2 = testRunInfo2.getStatus();
        if (n == 2) {
            if (n2 == 1 || n2 == 2) {
                return;
            }
            testRunInfo2.setStatus(2);
            testRunInfo.setStatus(2);
        } else {
            if (n2 == 1) {
                return;
            }
            testRunInfo2.setStatus(1);
            testRunInfo.setStatus(1);
        }
        this.propagateStatus(treeItem2, n);
    }

    private TestRunInfo getTestRunInfo(TreeItem treeItem) {
        return (TestRunInfo)treeItem.getData();
    }

    public void activate() {
        this.fMoveSelection = false;
        this.testSelected();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    public void aboutToStart() {
        this.fTree.removeAll();
        this.fSuiteInfos.removeAllElements();
        this.fTreeItemMap = new HashMap();
        this.fCachedParent = null;
        this.fCachedItems = null;
        this.fMoveSelection = false;
        this.fExecutionPath = new ArrayList();
    }

    private void testSelected() {
        this.fTestRunnerPart.handleTestSelected(this.getSelectedTestId());
    }

    private void addListeners() {
        this.fTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TestHierarchyTab.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TestHierarchyTab.this.activate();
            }
        });
        this.fTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TestHierarchyTab.this.disposeIcons();
            }
        });
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TestHierarchyTab.this.handleDoubleClick(mouseEvent);
            }
        });
    }

    void handleDoubleClick(MouseEvent mouseEvent) {
        TestRunInfo testRunInfo = this.getTestInfo();
        if (testRunInfo == null) {
            return;
        }
        testRunInfo.getTestName();
        IAction iAction = null;
        Shell shell = this.fTree.getShell();
        ISymbolFinder iSymbolFinder = RubyCore.getPlugin().getSymbolFinder();
        iAction = this.isSuiteSelected() ? OpenSymbolAction.forClass(this.getClassName(), iSymbolFinder, shell) : OpenSymbolAction.forMethod(this.getClassName(), this.getTestMethod(), iSymbolFinder, shell);
        if (iAction != null && iAction.isEnabled()) {
            iAction.run();
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        if (this.fTree.getSelectionCount() > 0) {
            TreeItem treeItem = this.fTree.getSelection()[0];
            TestRunInfo testRunInfo = (TestRunInfo)treeItem.getData();
            testRunInfo.getTestName();
            Shell shell = this.fTree.getShell();
            ISymbolFinder iSymbolFinder = RubyCore.getPlugin().getSymbolFinder();
            if (this.isSuiteSelected()) {
                iMenuManager.add(OpenSymbolAction.forClass(this.getClassName(), iSymbolFinder, shell));
                iMenuManager.add((IContributionItem)new Separator());
                if (this.testClassExists(this.getClassName()) && !this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
                    iMenuManager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), null, "run"));
                    iMenuManager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), null, "debug"));
                }
            } else {
                iMenuManager.add(OpenSymbolAction.forMethod(this.getClassName(), this.getTestMethod(), iSymbolFinder, shell));
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), this.getTestMethod(), "run"));
                iMenuManager.add((IAction)new RerunAction(this.fTestRunnerPart, this.getSelectedTestId(), this.getClassName(), this.getTestMethod(), "debug"));
            }
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IAction)new ExpandAllAction());
        }
    }

    private boolean testClassExists(String string) {
        return RubyCore.getPlugin().getSymbolFinder().find((Symbol)new ClassSymbol(string)).size() > 0;
    }

    public void newTreeEntry(String string) {
        TreeItem treeItem;
        int n = string.indexOf(44);
        StringBuffer stringBuffer = new StringBuffer(100);
        int n2 = this.scanTestName(string, n + 1, stringBuffer);
        int n3 = string.indexOf(44, n2 + 1);
        String string2 = stringBuffer.toString().trim();
        String string3 = string.substring(0, n);
        TestRunInfo testRunInfo = new TestRunInfo(string3, string2);
        String string4 = string.substring(n2 + 1, n3);
        int n4 = Integer.parseInt(string.substring(n3 + 1));
        while (this.fSuiteInfos.size() > 0 && ((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount == 0) {
            this.fSuiteInfos.removeElementAt(this.fSuiteInfos.size() - 1);
        }
        if (this.fSuiteInfos.size() == 0) {
            treeItem = new TreeItem(this.fTree, 0);
            treeItem.setImage(this.fSuiteIcon);
            this.fSuiteInfos.addElement(new SuiteInfo(treeItem, n4));
        } else if (string4.equals("true")) {
            treeItem = new TreeItem(((SuiteInfo)this.fSuiteInfos.lastElement()).fTreeItem, 0);
            treeItem.setImage(this.fSuiteIcon);
            --((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount;
            this.fSuiteInfos.addElement(new SuiteInfo(treeItem, n4));
        } else {
            treeItem = new TreeItem(((SuiteInfo)this.fSuiteInfos.lastElement()).fTreeItem, 0);
            treeItem.setImage(this.fTestIcon);
            --((SuiteInfo)this.fSuiteInfos.lastElement()).fTestCount;
            this.mapTest(testRunInfo, treeItem);
        }
        treeItem.setText(testRunInfo.getTestMethodName());
        treeItem.setData((Object)testRunInfo);
    }

    private int scanTestName(String string, int n, StringBuffer stringBuffer) {
        boolean bl = false;
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\\' && !bl) {
                bl = true;
            } else if (bl) {
                bl = false;
                stringBuffer.append(c);
            } else {
                if (c == ',') break;
                stringBuffer.append(c);
            }
            ++n2;
        }
        return n2;
    }

    private void mapTest(TestRunInfo testRunInfo, TreeItem treeItem) {
        this.fTreeItemMap.put(testRunInfo.getTestId(), treeItem);
    }

    private TreeItem findTreeItem(String string) {
        Object v = this.fTreeItemMap.get(string);
        if (v instanceof TreeItem) {
            return (TreeItem)v;
        }
        return null;
    }

    public void testStatusChanged(TestRunInfo testRunInfo) {
        Object v = this.fTreeItemMap.get(testRunInfo.getTestId());
        if (v instanceof TreeItem) {
            this.updateItem((TreeItem)v, testRunInfo);
            return;
        }
    }

    public void selectNext() {
        TreeItem treeItem = this.getInitialSearchSelection();
        if (!this.moveSelection(treeItem)) {
            return;
        }
        TreeItem treeItem2 = this.findFailure(treeItem, true, !this.isLeafFailure(treeItem));
        if (treeItem2 != null) {
            this.selectTest(treeItem2);
        }
    }

    public void selectPrevious() {
        TreeItem treeItem = this.getInitialSearchSelection();
        if (!this.moveSelection(treeItem)) {
            return;
        }
        TreeItem treeItem2 = this.findFailure(treeItem, false, !this.isLeafFailure(treeItem));
        if (treeItem2 != null) {
            this.selectTest(treeItem2);
        }
    }

    private boolean moveSelection(TreeItem treeItem) {
        if (!this.fMoveSelection) {
            this.fMoveSelection = true;
            if (this.isLeafFailure(treeItem)) {
                this.selectTest(treeItem);
                return false;
            }
        }
        return true;
    }

    private TreeItem getInitialSearchSelection() {
        TreeItem[] treeItemArray = this.fTree.getSelection();
        TreeItem treeItem = null;
        treeItem = treeItemArray.length == 0 ? this.fTree.getItems()[0] : treeItemArray[0];
        return treeItem;
    }

    private boolean isFailure(TreeItem treeItem) {
        return this.getTestRunInfo(treeItem).getStatus() != 0;
    }

    private boolean isLeafFailure(TreeItem treeItem) {
        boolean bl;
        boolean bl2 = bl = treeItem.getItemCount() == 0;
        return bl && this.isFailure(treeItem);
    }

    private void selectTest(TreeItem treeItem) {
        this.fTestRunnerPart.showTest(this.getTestRunInfo(treeItem));
    }

    private TreeItem findFailure(TreeItem treeItem, boolean bl, boolean bl2) {
        int n;
        TreeItem[] treeItemArray = this.findSiblings(treeItem, bl, bl2);
        if (bl) {
            n = 0;
            while (n < treeItemArray.length) {
                TreeItem treeItem2 = this.findFailureInTree(treeItemArray[n]);
                if (treeItem2 != null) {
                    return treeItem2;
                }
                ++n;
            }
        } else {
            n = treeItemArray.length - 1;
            while (n >= 0) {
                TreeItem treeItem3 = this.findFailureInTree(treeItemArray[n]);
                if (treeItem3 != null) {
                    return treeItem3;
                }
                --n;
            }
        }
        TreeItem treeItem4 = treeItem.getParentItem();
        if (treeItem4 == null) {
            return null;
        }
        return this.findFailure(treeItem4, bl, false);
    }

    private TreeItem[] findSiblings(TreeItem treeItem, boolean bl, boolean bl2) {
        TreeItem treeItem2 = treeItem.getParentItem();
        TreeItem[] treeItemArray = null;
        treeItemArray = treeItem2 == null ? treeItem.getParent().getItems() : treeItem2.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem treeItem3 = treeItemArray[n];
            if (treeItem3 == treeItem) {
                TreeItem[] treeItemArray2 = null;
                if (bl) {
                    if (!bl2) {
                        treeItemArray2 = new TreeItem[treeItemArray.length - n - 1];
                        System.arraycopy(treeItemArray, n + 1, treeItemArray2, 0, treeItemArray.length - n - 1);
                    } else {
                        treeItemArray2 = new TreeItem[treeItemArray.length - n];
                        System.arraycopy(treeItemArray, n, treeItemArray2, 0, treeItemArray.length - n);
                    }
                } else if (!bl2) {
                    treeItemArray2 = new TreeItem[n];
                    System.arraycopy(treeItemArray, 0, treeItemArray2, 0, n);
                } else {
                    treeItemArray2 = new TreeItem[n + 1];
                    System.arraycopy(treeItemArray, 0, treeItemArray2, 0, n + 1);
                }
                return treeItemArray2;
            }
            ++n;
        }
        return new TreeItem[0];
    }

    private TreeItem findFailureInTree(TreeItem treeItem) {
        if (treeItem.getItemCount() == 0 && this.isFailure(treeItem)) {
            return treeItem;
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem treeItem2 = this.findFailureInTree(treeItemArray[n]);
            if (treeItem2 != null) {
                return treeItem2;
            }
            ++n;
        }
        return null;
    }

    protected void expandAll() {
        TreeItem[] treeItemArray = this.fTree.getSelection();
        this.fTree.setRedraw(false);
        int n = 0;
        while (n < treeItemArray.length) {
            this.expandAll(treeItemArray[n]);
            ++n;
        }
        this.fTree.setRedraw(true);
    }

    private void expandAll(TreeItem treeItem) {
        treeItem.setExpanded(true);
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            this.expandAll(treeItemArray[n]);
            ++n;
        }
    }

    public void aboutToEnd() {
        int n = 0;
        while (n < this.fExecutionPath.size()) {
            this.refreshItem((TreeItem)this.fExecutionPath.get(n), false);
            ++n;
        }
    }

    private static class SuiteInfo {
        public int fTestCount;
        public TreeItem fTreeItem;

        public SuiteInfo(TreeItem treeItem, int n) {
            this.fTreeItem = treeItem;
            this.fTestCount = n;
        }
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(TestUnitMessages.getString("ExpandAllAction.text"));
            this.setToolTipText(TestUnitMessages.getString("ExpandAllAction.tooltip"));
        }

        public void run() {
            TestHierarchyTab.this.expandAll();
        }
    }
}

