/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.PatternStrings;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FixedJavaSearchPage
extends DialogPage
implements ISearchPage,
IJavaSearchConstants {
    public static final String PARTICIPANT_EXTENSION_POINT = "org.eclipse.jdt.ui.queryParticipants";
    public static final String EXTENSION_POINT_ID = "org.eclipse.jdt.ui.JavaSearchPage";
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "JavaSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private final List fPreviousSearchPatterns;
    private SearchPatternData fInitialData;
    private IJavaElement fJavaElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private Button[] fSearchFor;
    private String[] fSearchForText = new String[]{SearchMessages.SearchPage_searchFor_type, SearchMessages.SearchPage_searchFor_method, SearchMessages.SearchPage_searchFor_package, SearchMessages.SearchPage_searchFor_constructor, SearchMessages.SearchPage_searchFor_field};
    private Button[] fLimitTo;
    private String[] fLimitToText = new String[]{SearchMessages.SearchPage_limitTo_declarations, SearchMessages.SearchPage_limitTo_implementors, SearchMessages.SearchPage_limitTo_references, SearchMessages.SearchPage_limitTo_allOccurrences, SearchMessages.SearchPage_limitTo_readReferences, SearchMessages.SearchPage_limitTo_writeReferences};
    private Button fIncludeJRECheckbox;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FixedJavaSearchPage() {
        this.fPreviousSearchPatterns = new ArrayList();
    }

    public boolean performAction() {
        return this.performNewSearch();
    }

    private boolean performNewSearch() {
        SearchPatternData data = this.getPatternData();
        IJavaSearchScope scope = null;
        String scopeDescription = "";
        boolean includeJRE = data.includesJRE();
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scopeDescription = factory.getWorkspaceScopeDescription(includeJRE);
                scope = factory.createWorkspaceScope(includeJRE);
                break;
            }
            case 1: {
                IJavaElement[] javaElements = factory.getJavaElements(this.getContainer().getSelection());
                scope = factory.createJavaSearchScope(javaElements, includeJRE);
                scopeDescription = factory.getSelectionScopeDescription(javaElements, includeJRE);
                break;
            }
            case 3: {
                String[] projectNames = this.getContainer().getSelectedProjectNames();
                scope = factory.createJavaProjectSearchScope(projectNames, includeJRE);
                scopeDescription = factory.getProjectScopeDescription(projectNames, includeJRE);
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = factory.getWorkingSetScopeDescription(workingSets, includeJRE);
                scope = factory.createJavaSearchScope(workingSets, includeJRE);
                SearchUtil.updateLRUWorkingSets((IWorkingSet[])workingSets);
            }
        }
        PatternQuerySpecification querySpec = null;
        querySpec = new PatternQuerySpecification(data.getPattern(), data.getSearchFor(), data.isCaseSensitive(), data.getLimitTo(), scope, scopeDescription);
        data.setJavaElement(null);
        JavaSearchQuery textSearchJob = new JavaSearchQuery((QuerySpecification)querySpec);
        NewSearchUI.runQueryInBackground((ISearchQuery)textSearchJob);
        return true;
    }

    private int getLimitTo() {
        int i = 0;
        while (i < this.fLimitTo.length) {
            if (this.fLimitTo[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setLimitTo(int searchFor, int limitTo) {
        if (searchFor != 0 && searchFor != 6 && limitTo == 1) {
            limitTo = 2;
        }
        if (searchFor != 4 && (limitTo == 4 || limitTo == 5)) {
            limitTo = 2;
        }
        int i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].setSelection(limitTo == i);
            ++i;
        }
        this.fLimitTo[0].setEnabled(true);
        this.fLimitTo[1].setEnabled(searchFor == 6 || searchFor == 0);
        this.fLimitTo[2].setEnabled(true);
        this.fLimitTo[3].setEnabled(true);
        this.fLimitTo[4].setEnabled(searchFor == 4);
        this.fLimitTo[5].setEnabled(searchFor == 4);
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = ((SearchPatternData)this.fPreviousSearchPatterns.get(i)).getPattern();
            ++i;
        }
        return patterns;
    }

    private int getSearchFor() {
        int i = 0;
        while (i < this.fSearchFor.length) {
            if (this.fSearchFor[i].getSelection()) {
                return i;
            }
            ++i;
        }
        Assert.isTrue((boolean)false, (String)"shouldNeverHappen");
        return -1;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData findInPrevious(String pattern) {
        Iterator iter = this.fPreviousSearchPatterns.iterator();
        while (iter.hasNext()) {
            SearchPatternData element = (SearchPatternData)iter.next();
            if (!pattern.equals(element.getPattern())) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getPattern();
        SearchPatternData match = this.findInPrevious(pattern);
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getSearchFor(), this.getLimitTo(), pattern, this.fCaseSensitive.getSelection(), this.fJavaElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets(), this.fIncludeJRECheckbox.getSelection());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    public boolean isValid() {
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Control expressionComposite = this.createExpression(result);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        Control searchFor = this.createSearchFor(result);
        searchFor.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control limitTo = this.createLimitTo(result);
        limitTo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fIncludeJRECheckbox = new Button(result, 32);
        this.fIncludeJRECheckbox.setText(SearchMessages.SearchPage_searchJRE_label);
        this.fIncludeJRECheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        SelectionAdapter javaElementInitializer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FixedJavaSearchPage.this.getSearchFor() == FixedJavaSearchPage.this.fInitialData.getSearchFor()) {
                    FixedJavaSearchPage.this.fJavaElement = FixedJavaSearchPage.this.fInitialData.getJavaElement();
                } else {
                    FixedJavaSearchPage.this.fJavaElement = null;
                }
                FixedJavaSearchPage.this.setLimitTo(FixedJavaSearchPage.this.getSearchFor(), FixedJavaSearchPage.this.getLimitTo());
                FixedJavaSearchPage.this.doPatternModified();
            }
        };
        this.fSearchFor[0].addSelectionListener((SelectionListener)javaElementInitializer);
        this.fSearchFor[1].addSelectionListener((SelectionListener)javaElementInitializer);
        this.fSearchFor[4].addSelectionListener((SelectionListener)javaElementInitializer);
        this.fSearchFor[3].addSelectionListener((SelectionListener)javaElementInitializer);
        this.fSearchFor[2].addSelectionListener((SelectionListener)javaElementInitializer);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.jdt.ui.java_search_page_context");
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 16384);
        label.setText(SearchMessages.SearchPage_expression_label);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.fPattern = new Combo(result, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedJavaSearchPage.this.handlePatternSelected();
                FixedJavaSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FixedJavaSearchPage.this.doPatternModified();
                FixedJavaSearchPage.this.updateOKStatus();
            }
        });
        TextFieldNavigationHandler.install((Combo)this.fPattern);
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        this.fCaseSensitive = new Button(result, 32);
        this.fCaseSensitive.setText(SearchMessages.SearchPage_expression_caseSensitive);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedJavaSearchPage.this.fIsCaseSensitive = FixedJavaSearchPage.this.fCaseSensitive.getSelection();
            }
        });
        this.fCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    final void updateOKStatus() {
        boolean isValid = this.isValidSearchPattern();
        this.getContainer().setPerformActionEnabled(isValid);
    }

    private boolean isValidSearchPattern() {
        if (this.getPattern().length() == 0) {
            return false;
        }
        if (this.fJavaElement != null) {
            return true;
        }
        return SearchPattern.createPattern((String)this.getPattern(), (int)this.getSearchFor(), (int)this.getLimitTo(), (int)0) != null;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private void doPatternModified() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.getPattern()) && this.fInitialData.getJavaElement() != null && this.fInitialData.getSearchFor() == this.getSearchFor()) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
            this.fJavaElement = this.fInitialData.getJavaElement();
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
            this.fJavaElement = null;
        }
    }

    private void handlePatternSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData initialData = (SearchPatternData)this.fPreviousSearchPatterns.get(selectionIndex);
        this.setSearchFor(initialData.getSearchFor());
        this.setLimitTo(initialData.getSearchFor(), initialData.getLimitTo());
        this.fPattern.setText(initialData.getPattern());
        this.fIsCaseSensitive = initialData.isCaseSensitive();
        this.fJavaElement = initialData.getJavaElement();
        this.fCaseSensitive.setEnabled(this.fJavaElement == null);
        this.fCaseSensitive.setSelection(initialData.isCaseSensitive());
        if (initialData.getWorkingSets() != null) {
            this.getContainer().setSelectedWorkingSets(initialData.getWorkingSets());
        } else {
            this.getContainer().setSelectedScope(initialData.getScope());
        }
        this.fInitialData = initialData;
    }

    private void setSearchFor(int searchFor) {
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].setSelection(searchFor == i);
            ++i;
        }
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_searchFor_label);
        result.setLayout((Layout)new GridLayout(2, true));
        this.fSearchFor = new Button[this.fSearchForText.length];
        int i = 0;
        while (i < this.fSearchForText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fSearchForText[i]);
            button.setSelection(i == 0);
            button.setLayoutData((Object)new GridData());
            this.fSearchFor[i] = button;
            ++i;
        }
        Label filler = new Label((Composite)result, 0);
        filler.setVisible(false);
        filler.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_limitTo_label);
        result.setLayout((Layout)new GridLayout(2, true));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedJavaSearchPage.this.updateUseJRE();
            }
        };
        this.fLimitTo = new Button[this.fLimitToText.length];
        int i = 0;
        while (i < this.fLimitToText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fLimitToText[i]);
            this.fLimitTo[i] = button;
            button.setSelection(i == 2);
            button.addSelectionListener((SelectionListener)listener);
            button.setLayoutData((Object)new GridData());
            ++i;
        }
        return result;
    }

    private void initSelections() {
        ISelection sel = this.getContainer().getSelection();
        SearchPatternData initData = null;
        if (sel instanceof IStructuredSelection) {
            initData = this.tryStructuredSelection((IStructuredSelection)sel);
        } else if (sel instanceof ITextSelection) {
            IEditorPart activePart = this.getActiveEditor();
            if (activePart instanceof JavaEditor) {
                try {
                    IJavaElement[] elements = SelectionConverter.codeResolve((JavaEditor)((JavaEditor)activePart));
                    if (elements != null && elements.length > 0) {
                        initData = this.determineInitValuesFrom(elements[0]);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            if (initData == null) {
                initData = this.trySimpleTextSelection((ITextSelection)sel);
            }
        }
        if (initData == null) {
            initData = this.getDefaultInitValues();
        }
        this.fInitialData = initData;
        this.fJavaElement = initData.getJavaElement();
        this.fCaseSensitive.setSelection(initData.isCaseSensitive());
        this.fCaseSensitive.setEnabled(this.fJavaElement == null);
        this.setSearchFor(initData.getSearchFor());
        this.setLimitTo(initData.getSearchFor(), initData.getLimitTo());
        this.fPattern.setText(initData.getPattern());
        boolean forceIncludeJRE = FixedJavaSearchPage.forceIncludeJRE(this.getLimitTo());
        this.fIncludeJRECheckbox.setEnabled(!forceIncludeJRE);
        this.fIncludeJRECheckbox.setSelection(forceIncludeJRE || initData.includesJRE());
    }

    private void updateUseJRE() {
        boolean forceIncludeJRE = FixedJavaSearchPage.forceIncludeJRE(this.getLimitTo());
        this.fIncludeJRECheckbox.setEnabled(!forceIncludeJRE);
        boolean isSelected = true;
        isSelected = !forceIncludeJRE ? this.fIncludeJRECheckbox.getSelection() : true;
        this.fIncludeJRECheckbox.setSelection(isSelected);
    }

    private static boolean forceIncludeJRE(int limitTo) {
        return limitTo == 0 || limitTo == 1;
    }

    private SearchPatternData tryStructuredSelection(IStructuredSelection selection) {
        if (selection == null || selection.size() > 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        SearchPatternData res = null;
        if (o instanceof IJavaElement) {
            res = this.determineInitValuesFrom((IJavaElement)o);
        } else {
            if (o instanceof LogicalPackage) {
                LogicalPackage lp = (LogicalPackage)o;
                return new SearchPatternData(2, 2, this.fIsCaseSensitive, lp.getElementName(), null, false);
            }
            if (o instanceof IAdaptable) {
                IJavaElement element;
                IAdaptable iAdaptable = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    res = this.determineInitValuesFrom(element);
                }
            }
        }
        if (res == null && o instanceof IAdaptable) {
            IWorkbenchAdapter adapter;
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return new SearchPatternData(0, 2, this.fIsCaseSensitive, adapter.getLabel(o), null, false);
            }
        }
        return res;
    }

    static final boolean isSearchableType(IJavaElement element) {
        switch (element.getElementType()) {
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private SearchPatternData determineInitValuesFrom(IJavaElement element) {
        block14: {
            try {
                JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
                boolean isInsideJRE = factory.isInsideJRE(element);
                switch (element.getElementType()) {
                    case 4: 
                    case 11: {
                        return new SearchPatternData(2, 2, true, element.getElementName(), element, isInsideJRE);
                    }
                    case 13: {
                        IImportDeclaration declaration = (IImportDeclaration)element;
                        if (declaration.isOnDemand()) {
                            String name = Signature.getQualifier((String)declaration.getElementName());
                            return new SearchPatternData(2, 0, true, name, element, true);
                        }
                        return new SearchPatternData(0, 0, true, element.getElementName(), element, true);
                    }
                    case 7: {
                        return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature((IType)((IType)element)), element, isInsideJRE);
                    }
                    case 5: {
                        IType mainType = ((ICompilationUnit)element).findPrimaryType();
                        if (mainType != null) {
                            return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature((IType)mainType), (IJavaElement)mainType, isInsideJRE);
                        }
                        break;
                    }
                    case 6: {
                        IType mainType = ((IClassFile)element).getType();
                        if (mainType.exists()) {
                            return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature((IType)mainType), (IJavaElement)mainType, isInsideJRE);
                        }
                        break;
                    }
                    case 8: {
                        return new SearchPatternData(4, 2, true, PatternStrings.getFieldSignature((IField)((IField)element)), element, isInsideJRE);
                    }
                    case 9: {
                        IMethod method = (IMethod)element;
                        int searchFor = method.isConstructor() ? 3 : 1;
                        return new SearchPatternData(searchFor, 2, true, PatternStrings.getMethodSignature((IMethod)method), element, isInsideJRE);
                    }
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block14;
                ExceptionHandler.handle((CoreException)((Object)e), (String)SearchMessages.Search_Error_javaElementAccess_title, (String)SearchMessages.Search_Error_javaElementAccess_message);
            }
        }
        return null;
    }

    private SearchPatternData trySimpleTextSelection(ITextSelection selection) {
        String selectedText = selection.getText();
        if (selectedText != null && selectedText.length() > 0) {
            int i = 0;
            while (i < selectedText.length() && !IndentManipulation.isLineDelimiterChar((char)selectedText.charAt(i))) {
                ++i;
            }
            if (i > 0) {
                return new SearchPatternData(0, 2, this.fIsCaseSensitive, selectedText.substring(0, i), null, true);
            }
        }
        return null;
    }

    private SearchPatternData getDefaultInitValues() {
        if (!this.fPreviousSearchPatterns.isEmpty()) {
            return (SearchPatternData)this.fPreviousSearchPatterns.get(0);
        }
        return new SearchPatternData(0, 2, this.fIsCaseSensitive, "", null, false);
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = JavaPlugin.getActivePage();
        if (activePage != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private static class SearchPatternData {
        private int searchFor;
        private int limitTo;
        private String pattern;
        private boolean isCaseSensitive;
        private IJavaElement javaElement;
        private boolean includeJRE;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchPatternData(int searchFor, int limitTo, boolean isCaseSensitive, String pattern, IJavaElement element, boolean includeJRE) {
            this(searchFor, limitTo, pattern, isCaseSensitive, element, 0, null, includeJRE);
        }

        public SearchPatternData(int searchFor, int limitTo, String pattern, boolean isCaseSensitive, IJavaElement element, int scope, IWorkingSet[] workingSets, boolean includeJRE) {
            this.searchFor = searchFor;
            this.limitTo = limitTo;
            this.pattern = pattern;
            this.isCaseSensitive = isCaseSensitive;
            this.scope = scope;
            this.workingSets = workingSets;
            this.includeJRE = includeJRE;
            this.setJavaElement(element);
        }

        public void setJavaElement(IJavaElement javaElement) {
            this.javaElement = javaElement;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public IJavaElement getJavaElement() {
            return this.javaElement;
        }

        public int getLimitTo() {
            return this.limitTo;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getScope() {
            return this.scope;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public boolean includesJRE() {
            return this.includeJRE;
        }

        public void store(IDialogSettings settings) {
            settings.put("searchFor", this.searchFor);
            settings.put("scope", this.scope);
            settings.put("pattern", this.pattern);
            settings.put("limitTo", this.limitTo);
            settings.put("javaElement", this.javaElement != null ? this.javaElement.getHandleIdentifier() : "");
            settings.put("isCaseSensitive", this.isCaseSensitive);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getName();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
            settings.put("includeJRE", this.includeJRE);
        }

        public static SearchPatternData create(IDialogSettings settings) {
            IJavaElement restored;
            String pattern = settings.get("pattern");
            if (pattern.length() == 0) {
                return null;
            }
            IJavaElement elem = null;
            String handleId = settings.get("javaElement");
            if (handleId != null && handleId.length() > 0 && (restored = JavaCore.create((String)handleId)) != null && FixedJavaSearchPage.isSearchableType(restored) && restored.exists()) {
                elem = restored;
            }
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            try {
                int searchFor = settings.getInt("searchFor");
                int scope = settings.getInt("scope");
                int limitTo = settings.getInt("limitTo");
                boolean isCaseSensitive = settings.getBoolean("isCaseSensitive");
                boolean includeJRE = settings.get("includeJRE") != null ? settings.getBoolean("includeJRE") : FixedJavaSearchPage.forceIncludeJRE(limitTo);
                return new SearchPatternData(searchFor, limitTo, pattern, isCaseSensitive, elem, scope, workingSets, includeJRE);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

