/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericStatementDecorator;
import ca.sqlpower.sql.jdbcwrapper.ResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.StatementDecorator;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MySQLDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    private static final Logger logger = Logger.getLogger(MySQLDatabaseMetaDataDecorator.class);

    public MySQLDatabaseMetaDataDecorator(DatabaseMetaData delegate, ConnectionDecorator connectionDecorator) {
        super(delegate, connectionDecorator);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rs = super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        CachedRowSet crs = new CachedRowSet();
        crs.populate(rs);
        rs.close();
        while (crs.next()) {
            if (crs.getInt(5) != 12 || crs.getString(13) == null) continue;
            crs.updateString(13, SQL.quote(crs.getString(13)));
        }
        crs.beforeFirst();
        return crs;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ResultSet rs = super.getIndexInfo(catalog, schema, table, unique, approximate);
        CachedRowSet crs = new CachedRowSet();
        crs.populate(rs, null, "SPG_INDEX_TYPE");
        rs.close();
        Map<String, String> indexTypes = this.getIndexType(catalog, table);
        while (crs.next()) {
            if ("true".equals(crs.getString(4))) {
                crs.updateBoolean(4, true);
            } else {
                crs.updateBoolean(4, false);
            }
            crs.updateShort(7, (short)Short.valueOf(crs.getString(7)));
            if ("PRIMARY".equals(crs.getString(6))) {
                String tableName = crs.getString(3);
                crs.updateString(6, this.pkNameForTable(tableName));
            }
            crs.updateString("SPG_INDEX_TYPE", indexTypes.get(crs.getString(6)));
            logger.debug((Object)("Name: " + crs.getString(6)));
            logger.debug((Object)("JDBC Type?: " + crs.getShort(7)));
            logger.debug((Object)("Unique?: " + crs.getBoolean(4)));
            logger.debug((Object)("Index Type?: " + crs.getString("SPG_INDEX_TYPE")));
        }
        crs.beforeFirst();
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getIndexType(String catalog, String tableName) throws SQLException {
        HashMap<String, String> indexTypes = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        String type = "";
        String name = "";
        try {
            stmt = this.getConnection().createStatement();
            String sql = "SHOW INDEXES FROM " + (catalog == null ? "" : catalog + ".") + tableName;
            logger.debug((Object)("SQL statement was " + sql));
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                name = rs.getString("key_name");
                type = rs.getString("index_type");
                indexTypes.put(name, type);
            }
            HashMap<String, String> hashMap = indexTypes;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        CachedRowSet crs = new CachedRowSet();
        ResultSet origRS = null;
        try {
            origRS = super.getPrimaryKeys(catalog, schema, table);
            crs.populate(origRS);
        }
        finally {
            if (origRS != null) {
                origRS.close();
            }
        }
        while (crs.next()) {
            String tableName = crs.getString(3);
            if (!"PRIMARY".equals(crs.getString(6))) continue;
            crs.updateString(6, this.pkNameForTable(tableName));
        }
        crs.beforeFirst();
        return crs;
    }

    private String pkNameForTable(String tableName) {
        return tableName + "_PK";
    }

    @Override
    protected ResultSetDecorator wrap(ResultSet rs) throws SQLException {
        return new GenericResultSetDecorator(this.wrap(rs.getStatement()), rs);
    }

    @Override
    protected StatementDecorator wrap(Statement statement) {
        return new GenericStatementDecorator(this.connectionDecorator, statement);
    }
}

