/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.ldap.LdapUserDetailsImpl;
import org.springframework.security.userdetails.ldap.UserDetailsContextMapper;
import org.springframework.util.Assert;

public class LdapUserDetailsMapper
implements UserDetailsContextMapper {
    private final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$userdetails$ldap$LdapUserDetailsMapper == null ? (class$org$springframework$security$userdetails$ldap$LdapUserDetailsMapper = LdapUserDetailsMapper.class$("org.springframework.security.userdetails.ldap.LdapUserDetailsMapper")) : class$org$springframework$security$userdetails$ldap$LdapUserDetailsMapper));
    private String passwordAttributeName = "userPassword";
    private String rolePrefix = "ROLE_";
    private String[] roleAttributes = null;
    private boolean convertToUpperCase = true;
    static /* synthetic */ Class class$org$springframework$security$userdetails$ldap$LdapUserDetailsMapper;

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, GrantedAuthority[] authorities) {
        int i;
        String dn = ctx.getNameInNamespace();
        this.logger.debug((Object)("Mapping user details from context with DN: " + dn));
        LdapUserDetailsImpl.Essence essence = new LdapUserDetailsImpl.Essence();
        essence.setDn(dn);
        Object passwordValue = ctx.getObjectAttribute(this.passwordAttributeName);
        if (passwordValue != null) {
            essence.setPassword(this.mapPassword(passwordValue));
        }
        essence.setUsername(username);
        for (i = 0; this.roleAttributes != null && i < this.roleAttributes.length; ++i) {
            String[] rolesForAttribute = ctx.getStringAttributes(this.roleAttributes[i]);
            if (rolesForAttribute == null) {
                this.logger.debug((Object)("Couldn't read role attribute '" + this.roleAttributes[i] + "' for user " + dn));
                continue;
            }
            for (int j = 0; j < rolesForAttribute.length; ++j) {
                GrantedAuthority authority = this.createAuthority(rolesForAttribute[j]);
                if (authority == null) continue;
                essence.addAuthority(authority);
            }
        }
        for (i = 0; i < authorities.length; ++i) {
            essence.addAuthority(authorities[i]);
        }
        return essence.createUserDetails();
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
        throw new UnsupportedOperationException("LdapUserDetailsMapper only supports reading from a context. Pleaseuse a subclass if mapUserToContext() is required.");
    }

    protected String mapPassword(Object passwordValue) {
        if (!(passwordValue instanceof String)) {
            passwordValue = new String((byte[])passwordValue);
        }
        return (String)passwordValue;
    }

    protected GrantedAuthority createAuthority(Object role) {
        if (role instanceof String) {
            if (this.convertToUpperCase) {
                role = ((String)role).toUpperCase();
            }
            return new GrantedAuthorityImpl(this.rolePrefix + role);
        }
        return null;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public void setRoleAttributes(String[] roleAttributes) {
        Assert.notNull((Object)roleAttributes, (String)"roleAttributes array cannot be null");
        this.roleAttributes = roleAttributes;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

