'''OpenGL extension VERSION.GL_1_2

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_1_2 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_1_2.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.VERSION.GL_1_2 import *
### END AUTOGENERATED SECTION
from OpenGL.GL.VERSION.GL_1_2_images import *
from OpenGL.GL.ARB.imaging import *

GL_POINT_SIZE_GRANULARITY = GL_SMOOTH_POINT_SIZE_GRANULARITY # alias
GL_POINT_SIZE_RANGE = GL_SMOOTH_POINT_SIZE_RANGE # alias
GL_LINE_WIDTH_GRANULARITY = GL_SMOOTH_LINE_WIDTH_GRANULARITY # alias
GL_LINE_WIDTH_RANGE = GL_SMOOTH_LINE_WIDTH_RANGE # alias

glget.addGLGetTexParameterConstant(GL_TEXTURE_MIN_LOD,(1,))
glget.addGLGetTexParameterConstant(GL_TEXTURE_MAX_LOD,(1,))
glget.addGLGetTexParameterConstant(GL_TEXTURE_BASE_LEVEL,(1,))
glget.addGLGetTexParameterConstant(GL_TEXTURE_MAX_LEVEL,(1,))
glget.addGLGetTexParameterConstant(GL_TEXTURE_WRAP_R,(1,))

glDrawRangeElements = wrapper.wrapper( simple.glDrawRangeElements ).setPyConverter(
    'indices', arrays.AsArrayOfType( 'indices', 'type' ),
).setReturnValues(
    wrapper.returnPyArgument( 'indices' )
)
