require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AIC7XXX_OPENBSD_H_)) {
    eval 'sub _AIC7XXX_OPENBSD_H_ () {1;}' unless defined(&_AIC7XXX_OPENBSD_H_);
    require './dev/ic/pci.ph';
    require 'sys/param.ph';
    require 'sys/kernel.ph';
    require 'sys/systm.ph';
    require 'sys/device.ph';
    require 'sys/malloc.ph';
    require 'sys/buf.ph';
    require 'sys/queue.ph';
    require 'dev/pci/pcireg.ph';
    require 'dev/pci/pcivar.ph';
    require 'machine/bus.ph';
    require 'machine/intr.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsi_message.ph';
    require 'scsi/scsi_debug.ph';
    require 'scsi/scsiconf.ph';
    require 'uvm/uvm_extern.ph';
    if(defined(&CAM_NEW_TRAN_CODE)) {
	eval 'sub AHC_NEW_TRAN_SETTINGS () {1;}' unless defined(&AHC_NEW_TRAN_SETTINGS);
    }
    if((defined(&NPCI) ? &NPCI : undef) > 0) {
	eval 'sub AHC_PCI_CONFIG () {1;}' unless defined(&AHC_PCI_CONFIG);
    }
    if(0) {
	eval 'sub AHC_DEBUG () { &AHC_SHOW_SENSE |  &AHC_SHOW_MISC |  &AHC_SHOW_CMDS;}' unless defined(&AHC_DEBUG);
    }
    if(defined(&DEBUG)) {
	eval 'sub bootverbose () {1;}' unless defined(&bootverbose);
    } else {
	eval 'sub bootverbose () {0;}' unless defined(&bootverbose);
    }
    eval 'sub SCSI_IS_SCSIBUS_B {
        my($ahc, $sc_link) = @_;
	    eval q((($sc_link)-> &scsibus == ($ahc)-> ($sc_channel_b->{scsibus})));
    }' unless defined(&SCSI_IS_SCSIBUS_B);
    eval 'sub SCSI_SCSI_ID {
        my($ahc, $sc_link) = @_;
	    eval q(( &SCSI_IS_SCSIBUS_B($ahc, $sc_link) ?  ($ahc->{our_id_b}) :  ($ahc->{our_id})));
    }' unless defined(&SCSI_SCSI_ID);
    eval 'sub SCSI_CHANNEL {
        my($ahc, $sc_link) = @_;
	    eval q(( &SCSI_IS_SCSIBUS_B($ahc, $sc_link) ? ord(\'B\' : \'A\')));
    }' unless defined(&SCSI_CHANNEL);
    eval 'sub BUILD_SCSIID {
        my($ahc, $sc_link, $target_id, $our_id) = @_;
	    eval q((((($target_id) <<  &TID_SHIFT) &  &TID) | ($our_id) | ( &SCSI_IS_SCSIBUS_B($ahc, $sc_link) ?  &TWIN_CHNLB : 0)));
    }' unless defined(&BUILD_SCSIID);
    unless(defined(&offsetof)) {
	eval 'sub offsetof {
	    my($type, $member) = @_;
    	    eval q((((($type *)0)->$member)));
	}' unless defined(&offsetof);
    }
    eval 'sub ahc_dmamap_sync {
        my($ahc, $dma_tag, $dmamap, $offset, $len, $op) = @_;
	    eval q( &bus_dmamap_sync($dma_tag, $dmamap, $offset, $len, $op));
    }' unless defined(&ahc_dmamap_sync);
    eval 'sub AHC_NSEG () {( &roundup( &atop( &MAXPHYS) + 1, 16));}' unless defined(&AHC_NSEG);
    require 'dev/ic/aic7xxxvar.ph';
    unless(defined(&ISABUS_DMA_32BIT)) {
	eval 'sub ISABUS_DMA_32BIT () { &BUS_DMA_BUS1;}' unless defined(&ISABUS_DMA_32BIT);
    }
    if((defined(&AHC_REG_PRETTY_PRINT) ? &AHC_REG_PRETTY_PRINT : undef)) {
	eval 'sub AIC_DEBUG_REGISTERS () {1;}' unless defined(&AIC_DEBUG_REGISTERS);
    } else {
	eval 'sub AIC_DEBUG_REGISTERS () {0;}' unless defined(&AIC_DEBUG_REGISTERS);
    }
    eval 'sub ahc_timer_init () { &callout_init;}' unless defined(&ahc_timer_init);
    eval 'sub ahc_timer_stop () { &callout_stop;}' unless defined(&ahc_timer_stop);
    eval 'sub ahc_timer_reset {
        my($timer,$usec,$func,$arg) = @_;
	    eval q({  &callout_reset($timer, ($usec *  &hz)/1000000, $func, $arg); });
    }' unless defined(&ahc_timer_reset);
    eval 'sub ahc_scb_timer_reset {
        my($scb,$usec) = @_;
	    eval q({  &if (!( ($scb->{xs}->{xs_control}) &  &XS_CTL_POLL)) {  &callout_reset( ($scb->{xs}->{xs_callout}), ($usec *  &hz)/1000000,  &ahc_timeout, $scb); } });
    }' unless defined(&ahc_scb_timer_reset);
    eval 'sub ahc_inb {
        my($ahc, $port) = @_;
	    eval q( &bus_space_read_1(($ahc)-> &tag, ($ahc)-> &bsh, $port));
    }' unless defined(&ahc_inb);
    eval 'sub ahc_outb {
        my($ahc, $port, $value) = @_;
	    eval q( &bus_space_write_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $value));
    }' unless defined(&ahc_outb);
    eval 'sub ahc_outsb {
        my($ahc, $port, $valp, $count) = @_;
	    eval q( &bus_space_write_multi_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $valp, $count));
    }' unless defined(&ahc_outsb);
    eval 'sub ahc_insb {
        my($ahc, $port, $valp, $count) = @_;
	    eval q( &bus_space_read_multi_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $valp, $count));
    }' unless defined(&ahc_insb);
    eval 'sub ahc_flush_device_writes {
        my($ahc) = @_;
	    eval q({  &bus_space_barrier( ($ahc->{tag}),  ($ahc->{bsh}), 0, 0x100,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE);  &ahc_inb($ahc,  &INTSTAT); });
    }' unless defined(&ahc_flush_device_writes);
    eval 'sub ahc_get_sense_bufsize {
        my($ahc,$scb) = @_;
	    eval q({ ($sizeof{\'struct scsi_sense_data\'}); });
    }' unless defined(&ahc_get_sense_bufsize);
    eval 'sub ahc_freeze_scb {
        my($scb) = @_;
	    eval q({ });
    }' unless defined(&ahc_freeze_scb);
    eval 'sub ahc_platform_freeze_devq {
        my($ahc,$scb) = @_;
	    eval q({ });
    }' unless defined(&ahc_platform_freeze_devq);
    eval 'sub ahc_platform_abort_scbs {
        my($ahc,$target,$channel,$lun,$tag,$role,$status) = @_;
	    eval q({ (0); });
    }' unless defined(&ahc_platform_abort_scbs);
    eval 'sub ahc_platform_scb_free {
        my($ahc,$scb) = @_;
	    eval q({ \'int\'  &s;  &s =  &splbio();  &if (( ($ahc->{flags}) &  &AHC_RESOURCE_SHORTAGE) != 0) {  ($ahc->{flags}) &= ~ &AHC_RESOURCE_SHORTAGE; }  &timeout_del( ($scb->{xs}->{stimeout}));  &splx( &s); });
    }' unless defined(&ahc_platform_scb_free);
    if(defined(&AHC_PCI_CONFIG)) {
	eval 'sub ahc_pci_read_config {
	    my($pci,$reg,$width) = @_;
    	    eval q({ ( &pci_conf_read( ($pci->{pa_pc}),  ($pci->{pa_tag}), $reg)); });
	}' unless defined(&ahc_pci_read_config);
	eval 'sub ahc_pci_write_config {
	    my($pci,$reg,$value,$width) = @_;
    	    eval q({  &pci_conf_write( ($pci->{pa_pc}),  ($pci->{pa_tag}), $reg, $value); });
	}' unless defined(&ahc_pci_write_config);
	eval 'sub ahc_get_pci_function {
	    my($pci) = @_;
    	    eval q({ ( ($pci->{pa_function})); });
	}' unless defined(&ahc_get_pci_function);
	eval 'sub ahc_get_pci_slot {
	    my($pci) = @_;
    	    eval q({ ( ($pci->{pa_device})); });
	}' unless defined(&ahc_get_pci_slot);
	eval 'sub ahc_get_pci_bus {
	    my($pci) = @_;
    	    eval q({ ( ($pci->{pa_bus})); });
	}' unless defined(&ahc_get_pci_bus);
	eval("sub AHC_POWER_STATE_D0 () { 0; }") unless defined(&AHC_POWER_STATE_D0);
	eval("sub AHC_POWER_STATE_D1 () { 1; }") unless defined(&AHC_POWER_STATE_D1);
	eval("sub AHC_POWER_STATE_D2 () { 2; }") unless defined(&AHC_POWER_STATE_D2);
	eval("sub AHC_POWER_STATE_D3 () { 3; }") unless defined(&AHC_POWER_STATE_D3);
    }
    eval 'sub ahc_print_path {
        my($ahc,$scb) = @_;
	    eval q({  &sc_print_addr( ($scb->{xs}->{sc_link})); });
    }' unless defined(&ahc_print_path);
    eval 'sub ahc_platform_dump_card_state {
        my($ahc) = @_;
	    eval q({  &printf(\\"FEATURES = 0x%x, FLAGS = 0x%x, CHIP = 0x%x BUGS =0x%x\\\\n\\",  ($ahc->{features}),  ($ahc->{flags}),  ($ahc->{chip}),  ($ahc->{bugs})); });
    }' unless defined(&ahc_platform_dump_card_state);
    eval 'sub ahc_platform_flushwork {
        my($ahc) = @_;
	    eval q({ });
    }' unless defined(&ahc_platform_flushwork);
}
1;
