require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&ASSEMBLER)) {
    if(defined(&_STANDALONE)) {
    }
}
eval 'sub PROM_R_CLOSE () {0x11;}' unless defined(&PROM_R_CLOSE);
eval 'sub PROM_R_GETC () {0x1;}' unless defined(&PROM_R_GETC);
eval 'sub PROM_R_GETENV () {0x22;}' unless defined(&PROM_R_GETENV);
eval 'sub PROM_R_OPEN () {0x10;}' unless defined(&PROM_R_OPEN);
eval 'sub PROM_R_PUTS () {0x2;}' unless defined(&PROM_R_PUTS);
eval 'sub PROM_R_READ () {0x13;}' unless defined(&PROM_R_READ);
eval 'sub PROM_R_WRITE () {0x14;}' unless defined(&PROM_R_WRITE);
eval 'sub PROM_R_IOCTL () {0x12;}' unless defined(&PROM_R_IOCTL);
eval 'sub PROM_I_SKIP2IRG () {1;}' unless defined(&PROM_I_SKIP2IRG);
eval 'sub PROM_I_SKIP2MARK () {2;}' unless defined(&PROM_I_SKIP2MARK);
eval 'sub PROM_I_REWIND () {3;}' unless defined(&PROM_I_REWIND);
eval 'sub PROM_I_WRITEMARK () {4;}' unless defined(&PROM_I_WRITEMARK);
eval 'sub PROM_E_BOOTED_DEV () {0x4;}' unless defined(&PROM_E_BOOTED_DEV);
eval 'sub PROM_E_BOOTED_FILE () {0x6;}' unless defined(&PROM_E_BOOTED_FILE);
eval 'sub PROM_E_BOOTED_OSFLAGS () {0x8;}' unless defined(&PROM_E_BOOTED_OSFLAGS);
eval 'sub PROM_E_TTY_DEV () {0xf;}' unless defined(&PROM_E_TTY_DEV);
eval 'sub PROM_E_SCSIID () {0x42;}' unless defined(&PROM_E_SCSIID);
eval 'sub PROM_E_SCSIFAST () {0x43;}' unless defined(&PROM_E_SCSIFAST);
if(defined(&_STANDALONE) || defined(&ENABLEPROM)) {
    eval 'sub prom_open {
        my($dev, $len) = @_;
	    eval q( &prom_dispatch( &PROM_R_OPEN, ($dev), ($len), 0, 0));
    }' unless defined(&prom_open);
    eval 'sub prom_close {
        my($chan) = @_;
	    eval q( &prom_dispatch( &PROM_R_CLOSE, $chan, 0, 0, 0));
    }' unless defined(&prom_close);
    eval 'sub prom_read {
        my($chan, $len, $buf, $blkno) = @_;
	    eval q( &prom_dispatch( &PROM_R_READ, $chan, $len, ( &u_int64_t)$buf, $blkno));
    }' unless defined(&prom_read);
    eval 'sub prom_write {
        my($chan, $len, $buf, $blkno) = @_;
	    eval q( &prom_dispatch( &PROM_R_WRITE, $chan, $len, ( &u_int64_t)$buf, $blkno));
    }' unless defined(&prom_write);
    eval 'sub prom_ioctl {
        my($chan, $op, $count) = @_;
	    eval q( &prom_dispatch( &PROM_R_IOCTL, $chan, $op, ( &int64_t)$count, 0, 0));
    }' unless defined(&prom_ioctl);
    eval 'sub prom_putstr {
        my($chan, $str, $len) = @_;
	    eval q( &prom_dispatch( &PROM_R_PUTS, $chan, ( &u_int64_t)$str, $len, 0));
    }' unless defined(&prom_putstr);
    eval 'sub prom_getc {
        my($chan) = @_;
	    eval q( &prom_dispatch( &PROM_R_GETC, $chan, 0, 0, 0));
    }' unless defined(&prom_getc);
    eval 'sub prom_getenv_disp {
        my($id, $buf, $len) = @_;
	    eval q( &prom_dispatch( &PROM_R_GETENV, $id, ( &u_int64_t)$buf, $len, 0));
    }' unless defined(&prom_getenv_disp);
}
unless(defined(&ASSEMBLER)) {
    if(defined(&_KERNEL)) {
    }
}
1;
