/* Associates a string with a function
 * Ben Lynn
 */
/*
Copyright (C) 2003 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef JUMPTABLE_H
#define JUMPTABLE_H

struct jumptable_s {
    int count;
    int max;

    char **name;
    void (** function)();
};

typedef struct jumptable_s *jumptable_ptr;
typedef struct jumptable_s jumptable_t[1];

void jumptable_init(jumptable_ptr jt);
void jumptable_free(jumptable_ptr jt);
void jumptable_execute(jumptable_ptr jt, char *s);
void jumptable_add(jumptable_ptr jt, char *s, void (* function)());

#endif //JUMPTABLE_H
