/* Utility functions and handy information
 * Ben Lynn
 */
/*
Copyright (C) 2002 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef COMMON_H
#define COMMON_H

#include <glib.h>
#include "jumptable.h"

extern gint session;
extern gchar *homedir;
extern gchar *username;
extern gchar *filesuffix;
extern gchar *arg;

gint balance_clip(gint);
gint volume_clip(gint);

void argsplit(gchar *s);
void common_init();
void common_free();
void add_command(gchar *s, void (* function)());
void subcommand(jumptable_t jt);
void common_execute(gchar *s);
void setauto(int *i);
void common_symlink(char *src, char *dst);

#endif //COMMON_H
