/* Utility functions and handy information
 * Ben Lynn
 */
/*
Copyright (C) 2002 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>

//for stat
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "common.h"

gint session;
gchar *homedir;
gchar *username;
gchar *filesuffix;
gchar *arg;

static jumptable_t main_jt;

void argsplit(gchar *s)
//hackish
//searches for first occurence of ' ' in s
//if it exists, replaces it with '\0', and
//sets the global char *arg to the position after it
{
    arg = strchr(s, ' ');
    if (arg) {
	*arg = 0;
	arg++;
    }
}

void add_command(gchar *s, void (* function)())
{
    jumptable_add(main_jt, s, function);
}

static gint clip_int(gint i, gint lower, gint upper)
{
    if (i < lower) return lower;
    if (i > upper) return upper;
    return i;
}

gint balance_clip(gint i)
{
    return clip_int(i, -100, 100);
}

gint volume_clip(gint i)
{
    return clip_int(i, 0, 100);
}

void common_init(gint i)
{
    gchar session_string[32];

    session = i;
    jumptable_init(main_jt);
    homedir = g_get_home_dir();
    username = g_get_user_name();
    sprintf(session_string, "%d", session);
    filesuffix = g_strconcat(username, ".", session_string, NULL);
}

void common_free()
{
    jumptable_free(main_jt);
    g_free(filesuffix);
}

void subcommand(jumptable_t jt)
{
    if (arg) {
	gchar *s = arg;
	argsplit(s);

	jumptable_execute(jt, s);
    }
}

void common_execute(gchar *s)
{
    jumptable_execute(main_jt, s);
}

void setauto(int *i)
{
    if (arg) {
	if (!strcmp(arg, "on")) {
	    *i = 1;
	}
	if (!strcmp(arg, "off")) {
	    *i = 0;
	}
	if (!strcmp(arg, "toggle")) {
	    *i = !(*i);
	}
    }
}

void common_symlink(char *src, char *dst)
{
    int status;
    struct stat stbuf;

    status = stat(dst, &stbuf);
    if (!status) {
	if (!S_ISLNK(stbuf.st_mode)) {
	    fprintf(stderr, "deleting file: doesn't appear to be link\n");
	}
	status = unlink(dst);
	if (status) {
	    fprintf(stderr, "couldn't delete symlink\n");
	}
    }
    status = symlink(src, dst);
    if (status) {
	perror("symlink");
    }
}
