/*
xkeymouse enables synthezing button events from keyboard events
Copyright (C) 2001 Henrik Sandklef

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
ERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#include "xkeymouse.h"

xkm_prog_data *xkm_data;

int
xkm_err_handler(Display* dpy, XErrorEvent* ev)
{
  int len=100;
  char tmp[len];
  
  xkm_error ("xkm - X11 error handler \n");
  xkm_error ("   type       %d \n",  ev->type);
  xkm_error ("   serial     %lu \n", ev->serial);
  xkm_error ("   error code %lu \n", ev->error_code);
  xkm_error ("   major code %lu \n", ev->request_code);
  xkm_error ("   minor code %lu \n", ev->minor_code);
  
  XGetErrorText (dpy, ev->error_code, tmp, len);
  xkm_error ("   Message: %s\n", tmp);
  return 0;
}


int main (int argc,char *argv[])
{
  int    j = 0 ;
  int    i = 0 ;
  int button ; 
  int ret ; 
  int  tmp_press=0; 
  int is_pressed = 0 ; 
  int    tmp_code, tmp_modifier;
  int x_dir, y_dir;

  XEvent my_event ;
  
  xkm_data = (xkm_prog_data *) malloc ( sizeof (xkm_prog_data));
  if (xkm_data==NULL)
    {
      exit(XKEYMOUSE_ALLOC_FAILED);
    }
  
  (void) signal (SIGINT, signal_handler);
  
  xkm_init (xkm_data);
  xkm_parse_args (xkm_data, argc, argv);


  xkm_data->data_display = XOpenDisplay(xkm_data->display_name);
  if (xkm_data->data_display == NULL) 
    {
      xkm_error ("Could not open display ... \n");
      exit(XKEYMOUSE_DISPLAY_FAILED);
    }
  xkm_data->screen = DefaultScreen (xkm_data->data_display);
  xkm_data->window = RootWindow(xkm_data->data_display, xkm_data->screen);

  if ( !xkm_data->cli_rc )
    {
      xkm_open_rc_file (xkm_data);
      if (xkm_data->fd==NULL)
	{
	  xkm_error ("Couldn't find any rc file or any comand line option\n");
	  exit (XKEYMOUSE_RC_ERROR);
	}
    }  

  add_all_data (xkm_data);
  
  fclose(xkm_data->fd);
  

  /*  printf ("PRINTME  %d\n",xkm_data->gdl_size);
  getchar();
  for (i=0; i<xkm_data->gdl_size ; i++)
    verbose_gd(xkm_data->grab_data_list[i]);
  printf ("PRINTME  %d\n",xkm_data->gdl_size);
  getchar();
  */
  grab_all_data (xkm_data,1);

  ret = XTestGrabControl ( xkm_data->data_display , True);
  if (ret!=1) 
    {
      xkm_error ("Could not grab display\n");
      exit (XKEYMOUSE_NOT_GRAB);
    }

  /*  while(!close_down)*/
  xkm_print_settings( xkm_data );

  for (;;)
    {
      
      tmp_modifier=-1;
      tmp_code=-1;
      XNextEvent (xkm_data->data_display, &my_event);
      if (my_event.xkey.send_event==1) { printf ("send_event==true\n");}
      
      /*
      switch (my_event.type) 
	{
	case KeyPress :
	  xkm_verbose ("KeyPress\n");
	  press = XKEYMOUSE_PRESS; 
	  break;

	case KeyRelease :
	  xkm_verbose ("KeyRelease\n");
	  press = XKEYMOUSE_RELEASE ;
	  break;

	default:
	  press = 0 ;
	  xkm_error ("default\n");
	  break ;

	}
      */

      tmp_modifier=my_event.xkey.state;
      tmp_code=my_event.xkey.keycode;

      for (j=0;j<xkm_data->gdl_size;j++)
	{
	  /*	  xkm_verbose ("Checking if (code) %d==%d &&  /  (mopdifier) %d==%d  / NULL=%d type=%d  (loop %d/%d)\n", 
		       tmp_code,
		       xkm_data->grab_data_list[j]->code,
		       tmp_modifier, 
		       xkm_data->grab_data_list[j]->modifier,
		       xkm_data->grab_data_list[j],
		       xkm_data->grab_data_list[j]->type,
		       j,
		       xkm_data->size);*/
	  if ( (
		(xkm_data->grab_data_list[j]->code==tmp_code) 
		&&
		( (xkm_data->grab_data_list[j]->modifier==tmp_modifier) 
		  ||
		  (xkm_data->grab_data_list[j]->modifier==AnyModifier)
		  )
		))
	    {
	      

	      xkm_verbose ("Checking type=%d  (%d %d %d %d) \n", 
			   xkm_data->grab_data_list[j]->type,
			   XKEYMOUSE_BUTTON, 
			   XKEYMOUSE_MOTION, 
			   XKEYMOUSE_EXEC, 
			   XKEYMOUSE_KEY);
	      if (xkm_data->grab_data_list[j]->type==XKEYMOUSE_BUTTON)
		{
		  if ( my_event.type==KeyPress)
		    {
		      xkm_verbose ("XTestFakeButtonEvent ( %d, %d, %d, %d)\n",
				   xkm_data->data_display, xkm_data->grab_data_list[j]->xkm_action.ba.nr, True, 0);
		      XTestFakeButtonEvent ( xkm_data->data_display, xkm_data->grab_data_list[j]->xkm_action.ba.nr, True, 0);
		    }
		  else
		    {
		      xkm_verbose ("XTestFakeButtonEvent ( %d, %d, %d, %d)\n",
				   xkm_data->data_display, xkm_data->grab_data_list[j]->xkm_action.ba.nr, False, 0);
		      XTestFakeButtonEvent ( xkm_data->data_display, xkm_data->grab_data_list[j]->xkm_action.ba.nr, False, 0);
		    }
		}
	      else if (xkm_data->grab_data_list[j]->type==XKEYMOUSE_MOTION)
		{			  
		  if ( my_event.type==KeyPress)
		    {
		      xkm_verbose ("XTestFakeRelativeMotionEvent (%d, %d, %d, %d)\n",
				   xkm_data->data_display, 
				   xkm_data->grab_data_list[j]->xkm_action.ma.x_direction*
				   xkm_data->grab_data_list[j]->xkm_action.ma.speed,
				   xkm_data->grab_data_list[j]->xkm_action.ma.y_direction*
				   xkm_data->grab_data_list[j]->xkm_action.ma.speed,
				   0);
 		      XTestFakeRelativeMotionEvent (xkm_data->data_display, 
						    xkm_data->grab_data_list[j]->xkm_action.ma.x_direction*
						    xkm_data->grab_data_list[j]->xkm_action.ma.speed,
						    xkm_data->grab_data_list[j]->xkm_action.ma.y_direction*
						    xkm_data->grab_data_list[j]->xkm_action.ma.speed,
						    0);
		    }
		  else
		    {
		      xkm_verbose ("MOTION (release) ----   TODO #################### \n");
		    }
		}
	      else if (xkm_data->grab_data_list[j]->type==XKEYMOUSE_EXEC)
		{
		  if ( my_event.type==KeyPress)
		    {
		      xkm_verbose ("EXEC (press) ----   TODO #################### \n");
		      xkm_verbose (" executing %s\n", xkm_data->grab_data_list[j]->xkm_action.ea.command_line);
		      system (xkm_data->grab_data_list[j]->xkm_action.ea.command_line);
		    }
		  else
		    {
		      xkm_verbose ("EXEC (release) ----   TODO #################### \n");
		    }
		  /* XTestFakeButtonEvent ( xkm_data->data_display, button, True, 100);*/
		  /*  XTestFakeButtonEvent ( xkm_data->data_display, button, False, 100);*/
		}
	      else if (xkm_data->grab_data_list[j]->type==XKEYMOUSE_KEY)
		{
		  if ( my_event.type==KeyPress)
		    {
		      xkm_verbose ("KEY (press) ----   TODO #################### \n");
		    }
		  else
		    {
		      xkm_verbose ("KEY (release) ----   TODO #################### \n");
		    }
		  /* XTestFakeButtonEvent ( xkm_data->data_display, button, True, 100);*/
		  /*  XTestFakeButtonEvent ( xkm_data->data_display, button, False, 100);*/
		}
	      else
		{
		  xkm_verbose ("XKEYMOUSE ... found neither a motion or button to that key\n");
		}
	    }	
	}		  
      
    }
  
  xkm_close_down(xkm_data);
  return 1;
}






