#!/bin/bash
version=0.8
full=""
while [ $1 ]; do
   case $1 in
#      -a | --all ) full="OK"
#                  echo "Scan is going to check all known frequencies..."
#                  shift;;

      -v | --version ) echo "Script version $version"
                       exit;;

      -h | --help ) echo "This script can be launched with these options:"
#                   echo "-a (--all) : Use this switch to scan all frequencies, not only known channels."
		    echo "-v (--version) : Use this switch to learn the exact script version."
		    echo "-h (--help) : Use this switch to get some help."
		    exit;;

      *  ) echo "Unknown option : $1, can't be used..."
           shift;;
   esac
done


# --check softwares needed
LISTE_APPLIS="grep awk touch cp cat echo rm mkdir expr xdtv_scantv xdtv"
sortie="notok"
for i in $LISTE_APPLIS;
do
 which $i > /dev/null 2>&1
 if [ "$?" = "1" ]; then
  [ "$sortie" = "notok" ] && echo -e "Software(s) needed:"
  echo -e "${i}"
  sortie="ok"
 fi;
done
if [ "$sortie" = "ok" ]; then
   echo
   echo -n "<Press Enter to quit>"
   read
   exit -1
fi
#---

# -- check kernel version
kernel26=`uname -r | grep 2.6.`
# --search for the good video device
if [ "$kernel26" = "" ]; then # KERNEL 2.4.x
   i=0
   trouve=""
   while [ $i -le 9 ] && [ "$trouve" = "" ]; do
      if [ -e "/proc/video/dev/video${i}" ]; then
          video=`cat /proc/video/dev/video${i} | grep TUNER`
      fi
      [ "$video" != "" ] && trouve="OK"
      i=$(($i+1))
   done
   i=$(($i-1))
else # KERNEL 2.6.x
   sysok=`cat /etc/mtab | grep sysfs`
   if [ "$sysok" = "" ]; then
      echo "sys pseudo-filesystem is not mounted in /sys..."
      exit -1
   fi
   i=0
   trouve=""
   while [ $i -le 9 ] && [ "$trouve" = "" ]; do
      if [ -e "/sys/class/video4linux/video${i}" ] && [ -e "/sys/class/video4linux/video${i}/card" ]; then
         trouve="OK"
      fi
      i=$(($i+1))
   done
   i=$(($i-1))  
fi
if [ "$trouve" = "OK" ] ; then
   if [ -e /dev/v4l/video${i} ]; then
      devvideo="/dev/v4l/video${i}"
   elif [ -e /dev/video${i} ]; then
      devvideo="/dev/video${i}"
   else
      echo "Video device missing..."
      exit -1
   fi
else
   echo "Video device not found..."
   exit -1
fi
echo "-->Video device found: $devvideo"
#---

#-- search for the good vbi device
if [ "$kernel26" = "" ]; then # KERNEL 2.4.x
   i=0
   trouve=""
   while [ $i -le 9 ] && [ "$trouve" = "" ]; do
      if [ -e "/proc/video/dev/vbi${i}" ]; then
         vbi=`cat /proc/video/dev/vbi${i} | grep vbi`
      fi
      [ "$vbi" != "" ] && trouve="OK"
      i=$(($i+1))
   done
   i=$(($i-1))
else # KERNEL 2.6.x
   i=0
   trouve=""
   while [ $i -le 9 ] && [ "$trouve" = "" ]; do
      if [ -e "/sys/class/video4linux/vbi${i}" ]; then
         vbi=`cat /sys/class/video4linux/vbi${i}/name | grep vbi`
      fi
      [ "$vbi" != "" ] && trouve="OK"
      i=$(($i+1))
   done
   i=$(($i-1))
fi
if [ "$trouve" = "OK" ] ; then
   if [ -e /dev/v4l/vbi${i} ]; then
      devvbi="/dev/v4l/vbi${i}"
   elif [ -e /dev/vbi${i} ]; then
      devvbi="/dev/vbi${i}"
   else
      echo "Vbi device missing..."
      exit -1
   fi
else
   echo "Vbi device not found..."
   exit -1
fi
echo "-->Vbi device found : $devvbi"
#---

scan=`which xdtv_scantv 2>/dev/null`
xaw=`which xdtv 2>/dev/null`
xawrc="$HOME/.xdtv/xdtvrc"
xawrctmp="$HOME/.xdtv/xdtvtmp"
[ -e $xawrctmp ] && rm -f $xawrctmp
[ ! -d "$HOME/.xdtv" ] && mkdir $HOME/.xdtv

if [ -e $xawrc ]; then
      IFS=$'\n'
      oldchannelTMP=($(cat $HOME/.xdtv/xdtvrc | grep ^channel))
      oldnameTMP=($(cat $HOME/.xdtv/xdtvrc | grep "^\["))
      noldchTMP=$((${#oldchannelTMP[*]}))
      noldnameTMP=$((${#oldnameTMP[*]}))
      i=0
      ext=0
      noldch=${noldchTMP}
      noldname=${noldnameTMP}
      while [ $i -lt $noldchTMP ]; do
         k=$(($i-$ext))         
         if [ "${oldnameTMP[$i]}" = "[external]" ]; then # test external source
            ext=$(($ext+1))
            noldch=$((${noldch}-1))
            noldname=$((${noldname}-1))
         else
            oldname[$k]=${oldnameTMP[$i]}
            oldchannel[$k]=${oldchannelTMP[$i]}
         fi
         i=$(($i+1))
      done
      i=0
      exist="OK"
      while [ "$exist" = "OK" ] && [ $i -le 10000 ]; do
         i=$(($i+1))
         [ -e $HOME/.xdtv/xdtvrc.bak${i} ] && exist="OK" || exist=""
      done
      mv $xawrc $HOME/.xdtv/xdtvrc.bak${i}
      echo
      echo "-->A configuration file already exist: ($HOME/.xdtv/xdtvrc)."
      echo "   That one will be renamed into $HOME/.xdtv/xdtvrc.bak${i}"
      if [ "$noldch" != "0" ]; then
         echo
         echo "Previous channels found : "
         i=0
         while [ $i -lt $noldch ]; do
           echo ${oldname[$i]}
           echo ${oldchannel[$i]}
           i=$(($i+1))
         done
         echo "Do you want to restore these previous channels into the new configuration file [ by default : y ] ? >"
         read mergechannel
         [ "$mergechannel" = "" ] && mergechannel="y"
         [ "$mergechannel" = "Y" ] && mergechannel="y"
         [ "$mergechannel" != "y" ] && mergechannel="n"  
         [ "$mergechannel" = "n" ] && echo "Ok, we don't restore them..."
         [ "$mergechannel" = "y" ] && echo "Previous Channels will be restored..." 
      fi
      rm -f $xawrc
      touch $xawrc
fi


# --Scan and save infos into $HOME/.xdtv/channelrc
if [ "$full" = "OK" ];then
   $scan -a -c $devvideo -C $devvbi -o $HOME/.xdtv/channelrc
else
   $scan -c $devvideo -C $devvbi -o $HOME/.xdtv/channelrc
fi
#---

# compare new detected channels and previous channels
if [ "$mergechannel" = "y" ]; then
   i=0
   cp $HOME/.xdtv/channelrc $HOME/.xdtv/channelrc-tmp
   while [ $i -lt $noldch ]; do
      exist=`cat $HOME/.xdtv/channelrc-tmp | grep ${oldchannel[$i]}`
      if [ "$exist" = "" ]; then
         echo "${oldname[$i]}" >> $HOME/.xdtv/channelrc
         echo "${oldchannel[$i]}" >> $HOME/.xdtv/channelrc
         echo "" >> $HOME/.xdtv/channelrc
      fi
      i=$(($i+1))
   done
   rm -f $HOME/.xdtv/channelrc-tmp
fi


# --make a chart with all informations
IFS=$'\n'
infostr=($(cat $HOME/.xdtv/channelrc))
nch=$((${#infostr[*]}))
nbchaine=`expr $nch - 3`
nbchaine=`expr $nbchaine / 2`
echo
echo
echo "Found channels list :"
# --We separate the norm option and the chart
norm=`cat $HOME/.xdtv/channelrc | grep ^norm | awk '{print $3}'`
table=`cat $HOME/.xdtv/channelrc | grep ^freq | awk '{print $3}'`
#---

# -- Make the first configuration file
echo "norm = $norm" >> $xawrctmp
echo "capture = overlay" >> $xawrctmp
echo "source = Television" >> $xawrctmp
echo "freqtab = ${table}" >> $xawrctmp
echo "fullscreen = 640 x 480" >> $xawrctmp
echo "fullscreen_mode = old" >> $xawrctmp
echo "pixsize = 128 x 96" >> $xawrctmp
echo "windowsize = 384 x 288" >> $xawrctmp
echo "colorkey = 123456" >> $xawrctmp
echo "capture_size = 768 x 576" >> $xawrctmp
echo >> $xawrctmp



# -- display detected channels
i=3
j=1
while [ $i -lt $nch ]; do
   nomchaine=`echo ${infostr[$i]} | cut -d[ -f 2 | cut -d] -f 1`
   echo "${j}. $nomchaine"
   i=$(($i+2))
   j=$(($j+1))
done

# -- add some channels manually
echo
isnum=""
until [ "$isnum" != "" ]; do
   echo -n "How many channels do you want to add manually [ by default : 0 ] ? > "
   read nbmanuel
   if [ "$nbmanuel" = "" ]; then
      echo "Ok, we don't add any new channel manually..."
      nbmanuel=0
   fi
   isnum=`echo $nbmanuel | grep "^[0-9][0-9]*$"`
   [ "$isnum" = "" ] && echo " Your answer must be an integer !"
done

i=1
k=1
while [ $k -le $nbmanuel ]; do
   echo -n "Channel Name n${k} : "
   read a
   j=$((${i}+${nch}-1))
   infostr[$j]="[$a]"
   echo -n "Channel Number n${k} : "
   read a
   j=$((${i}+${nch}))
   infostr[$j]="channel = $a"
   i=$(($i+2))
   k=$(($k+1))
done
nch=$((${nch}+${nbmanuel}+${nbmanuel}))
nbchaine=$((${nbchaine}+${nbmanuel}))

# -- rename channels
if [ -e "$HOME/.xdtv/inconnus" ]; then
   rm -f $HOME/.xdtv/inconnus
fi
touch $HOME/.xdtv/inconnus

i=3
j=1
while [ $i -lt $nch ]; do
   nomchaine=`echo ${infostr[$i]} | cut -d[ -f 2 | cut -d] -f 1 | grep unknown`
   if [ "$nomchaine" != "" ]; then
      echo "${j}. $i $nomchaine" >> $HOME/.xdtv/inconnus
      j=$(($j+1))
   fi
   i=$(($i+2))
done
inconnu=`cat $HOME/.xdtv/inconnus | grep unknown`
if [ "$inconnu" = "" ]; then
   rm -f $HOME/.xdtv/inconnus
else
   i=1
   j=5
   echo
   echo "-->Rename or suppress all unknown channels :"
   while [ $i -lt 10000 ] && [ "$j" != "" ]; do
      cp -f $xawrctmp $xawrc
      j=`cat $HOME/.xdtv/inconnus | grep ^${i} | awk '{print $2}'`
      if [ "$j" != "" ]; then
         [ -e $HOME/.xdtv/last_channel ] && rm -f $HOME/.xdtv/last_channel
         nomchaine=`echo ${infostr[$j]} | cut -d[ -f 2 | cut -d] -f 1`
         echo "Current Channel : <${nomchaine}>"
	 echo "Close XdTV if you recognize & and get the name of the current TV network ..."
         echo ${infostr[$j]} >> $xawrc
         echo ${infostr[${j}+1]} >> $xawrc
         echo "capture = overlay" >> $xawrc
         $xaw -c $devvideo -C $devvbi >/dev/null 2>&1
         echo -n "Which name do you want for this TV current network [Just press ENTER to suppress this channel...] ? > "
         read a
	 if [ "$a" = "" ];then
	    chsup=`cat $HOME/.xdtv/inconnus | grep ^${i} | awk '{print $3 $4}' `
	    echo "<Channel $chsup suppressed...>"
	    infostr[$j]="suppressed"
	 else
	    infostr[$j]="[$a]"
         fi
	 echo
      fi
      i=$(($i+1))
      rm -f $xawrc
   done
fi
[ -e $HOME/.xdtv/last_channel ] && rm -f $HOME/.xdtv/last_channel 2>/dev/null

echo "#" >> $xawrc
echo "# Global options" >> $xawrc
echo "#" >> $xawrc
echo "norm = $norm" >> $xawrc
echo "capture = grab" >> $xawrc
echo "source = Television" >> $xawrc
echo "subpage = 888" >> $xawrc
echo "freqtab = ${table}" >> $xawrc
echo >> $xawrc
echo "#" >> $xawrc
echo "# Fullscreen options" >> $xawrc
echo "#" >> $xawrc
echo "fullscreen = 640 x 480" >> $xawrc
echo "fullscreen_mode = old" >> $xawrc
echo "pixsize = 128 x 96" >> $xawrc
echo "windowsize = 384 x 288" >> $xawrc
echo "colorkey = 123456" >> $xawrc
echo "capture_size = 768 x 576" >> $xawrc
echo >> $xawrc
echo "#" >> $xawrc
echo "# Channel options" >> $xawrc
echo "#" >> $xawrc
echo 
echo "-->Sorting all channels :"
i=3
j=1
while [ $i -le $nch ]; do
   nomchaine=`echo ${infostr[$i]} | cut -d[ -f 2 | cut -d] -f 1`
   if [ "$nomchaine" = "suppressed" ]; then
      nch=$(($nch-2))
      nbchaine=$(($nbchaine-1))
      k=$i
      while [ $k -lt $nch ]; do
         infostr[$k]=${infostr[$k+2]}
         infostr[$k+1]=${infostr[$k+3]}
         k=$(($k+2))
      done
   fi
   i=$(($i+2))
   j=$(($j+1))
done


i=3
j=1
while [ $i -lt $nch ]; do
   nomchaine=`echo ${infostr[$i]} | cut -d[ -f 2 | cut -d] -f 1`
   echo "${j}. $nomchaine"
   i=$(($i+2))
   j=$(($j+1))
done
# --sorting channels
i=1
while [ $i -le $nbchaine ]; do
   isnum=""
   until [ "$isnum" != "" ]; do
      echo -n " Which channel do you want to use in position $i [ by default : $i ] ? > "
      read numpos
      if [ "$numpos" = "" ]; then
         numpos=$i
	 echo "Ok, we select channel n$i..."
      fi
      isnum=`echo $numpos | grep "^[1-9][0-9]*$"`
      if [ "$isnum" = "" ] ;then
         echo "Your answer must be an integer !"
      else
         dejapris[$i]=$numpos
	 k=1
         while [ $k -lt $i ]; do
            if [ ${dejapris[$k]} -eq $numpos ]; then
	       echo "Channel already choosen..."
	       isnum=""
	    fi
	 k=$(($k+1))
	 done
      fi
   done
   nomordre[$i]=${infostr[${numpos}+${numpos}+1]}
   canalordre[$i]=${infostr[${numpos}+${numpos}+2]}
   i=$(($i+1))
done

echo
external=""
isformat=""
while [ "$isformat" = "" ]; do
   echo -n "Do you want to add an external source (y/n) [ by default : n ] ? > "
   read repo
   if [ "$repo" = "" ]; then
      repo=n
   fi
   case $repo in
      y | Y ) external="OK"
              isformat="OK";;
      n | N ) echo "Ok, we don't add any external source..."
               isformat="OK";;
      * ) echo "Bad answer (y/n) !" ;;
   esac
done

if [ "$external" = "OK" ]; then
   echo "1) Composite 1"
   echo "2) Composite 3"
   echo "3) S-Video"
   isformat=""
   while [ "$isformat" = "" ]; do
      echo -n "Which source do you want to use [ by default : 1 ] ? > "
      read nbsource
      if [ "$nbsource" = "" ]; then
         nbsource=1
      fi
      case $nbsource in
         1) source="Composite1"
            isformat="OK"
	    echo "source $source selected...";;
         2) source="Composite3"
            isformat="OK"
	    echo "source $source selected...";;
         3) source="S-Video"
            isformat="OK"
	    echo "source $source selected...";;
         *) echo "Bad answer (1,2 or 3) !" ;;
      esac
   done
fi

j=1
while [ $j -le $nbchaine ]; do
   echo ${nomordre[$j]} >> $xawrc
   echo ${canalordre[$j]} >> $xawrc
   case $j in
     1) echo "key = KP_End" >> $xawrc ;;
     2) echo "key = KP_Down" >> $xawrc ;;
     3) echo "key = KP_Next" >> $xawrc ;;
     4) echo "key = KP_Left" >> $xawrc ;;
     5) echo "key = KP_Begin" >> $xawrc ;;
     6) echo "key = KP_Right" >> $xawrc ;;
     7) echo "key = KP_Home" >> $xawrc ;;
     8) echo "key = KP_Up" >> $xawrc ;;
     9) echo "key = KP_Prior" >> $xawrc ;;
     10) echo "key = KP_Insert" >> $xawrc ;;
     11) echo "key = Shift+KP_End" >> $xawrc ;;
     12) echo "key = Shift+KP_Down" >> $xawrc ;;
     13) echo "key = Shift+KP_Next" >> $xawrc ;;
     14) echo "key = Shift+KP_Left" >> $xawrc ;;
     15) echo "key = Shift+KP_Begin" >> $xawrc ;;
     16) echo "key = Shift+KP_Right" >> $xawrc ;;
     17) echo "key = Shift+KP_Home" >> $xawrc ;;
     18) echo "key = Shift+KP_Up" >> $xawrc ;;
     19) echo "key = Shift+KP_Prior" >> $xawrc ;;
     20) echo "key = Shift+KP_Insert" >> $xawrc ;;
     21) echo "key = Ctrl+KP_End" >> $xawrc ;;
     22) echo "key = Ctrl+KP_Down" >> $xawrc ;;
     23) echo "key = Ctrl+KP_Next" >> $xawrc ;;
     24) echo "key = Ctrl+KP_Left" >> $xawrc ;;
     25) echo "key = Ctrl+KP_Begin" >> $xawrc ;;
     26) echo "key = Ctrl+KP_Right" >> $xawrc ;;
     27) echo "key = Ctrl+KP_Home" >> $xawrc ;;
     28) echo "key = Ctrl+KP_Up" >> $xawrc ;;
     29) echo "key = Ctrl+KP_Prior" >> $xawrc ;;
     30) echo "key = Ctrl+KP_Insert" >> $xawrc ;;
   esac
   echo "color = 19000" >> $xawrc
   echo "bright = 34000" >> $xawrc
   echo "contrast = 28000" >> $xawrc
   echo "deinterlace = Linear Blend" >> $xawrc
#   echo "subpage = 888" >> $xawrc
   echo >> $xawrc
   j=$(($j+1))
done
if [ "$external" = "OK" ]; then
   echo "[external]" >> $xawrc
   echo "source = $source" >> $xawrc
   case $j in
     1) echo "key = KP_End" >> $xawrc ;;
     2) echo "key = KP_Down" >> $xawrc ;;
     3) echo "key = KP_Next" >> $xawrc ;;
     4) echo "key = KP_Left" >> $xawrc ;;
     5) echo "key = KP_Begin" >> $xawrc ;;
     6) echo "key = KP_Right" >> $xawrc ;;
     7) echo "key = KP_Home" >> $xawrc ;;
     8) echo "key = KP_Up" >> $xawrc ;;
     9) echo "key = KP_Prior" >> $xawrc ;;
     10) echo "key = KP_Insert" >> $xawrc ;;
     11) echo "key = Shift+KP_End" >> $xawrc ;;
     12) echo "key = Shift+KP_Down" >> $xawrc ;;
     13) echo "key = Shift+KP_Next" >> $xawrc ;;
     14) echo "key = Shift+KP_Left" >> $xawrc ;;
     15) echo "key = Shift+KP_Begin" >> $xawrc ;;
     16) echo "key = Shift+KP_Right" >> $xawrc ;;
     17) echo "key = Shift+KP_Home" >> $xawrc ;;
     18) echo "key = Shift+KP_Up" >> $xawrc ;;
     19) echo "key = Shift+KP_Prior" >> $xawrc ;;
     20) echo "key = Shift+KP_Insert" >> $xawrc ;;
     21) echo "key = Ctrl+KP_End" >> $xawrc ;;
     22) echo "key = Ctrl+KP_Down" >> $xawrc ;;
     23) echo "key = Ctrl+KP_Next" >> $xawrc ;;
     24) echo "key = Ctrl+KP_Left" >> $xawrc ;;
     25) echo "key = Ctrl+KP_Begin" >> $xawrc ;;
     26) echo "key = Ctrl+KP_Right" >> $xawrc ;;
     27) echo "key = Ctrl+KP_Home" >> $xawrc ;;
     28) echo "key = Ctrl+KP_Up" >> $xawrc ;;
     29) echo "key = Ctrl+KP_Prior" >> $xawrc ;;
     30) echo "key = Ctrl+KP_Insert" >> $xawrc ;;
   esac
   echo "color = 19000" >> $xawrc
   echo "bright = 34000" >> $xawrc
   echo "contrast = 28000" >> $xawrc
   echo "deinterlace = Linear Blend" >> $xawrc
#   echo "subpage = 888" >> $xawrc
fi

#- --

# --Delete all temporary files
rm -f $HOME/.xdtv/channelrc 2>/dev/null
rm -f $xawrctmp 2>/dev/null
rm -f $HOME/.xdtv/inconnus 2>/dev/null
# # --launch XdTV
$xaw

