/*****************************************************************************
 * $Id: vop.h,v 1.12 2004/09/27 10:13:03 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#ifndef _XDTV_VOP_H_
#define _XDTV_VOP_H_

#include "colorspace.h"
struct _vop2;
typedef struct {
  /* fixed part */
  char *name;
  int nbufs_needed;
  video_fmt f_src;
  video_fmt f_dest;
  /* 
     treat_image is the main function
     if nbufs_needed>1 then src is always v->bufs[v->buf_cur] 
     if height_dest>0 then height is always  height_dest
     the size of dest is width x height
     the size of src is specified by width_src and height_src
     the formats of src/dest are specified by f_src/f_dest
     return 0 if fails (should be rare), 1 if success
  */
  int (*treat_image)(struct _vop2 *v, unsigned char *dest, unsigned char *src, 
		      int width, int height);

  /* reinit is called when the buffers change
     (probably because the size has changed) 
     can be NULL if not needed.
  */
  void (*reinit)(void);

  int width_src;  // 0 means destination width, -1 means 720/768 on ntsc/pal
  int height_src; // 0 means destination height,-1 means 480/576 on ntsc/pal
  int height_dest;// 0 means no constraint,     -1 means 480/576 on ntsc/pal
  int post;       // non-zero means post-filter
} vop;

typedef struct _vop2 {
  vop *v;
  void **bufs;
  int nbufs;
  int buf_cur;
  int width_cur;
  int height_cur;
  void *dest_tmp;
  void *dest_tmp2;
  void *dest_tmp3;
  struct _vop2 *prev;
  int directgrab1; /* possible except if nbufs is too small */
  int directgrab2;
  int nbufs_prec;
} vop2;

extern vop2 *last_vop;
int get_image2_vop(vop2 *vop, void *dest, video_fmt f, int width, int height);
void *get_image_vop(vop2 *vop, video_fmt f, int width, int height);

void vop_init(char *cmdline);
void vop_register(vop *v);
int toggle_vop(char *name);
void activate_vop(char *name);
void deactivate_vop(char *name);
void register_initaction(void (*f)(void));
void register_idleaction(void (*f)(void));

/* variable often used by video operations */
extern int cur_maxheight,cur_maxwidth;
extern int debug;
extern int vop_autograb;

#endif
