/*****************************************************************************
 * strtab.c: misc label handling
 *****************************************************************************
 * $Id: strtab.c,v 1.4 2004/10/12 22:23:11 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 1997 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "strtab.h"

struct STRTAB booltab[] = {
  {0, "no"},
  {0, "false"},
  {0, "off"},
  {1, "yes"},
  {1, "true"},
  {1, "on"},
  {-1, NULL}
};

int
str_to_int_noatoi (char *str, struct STRTAB *tab)
{
  int i;

  for (i = 0; tab[i].str != NULL; i++)
    if (0 == strcasecmp (str, tab[i].str))
      return (tab[i].nr);
  return -1;
}

int
str_to_int (char *str, struct STRTAB *tab)
{
  int i;

  for (i = 0; tab[i].str != NULL; i++)
    if (0 == strcasecmp (str, tab[i].str))
      return (tab[i].nr);
  if (str[0] >= '0' && str[0] <= '9')
    return atoi (str);
  return -1;
}

char *
int_to_str (int n, struct STRTAB *tab)
{
  int i;

  for (i = 0; tab[i].str != NULL; i++)
    if (tab[i].nr == n)
      return tab[i].str;
  return NULL;
}
