/*****************************************************************************
 * lirc.c: interface to the lirc driver
 *****************************************************************************
 * $Id: lirc.c,v 1.8 2004/09/08 21:03:48 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 * Added eventmap support for xdtv Lucian Langa <cooly@eweb.ro>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * This software was based on xawtv. Those portions are
 * Copyright (C) 2000 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>

#include "config.h"
#include "commands.h"

#ifdef HAVE_LIBLIRC_CLIENT
# include <lirc/lirc_client.h>
#endif
#include "lirc.h"
#include "event.h"

/*-----------------------------------------------------------------------*/

extern int debug;

#ifdef HAVE_LIBLIRC_CLIENT
static struct lirc_config *config;

/* default mappings if we have no eventmap stuff in conf file */
static struct event_entry lirc_events[] = {
    {
	event:  "lirc-key-ch+",
	action: "setstation next",
	repeat: 1,
    },{
	event:  "lirc-key-ch-",
	action: "setstation prev",
	repeat: 1,
    },{
	event:  "lirc-key-vol+",
	action: "volume inc",
	repeat: 1,
    },{
	event:  "lirc-key-vol-",
	action: "volume dec",
	repeat: 1,
    },{
	event:  "lirc-key-Mute",
	action: "volume mute",
	repeat: 0,
    },{
	event:  "lirc-key-full_screen",
	action: "fullscreen toggle",
	repeat: 0,
    },{
	event:  "lirc-key-source",
	action: "setinput next",
	repeat: 1,
    },{
	event:  "lirc-key-reserved",
	action: "quit",
	repeat: 0,
    },{
	event:  "lirc-key-0",
	action: "keypad 0",
	repeat: 0,
    },{
	event:  "lirc-key-1",
	action: "keypad 1",
	repeat: 0,
    },{
	event:  "lirc-key-2",
	action: "keypad 2",
	repeat: 0,
    },{
	event:  "lirc-key-3",
	action: "keypad 3",
	repeat: 0,
    },{
	event:  "lirc-key-4",
	action: "keypad 4",
	repeat: 0,
    },{
	event:  "lirc-key-5",
	action: "keypad 5",
	repeat: 0,
    },{
	event:  "lirc-key-6",
	action: "keypad 6",
	repeat: 0,
    },{
	event:  "lirc-key-7",
	action: "keypad 7",
	repeat: 0,
    },{
	event:  "lirc-key-8",
	action: "keypad 8",
	repeat: 0,
    },{
	event:  "lirc-key-9",
	action: "keypad 9",
	repeat: 0,
    },{
	/* end of list */
    }
};
#endif

int lirc_tv_init()
{
#ifdef HAVE_LIBLIRC_CLIENT
    int fd;

    if (-1 == (fd = lirc_init("xdtv",debug))) {
      if (debug)
	    fprintf(stderr,"no infrared remote support available\n");
	return -1;
    }

    if (0 != lirc_readconfig(NULL,&config,NULL))
	{
		//lirc_deinit(); // we'll check eventmap no need to rush
		config = NULL;
     }
	if (debug)
	fprintf(stderr, "lirc: ~/.lircrc file %sfound\n",
		config ? "" : "not ");

     fcntl(fd,F_SETFL,O_NONBLOCK);
     fcntl(fd,F_SETFD,FD_CLOEXEC);
	event_register_list(lirc_events);
	if (debug)
	fprintf(stderr,"lirc: init ok\n");

     return fd;
 #else
	if (debug)
	fprintf(stderr,"lirc: not enabled at compile time\n");
     return -1;
 #endif
 }

int lirc_tv_havedata()
{
#ifdef HAVE_LIBLIRC_CLIENT
    char *code,event[32],*cmd;
    int dummy,repeat;
    int ret=-1;

    strcpy(event,"lirc-key-");
    while (lirc_nextcode(&code)==0 && code!=NULL)
    {
        ret = 0;
	if (3 != sscanf(code,"%x %x %20s",&dummy,&repeat,event+9))
	{
    	    fprintf(stderr,"lirc: oops, parse error: %s",code);
	    continue;
	}
	if (debug)
	    fprintf(stderr,"lirc: key=%s repeat=%d\n", event+9, repeat);
	if (config)
	{
	/* use ~/.lircrc */
    	    while (lirc_code2char(config,code,&cmd)==0 && cmd!=NULL)
	    {
		if (debug)
		    fprintf(stderr,"lirc: \"%s\"\n", cmd);
		if (0 == strcasecmp(cmd,"eventmap"))
		    event_dispatch(event, (int)NULL);
		else
		    do_command(cmd);
	    }
	}
	else
	{
	/* standalone mode */
    	event_dispatch(event, repeat);
	}
	free(code);
    }
    return ret;
#else
    return 0;
#endif
}
