# Copyright 1999-2004 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /cvsroot/xawdecode/xawdecode/gentoo/xdtv.ebuild,v 1.5 2004/11/14 00:11:58 pingus77 Exp $

inherit font

IUSE="alsa jpeg encode ffmpeg xvid lirc xinerama divx4linux neXt Xaw3d mmx"

DESCRIPTION="TV viewer with support for AVI recording and plugins"
HOMEPAGE="http://xawdecode.sourceforge.net/"
SRC_URI="mirror://sourceforge/xawdecode/${P}.tar.bz2"
RESTRICT="nomirror"
	
SLOT="0"
LICENSE="GPL-2"
KEYWORDS="~x86"

RDEPEND="virtual/x11
	>=media-libs/zvbi-0.2.4
	neXt? ( x11-libs/neXtaw )
	Xaw3d? ( !neXt? ( x11-libs/Xaw3d ) )
	divx4linux? ( >=media-libs/divx4linux-20030428 )
	ffmpeg? ( >=media-video/ffmpeg-0.4.7 )
	xvid? ( =media-libs/xvid-1* )
	encode? ( >=media-sound/lame-3.93 )
	jpeg? ( media-libs/jpeg )
	lirc? ( app-misc/lirc )
	alsa? ( >=media-libs/alsa-lib-0.9 )"

DEPEND="${RDEPEND}
	sys-apps/sed"

FONT_S="${S}/font"
FONT_SUFFIX="pcf.gz"

src_compile() {
	# makes the xaw widgets choice deterministic
	local xawconf="--disable-xaw95 --disable-xawm"
	if use neXt ; then
		use Xaw3d && ewarn "Both \"neXt\" and \"Xaw3d\" found in USE. Will use neXtaw widgets."
		xawconf="${xawconf} --enable-nextaw --disable-xaw3d"
	elif use Xaw3d ; then 
		xawconf="${xawconf} --disable-nextaw --enable-xaw3d"
	else
		xawconf="${xawconf} --disable-nextaw --disable-xaw3d"
		ewarn "If you want a better GUI toolkit, enable either \"neXt\" or \"Xaw3d\" USE flags."
	fi

	econf ${xawconf} \
		`use_enable divx4linux` \
		`use_enable alsa` \
		`use_enable jpeg` \
		`use_enable lirc` \
		`use_enable ffmpeg` \
		`use_enable xvid` \
		`use_enable xinerama` \
		`use_enable mmx` \
		--disable-cpu-detection \
		|| die "Configuration failed."

	emake OPT="${CFLAGS}" PERF_FLAGS="${CFLAGS}" || die "Compilation failed."
}

src_install() {

	sed -i "/^SUBDIRS/s:font::" Makefile

	einstall \
		ROOT=${D} || die "Installation failed."

	insinto /usr/share/applications
	doins gentoo/xdtv.desktop

	gzip font/led-fixed.pcf
	font_src_install
	
	dodoc COPYING ChangeLog AUTHORS INSTALL
	dodoc FAQ* README.* TODO lisez-moi* libavc-rate-control.txt
	dodoc xdtvrc.sample lircrc.*.sample

	docinto alevt
	dodoc alevt/README alevt/ReadmeGR alevt/CHANGELOG alevt/COPYRIGHT
	
}

pkg_postinst() {
	echo
	einfo "Please note that this ebuild created a suid-binary:"
	einfo "/usr/bin/xdtv_v4l-conf"
	echo
	einfo "The OSD font has moved. You probably should add"
	einfo "this path to your X configuration:"
	einfo "/usr/share/fonts/${PN}"
	echo
}
