/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the core module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QTRANSLATOR_H
#define QTRANSLATOR_H

#include "qobject.h"
#include "qbytearray.h"

#ifndef QT_NO_TRANSLATION

class QTranslatorPrivate;
template <typename T> class QList;

class Q_CORE_EXPORT QTranslatorMessage
{
public:
    QTranslatorMessage();
    QTranslatorMessage(const char * context, const char * sourceText,
                       const char * comment, const QString& translation = QString());
    QTranslatorMessage(QDataStream &);
    QTranslatorMessage(const QTranslatorMessage & m);

    QTranslatorMessage & operator=(const QTranslatorMessage & m);

    uint hash() const { return h; }
    const char *context() const { return cx.isNull() ? 0 : cx.constData(); }
    const char *sourceText() const { return st.isNull() ? 0 : st.constData(); }
    const char *comment() const { return cm.isNull() ? 0 : cm.constData(); }

    void setTranslation(const QString & translation) { tn = translation; }
    QString translation() const { return tn; }

    enum Prefix { NoPrefix, Hash, HashContext, HashContextSourceText,
                  HashContextSourceTextComment };
    void write(QDataStream & s, bool strip = false,
                Prefix prefix = HashContextSourceTextComment) const;
    Prefix commonPrefix(const QTranslatorMessage&) const;

    bool operator==(const QTranslatorMessage& m) const;
    bool operator!=(const QTranslatorMessage& m) const
    { return !operator==(m); }
    bool operator<(const QTranslatorMessage& m) const;
    bool operator<=(const QTranslatorMessage& m) const
    { return !m.operator<(*this); }
    bool operator>(const QTranslatorMessage& m) const
    { return m.operator<(*this); }
    bool operator>=(const QTranslatorMessage& m) const
    { return !operator<(m); }

private:
    uint h;
    QByteArray cx;
    QByteArray st;
    QByteArray cm;
    QString tn;

    enum Tag { Tag_End = 1, Tag_SourceText16, Tag_Translation, Tag_Context16,
               Tag_Hash, Tag_SourceText, Tag_Context, Tag_Comment,
               Tag_Obsolete1 };
};
Q_DECLARE_TYPEINFO(QTranslatorMessage, Q_MOVABLE_TYPE);


class Q_CORE_EXPORT QTranslator : public QObject
{
    Q_OBJECT
public:
    QTranslator(QObject *parent = 0);
#ifdef QT_COMPAT
    QT_COMPAT_CONSTRUCTOR QTranslator(QObject * parent, const char * name);
#endif
    ~QTranslator();

    virtual QTranslatorMessage findMessage(const char *, const char *,
                                            const char * = 0) const;

    bool load(const QString & filename,
               const QString & directory = QString::null,
               const QString & search_delimiters = QString::null,
               const QString & suffix = QString::null);
    bool load(const uchar *data, int len);

    void clear();

#ifndef QT_NO_TRANSLATION_BUILDER
    enum SaveMode { Everything, Stripped };

    bool save(const QString & filename, SaveMode mode = Everything);

    void insert(const QTranslatorMessage&);
    inline void insert(const char *context, const char *sourceText, const QString &translation) {
        insert(QTranslatorMessage(context, sourceText, "", translation));
    }
    void remove(const QTranslatorMessage&);
    inline void remove(const char *context, const char *sourceText) {
        remove(QTranslatorMessage(context, sourceText, ""));
    }
    bool contains(const char *, const char *, const char * comment = 0) const;

    void squeeze(SaveMode = Everything);
    void unsqueeze();

    QList<QTranslatorMessage> messages() const;
#endif

    bool isEmpty() const;

#ifdef QT_COMPAT
    QT_COMPAT QString find(const char *context, const char *sourceText, const char * comment = 0) const
        { return findMessage(context, sourceText, comment).translation(); }
#endif

private:
    Q_DISABLE_COPY(QTranslator)
    Q_DECLARE_PRIVATE(QTranslator)
};

#endif // QT_NO_TRANSLATION

#endif
