/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "plasmadelegate.h"
#include <qabstractitemmodel.h>
#include <qpainter.h>

PlasmaDelegate::PlasmaDelegate(QObject *parent)
    : QAbstractItemDelegate(parent)
{
}

PlasmaDelegate::~PlasmaDelegate()
{

}

void PlasmaDelegate::paint(QPainter *painter,
                           const QStyleOptionViewItem &option,
                           const QModelIndex &index) const
{
    unsigned char s = option.state & QStyle::Style_Selected ? 63 : 0;
    unsigned int color = index.model()->data(index, QAbstractItemModel::DisplayRole).toInt();
    unsigned char r = ((color & 0x00FF0000) >> 16) + s;
    unsigned char g = ((color & 0x0000FF00) >> 8) + s;
    unsigned char b = (color & 0x000000FF) + s;

    painter->setPen(Qt::NoPen);
    painter->setBrush(QColor(r, g, b));
    painter->drawRect(option.rect);
}

QSize PlasmaDelegate::sizeHint(const QStyleOptionViewItem &, const QModelIndex &) const
{
    return QSize(4, 4);
}
