/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include "shared_global.h"

#include <QtCore/QStringList>
#include <QtCore/QSettings>

class QT_SHARED_EXPORT PluginManager: public QObject
{
    Q_OBJECT
public:
    PluginManager(QObject *parent = 0);
    virtual ~PluginManager();

    QObject *instance(const QString &plugin) const;

    QStringList registeredPlugins() const;
    void registerPlugin(const QString &plugin);
    void unregisterPlugin(const QString &plugin);

    void registerPath(const QString &path);

    QStringList pluginPaths() const;
    void setPluginPaths(const QStringList &paths);

    void clearPluginPaths();

    void addPluginPath(const QString &path);
    void removePluginPath(const QString &path);
    bool syncSettings();
private:
    static QStringList unique(const QStringList &list);

private:
    QStringList m_pluginPaths;
    QStringList m_registeredPlugins;
};

#endif // PLUGINMANAGER_H
