/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QDESIGNER_CUSTOMWIDGET_H
#define QDESIGNER_CUSTOMWIDGET_H

#include "qdesigner_widget.h"

class FormWindow;
struct AbstractWidgetDataBaseItem;

class QDesignerCustomWidget: public QDesignerWidget
{
    Q_OBJECT
    Q_PROPERTY(bool compat READ isCompat WRITE setCompat STORED false)
    Q_PROPERTY(bool container READ isContainer WRITE setContainer STORED false)
public:
    QDesignerCustomWidget(FormWindow *formWindow, QWidget *parent = 0);
    virtual ~QDesignerCustomWidget();
    
    AbstractWidgetDataBaseItem *widgetItem() const;

    QString widgetClassName() const;
    void setWidgetClassName(const QString &widgetClassName);
        
    bool isCompat() const;
    void setCompat(bool compat);
    
    bool isContainer() const;
    void setContainer(bool container);
    
private:
    void createWidgetItem();
    
private:
    QString m_widgetClassName;
};

#endif // QDESIGNER_CUSTOMWIDGET_H
