/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef WARPIX_H
#define WARPIX_H

#include "demowidget.h"

#include <qpixmap.h>
#include <qsound.h>

class QKeyEvent;

class Warpix : public DemoWidget
{
public:
    Warpix(QWidget *parent = 0);

    void paintEvent(QPaintEvent *e);

    void setPixmap(const QPixmap &pix);

    void mouseMoveEvent(QMouseEvent *e);
    void mousePressEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);

private:
    QPixmap p1, p2, p3, p4;
    QPixmap buffer;

    double a, b, c, d;

    QPoint clickPos;

    QSound *beat;
};

#endif
