/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "KWQCursor.h"
#include "KWQLogging.h"
#include "KWQPixmap.h"
#include "WebCoreImageRenderer.h"

#include <gdk/gdk.h>
QCursor::QCursor()
    : cursor(NULL)
{
}

QCursor::QCursor(GdkCursor *cur)
    : cursor(cur)
{
}

QCursor::QCursor(const QPixmap &pixmap)
    : cursor(NULL)
{
    ERROR("not yet implemented");

    GdkPixbuf* buf = pixmap.image()->handle();
    QPoint hotSpot(0,0);
#if (GTK_MAJOR_VERSION >= 2) && (GTK_MINOR_VERSION >=4)
    cursor =  gdk_cursor_new_from_pixbuf(GDK_DISPLAY(), buf, hotSpot.x(), hotSpot.y());
#else
    GdkPixmap *gdkpixmap;
    GdkBitmap *mask;
    gdk_pixbuf_render_pixmap_and_mask(buf, &gdkpixmap, &mask, 100);
    GdkColor fg = { 0, 65535, 65535, 65535 }; /* White. */
    GdkColor bg = { 0, 0, 0, 0 }; /* Black. */
    cursor = gdk_cursor_new_from_pixmap(mask, mask, &fg, &bg, hotSpot.x(), hotSpot.y());
    g_object_unref(gdkpixmap);
    g_object_unref(mask);
#endif

}

QCursor::QCursor(const QCursor &other)
    : cursor(other.cursor)
{
    if (cursor)
	gdk_cursor_ref(cursor);

}

QCursor::~QCursor()
{
    if (cursor) 
	gdk_cursor_unref(cursor);
}
      
QCursor &QCursor::operator=(const QCursor &other)
{
    if (other.cursor) 
	gdk_cursor_ref(other.cursor);
    if (cursor) 
	gdk_cursor_unref(cursor);

    cursor = other.cursor;
    return *this;
}

GdkCursor *QCursor::handle() const
{
    return cursor;
}
