/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef ClientProxy_H
#define ClientProxy_H

#include "Proxy.h"

//
// Set the verbosity level.
//

#undef  TEST
#undef  DEBUG

class ClientProxy : public Proxy
{
  public:

  ClientProxy(int proxyFD);

  virtual ~ClientProxy();

  protected:

  virtual int handleNewXConnection(int clientFd);

  virtual int handleNewXConnectionFromProxy(int channelId);

  virtual int handleNewSyncConnection(int clientFd);

  virtual int handleNewSyncConnectionFromProxy(int channelId);

  virtual int handleNewKeybdConnection(int clientFd);

  virtual int handleNewKeybdConnectionFromProxy(int channelId);

  virtual int handleNewSambaConnection(int clientFd);

  virtual int handleNewSambaConnectionFromProxy(int channelId);

  virtual int handleNewMediaConnection(int clientFd);

  virtual int handleNewMediaConnectionFromProxy(int channelId);

  //
  // Send a notification event of the given type
  // to any active X channel.
  //

  virtual int handleNotify(T_notification_type type);

  //
  // Implement persistence according to proxy mode.
  //

  virtual int handleCheckLoad(T_proxy_load type);
  virtual int handleCheckSave();

  virtual int handleLoadFromProxy();
  virtual int handleSaveFromProxy();

  virtual int handleSaveStores(ostream *cachefs, md5_state_t *md5StateStream,
                                   md5_state_t *md5StateClient) const;

  virtual int handleLoadStores(istream *cachefs, md5_state_t *md5StateStream) const;

  //
  // Postpone any wakeup timeout.
  //

  virtual void handleUpdateWakeup() const;

  //
  // Check if there are images currently
  // being streamed.
  //

  virtual int needSplit() const;

  //
  // This proxy has wakeup and doesn't
  // have motion events.
  //

  virtual int needMotion() const
  {
    return -1;
  }

  virtual int needWakeup() const;

  virtual int getFd(int channelId) const
  {
    return channelId;
  }

  virtual int getChannel(int fd) const
  {
    return fd;
  }

  virtual void cleanupChannelMap(int channelId)
  {
  }

  //
  // Utility function used to realize
  // a new connection.
  //

  private:

  int checkNewGenericConnection(int newFD, T_channel_type type, char *label);

  int handleNewGenericConnection(int newFd, T_channel_type type, char *label);
};


#endif /* ClientProxy_H */
