/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#ifndef __Font_H__
#define __Font_H__

typedef struct {
  XFontStruct *font_struct;
  char fontName[256];
# ifdef NXAGENT_RECONNECT
  XID mirrorID;
# endif
} nxagentPrivFont;

extern int nxagentFontPrivateIndex;

#define nxagentFontPriv(pFont) \
  ((nxagentPrivFont *)FontGetPrivate(pFont, nxagentFontPrivateIndex))

#define nxagentFontStruct(pFont) (nxagentFontPriv(pFont)->font_struct)

#define nxagentFont(pFont) (nxagentFontStruct(pFont)->fid)

Bool nxagentRealizeFont();
Bool nxagentUnrealizeFont();

#ifdef NXAGENT_FONTCACHE
void nxagentFreeFontCache(void);
#endif

#ifdef NXAGENT_FONTMATCH
void nxagentListRemoteFonts(const char*, int);
int nxagentFontLookUp(const char *);
Bool nxagentFontFind(const char*, int*);
void nxagentSaveRemoteList(const char *);
void nxagentListRemoteAddName(const char *, int);

#endif /* NXAGENT_FONTMATCH */

#endif /* __Font_H__ */
