/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: datatype.h,v 3.7 2003/04/20 21:31:38 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASASKI_DATATYPE_H
#define	_MURASASKI_DATATYPE_H

enum hotplug_device {
	net,
	usb,
	pci,
	ieee1394,
	exthost
};

struct mu_op {
	enum hotplug_device device;
	char *device_name;
	char *command;
	char *mappath;
	char *default_mapname;
	int  action;
	void *config;
	void (*get_info)(void);
	int (*get_list)(struct mu_op *);
	int (*match_map)(char **,char *,char *,void *);
	int (*run)(struct mu_op *);
	void (*prepare)(struct mu_op *,int);
	void (*end)(struct mu_op *,int);
};

#endif	/* _MURASASKI_DATATYPE_H */

