/*
 *  linux/arch/arm/lib/copypage.S
 *
 *  Copyright (C) 1995-1999 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  ASM optimised string functions
 */
#include <linux/linkage.h>
#include <asm/assembler.h>
#include <asm/constants.h>

		.text
		.align	5

#ifdef __XSCALE__
	
ENTRY(copy_page)
		str	lr, [sp, #-4]!
		str	r4, [sp, #-4]!
		mov	ip, #PAGE_SZ/32
		mov	lr, r0
		mov	r4, r1
1:
		ldrd	r0, [r4], #8
		pld	[r4, #96]
		ldrd	r2, [r4], #8
		strd	r0, [lr], #8
		strd	r2, [lr], #8

		ldrd	r0, [r4], #8
		subs	ip, ip, #1
		ldrd	r2, [r4], #8
		strd	r0, [lr], #8
		strd	r2, [lr], #8
		bne	1b

		ldr	r4, [sp], #4
		ldr	pc, [sp], #4
#else

/*
 * StrongARM optimised copy_page routine
 * now 1.78bytes/cycle, was 1.60 bytes/cycle (50MHz bus -> 89MB/s)
 * Note that we probably achieve closer to the 100MB/s target with
 * the core clock switching.
 */
ENTRY(copy_page)
		stmfd	sp!, {r4, lr}			@	2
		mov	r2, #PAGE_SZ/64			@	1
		ldmia	r1!, {r3, r4, ip, lr}		@	4+1
1:		stmia	r0!, {r3, r4, ip, lr}		@	4
		ldmia	r1!, {r3, r4, ip, lr}		@	4+1
		stmia	r0!, {r3, r4, ip, lr}		@	4
		ldmia	r1!, {r3, r4, ip, lr}		@	4+1
		stmia	r0!, {r3, r4, ip, lr}		@	4
		ldmia	r1!, {r3, r4, ip, lr}		@	4
		subs	r2, r2, #1			@	1
		stmia	r0!, {r3, r4, ip, lr}		@	4
		ldmneia	r1!, {r3, r4, ip, lr}		@	4
		bne	1b				@	1
		LOADREGS(fd, sp!, {r4, pc})		@	3

#endif
