/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_PLATFORM_H
#define __ASM_ARCH_PLATFORM_H

/* memory mapped registers */
/* this memory region is not cacheable, burst writes are not allowed */
#define TIMER0_REGISTER_BASE    0x00030000	// TIMER0
#define TIMER1_REGISTER_BASE	0x00030080	// TIMER1
#define TIMER2_REGISTER_BASE	0x00030100	// timer2
#define TIMER3_REGISTER_BASE	0x00030180	// timer3
#define SERIAL0_REGISTER_BASE	0x00030200	// serial0
#define SERIAL1_REGISTER_BASE	0x00030280	// serial1
#define WDT_REGISTER_BASE	0x00030300	// watch dog timer
#define UART0_REGISTER_BASE	0x00030380	// UART0
#define UART1_REGISTER_BASE	0x00030400	// UART1
#define USB_REGISTER_BASE	0x00030480	// USB device

#define INTCTRL_REGISTER_BASE	0x00030580	// INTC
#define GIO_REGISTER_BASE	0x00030600	// GIO
#define OSD_REGISTER_BASE	0x00030680	// OSD
#define DSPC_REGISTER_BASE	0x00030700	// DSP controller
#define CCDC_REGISTER_BASE	0x00030780	// CCD controller

#define VIDEOENC_REGISTER_BASE	0x00030900	// NTSC/PAL encoder
#define SDRAMC_REGISTER_BASE	0x00030980	// SDRAM controller
#define EXBC_REGISTER_BASE	0x00030A00	// external bus controller
#define CLOCKC_REGISTER_BASE	0x00030A80	// clock controller
#define BUSC_REGISTER_BASE	0x00030B00	// bus controller
#define DMAIF_REGISTER_BASE	0x00030B80	// external bus DMA I/F
#define USBHOST_REGISTER_BASE   0x00030C00      // USB Host
#define MMCSD_REGISTER_BASE     0x00030C80      // MMC/SD
#define PREVIEW_REGISTER_BASE   0x00030D00      // preview engine
#define MSTICK_REGISTER_BASE    0x00030E00      // memory stick

/* DSPRAM */
#define DM310_DSPRAM_BASE       0x00100000  // DSPRAM base address

/* SDRAM address (real byte address) */
#define DM310_SDRAM_BASE        0x08000000  // sdram base address
#define DM310_SDRAM_SIZE        0x01000000  // hard-code 16MB for now

/* SDRAM controller registers */
#define DM310_SDRAM_MODE	    (SDRAMC_REGISTER_BASE + 0x30)
#define DM310_SDRAM_REFCTL	    (SDRAMC_REGISTER_BASE + 0x32)

/* CARD map (tentative) */
#define DM310_CARD_BASE                 0x04000000		// CFC card base address
#define DM310_CARD_ENCODED_START	0x00000800		// encoded image start address
#define DM310_CARD_ENCODED_SLOT_SIZE	0x00044000		// encoded image slot size

/* IRQ defines  (Offset listed in register document is in words, so double offset) */
#define DM310_IRQ0_STATUS (INTCTRL_REGISTER_BASE + 0x02)
#define DM310_IRQ1_STATUS (INTCTRL_REGISTER_BASE + 0x04)
#define DM310_IRQ2_STATUS (INTCTRL_REGISTER_BASE + 0x06)

#define DM310_IRQ0_ENABLE (INTCTRL_REGISTER_BASE + 0x22)
#define DM310_IRQ1_ENABLE (INTCTRL_REGISTER_BASE + 0x24)
#define DM310_IRQ2_ENABLE (INTCTRL_REGISTER_BASE + 0x26)

/* FIQ defined */
#define DM310_FIQ_STATUS  (INTCTRL_REGISTER_BASE + 0x00)
#define DM310_FIQ_ENABLE  (INTCTRL_REGISTER_BASE + 0x20)

/* special registers of interrupt controller */
#define DM310_INTIDIR     (INTCTRL_REGISTER_BASE + 0x40)
#define DM310_MINTIDIR    (INTCTRL_REGISTER_BASE + 0x42)

/* GIO defines */
#define DM310_GIO_DIR0    (GIO_REGISTER_BASE + 0x00)
#define DM310_GIO_DIR1    (GIO_REGISTER_BASE + 0x02)
#define DM310_GIO_INV0    (GIO_REGISTER_BASE + 0x04)
#define DM310_GIO_INV1    (GIO_REGISTER_BASE + 0x06)
#define DM310_GIO_BITSET0 (GIO_REGISTER_BASE + 0x08)
#define DM310_GIO_BITSET1 (GIO_REGISTER_BASE + 0x0a)
#define DM310_GIO_BITCLR0 (GIO_REGISTER_BASE + 0x0c)
#define DM310_GIO_BITCLR1 (GIO_REGISTER_BASE + 0x0e)
#define DM310_GIO_IRQPORT (GIO_REGISTER_BASE + 0x10)
#define DM310_GIO_MISC    (GIO_REGISTER_BASE + 0x12)
#define DM310_GIO_GIOCNF0 (GIO_REGISTER_BASE + 0x16)
#define DM310_GIO_GIOCNF1 (GIO_REGISTER_BASE + 0x18)
#define DM310_GIO_GIOCNF2 (GIO_REGISTER_BASE + 0x1a)
#define DM310_GIO_GIOCNF3 (GIO_REGISTER_BASE + 0x1c)
#define DM310_GIO_GIOCNF4 (GIO_REGISTER_BASE + 0x1e)
#define DM310_GIO_GIOCNF5 (GIO_REGISTER_BASE + 0x20)
#define DM310_GIO_GLOCNF0 (GIO_REGISTER_BASE + 0x22)
#define DM310_GIO_GLOCNF1 (GIO_REGISTER_BASE + 0x24)
#define DM310_GIO_TRUIDE  (GIO_REGISTER_BASE + 0x40)
#define DM310_GIO_OUTECTL (GIO_REGISTER_BASE + 0x42)
#define DM310_GIO_PUCTL   (GIO_REGISTER_BASE + 0x44)

/* GIOCNF0 Flags */
#define DM310_GIOCNF0_GIO4      (0x0 << 12)
#define DM310_GIOCNF0_INT4      (0x1 << 12)
#define DM310_GIOCNF0_USBOCSNS1 (0x2 << 12)
#define DM310_GIOCNF0_DSPGIO4   (0x4 << 12)

/* GIOCNF1 Flags */
#define DM310_GIOCNF1_GIO5      (0x0 << 0)
#define DM310_GIOCNF1_INT5      (0x1 << 0)
#define DM310_GIOCNF1_USBOCSNS0 (0x2 << 0)
#define DM310_GIOCNF1_DSPGIO5   (0x4 << 0)

#define DM310_GIOCNF1_GIO7      (0x0 << 6)
#define DM310_GIOCNF1_INT7      (0x1 << 6)
#define DM310_GIOCNF1_USBPWSW0  (0x2 << 6)
#define DM310_GIOCNF1_DSPGIO7   (0x4 << 6)

/* GIOCNF3 Flags */
#define DM310_GIOCNF3_GIO15      (0x0 << 6)
#define DM310_GIOCNF3_INT7      (0x1 << 6)
#define DM310_GIOCNF3_USBPWSW0  (0x2 << 6)
#define DM310_GIOCNF3_DSPGIO7   (0x4 << 6)

/* GIOCNF4 Flags */
#define DM310_GIOCNF4_GIO24     (0x0)
#define DM310_GIOCNF4_USBPWSW0  (0x1)

/* GIOCNF5 Flags */
#define DM310_GIOCNF5_GIO25     (0x0)
#define DM310_GIOCNF5_USBPWSW0  (0x1)



/* ARM clock rate */
/* EVM is currently clocked at 108E6 Hz */
#define DM310_CLOCK_RATE     108000000

#define DM310_CLOCKC_PLLARM   (CLOCKC_REGISTER_BASE + 0x00)
#define DM310_CLOCKC_CLKARM1  (CLOCKC_REGISTER_BASE + 0x02)
#define DM310_CLOCKC_CLKARM2  (CLOCKC_REGISTER_BASE + 0x04)
#define DM310_CLOCKC_CLKARM3  (CLOCKC_REGISTER_BASE + 0x06)
#define DM310_CLOCKC_PLLDSP   (CLOCKC_REGISTER_BASE + 0x08)
#define DM310_CLOCKC_CLKDSP   (CLOCKC_REGISTER_BASE + 0x0A)
#define DM310_CLOCKC_PLLSDR   (CLOCKC_REGISTER_BASE + 0x0C)
#define DM310_CLOCKC_CLKSDR   (CLOCKC_REGISTER_BASE + 0x0E)
#define DM310_CLOCKC_CLKENC   (CLOCKC_REGISTER_BASE + 0x10)
#define DM310_CLOCKC_CLKUSB   (CLOCKC_REGISTER_BASE + 0x12)
#define DM310_CLOCKC_CLKCCD   (CLOCKC_REGISTER_BASE + 0x14)
#define DM310_CLOCKC_PLLCOP   (CLOCKC_REGISTER_BASE + 0x16)
#define DM310_CLOCKC_CLKMS    (CLOCKC_REGISTER_BASE + 0x18)
#define DM310_CLOCKC_CLKVENC  (CLOCKC_REGISTER_BASE + 0x1A)
#define DM310_CLOCKC_PWRDN    (CLOCKC_REGISTER_BASE + 0x1C)
#define DM310_CLOCKC_PLLRESET (CLOCKC_REGISTER_BASE + 0x1E)

/* CLKARM3 Flags */
#define DM310_CLKARM3_SERI      0x0008
#define DM310_CLKARM3_GIO       0x0010
#define DM310_CLKARM3_EXDIF     0x0020
#define DM310_CLKARM3_EXBC      0x0040
#define DM310_CLKARM3_MS        0x0080
#define DM310_CLKARM3_MMCSD     0x0100
#define DM310_CLKARM3_USBH      0x0200
#define DM310_CLKARM3_USBF      0x0800

/* CLKUSB Flags */
#define DM310_CLKUSB_USBF       0x0002
#define DM310_CLKUSB_USBH       0x0004
#define DM310_CLKUSB_MS         0x0010


/* external bus */
#define DM310_EXTBUS_BUSRST	(EXBC_REGISTER_BASE + 0x00)
#define DM310_EXTBUS_BUSMD	(EXBC_REGISTER_BASE + 0x04)
#define DM310_EXTBUS_BUSINTEN	(EXBC_REGISTER_BASE + 0x08)
#define DM310_EXTBUS_BUSINTST	(EXBC_REGISTER_BASE + 0x0c)
#define DM310_EXTBUS_BUSST	(EXBC_REGISTER_BASE + 0x10)
#define DM310_EXTBUS_WP		(EXBC_REGISTER_BASE + 0x14)
#define DM310_EXTBUS_BUSCFE1	(EXBC_REGISTER_BASE + 0x18)
#define DM310_EXTBUS_BUSWAITMD	(EXBC_REGISTER_BASE + 0x1C)
#define DM310_EXTBUS_HSTIME	(EXBC_REGISTER_BASE + 0x24)
#define DM310_EXTBUS_ECCCLR	(EXBC_REGISTER_BASE + 0x28)
#define DM310_EXTBUS_ECC1CP	(EXBC_REGISTER_BASE + 0x40)
#define DM310_EXTBUS_ECC1LP	(EXBC_REGISTER_BASE + 0x44)
#define DM310_EXTBUS_ECC2CP	(EXBC_REGISTER_BASE + 0x48)
#define DM310_EXTBUS_ECC2LP	(EXBC_REGISTER_BASE + 0x4c)

#define DM310_EXTBUS_ST_CFRDY	0x0001
/* bit 1 is reserved */
#define DM310_EXTBUS_ST_WAIT	0x0004
#define DM310_EXTBUS_ST_STSCHG	0x0008
#define DM310_EXTBUS_ST_CD1	0x0010
#define DM310_EXTBUS_ST_CD2	0x0020
#define DM310_EXTBUS_ST_WP	0x0040

/* external DMA controller */
#define DM310_EXTDMA_CTL	(DMAIF_REGISTER_BASE + 0x00)
#define DM310_EXTDMA_MODE	(DMAIF_REGISTER_BASE + 0x02)
#define DM310_EXTDMA_TRSZ	(DMAIF_REGISTER_BASE + 0x04)
#define DM310_EXTDMA_EXBADR0	(DMAIF_REGISTER_BASE + 0x06)
#define DM310_EXTDMA_EXBADR1	(DMAIF_REGISTER_BASE + 0x08)
#define DM310_EXTDMA_STADR0	(DMAIF_REGISTER_BASE + 0x0a)
#define DM310_EXTDMA_STADR1	(DMAIF_REGISTER_BASE + 0x0c)
#define DM310_EXTDMA_STATUS	(DMAIF_REGISTER_BASE + 0x0e)

/* uarts (note that the register fields aren't needed by the standard linux
   serial driver -- we only use them for our initial debugging console) */
#define DM310_UART0       (UART0_REGISTER_BASE + 0x00)
#define DM310_UART0_DTRR  (UART0_REGISTER_BASE + 0x00)
#define DM310_UART0_BRSR  (UART0_REGISTER_BASE + 0x02)
#define DM310_UART0_MSR   (UART0_REGISTER_BASE + 0x04)
#define DM310_UART0_RFCR  (UART0_REGISTER_BASE + 0x06)
#define DM310_UART0_TFCR  (UART0_REGISTER_BASE + 0x08)
#define DM310_UART0_LCR	  (UART0_REGISTER_BASE + 0x0a)
#define DM310_UART0_SR 	  (UART0_REGISTER_BASE + 0x0c)

#define DM310_UART1       (UART1_REGISTER_BASE + 0x00)
#define DM310_UART1_DTRR  (UART1_REGISTER_BASE + 0x00)
#define DM310_UART1_BRSR  (UART1_REGISTER_BASE + 0x02)
#define DM310_UART1_MSR   (UART1_REGISTER_BASE + 0x04)
#define DM310_UART1_RFCR  (UART1_REGISTER_BASE + 0x06)
#define DM310_UART1_TFCR  (UART1_REGISTER_BASE + 0x08)
#define DM310_UART1_LCR	  (UART1_REGISTER_BASE + 0x0a)
#define DM310_UART1_SR 	  (UART1_REGISTER_BASE + 0x0c)

/* timers */
#define DM310_TIMER0_MODE    (TIMER0_REGISTER_BASE + 0x00)
#define DM310_TIMER0_SEL     (TIMER0_REGISTER_BASE + 0x02)
#define DM310_TIMER0_SCAL    (TIMER0_REGISTER_BASE + 0x04)
#define DM310_TIMER0_DIV     (TIMER0_REGISTER_BASE + 0x06)
#define DM310_TIMER0_TRG     (TIMER0_REGISTER_BASE + 0x08)
#define DM310_TIMER0_CNT     (TIMER0_REGISTER_BASE + 0x0a)

#define DM310_TIMER1_MODE    (TIMER1_REGISTER_BASE + 0x00)
#define DM310_TIMER1_SEL     (TIMER1_REGISTER_BASE + 0x02)
#define DM310_TIMER1_SCAL    (TIMER1_REGISTER_BASE + 0x04)
#define DM310_TIMER1_DIV     (TIMER1_REGISTER_BASE + 0x06)
#define DM310_TIMER1_TRG     (TIMER1_REGISTER_BASE + 0x08)
#define DM310_TIMER1_CNT     (TIMER1_REGISTER_BASE + 0x0a)

#define DM310_TIMER2_MODE    (TIMER2_REGISTER_BASE + 0x00)
#define DM310_TIMER2_SEL     (TIMER2_REGISTER_BASE + 0x02)
#define DM310_TIMER2_SCAL    (TIMER2_REGISTER_BASE + 0x04)
#define DM310_TIMER2_DIV     (TIMER2_REGISTER_BASE + 0x06)
#define DM310_TIMER2_TRG     (TIMER2_REGISTER_BASE + 0x08)
#define DM310_TIMER2_CNT     (TIMER2_REGISTER_BASE + 0x0a)

#define DM310_TIMER3_MODE    (TIMER3_REGISTER_BASE + 0x00)
#define DM310_TIMER3_SEL     (TIMER3_REGISTER_BASE + 0x02)
#define DM310_TIMER3_SCAL    (TIMER3_REGISTER_BASE + 0x04)
#define DM310_TIMER3_DIV     (TIMER3_REGISTER_BASE + 0x06)
#define DM310_TIMER3_TRG     (TIMER3_REGISTER_BASE + 0x08)
#define DM310_TIMER3_CNT     (TIMER3_REGISTER_BASE + 0x0a)

/* Watchdog */
#define DM310_WDT_MODE       (WDT_REGISTER_BASE + 0x00)
#define DM310_WDT_RST        (WDT_REGISTER_BASE + 0x02)
#define DM310_WDT_SCAL       (WDT_REGISTER_BASE + 0x04)
#define DM310_WDT_DIV        (WDT_REGISTER_BASE + 0x06)

/* USBHOST Control Registers */
#define DM310_USBHOST_HCCOMMANDSTATUS   (USBHOST_REGISTER_BASE + 0x08)
#define DM310_USBHOST_HCDSCMISC1        (USBHOST_REGISTER_BASE + 0x78)
#define DM310_USBHOST_HCDSCMISC2        (USBHOST_REGISTER_BASE + 0x7c)

/* USB Host Command Status Register Flags */
#define DM310_USBHOSTCMDST_RST  0x00000001


/* USB Host Miscellaneous Control #1 Flags */
#define DM310_USBHOSTMISC1_PTC  0x00000001

/* USB Control Registers */
/* endpoint 0 */
#define DM310_USB_EP0OAD        (USB_REGISTER_BASE + 0x00)
#define DM310_USB_EP0OSZ        (USB_REGISTER_BASE + 0x02)
#define DM310_USB_EP0OCTL       (USB_REGISTER_BASE + 0x04)
#define DM310_USB_EP0OIRQSZ     (USB_REGISTER_BASE + 0x06)
#define DM310_USB_EP0ORDT       (USB_REGISTER_BASE + 0x0A)
#define DM310_USB_EP0OREM       (USB_REGISTER_BASE + 0x0C)
#define DM310_USB_EP0OST        (USB_REGISTER_BASE + 0x0E)
#define DM310_USB_EP0IAD        (USB_REGISTER_BASE + 0x10)
#define DM310_USB_EP0ISZ        (USB_REGISTER_BASE + 0x12)
#define DM310_USB_EP0ICTL       (USB_REGISTER_BASE + 0x14)
#define DM310_USB_EP0IIRQSZ     (USB_REGISTER_BASE + 0x16)
#define DM310_USB_EP0IWDT       (USB_REGISTER_BASE + 0x18)
#define DM310_USB_EP0IREM       (USB_REGISTER_BASE + 0x1c)
#define DM310_USB_EP0IST        (USB_REGISTER_BASE + 0x1e)
/* endpoint 1 */
#define DM310_USB_EP1OAD        (USB_REGISTER_BASE + 0x20)
#define DM310_USB_EP1OSZ        (USB_REGISTER_BASE + 0x22)
#define DM310_USB_EP1OCTL       (USB_REGISTER_BASE + 0x24)
#define DM310_USB_EP1OIRQSZ     (USB_REGISTER_BASE + 0x26)
#define DM310_USB_EP1ORDT       (USB_REGISTER_BASE + 0x2A)
#define DM310_USB_EP1OREM       (USB_REGISTER_BASE + 0x2C)
#define DM310_USB_EP1OST        (USB_REGISTER_BASE + 0x2E)
#define DM310_USB_EP1IAD        (USB_REGISTER_BASE + 0x30)
#define DM310_USB_EP1ISZ        (USB_REGISTER_BASE + 0x32)
#define DM310_USB_EP1ICTL       (USB_REGISTER_BASE + 0x34)
#define DM310_USB_EP1IIRQSZ     (USB_REGISTER_BASE + 0x36)
#define DM310_USB_EP1IWDT       (USB_REGISTER_BASE + 0x38)
#define DM310_USB_EP1IREM       (USB_REGISTER_BASE + 0x3c)
#define DM310_USB_EP1IST        (USB_REGISTER_BASE + 0x3e)
/* endpoint 2 */
#define DM310_USB_EP2OAD        (USB_REGISTER_BASE + 0x40)
#define DM310_USB_EP2OSZ        (USB_REGISTER_BASE + 0x42)
#define DM310_USB_EP2OCTL       (USB_REGISTER_BASE + 0x44)
#define DM310_USB_EP2OIRQSZ     (USB_REGISTER_BASE + 0x46)
#define DM310_USB_EP2ORDT       (USB_REGISTER_BASE + 0x4A)
#define DM310_USB_EP2OREM       (USB_REGISTER_BASE + 0x4C)
#define DM310_USB_EP2OST        (USB_REGISTER_BASE + 0x4E)
#define DM310_USB_EP2IAD        (USB_REGISTER_BASE + 0x50)
#define DM310_USB_EP2ISZ        (USB_REGISTER_BASE + 0x52)
#define DM310_USB_EP2ICTL       (USB_REGISTER_BASE + 0x54)
#define DM310_USB_EP2IIRQSZ     (USB_REGISTER_BASE + 0x56)
#define DM310_USB_EP2IWDT       (USB_REGISTER_BASE + 0x58)
#define DM310_USB_EP2IREM       (USB_REGISTER_BASE + 0x5c)
#define DM310_USB_EP2IST        (USB_REGISTER_BASE + 0x5e)

#define DM310_USB_RST           (USB_REGISTER_BASE + 0x60)
#define DM310_USB_RSM           (USB_REGISTER_BASE + 0x62)
#define DM310_USB_INTMSK        (USB_REGISTER_BASE + 0x64)
#define DM310_USB_CFG           (USB_REGISTER_BASE + 0x66)
#define DM310_USB_ST            (USB_REGISTER_BASE + 0x68)
#define DM310_USB_INTST         (USB_REGISTER_BASE + 0x6a)
#define DM310_USB_FRM           (USB_REGISTER_BASE + 0x6c)
#define DM310_USB_ALT           (USB_REGISTER_BASE + 0x6e)
#define DM310_USB_CTL           (USB_REGISTER_BASE + 0x70)
#define DM310_USB_DMAAD0        (USB_REGISTER_BASE + 0x72)
#define DM310_USB_DMAAD1        (USB_REGISTER_BASE + 0x74)
#define DM310_USB_DMASZ         (USB_REGISTER_BASE + 0x76)
#define DM310_USB_DMACTL        (USB_REGISTER_BASE + 0x78)
#define DM310_USB_DMATRG        (USB_REGISTER_BASE + 0x7a)

/* MMC/SD controller */
#define DM310_MMC_FCLK		(MMCSD_REGISTER_BASE + 0x00)
#define DM310_MMC_CTL 		(MMCSD_REGISTER_BASE + 0x02)
#define DM310_MMC_CLK 		(MMCSD_REGISTER_BASE + 0x04)
#define DM310_MMC_ST0 		(MMCSD_REGISTER_BASE + 0x06)
#define DM310_MMC_ST1 		(MMCSD_REGISTER_BASE + 0x08)
#define DM310_MMC_IE  		(MMCSD_REGISTER_BASE + 0x0a)
#define DM310_MMC_TOR 		(MMCSD_REGISTER_BASE + 0x0c)
#define DM310_MMC_TOD 		(MMCSD_REGISTER_BASE + 0x0e)
#define DM310_MMC_BLEN		(MMCSD_REGISTER_BASE + 0x10)
#define DM310_MMC_NBLK		(MMCSD_REGISTER_BASE + 0x12)
#define DM310_MMC_NBLC		(MMCSD_REGISTER_BASE + 0x14)
#define DM310_MMC_DRR 		(MMCSD_REGISTER_BASE + 0x16)
#define DM310_MMC_DXR 		(MMCSD_REGISTER_BASE + 0x18)
#define DM310_MMC_CMD 		(MMCSD_REGISTER_BASE + 0x1a)
#define DM310_MMC_ARGL		(MMCSD_REGISTER_BASE + 0x1c)
#define DM310_MMC_ARGH		(MMCSD_REGISTER_BASE + 0x1e)
#define DM310_MMC_RSP0		(MMCSD_REGISTER_BASE + 0x20)
#define DM310_MMC_RSP1		(MMCSD_REGISTER_BASE + 0x22)
#define DM310_MMC_RSP2		(MMCSD_REGISTER_BASE + 0x24)
#define DM310_MMC_RSP3		(MMCSD_REGISTER_BASE + 0x26)
#define DM310_MMC_RSP4		(MMCSD_REGISTER_BASE + 0x28)
#define DM310_MMC_RSP5		(MMCSD_REGISTER_BASE + 0x2a)
#define DM310_MMC_RSP6		(MMCSD_REGISTER_BASE + 0x2c)
#define DM310_MMC_RSP7		(MMCSD_REGISTER_BASE + 0x2e)
#define DM310_MMC_DRSP		(MMCSD_REGISTER_BASE + 0x30)
#define DM310_MMC_ETOK		(MMCSD_REGISTER_BASE + 0x32)
#define DM310_MMC_CIDX		(MMCSD_REGISTER_BASE + 0x34)

/* Video Encoder, OSD */
#define DM310_OSDMODE                 (OSD_REGISTER_BASE + 0x00)
#define DM310_VIDWINMD                (OSD_REGISTER_BASE + 0x02)
#define DM310_OSDWIN0MD               (OSD_REGISTER_BASE + 0x04)
#define DM310_OSDWIN1MD               (OSD_REGISTER_BASE + 0x06)
#define DM310_RECTCUR                 (OSD_REGISTER_BASE + 0x08)
#define DM310_BMPCUR                  (OSD_REGISTER_BASE + 0x0A)
#define DM310_VIDWIN0OFST             (OSD_REGISTER_BASE + 0x0C)
#define DM310_VIDWIN1OFST             (OSD_REGISTER_BASE + 0x0E)
#define DM310_OSDWIN0OFST             (OSD_REGISTER_BASE + 0x10)
#define DM310_OSDWIN1OFST             (OSD_REGISTER_BASE + 0x12)
#define DM310_VIDWINADH               (OSD_REGISTER_BASE + 0x14)
#define DM310_VIDWIN0ADL              (OSD_REGISTER_BASE + 0x16)
#define DM310_VIDWIN1ADL              (OSD_REGISTER_BASE + 0x18)
#define DM310_OSDWINADH               (OSD_REGISTER_BASE + 0x1A)
#define DM310_OSDWIN0ADL              (OSD_REGISTER_BASE + 0x1C)
#define DM310_OSDWIN1ADL              (OSD_REGISTER_BASE + 0x1E)
#define DM310_BASEPX                  (OSD_REGISTER_BASE + 0x20)
#define DM310_BASEPY                  (OSD_REGISTER_BASE + 0x22)
#define DM310_VIDWIN0XP               (OSD_REGISTER_BASE + 0x24)
#define DM310_VIDWIN0YP               (OSD_REGISTER_BASE + 0x26)
#define DM310_VIDWIN0XL               (OSD_REGISTER_BASE + 0x28)
#define DM310_VIDWIN0YL               (OSD_REGISTER_BASE + 0x2A)
#define DM310_VIDWIN1XP               (OSD_REGISTER_BASE + 0x2C)
#define DM310_VIDWIN1YP               (OSD_REGISTER_BASE + 0x2E)
#define DM310_VIDWIN1XL               (OSD_REGISTER_BASE + 0x30)
#define DM310_VIDWIN1YL               (OSD_REGISTER_BASE + 0x32)
#define DM310_OSDWIN0XP               (OSD_REGISTER_BASE + 0x34)
#define DM310_OSDWIN0YP               (OSD_REGISTER_BASE + 0x36)
#define DM310_OSDWIN0XL               (OSD_REGISTER_BASE + 0x38)
#define DM310_OSDWIN0YL               (OSD_REGISTER_BASE + 0x3A)
#define DM310_OSDWIN1XP               (OSD_REGISTER_BASE + 0x3C)
#define DM310_OSDWIN1YP               (OSD_REGISTER_BASE + 0x3E)
#define DM310_OSDWIN1XL               (OSD_REGISTER_BASE + 0x40)
#define DM310_OSDWIN1YL               (OSD_REGISTER_BASE + 0x42)
#define DM310_CURXP                   (OSD_REGISTER_BASE + 0x44)
#define DM310_CURYP                   (OSD_REGISTER_BASE + 0x46)
#define DM310_CURXL                   (OSD_REGISTER_BASE + 0x48)
#define DM310_CURYL                   (OSD_REGISTER_BASE + 0x4A)
#define DM310_BMPCURXP                (OSD_REGISTER_BASE + 0x4C)
#define DM310_BMPCURYP                (OSD_REGISTER_BASE + 0x4E)
#define DM310_W0BMP01                 (OSD_REGISTER_BASE + 0x50)
#define DM310_W0BMP23                 (OSD_REGISTER_BASE + 0x52)
#define DM310_W0BMP45                 (OSD_REGISTER_BASE + 0x54)
#define DM310_W0BMP67                 (OSD_REGISTER_BASE + 0x56)
#define DM310_W0BMP89                 (OSD_REGISTER_BASE + 0x58)
#define DM310_W0BMPAB                 (OSD_REGISTER_BASE + 0x5A)
#define DM310_W0BMPCD                 (OSD_REGISTER_BASE + 0x5C)
#define DM310_W0BMPEF                 (OSD_REGISTER_BASE + 0x5E)
#define DM310_W1BMP01                 (OSD_REGISTER_BASE + 0x60)
#define DM310_W1BMP23                 (OSD_REGISTER_BASE + 0x62)
#define DM310_W1BMP45                 (OSD_REGISTER_BASE + 0x64)
#define DM310_W1BMP67                 (OSD_REGISTER_BASE + 0x66)
#define DM310_W1BMP89                 (OSD_REGISTER_BASE + 0x68)
#define DM310_W1BMPAB                 (OSD_REGISTER_BASE + 0x6A)
#define DM310_W1BMPCD                 (OSD_REGISTER_BASE + 0x6C)
#define DM310_W1BMPEF                 (OSD_REGISTER_BASE + 0x6E)
#define DM310_BMPCURDAT               (OSD_REGISTER_BASE + 0x72)
#define DM310_MISCCTL                 (OSD_REGISTER_BASE + 0x74)
#define DM310_CLUTRAMYCB              (OSD_REGISTER_BASE + 0x76)
#define DM310_CLUTRAMCR               (OSD_REGISTER_BASE + 0x78)
#define DM310_PPVWIN0ADH              (OSD_REGISTER_BASE + 0x7C)
#define DM310_PPVWIN1ADH              (OSD_REGISTER_BASE + 0x7E)

#define DM310_VID01              (VIDEOENC_REGISTER_BASE + 0x00)
#define DM310_VID02              (VIDEOENC_REGISTER_BASE + 0x02)
#define DM310_DLCD1              (VIDEOENC_REGISTER_BASE + 0x04)
#define DM310_DLCD2              (VIDEOENC_REGISTER_BASE + 0x06)
#define DM310_DCLKPTN0           (VIDEOENC_REGISTER_BASE + 0x08)
#define DM310_DCLKPTN1           (VIDEOENC_REGISTER_BASE + 0x0A)
#define DM310_DCLKPTN2           (VIDEOENC_REGISTER_BASE + 0x0C)
#define DM310_DCLKPTN3           (VIDEOENC_REGISTER_BASE + 0x0E)
#define DM310_DCLKSTPH           (VIDEOENC_REGISTER_BASE + 0x10)
#define DM310_DCLKVLDH           (VIDEOENC_REGISTER_BASE + 0x12)
#define DM310_DCLKSTPV           (VIDEOENC_REGISTER_BASE + 0x14)
#define DM310_DCLKVLDV           (VIDEOENC_REGISTER_BASE + 0x16)
#define DM310_HVPWIDTH           (VIDEOENC_REGISTER_BASE + 0x18)
#define DM310_HINTERVL           (VIDEOENC_REGISTER_BASE + 0x1A)
#define DM310_HSTART             (VIDEOENC_REGISTER_BASE + 0x1C)
#define DM310_HVALID             (VIDEOENC_REGISTER_BASE + 0x1E)
#define DM310_VINTERVL           (VIDEOENC_REGISTER_BASE + 0x20)
#define DM310_VSTART             (VIDEOENC_REGISTER_BASE + 0x22)
#define DM310_VVALID             (VIDEOENC_REGISTER_BASE + 0x24)
#define DM310_HDELAY             (VIDEOENC_REGISTER_BASE + 0x26)
#define DM310_VDELAY             (VIDEOENC_REGISTER_BASE + 0x28)
#define DM310_CULLLINE           (VIDEOENC_REGISTER_BASE + 0x2A)
#define DM310_PWMCTRL            (VIDEOENC_REGISTER_BASE + 0x2C)
#define DM310_PWMCNT             (VIDEOENC_REGISTER_BASE + 0x2E)
#define DM310_RGBLEVEL           (VIDEOENC_REGISTER_BASE + 0x30)
#define DM310_ATR0               (VIDEOENC_REGISTER_BASE + 0x32)
#define DM310_ATR1               (VIDEOENC_REGISTER_BASE + 0x34)
#define DM310_ATR2               (VIDEOENC_REGISTER_BASE + 0x36)

/* memory stick controller registers */
#define MS_CMD			(MSTICK_REGISTER_BASE + 0x00)
#define MS_MODE			(MSTICK_REGISTER_BASE + 0x02)
#define MS_STAT			(MSTICK_REGISTER_BASE + 0x04)
#define MS_CTL			(MSTICK_REGISTER_BASE + 0x08)
#define MS_IDAT			(MSTICK_REGISTER_BASE + 0x0C)
#define MS_ICTL			(MSTICK_REGISTER_BASE + 0x10)
#define MS_PPDATA 		(MSTICK_REGISTER_BASE + 0x14)
#define MS_DRR	 		(MSTICK_REGISTER_BASE + 0x20)
#define MS_DXR	 		(MSTICK_REGISTER_BASE + 0x24)
#define MS_FIFOCTL 		(MSTICK_REGISTER_BASE + 0x28)
#define MS_FIFOCNT 		(MSTICK_REGISTER_BASE + 0x2C)

#endif
