/*
 * irqs.h:
 *         IRQ numbers for the dm310.
 * copyright:
 *              (C) 2002 Matthias Welwarsky
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 *
 * THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 * WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 * NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 * USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write  to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __ASM_ARCH_IRQS_H__
#define __ASM_ARCH_IRQS_H__

/* irq #s */

/* NOTE: the numbering is different from the TI documents
 *       reordering was needed because TI engineers
 *       managed to make it extremely difficult to use
 *       the INTIDIR register efficiently. Everything is
 *       OK for the DSC21 style interrupts, but the way
 *       they implemented the DM310 specific IDs is just,
 *       well, interesting.
 */

/* IRQ1 */
#define DM310_IRQ_TIMER0  0x00
#define DM310_IRQ_TIMER1  0x01
#define DM310_IRQ_TIMER2  0x02
#define DM310_IRQ_TIMER3  0x03
#define DM310_IRQ_CCDVD0  0x04
#define DM310_IRQ_CCDVD1  0x05
#define DM310_IRQ_CCDVD2  0x06
#define DM310_IRQ_ENCVD   0x07
#define DM310_IRQ_SERIAL0 0x08
#define DM310_IRQ_SERIAL1 0x09
#define DM310_IRQ_DSP     0x0a
#define DM310_IRQ_UART0   0x0b
#define DM310_IRQ_UART1   0x0c
#define DM310_IRQ_USB     0x0d
#define DM310_IRQ_EXBC    0x0f

/* IRQ0 */
#define DM310_IRQ_EXT0    0x10
#define DM310_IRQ_EXT1    0x11
#define DM310_IRQ_EXT2    0x12
#define DM310_IRQ_EXT3    0x13
#define DM310_IRQ_EXT4    0x14
#define DM310_IRQ_EXT5    0x15
#define DM310_IRQ_EXT6    0x16
#define DM310_IRQ_EXT7    0x17
#define DM310_IRQ_EXDMA   0x18
#define DM310_IRQ_FLRDY   0x19

/* IRQ2 */
#define DM310_IRQ_USBHOST 0x1a
#define DM310_IRQ_PREVIEW 0x1b
#define DM310_IRQ_MMCSD   0x1c
#define DM310_IRQ_MSTICK  0x1d

#define NR_IRQS           (DM310_IRQ_MSTICK + 1)

/* alias */
#define IRQ_TIMER         DM310_IRQ_TIMER0

/* CFLASH IDE */
#define IRQ_HARDDISK	  DM310_IRQ_EXBC

/* flags for request_irq() */
#define IRQ_FLG_LOCK      (0x0001)  /* handler is not replaceable   */
#define IRQ_FLG_REPLACE   (0x0002)  /* replace existing handler     */
#define IRQ_FLG_FAST      (0x0004)
#define IRQ_FLG_SLOW      (0x0008)
#define IRQ_FLG_STD       (0x8000)  /* internally used              */

/* bit positions in IRQ0_XXX */
#define DM310_IRQ0POS_EXT0       (0x0001)
#define DM310_IRQ0POS_EXT1       (0x0002)
#define DM310_IRQ0POS_EXT2       (0x0004)
#define DM310_IRQ0POS_EXT3       (0x0008)
#define DM310_IRQ0POS_EXT4       (0x0010)
#define DM310_IRQ0POS_EXT5       (0x0020)
#define DM310_IRQ0POS_EXT6       (0x0040)
#define DM310_IRQ0POS_EXT7       (0x0080)
#define DM310_IRQ0POS_EXDMA      (0x0100)
#define DM310_IRQ0POS_FLRDY      (0x0200)

/* bit positions in IRQ1_XXX */
#define DM310_IRQ1POS_TIMER0     (0x0001)
#define DM310_IRQ1POS_TIMER1     (0x0002)
#define DM310_IRQ1POS_TIMER2     (0x0004)
#define DM310_IRQ1POS_TIMER3     (0x0008)
#define DM310_IRQ1POS_CCDVD0     (0x0010)
#define DM310_IRQ1POS_CCDVD1     (0x0020)
#define DM310_IRQ1POS_CCDVD2     (0x0040)
#define DM310_IRQ1POS_ENCVD      (0x0080)
#define DM310_IRQ1POS_SERIAL0    (0x0100)
#define DM310_IRQ1POS_SERIAL1    (0x0200)
#define DM310_IRQ1POS_DSP        (0x0400)
#define DM310_IRQ1POS_UART0      (0x0800)
#define DM310_IRQ1POS_UART1      (0x1000)
#define DM310_IRQ1POS_USB        (0x2000)
/* bit 14 is reserverd */
#define DM310_IRQ1POS_EXBC       (0x8000)

/* bit positions in IRQ2_XXX */
/* bit 0 is reserverd */
#define DM310_IRQ2POS_USBHOST    (0x0002)
#define DM310_IRQ2POS_MMCSD      (0x0004)
#define DM310_IRQ2POS_MSTICK     (0x0008)
#define DM310_IRQ2POS_PREVIEW    (0x0010)
/* rest reserved */

#endif /* __ASM_ARCH_IRQS_H__ */
