/*
 *  linux/include/asm-arm/atomic.h
 *
 *  Copyright (c) 1996 Russell King.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  Changelog:
 *   27-06-1996	RMK	Created
 *   13-04-1997	RMK	Made functions atomic!
 *   07-12-1997	RMK	Upgraded for v2.1.
 *   26-08-1998	PJB	Added #ifdef __KERNEL__
 */
#ifndef __ASM_ARM_ATOMIC_H
#define __ASM_ARM_ATOMIC_H

#include <linux/config.h>

#ifdef CONFIG_SMP
#error SMP not supported
#endif

typedef struct { volatile int counter; } atomic_t;

#define ATOMIC_INIT(i)	{ (i) }

#ifdef __KERNEL__

#ifdef CONFIG_RTHAL
#include <asm/proc/hard_system.h>
#define my_local_irq_save(x)    hard_save_flags_cli(x)
#define my_local_irq_restore(x) hard_restore_flags(x)
#else
#include <asm/proc/system.h>
#define my_local_irq_save(x)    local_irq_save(x)
#define my_local_irq_restore(x) local_irq_restore(x)
#endif

#define atomic_read(v)	((v)->counter)
#define atomic_set(v,i)	(((v)->counter) = (i))

static inline void atomic_add(int i, volatile atomic_t *v)
{
	unsigned long flags;

	my_local_irq_save(flags);
	v->counter += i;
	my_local_irq_restore(flags);
}

static inline void atomic_sub(int i, volatile atomic_t *v)
{
	unsigned long flags;

	my_local_irq_save(flags);
	v->counter -= i;
	my_local_irq_restore(flags);
}

static inline void atomic_inc(volatile atomic_t *v)
{
	unsigned long flags;

	my_local_irq_save(flags);
	v->counter += 1;
	my_local_irq_restore(flags);
}

static inline void atomic_dec(volatile atomic_t *v)
{
	unsigned long flags;

	my_local_irq_save(flags);
	v->counter -= 1;
	my_local_irq_restore(flags);
}

static inline int atomic_dec_and_test(volatile atomic_t *v)
{
	unsigned long flags;
	int val;

	my_local_irq_save(flags);
	val = v->counter;
	v->counter = val -= 1;
	my_local_irq_restore(flags);

	return val == 0;
}

static inline int atomic_add_negative(int i, volatile atomic_t *v)
{
	unsigned long flags;
	int val;

	my_local_irq_save(flags);
	val = v->counter;
	v->counter = val += i;
	my_local_irq_restore(flags);

	return val < 0;
}

static inline void atomic_clear_mask(unsigned long mask, unsigned long *addr)
{
	unsigned long flags;

	my_local_irq_save(flags);
	*addr &= ~mask;
	my_local_irq_restore(flags);
}

/* Atomic operations are already serializing on ARM */
#define smp_mb__before_atomic_dec()	barrier()
#define smp_mb__after_atomic_dec()	barrier()
#define smp_mb__before_atomic_inc()	barrier()
#define smp_mb__after_atomic_inc()	barrier()

#endif
#endif
