/*
 *  linux/include/asm-arm/arch-lh79520/smc_pl090.h
 *
 *  Copyright (C) 2002 Lineo, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *
 *      This file contains the structure definitions and manifest
 *      constants for ARM IP component:
 *      	Static Memory Controller PrimeCell PL090
 *
 *	References:
 *		(1) ARM PrimeCell Static Memory Controller (PL090)
 *		Technical Reference Manual, ARM DDI 0160C.
 *		(2) ARM Isis Technical Reference Manual, System on Chip Group,
 *		ARM SC063-TRM-0001-B
 *
 *	COPYRIGHT (C) 2001 SHARP MICROELECTRONICS OF THE AMERICAS, INC.
 *		CAMAS, WA
 */

#ifndef SMC_PL090_H
#define SMC_PL090_H

#ifndef _BIT
#define _BIT(n)	(1 << (n))
#endif

#ifndef _SBF
#define _SBF(f,v) ((v) << (f))
#endif

/*
 * Static Memory Controller Module Register Structure
 */ 
typedef struct {
	volatile unsigned int	bcr0;	 /* Configuration for bank 0 */ 
	volatile unsigned int	bcr1;	 /* Configuration for bank 1 */ 
	volatile unsigned int	bcr2;	 /* Configuration for bank 2 */ 
	volatile unsigned int	bcr3;	 /* Configuration for bank 3 */ 
	volatile unsigned int	bcr4;	 /* Configuration for bank 4 */ 
	volatile unsigned int	bcr5;	 /* Configuration for bank 5 */ 
	volatile unsigned int	bcr6;	 /* Configuration for bank 6 */ 
	volatile unsigned int	bcr7;	 /* Configuration for bank 7 */ 
} smcRegs_t;

/*
 * Static Memory Controller Bit Field constants
 */ 
#define IDCY(n)		_SBF(0,((n)&0x0F))	/* Idle Cycle Time */ 
#define WST1(n)		_SBF(5,((n)&0x1F))	/* Wait State 1 */ 
#define RBLE(n)		_SBF(10,((n)&0x01))	/* Read Byte Lane Enable */ 
#define WST2(n)		_SBF(11,((n)&0x1F))	/* Wait State 2 */ 
#define BUSERR		_BIT(24)			/* Bus Transfer Error Flag */ 
#define WPERR		_BIT(25)			/* Write Protect Error Flag */ 
#define WP			_BIT(26)			/* Write Protect */ 
#define BM			_BIT(27)			/* Burst Mode */ 
#define MW8			_SBF(28,0)			/* Memory width 8 bits */ 
#define MW16		_SBF(28,1)			/* Memory width 16 bits */ 
#define MW32		_SBF(28,2)			/* Memory width 32 bits */ 
#define ATNONE		_SBF(30,0)			/* No Retry */ 
#define ATEVERY		_SBF(30,2)			/* Retry after every access */
#define ATAFTER4	_SBF(30,3)			/* Retry after 4 accesses */

#endif /* SMC_PL090_H */ 
