/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis 'TREMOR' CODEC SOURCE CODE.   *
 *                                                                  *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis 'TREMOR' SOURCE CODE IS (C) COPYRIGHT 1994-2002    *
 * BY THE Xiph.Org FOUNDATION http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: mdct trig lookups for n=64 through 8192

 ********************************************************************/

static ogg_int32_t triglook_64[80]={
  0x40000000, 0x00000000, 0x3ec52fa0, 0xf383a3e2,
  0x3b20d79e, 0xe7821d59, 0x3536cc52, 0xdc71898d,
  0x2d413ccd, 0xd2bec333, 0x238e7673, 0xcac933ae,
  0x187de2a7, 0xc4df2862, 0x0c7c5c1e, 0xc13ad060,
  0x00000000, 0xc0000000, 0xf383a3e2, 0xc13ad060,
  0xe7821d59, 0xc4df2862, 0xdc71898d, 0xcac933ae,
  0xd2bec333, 0xd2bec333, 0xcac933ae, 0xdc71898d,
  0xc4df2862, 0xe7821d59, 0xc13ad060, 0xf383a3e2,
  0x3ffb10c1, 0x0192155f, 0x3fd39b5a, 0x04b54825,
  0x3f84c8e2, 0x07d59396, 0x3f0ec9f5, 0x0af10a22,
  0x3e71e759, 0x0e05c135, 0x3dae81cf, 0x1111d263,
  0x3cc511d9, 0x14135c94, 0x3bb6276e, 0x17088531,
  0x3a8269a3, 0x19ef7944, 0x392a9642, 0x1cc66e99,
  0x37af8159, 0x1f8ba4dc, 0x361214b0, 0x223d66a8,
  0x34534f41, 0x24da0a9a, 0x32744493, 0x275ff452,
  0x30761c18, 0x29cd9578, 0x2e5a1070, 0x2c216eaa,
  0x1fd88da4, 0xfcdd0b28, 0x1e9f4157, 0xf6b5fce9,
  0x1c38b2f2, 0xf0ea5164, 0x18bc806b, 0xebb30cdb,
  0x144cf325, 0xe7437f95, 0x0f15ae9c, 0xe3c74d0e,
  0x094a0317, 0xe160bea9, 0x0322f4d8, 0xe027725c,
};

static ogg_int16_t bitrevlook_64[16]={
  0x001e, 0x0000, 0x000e, 0x0010,
  0x0016, 0x0008, 0x0006, 0x0018,
  0x001a, 0x0004, 0x000a, 0x0014,
  0x0012, 0x000c, 0x0002, 0x001c,
};

static ogg_int32_t triglook_128[160]={
  0x40000000, 0x00000000, 0x3fb11b48, 0xf9ba1651,
  0x3ec52fa0, 0xf383a3e2, 0x3d3e82ae, 0xed6bf9d1,
  0x3b20d79e, 0xe7821d59, 0x387165e3, 0xe1d4a2c8,
  0x3536cc52, 0xdc71898d, 0x317900d6, 0xd76619b6,
  0x2d413ccd, 0xd2bec333, 0x2899e64a, 0xce86ff2a,
  0x238e7673, 0xcac933ae, 0x1e2b5d38, 0xc78e9a1d,
  0x187de2a7, 0xc4df2862, 0x1294062f, 0xc2c17d52,
  0x0c7c5c1e, 0xc13ad060, 0x0645e9af, 0xc04ee4b8,
  0x00000000, 0xc0000000, 0xf9ba1651, 0xc04ee4b8,
  0xf383a3e2, 0xc13ad060, 0xed6bf9d1, 0xc2c17d52,
  0xe7821d59, 0xc4df2862, 0xe1d4a2c8, 0xc78e9a1d,
  0xdc71898d, 0xcac933ae, 0xd76619b6, 0xce86ff2a,
  0xd2bec333, 0xd2bec333, 0xce86ff2a, 0xd76619b6,
  0xcac933ae, 0xdc71898d, 0xc78e9a1d, 0xe1d4a2c8,
  0xc4df2862, 0xe7821d59, 0xc2c17d52, 0xed6bf9d1,
  0xc13ad060, 0xf383a3e2, 0xc04ee4b8, 0xf9ba1651,
  0x3ffec42d, 0x00c90e90, 0x3ff4e5e0, 0x025b0caf,
  0x3fe12acb, 0x03ecadcf, 0x3fc395f9, 0x057db403,
  0x3f9c2bfb, 0x070de172, 0x3f6af2e3, 0x089cf867,
  0x3f2ff24a, 0x0a2abb59, 0x3eeb3347, 0x0bb6ecef,
  0x3e9cc076, 0x0d415013, 0x3e44a5ef, 0x0ec9a7f3,
  0x3de2f148, 0x104fb80e, 0x3d77b192, 0x11d3443f,
  0x3d02f757, 0x135410c3, 0x3c84d496, 0x14d1e242,
  0x3bfd5cc4, 0x164c7ddd, 0x3b6ca4c4, 0x17c3a931,
  0x3ad2c2e8, 0x19372a64, 0x3a2fcee8, 0x1aa6c82b,
  0x3983e1e8, 0x1c1249d8, 0x38cf1669, 0x1d79775c,
  0x3811884d, 0x1edc1953, 0x374b54ce, 0x2039f90f,
  0x367c9a7e, 0x2192e09b, 0x35a5793c, 0x22e69ac8,
  0x34c61236, 0x2434f332, 0x33de87de, 0x257db64c,
  0x32eefdea, 0x26c0b162, 0x31f79948, 0x27fdb2a7,
  0x30f8801f, 0x29348937, 0x2ff1d9c7, 0x2a650525,
  0x2ee3cebe, 0x2b8ef77d, 0x2dce88aa, 0x2cb2324c,
  0x1ff621e3, 0xfe6e09a1, 0x1fa7557f, 0xfb4dfbe4,
  0x1f0a7efc, 0xf83981a1, 0x1e212105, 0xf53832c5,
  0x1ced7af4, 0xf25177fb, 0x1b728345, 0xef8c7867,
  0x19b3e048, 0xecf00803, 0x17b5df22, 0xea8296cb,
  0x157d6935, 0xe84a20de, 0x130ff7fd, 0xe64c1fb8,
  0x10738799, 0xe48d7cbb, 0x0dae8805, 0xe312850c,
  0x0ac7cd3b, 0xe1dedefb, 0x07c67e5f, 0xe0f58104,
  0x04b2041c, 0xe058aa81, 0x0191f65f, 0xe009de1d,
};

static ogg_int16_t bitrevlook_128[32]={
  0x003e, 0x0000, 0x001e, 0x0020,
  0x002e, 0x0010, 0x000e, 0x0030,
  0x0036, 0x0008, 0x0016, 0x0028,
  0x0026, 0x0018, 0x0006, 0x0038,
  0x003a, 0x0004, 0x001a, 0x0024,
  0x002a, 0x0014, 0x000a, 0x0034,
  0x0032, 0x000c, 0x0012, 0x002c,
  0x0022, 0x001c, 0x0002, 0x003c,
};

static ogg_int32_t triglook_256[320]={
  0x40000000, 0x00000000, 0x3fec43c7, 0xfcdc1342,
  0x3fb11b48, 0xf9ba1651, 0x3f4eaafe, 0xf69bf7c9,
  0x3ec52fa0, 0xf383a3e2, 0x3e14fdf7, 0xf0730342,
  0x3d3e82ae, 0xed6bf9d1, 0x3c42420a, 0xea70658a,
  0x3b20d79e, 0xe7821d59, 0x39daf5e8, 0xe4a2eff6,
  0x387165e3, 0xe1d4a2c8, 0x36e5068a, 0xdf18f0ce,
  0x3536cc52, 0xdc71898d, 0x3367c090, 0xd9e01006,
  0x317900d6, 0xd76619b6, 0x2f6bbe45, 0xd5052d97,
  0x2d413ccd, 0xd2bec333, 0x2afad269, 0xd09441bb,
  0x2899e64a, 0xce86ff2a, 0x261feffa, 0xcc983f70,
  0x238e7673, 0xcac933ae, 0x20e70f32, 0xc91af976,
  0x1e2b5d38, 0xc78e9a1d, 0x1b5d100a, 0xc6250a18,
  0x187de2a7, 0xc4df2862, 0x158f9a76, 0xc3bdbdf6,
  0x1294062f, 0xc2c17d52, 0x0f8cfcbe, 0xc1eb0209,
  0x0c7c5c1e, 0xc13ad060, 0x09640837, 0xc0b15502,
  0x0645e9af, 0xc04ee4b8, 0x0323ecbe, 0xc013bc39,
  0x00000000, 0xc0000000, 0xfcdc1342, 0xc013bc39,
  0xf9ba1651, 0xc04ee4b8, 0xf69bf7c9, 0xc0b15502,
  0xf383a3e2, 0xc13ad060, 0xf0730342, 0xc1eb0209,
  0xed6bf9d1, 0xc2c17d52, 0xea70658a, 0xc3bdbdf6,
  0xe7821d59, 0xc4df2862, 0xe4a2eff6, 0xc6250a18,
  0xe1d4a2c8, 0xc78e9a1d, 0xdf18f0ce, 0xc91af976,
  0xdc71898d, 0xcac933ae, 0xd9e01006, 0xcc983f70,
  0xd76619b6, 0xce86ff2a, 0xd5052d97, 0xd09441bb,
  0xd2bec333, 0xd2bec333, 0xd09441bb, 0xd5052d97,
  0xce86ff2a, 0xd76619b6, 0xcc983f70, 0xd9e01006,
  0xcac933ae, 0xdc71898d, 0xc91af976, 0xdf18f0ce,
  0xc78e9a1d, 0xe1d4a2c8, 0xc6250a18, 0xe4a2eff6,
  0xc4df2862, 0xe7821d59, 0xc3bdbdf6, 0xea70658a,
  0xc2c17d52, 0xed6bf9d1, 0xc1eb0209, 0xf0730342,
  0xc13ad060, 0xf383a3e2, 0xc0b15502, 0xf69bf7c9,
  0xc04ee4b8, 0xf9ba1651, 0xc013bc39, 0xfcdc1342,
  0x3fffb10b, 0x006487c4, 0x3ffd3969, 0x012d936c,
  0x3ff84a3c, 0x01f69373, 0x3ff0e3b6, 0x02bf801a,
  0x3fe7061f, 0x038851a2, 0x3fdab1d9, 0x0451004d,
  0x3fcbe75e, 0x0519845e, 0x3fbaa740, 0x05e1d61b,
  0x3fa6f228, 0x06a9edc9, 0x3f90c8da, 0x0771c3b3,
  0x3f782c30, 0x08395024, 0x3f5d1d1d, 0x09008b6a,
  0x3f3f9cab, 0x09c76dd8, 0x3f1fabff, 0x0a8defc3,
  0x3efd4c54, 0x0b540982, 0x3ed87efc, 0x0c19b374,
  0x3eb14563, 0x0cdee5f9, 0x3e87a10c, 0x0da39978,
  0x3e5b9392, 0x0e67c65a, 0x3e2d1ea8, 0x0f2b650f,
  0x3dfc4418, 0x0fee6e0d, 0x3dc905c5, 0x10b0d9d0,
  0x3d9365a8, 0x1172a0d7, 0x3d5b65d2, 0x1233bbac,
  0x3d21086c, 0x12f422db, 0x3ce44fb7, 0x13b3cefa,
  0x3ca53e09, 0x1472b8a5, 0x3c63d5d1, 0x1530d881,
  0x3c201994, 0x15ee2738, 0x3bda0bf0, 0x16aa9d7e,
  0x3b91af97, 0x1766340f, 0x3b470753, 0x1820e3b0,
  0x3afa1605, 0x18daa52f, 0x3aaadea6, 0x19937161,
  0x3a596442, 0x1a4b4128, 0x3a05a9fd, 0x1b020d6c,
  0x39afb313, 0x1bb7cf23, 0x395782d3, 0x1c6c7f4a,
  0x38fd1ca4, 0x1d2016e9, 0x38a08402, 0x1dd28f15,
  0x3841bc7f, 0x1e83e0eb, 0x37e0c9c3, 0x1f340596,
  0x377daf89, 0x1fe2f64c, 0x371871a5, 0x2090ac4d,
  0x36b113fd, 0x213d20e8, 0x36479a8e, 0x21e84d76,
  0x35dc0968, 0x22922b5e, 0x356e64b2, 0x233ab414,
  0x34feb0a5, 0x23e1e117, 0x348cf190, 0x2487abf7,
  0x34192bd5, 0x252c0e4f, 0x33a363ec, 0x25cf01c8,
  0x332b9e5e, 0x2670801a, 0x32b1dfc9, 0x2710830c,
  0x32362ce0, 0x27af0472, 0x31b88a66, 0x284bfe2f,
  0x3138fd35, 0x28e76a37, 0x30b78a36, 0x2981428c,
  0x30343667, 0x2a19813f, 0x2faf06da, 0x2ab02071,
  0x2f2800af, 0x2b451a55, 0x2e9f291b, 0x2bd8692b,
  0x2e148566, 0x2c6a0746, 0x2d881ae8, 0x2cf9ef09,
  0x1ffd8861, 0xff36f550, 0x1fe9cdad, 0xfda55bee,
  0x1fc26471, 0xfc153635, 0x1f8764fa, 0xfa877aef,
  0x1f38f3ac, 0xf8fd1f65, 0x1ed740e7, 0xf77716cf,
  0x1e6288ec, 0xf5f651b6, 0x1ddb13b7, 0xf47bbd68,
  0x1d4134d1, 0xf308435e, 0x1c954b21, 0xf19cc8b3,
  0x1bd7c0ac, 0xf03a2d92, 0x1b090a58, 0xeee14cac,
  0x1a29a7a0, 0xed92fab3, 0x193a224a, 0xec5005d7,
  0x183b0e0c, 0xeb193544, 0x172d0838, 0xe9ef48ab,
  0x1610b755, 0xe8d2f7c8, 0x14e6cabc, 0xe7c4f1f4,
  0x13affa29, 0xe6c5ddb6, 0x126d054d, 0xe5d65860,
  0x111eb354, 0xe4f6f5a8, 0x0fc5d26e, 0xe4283f54,
  0x0e63374d, 0xe36ab4df, 0x0cf7bca2, 0xe2becb2f,
  0x0b844298, 0xe224ec49, 0x0a09ae4a, 0xe19d7714,
  0x0888e931, 0xe128bf19, 0x0702e09b, 0xe0c70c54,
  0x05788511, 0xe0789b06, 0x03eac9cb, 0xe03d9b8f,
  0x025aa412, 0xe0163253, 0x00c90ab0, 0xe002779f,
};

static ogg_int16_t bitrevlook_256[64]={
  0x007e, 0x0000, 0x003e, 0x0040,
  0x005e, 0x0020, 0x001e, 0x0060,
  0x006e, 0x0010, 0x002e, 0x0050,
  0x004e, 0x0030, 0x000e, 0x0070,
  0x0076, 0x0008, 0x0036, 0x0048,
  0x0056, 0x0028, 0x0016, 0x0068,
  0x0066, 0x0018, 0x0026, 0x0058,
  0x0046, 0x0038, 0x0006, 0x0078,
  0x007a, 0x0004, 0x003a, 0x0044,
  0x005a, 0x0024, 0x001a, 0x0064,
  0x006a, 0x0014, 0x002a, 0x0054,
  0x004a, 0x0034, 0x000a, 0x0074,
  0x0072, 0x000c, 0x0032, 0x004c,
  0x0052, 0x002c, 0x0012, 0x006c,
  0x0062, 0x001c, 0x0022, 0x005c,
  0x0042, 0x003c, 0x0002, 0x007c,
};

static ogg_int32_t triglook_512[640]={
  0x40000000, 0x00000000, 0x3ffb10c1, 0xfe6deaa1,
  0x3fec43c7, 0xfcdc1342, 0x3fd39b5a, 0xfb4ab7db,
  0x3fb11b48, 0xf9ba1651, 0x3f84c8e2, 0xf82a6c6a,
  0x3f4eaafe, 0xf69bf7c9, 0x3f0ec9f5, 0xf50ef5de,
  0x3ec52fa0, 0xf383a3e2, 0x3e71e759, 0xf1fa3ecb,
  0x3e14fdf7, 0xf0730342, 0x3dae81cf, 0xeeee2d9d,
  0x3d3e82ae, 0xed6bf9d1, 0x3cc511d9, 0xebeca36c,
  0x3c42420a, 0xea70658a, 0x3bb6276e, 0xe8f77acf,
  0x3b20d79e, 0xe7821d59, 0x3a8269a3, 0xe61086bc,
  0x39daf5e8, 0xe4a2eff6, 0x392a9642, 0xe3399167,
  0x387165e3, 0xe1d4a2c8, 0x37af8159, 0xe0745b24,
  0x36e5068a, 0xdf18f0ce, 0x361214b0, 0xddc29958,
  0x3536cc52, 0xdc71898d, 0x34534f41, 0xdb25f566,
  0x3367c090, 0xd9e01006, 0x32744493, 0xd8a00bae,
  0x317900d6, 0xd76619b6, 0x30761c18, 0xd6326a88,
  0x2f6bbe45, 0xd5052d97, 0x2e5a1070, 0xd3de9156,
  0x2d413ccd, 0xd2bec333, 0x2c216eaa, 0xd1a5ef90,
  0x2afad269, 0xd09441bb, 0x29cd9578, 0xcf89e3e8,
  0x2899e64a, 0xce86ff2a, 0x275ff452, 0xcd8bbb6d,
  0x261feffa, 0xcc983f70, 0x24da0a9a, 0xcbacb0bf,
  0x238e7673, 0xcac933ae, 0x223d66a8, 0xc9edeb50,
  0x20e70f32, 0xc91af976, 0x1f8ba4dc, 0xc8507ea7,
  0x1e2b5d38, 0xc78e9a1d, 0x1cc66e99, 0xc6d569be,
  0x1b5d100a, 0xc6250a18, 0x19ef7944, 0xc57d965d,
  0x187de2a7, 0xc4df2862, 0x17088531, 0xc449d892,
  0x158f9a76, 0xc3bdbdf6, 0x14135c94, 0xc33aee27,
  0x1294062f, 0xc2c17d52, 0x1111d263, 0xc2517e31,
  0x0f8cfcbe, 0xc1eb0209, 0x0e05c135, 0xc18e18a7,
  0x0c7c5c1e, 0xc13ad060, 0x0af10a22, 0xc0f1360b,
  0x09640837, 0xc0b15502, 0x07d59396, 0xc07b371e,
  0x0645e9af, 0xc04ee4b8, 0x04b54825, 0xc02c64a6,
  0x0323ecbe, 0xc013bc39, 0x0192155f, 0xc004ef3f,
  0x00000000, 0xc0000000, 0xfe6deaa1, 0xc004ef3f,
  0xfcdc1342, 0xc013bc39, 0xfb4ab7db, 0xc02c64a6,
  0xf9ba1651, 0xc04ee4b8, 0xf82a6c6a, 0xc07b371e,
  0xf69bf7c9, 0xc0b15502, 0xf50ef5de, 0xc0f1360b,
  0xf383a3e2, 0xc13ad060, 0xf1fa3ecb, 0xc18e18a7,
  0xf0730342, 0xc1eb0209, 0xeeee2d9d, 0xc2517e31,
  0xed6bf9d1, 0xc2c17d52, 0xebeca36c, 0xc33aee27,
  0xea70658a, 0xc3bdbdf6, 0xe8f77acf, 0xc449d892,
  0xe7821d59, 0xc4df2862, 0xe61086bc, 0xc57d965d,
  0xe4a2eff6, 0xc6250a18, 0xe3399167, 0xc6d569be,
  0xe1d4a2c8, 0xc78e9a1d, 0xe0745b24, 0xc8507ea7,
  0xdf18f0ce, 0xc91af976, 0xddc29958, 0xc9edeb50,
  0xdc71898d, 0xcac933ae, 0xdb25f566, 0xcbacb0bf,
  0xd9e01006, 0xcc983f70, 0xd8a00bae, 0xcd8bbb6d,
  0xd76619b6, 0xce86ff2a, 0xd6326a88, 0xcf89e3e8,
  0xd5052d97, 0xd09441bb, 0xd3de9156, 0xd1a5ef90,
  0xd2bec333, 0xd2bec333, 0xd1a5ef90, 0xd3de9156,
  0xd09441bb, 0xd5052d97, 0xcf89e3e8, 0xd6326a88,
  0xce86ff2a, 0xd76619b6, 0xcd8bbb6d, 0xd8a00bae,
  0xcc983f70, 0xd9e01006, 0xcbacb0bf, 0xdb25f566,
  0xcac933ae, 0xdc71898d, 0xc9edeb50, 0xddc29958,
  0xc91af976, 0xdf18f0ce, 0xc8507ea7, 0xe0745b24,
  0xc78e9a1d, 0xe1d4a2c8, 0xc6d569be, 0xe3399167,
  0xc6250a18, 0xe4a2eff6, 0xc57d965d, 0xe61086bc,
  0xc4df2862, 0xe7821d59, 0xc449d892, 0xe8f77acf,
  0xc3bdbdf6, 0xea70658a, 0xc33aee27, 0xebeca36c,
  0xc2c17d52, 0xed6bf9d1, 0xc2517e31, 0xeeee2d9d,
  0xc1eb0209, 0xf0730342, 0xc18e18a7, 0xf1fa3ecb,
  0xc13ad060, 0xf383a3e2, 0xc0f1360b, 0xf50ef5de,
  0xc0b15502, 0xf69bf7c9, 0xc07b371e, 0xf82a6c6a,
  0xc04ee4b8, 0xf9ba1651, 0xc02c64a6, 0xfb4ab7db,
  0xc013bc39, 0xfcdc1342, 0xc004ef3f, 0xfe6deaa1,
  0x3fffec43, 0x003243f1, 0x3fff4e59, 0x0096cb58,
  0x3ffe1288, 0x00fb514b, 0x3ffc38d1, 0x015fd4d2,
  0x3ff9c13a, 0x01c454f5, 0x3ff6abc8, 0x0228d0bb,
  0x3ff2f884, 0x028d472e, 0x3feea776, 0x02f1b755,
  0x3fe9b8a9, 0x03562038, 0x3fe42c2a, 0x03ba80df,
  0x3fde0205, 0x041ed854, 0x3fd73a4a, 0x0483259d,
  0x3fcfd50b, 0x04e767c5, 0x3fc7d258, 0x054b9dd3,
  0x3fbf3246, 0x05afc6d0, 0x3fb5f4ea, 0x0613e1c5,
  0x3fac1a5b, 0x0677edbb, 0x3fa1a2b2, 0x06dbe9bb,
  0x3f968e07, 0x073fd4cf, 0x3f8adc77, 0x07a3adff,
  0x3f7e8e1e, 0x08077457, 0x3f71a31b, 0x086b26de,
  0x3f641b8d, 0x08cec4a0, 0x3f55f796, 0x09324ca7,
  0x3f473759, 0x0995bdfd, 0x3f37dafa, 0x09f917ac,
  0x3f27e29f, 0x0a5c58c0, 0x3f174e70, 0x0abf8043,
  0x3f061e95, 0x0b228d42, 0x3ef45338, 0x0b857ec7,
  0x3ee1ec87, 0x0be853de, 0x3eceeaad, 0x0c4b0b94,
  0x3ebb4ddb, 0x0cada4f5, 0x3ea7163f, 0x0d101f0e,
  0x3e92440d, 0x0d7278eb, 0x3e7cd778, 0x0dd4b19a,
  0x3e66d0b4, 0x0e36c82a, 0x3e502ff9, 0x0e98bba7,
  0x3e38f57c, 0x0efa8b20, 0x3e212179, 0x0f5c35a3,
  0x3e08b42a, 0x0fbdba40, 0x3defadca, 0x101f1807,
  0x3dd60e99, 0x10804e06, 0x3dbbd6d4, 0x10e15b4e,
  0x3da106bd, 0x11423ef0, 0x3d859e96, 0x11a2f7fc,
  0x3d699ea3, 0x12038584, 0x3d4d0728, 0x1263e699,
  0x3d2fd86c, 0x12c41a4f, 0x3d1212b7, 0x13241fb6,
  0x3cf3b653, 0x1383f5e3, 0x3cd4c38b, 0x13e39be9,
  0x3cb53aaa, 0x144310dd, 0x3c951bff, 0x14a253d1,
  0x3c7467d9, 0x150163dc, 0x3c531e88, 0x15604013,
  0x3c314060, 0x15bee78c, 0x3c0ecdb2, 0x161d595d,
  0x3bebc6d5, 0x167b949d, 0x3bc82c1f, 0x16d99864,
  0x3ba3fde7, 0x173763c9, 0x3b7f3c87, 0x1794f5e6,
  0x3b59e85a, 0x17f24dd3, 0x3b3401bb, 0x184f6aab,
  0x3b0d8909, 0x18ac4b87, 0x3ae67ea1, 0x1908ef82,
  0x3abee2e5, 0x196555b8, 0x3a96b636, 0x19c17d44,
  0x3a6df8f8, 0x1a1d6544, 0x3a44ab8e, 0x1a790cd4,
  0x3a1ace5f, 0x1ad47312, 0x39f061d2, 0x1b2f971e,
  0x39c5664f, 0x1b8a7815, 0x3999dc42, 0x1be51518,
  0x396dc414, 0x1c3f6d47, 0x39411e33, 0x1c997fc4,
  0x3913eb0e, 0x1cf34baf, 0x38e62b13, 0x1d4cd02c,
  0x38b7deb4, 0x1da60c5d, 0x38890663, 0x1dfeff67,
  0x3859a292, 0x1e57a86d, 0x3829b3b9, 0x1eb00696,
  0x37f93a4b, 0x1f081907, 0x37c836c2, 0x1f5fdee6,
  0x3796a996, 0x1fb7575c, 0x37649341, 0x200e8190,
  0x3731f440, 0x20655cac, 0x36fecd0e, 0x20bbe7d8,
  0x36cb1e2a, 0x21122240, 0x3696e814, 0x21680b0f,
  0x36622b4c, 0x21bda171, 0x362ce855, 0x2212e492,
  0x35f71fb1, 0x2267d3a0, 0x35c0d1e7, 0x22bc6dca,
  0x3589ff7a, 0x2310b23e, 0x3552a8f4, 0x2364a02e,
  0x351acedd, 0x23b836ca, 0x34e271bd, 0x240b7543,
  0x34a99221, 0x245e5acc, 0x34703095, 0x24b0e699,
  0x34364da6, 0x250317df, 0x33fbe9e2, 0x2554edd1,
  0x33c105db, 0x25a667a7, 0x3385a222, 0x25f78497,
  0x3349bf48, 0x264843d9, 0x330d5de3, 0x2698a4a6,
  0x32d07e85, 0x26e8a637, 0x329321c7, 0x273847c8,
  0x32554840, 0x27878893, 0x3216f287, 0x27d667d5,
  0x31d82137, 0x2824e4cc, 0x3198d4ea, 0x2872feb6,
  0x31590e3e, 0x28c0b4d2, 0x3118cdcf, 0x290e0661,
  0x30d8143b, 0x295af2a3, 0x3096e223, 0x29a778db,
  0x30553828, 0x29f3984c, 0x301316eb, 0x2a3f503a,
  0x2fd07f0f, 0x2a8a9fea, 0x2f8d713a, 0x2ad586a3,
  0x2f49ee0f, 0x2b2003ac, 0x2f05f637, 0x2b6a164d,
  0x2ec18a58, 0x2bb3bdce, 0x2e7cab1c, 0x2bfcf97c,
  0x2e37592c, 0x2c45c8a0, 0x2df19534, 0x2c8e2a87,
  0x2dab5fdf, 0x2cd61e7f, 0x2d64b9da, 0x2d1da3d5,
  0x1fff6217, 0xff9b78b8, 0x1ffa72f0, 0xfed279a9,
  0x1ff09566, 0xfe09a918, 0x1fe1cafd, 0xfd4125ff,
  0x1fce15fd, 0xfc790f47, 0x1fb57972, 0xfbb183cc,
  0x1f97f925, 0xfaeaa254, 0x1f7599a4, 0xfa248988,
  0x1f4e603b, 0xf95f57f7, 0x1f2252f7, 0xf89b2c07,
  0x1ef178a4, 0xf7d823f9, 0x1ebbd8c9, 0xf7165de0,
  0x1e817bab, 0xf655f79f, 0x1e426a4b, 0xf5970edf,
  0x1dfeae62, 0xf4d9c111, 0x1db65262, 0xf41e2b67,
  0x1d696174, 0xf3646ace, 0x1d17e774, 0xf2ac9bea,
  0x1cc1f0f4, 0xf1f6db14, 0x1c678b35, 0xf1434452,
  0x1c08c426, 0xf091f357, 0x1ba5aa67, 0xefe30379,
  0x1b3e4d3f, 0xef368fb3, 0x1ad2bc9e, 0xee8cb29c,
  0x1a63091b, 0xede58667, 0x19ef43ef, 0xed4124da,
  0x19777ef5, 0xec9fa74f, 0x18fbcca4, 0xec0126ad,
  0x187c4010, 0xeb65bb64, 0x17f8ece3, 0xeacd7d6d,
  0x1771e75f, 0xea388442, 0x16e74455, 0xe9a6e6da,
  0x16591926, 0xe918bbab, 0x15c77bbe, 0xe88e18a1,
  0x15328293, 0xe807131d, 0x149a449c, 0xe783bff0,
  0x13fed953, 0xe704335c, 0x136058b1, 0xe688810b,
  0x12bedb26, 0xe610bc11, 0x121a7999, 0xe59cf6e5,
  0x11734d64, 0xe52d4362, 0x10c9704d, 0xe4c1b2c1,
  0x101cfc87, 0xe45a5599, 0x0f6e0ca9, 0xe3f73bda,
  0x0ebcbbae, 0xe39874cb, 0x0e0924ec, 0xe33e0f0c,
  0x0d536416, 0xe2e8188c, 0x0c9b9532, 0xe2969e8c,
  0x0be1d499, 0xe249ad9e, 0x0b263eef, 0xe201519e,
  0x0a68f121, 0xe1bd95b5, 0x09aa0861, 0xe17e8455,
  0x08e9a220, 0xe1442737, 0x0827dc07, 0xe10e875c,
  0x0764d3f9, 0xe0ddad09, 0x06a0a809, 0xe0b19fc5,
  0x05db7678, 0xe08a665c, 0x05155dac, 0xe06806db,
  0x044e7c34, 0xe04a868e, 0x0386f0b9, 0xe031ea03,
  0x02beda01, 0xe01e3503, 0x01f656e8, 0xe00f6a9a,
  0x012d8657, 0xe0058d10, 0x00648748, 0xe0009de9,
};

static ogg_int16_t bitrevlook_512[128]={
  0x00fe, 0x0000, 0x007e, 0x0080,
  0x00be, 0x0040, 0x003e, 0x00c0,
  0x00de, 0x0020, 0x005e, 0x00a0,
  0x009e, 0x0060, 0x001e, 0x00e0,
  0x00ee, 0x0010, 0x006e, 0x0090,
  0x00ae, 0x0050, 0x002e, 0x00d0,
  0x00ce, 0x0030, 0x004e, 0x00b0,
  0x008e, 0x0070, 0x000e, 0x00f0,
  0x00f6, 0x0008, 0x0076, 0x0088,
  0x00b6, 0x0048, 0x0036, 0x00c8,
  0x00d6, 0x0028, 0x0056, 0x00a8,
  0x0096, 0x0068, 0x0016, 0x00e8,
  0x00e6, 0x0018, 0x0066, 0x0098,
  0x00a6, 0x0058, 0x0026, 0x00d8,
  0x00c6, 0x0038, 0x0046, 0x00b8,
  0x0086, 0x0078, 0x0006, 0x00f8,
  0x00fa, 0x0004, 0x007a, 0x0084,
  0x00ba, 0x0044, 0x003a, 0x00c4,
  0x00da, 0x0024, 0x005a, 0x00a4,
  0x009a, 0x0064, 0x001a, 0x00e4,
  0x00ea, 0x0014, 0x006a, 0x0094,
  0x00aa, 0x0054, 0x002a, 0x00d4,
  0x00ca, 0x0034, 0x004a, 0x00b4,
  0x008a, 0x0074, 0x000a, 0x00f4,
  0x00f2, 0x000c, 0x0072, 0x008c,
  0x00b2, 0x004c, 0x0032, 0x00cc,
  0x00d2, 0x002c, 0x0052, 0x00ac,
  0x0092, 0x006c, 0x0012, 0x00ec,
  0x00e2, 0x001c, 0x0062, 0x009c,
  0x00a2, 0x005c, 0x0022, 0x00dc,
  0x00c2, 0x003c, 0x0042, 0x00bc,
  0x0082, 0x007c, 0x0002, 0x00fc,
};

static ogg_int32_t triglook_1024[1280]={
  0x40000000, 0x00000000, 0x3ffec42d, 0xff36f170,
  0x3ffb10c1, 0xfe6deaa1, 0x3ff4e5e0, 0xfda4f351,
  0x3fec43c7, 0xfcdc1342, 0x3fe12acb, 0xfc135231,
  0x3fd39b5a, 0xfb4ab7db, 0x3fc395f9, 0xfa824bfd,
  0x3fb11b48, 0xf9ba1651, 0x3f9c2bfb, 0xf8f21e8e,
  0x3f84c8e2, 0xf82a6c6a, 0x3f6af2e3, 0xf7630799,
  0x3f4eaafe, 0xf69bf7c9, 0x3f2ff24a, 0xf5d544a7,
  0x3f0ec9f5, 0xf50ef5de, 0x3eeb3347, 0xf4491311,
  0x3ec52fa0, 0xf383a3e2, 0x3e9cc076, 0xf2beafed,
  0x3e71e759, 0xf1fa3ecb, 0x3e44a5ef, 0xf136580d,
  0x3e14fdf7, 0xf0730342, 0x3de2f148, 0xefb047f2,
  0x3dae81cf, 0xeeee2d9d, 0x3d77b192, 0xee2cbbc1,
  0x3d3e82ae, 0xed6bf9d1, 0x3d02f757, 0xecabef3d,
  0x3cc511d9, 0xebeca36c, 0x3c84d496, 0xeb2e1dbe,
  0x3c42420a, 0xea70658a, 0x3bfd5cc4, 0xe9b38223,
  0x3bb6276e, 0xe8f77acf, 0x3b6ca4c4, 0xe83c56cf,
  0x3b20d79e, 0xe7821d59, 0x3ad2c2e8, 0xe6c8d59c,
  0x3a8269a3, 0xe61086bc, 0x3a2fcee8, 0xe55937d5,
  0x39daf5e8, 0xe4a2eff6, 0x3983e1e8, 0xe3edb628,
  0x392a9642, 0xe3399167, 0x38cf1669, 0xe28688a4,
  0x387165e3, 0xe1d4a2c8, 0x3811884d, 0xe123e6ad,
  0x37af8159, 0xe0745b24, 0x374b54ce, 0xdfc606f1,
  0x36e5068a, 0xdf18f0ce, 0x367c9a7e, 0xde6d1f65,
  0x361214b0, 0xddc29958, 0x35a5793c, 0xdd196538,
  0x3536cc52, 0xdc71898d, 0x34c61236, 0xdbcb0cce,
  0x34534f41, 0xdb25f566, 0x33de87de, 0xda8249b4,
  0x3367c090, 0xd9e01006, 0x32eefdea, 0xd93f4e9e,
  0x32744493, 0xd8a00bae, 0x31f79948, 0xd8024d59,
  0x317900d6, 0xd76619b6, 0x30f8801f, 0xd6cb76c9,
  0x30761c18, 0xd6326a88, 0x2ff1d9c7, 0xd59afadb,
  0x2f6bbe45, 0xd5052d97, 0x2ee3cebe, 0xd4710883,
  0x2e5a1070, 0xd3de9156, 0x2dce88aa, 0xd34dcdb4,
  0x2d413ccd, 0xd2bec333, 0x2cb2324c, 0xd2317756,
  0x2c216eaa, 0xd1a5ef90, 0x2b8ef77d, 0xd11c3142,
  0x2afad269, 0xd09441bb, 0x2a650525, 0xd00e2639,
  0x29cd9578, 0xcf89e3e8, 0x29348937, 0xcf077fe1,
  0x2899e64a, 0xce86ff2a, 0x27fdb2a7, 0xce0866b8,
  0x275ff452, 0xcd8bbb6d, 0x26c0b162, 0xcd110216,
  0x261feffa, 0xcc983f70, 0x257db64c, 0xcc217822,
  0x24da0a9a, 0xcbacb0bf, 0x2434f332, 0xcb39edca,
  0x238e7673, 0xcac933ae, 0x22e69ac8, 0xca5a86c4,
  0x223d66a8, 0xc9edeb50, 0x2192e09b, 0xc9836582,
  0x20e70f32, 0xc91af976, 0x2039f90f, 0xc8b4ab32,
  0x1f8ba4dc, 0xc8507ea7, 0x1edc1953, 0xc7ee77b3,
  0x1e2b5d38, 0xc78e9a1d, 0x1d79775c, 0xc730e997,
  0x1cc66e99, 0xc6d569be, 0x1c1249d8, 0xc67c1e18,
  0x1b5d100a, 0xc6250a18, 0x1aa6c82b, 0xc5d03118,
  0x19ef7944, 0xc57d965d, 0x19372a64, 0xc52d3d18,
  0x187de2a7, 0xc4df2862, 0x17c3a931, 0xc4935b3c,
  0x17088531, 0xc449d892, 0x164c7ddd, 0xc402a33c,
  0x158f9a76, 0xc3bdbdf6, 0x14d1e242, 0xc37b2b6a,
  0x14135c94, 0xc33aee27, 0x135410c3, 0xc2fd08a9,
  0x1294062f, 0xc2c17d52, 0x11d3443f, 0xc2884e6e,
  0x1111d263, 0xc2517e31, 0x104fb80e, 0xc21d0eb8,
  0x0f8cfcbe, 0xc1eb0209, 0x0ec9a7f3, 0xc1bb5a11,
  0x0e05c135, 0xc18e18a7, 0x0d415013, 0xc1633f8a,
  0x0c7c5c1e, 0xc13ad060, 0x0bb6ecef, 0xc114ccb9,
  0x0af10a22, 0xc0f1360b, 0x0a2abb59, 0xc0d00db6,
  0x09640837, 0xc0b15502, 0x089cf867, 0xc0950d1d,
  0x07d59396, 0xc07b371e, 0x070de172, 0xc063d405,
  0x0645e9af, 0xc04ee4b8, 0x057db403, 0xc03c6a07,
  0x04b54825, 0xc02c64a6, 0x03ecadcf, 0xc01ed535,
  0x0323ecbe, 0xc013bc39, 0x025b0caf, 0xc00b1a20,
  0x0192155f, 0xc004ef3f, 0x00c90e90, 0xc0013bd3,
  0x00000000, 0xc0000000, 0xff36f170, 0xc0013bd3,
  0xfe6deaa1, 0xc004ef3f, 0xfda4f351, 0xc00b1a20,
  0xfcdc1342, 0xc013bc39, 0xfc135231, 0xc01ed535,
  0xfb4ab7db, 0xc02c64a6, 0xfa824bfd, 0xc03c6a07,
  0xf9ba1651, 0xc04ee4b8, 0xf8f21e8e, 0xc063d405,
  0xf82a6c6a, 0xc07b371e, 0xf7630799, 0xc0950d1d,
  0xf69bf7c9, 0xc0b15502, 0xf5d544a7, 0xc0d00db6,
  0xf50ef5de, 0xc0f1360b, 0xf4491311, 0xc114ccb9,
  0xf383a3e2, 0xc13ad060, 0xf2beafed, 0xc1633f8a,
  0xf1fa3ecb, 0xc18e18a7, 0xf136580d, 0xc1bb5a11,
  0xf0730342, 0xc1eb0209, 0xefb047f2, 0xc21d0eb8,
  0xeeee2d9d, 0xc2517e31, 0xee2cbbc1, 0xc2884e6e,
  0xed6bf9d1, 0xc2c17d52, 0xecabef3d, 0xc2fd08a9,
  0xebeca36c, 0xc33aee27, 0xeb2e1dbe, 0xc37b2b6a,
  0xea70658a, 0xc3bdbdf6, 0xe9b38223, 0xc402a33c,
  0xe8f77acf, 0xc449d892, 0xe83c56cf, 0xc4935b3c,
  0xe7821d59, 0xc4df2862, 0xe6c8d59c, 0xc52d3d18,
  0xe61086bc, 0xc57d965d, 0xe55937d5, 0xc5d03118,
  0xe4a2eff6, 0xc6250a18, 0xe3edb628, 0xc67c1e18,
  0xe3399167, 0xc6d569be, 0xe28688a4, 0xc730e997,
  0xe1d4a2c8, 0xc78e9a1d, 0xe123e6ad, 0xc7ee77b3,
  0xe0745b24, 0xc8507ea7, 0xdfc606f1, 0xc8b4ab32,
  0xdf18f0ce, 0xc91af976, 0xde6d1f65, 0xc9836582,
  0xddc29958, 0xc9edeb50, 0xdd196538, 0xca5a86c4,
  0xdc71898d, 0xcac933ae, 0xdbcb0cce, 0xcb39edca,
  0xdb25f566, 0xcbacb0bf, 0xda8249b4, 0xcc217822,
  0xd9e01006, 0xcc983f70, 0xd93f4e9e, 0xcd110216,
  0xd8a00bae, 0xcd8bbb6d, 0xd8024d59, 0xce0866b8,
  0xd76619b6, 0xce86ff2a, 0xd6cb76c9, 0xcf077fe1,
  0xd6326a88, 0xcf89e3e8, 0xd59afadb, 0xd00e2639,
  0xd5052d97, 0xd09441bb, 0xd4710883, 0xd11c3142,
  0xd3de9156, 0xd1a5ef90, 0xd34dcdb4, 0xd2317756,
  0xd2bec333, 0xd2bec333, 0xd2317756, 0xd34dcdb4,
  0xd1a5ef90, 0xd3de9156, 0xd11c3142, 0xd4710883,
  0xd09441bb, 0xd5052d97, 0xd00e2639, 0xd59afadb,
  0xcf89e3e8, 0xd6326a88, 0xcf077fe1, 0xd6cb76c9,
  0xce86ff2a, 0xd76619b6, 0xce0866b8, 0xd8024d59,
  0xcd8bbb6d, 0xd8a00bae, 0xcd110216, 0xd93f4e9e,
  0xcc983f70, 0xd9e01006, 0xcc217822, 0xda8249b4,
  0xcbacb0bf, 0xdb25f566, 0xcb39edca, 0xdbcb0cce,
  0xcac933ae, 0xdc71898d, 0xca5a86c4, 0xdd196538,
  0xc9edeb50, 0xddc29958, 0xc9836582, 0xde6d1f65,
  0xc91af976, 0xdf18f0ce, 0xc8b4ab32, 0xdfc606f1,
  0xc8507ea7, 0xe0745b24, 0xc7ee77b3, 0xe123e6ad,
  0xc78e9a1d, 0xe1d4a2c8, 0xc730e997, 0xe28688a4,
  0xc6d569be, 0xe3399167, 0xc67c1e18, 0xe3edb628,
  0xc6250a18, 0xe4a2eff6, 0xc5d03118, 0xe55937d5,
  0xc57d965d, 0xe61086bc, 0xc52d3d18, 0xe6c8d59c,
  0xc4df2862, 0xe7821d59, 0xc4935b3c, 0xe83c56cf,
  0xc449d892, 0xe8f77acf, 0xc402a33c, 0xe9b38223,
  0xc3bdbdf6, 0xea70658a, 0xc37b2b6a, 0xeb2e1dbe,
  0xc33aee27, 0xebeca36c, 0xc2fd08a9, 0xecabef3d,
  0xc2c17d52, 0xed6bf9d1, 0xc2884e6e, 0xee2cbbc1,
  0xc2517e31, 0xeeee2d9d, 0xc21d0eb8, 0xefb047f2,
  0xc1eb0209, 0xf0730342, 0xc1bb5a11, 0xf136580d,
  0xc18e18a7, 0xf1fa3ecb, 0xc1633f8a, 0xf2beafed,
  0xc13ad060, 0xf383a3e2, 0xc114ccb9, 0xf4491311,
  0xc0f1360b, 0xf50ef5de, 0xc0d00db6, 0xf5d544a7,
  0xc0b15502, 0xf69bf7c9, 0xc0950d1d, 0xf7630799,
  0xc07b371e, 0xf82a6c6a, 0xc063d405, 0xf8f21e8e,
  0xc04ee4b8, 0xf9ba1651, 0xc03c6a07, 0xfa824bfd,
  0xc02c64a6, 0xfb4ab7db, 0xc01ed535, 0xfc135231,
  0xc013bc39, 0xfcdc1342, 0xc00b1a20, 0xfda4f351,
  0xc004ef3f, 0xfe6deaa1, 0xc0013bd3, 0xff36f170,
  0x3ffffb11, 0x001921fb, 0x3fffd396, 0x004b65e1,
  0x3fff84a1, 0x007da998, 0x3fff0e32, 0x00afed02,
  0x3ffe704a, 0x00e22fff, 0x3ffdaae7, 0x01147271,
  0x3ffcbe0c, 0x0146b438, 0x3ffba9b8, 0x0178f536,
  0x3ffa6dec, 0x01ab354b, 0x3ff90aaa, 0x01dd7459,
  0x3ff77ff1, 0x020fb240, 0x3ff5cdc3, 0x0241eee2,
  0x3ff3f420, 0x02742a1f, 0x3ff1f30b, 0x02a663d8,
  0x3fefca84, 0x02d89bf0, 0x3fed7a8c, 0x030ad245,
  0x3feb0326, 0x033d06bb, 0x3fe86452, 0x036f3931,
  0x3fe59e12, 0x03a16988, 0x3fe2b067, 0x03d397a3,
  0x3fdf9b55, 0x0405c361, 0x3fdc5edc, 0x0437eca4,
  0x3fd8fafe, 0x046a134c, 0x3fd56fbe, 0x049c373c,
  0x3fd1bd1e, 0x04ce5854, 0x3fcde320, 0x05007674,
  0x3fc9e1c6, 0x0532917f, 0x3fc5b913, 0x0564a955,
  0x3fc1690a, 0x0596bdd7, 0x3fbcf1ad, 0x05c8cee7,
  0x3fb852ff, 0x05fadc66, 0x3fb38d02, 0x062ce634,
  0x3fae9fbb, 0x065eec33, 0x3fa98b2a, 0x0690ee44,
  0x3fa44f55, 0x06c2ec48, 0x3f9eec3e, 0x06f4e620,
  0x3f9961e8, 0x0726dbae, 0x3f93b058, 0x0758ccd2,
  0x3f8dd78f, 0x078ab96e, 0x3f87d792, 0x07bca163,
  0x3f81b065, 0x07ee8493, 0x3f7b620c, 0x082062de,
  0x3f74ec8a, 0x08523c25, 0x3f6e4fe3, 0x0884104b,
  0x3f678c1c, 0x08b5df30, 0x3f60a138, 0x08e7a8b5,
  0x3f598f3c, 0x09196cbc, 0x3f52562c, 0x094b2b27,
  0x3f4af60d, 0x097ce3d5, 0x3f436ee3, 0x09ae96aa,
  0x3f3bc0b3, 0x09e04385, 0x3f33eb81, 0x0a11ea49,
  0x3f2bef53, 0x0a438ad7, 0x3f23cc2e, 0x0a752510,
  0x3f1b8215, 0x0aa6b8d5, 0x3f13110f, 0x0ad84609,
  0x3f0a7921, 0x0b09cc8c, 0x3f01ba50, 0x0b3b4c40,
  0x3ef8d4a1, 0x0b6cc506, 0x3eefc81a, 0x0b9e36c0,
  0x3ee694c1, 0x0bcfa150, 0x3edd3a9a, 0x0c010496,
  0x3ed3b9ad, 0x0c326075, 0x3eca11fe, 0x0c63b4ce,
  0x3ec04394, 0x0c950182, 0x3eb64e75, 0x0cc64673,
  0x3eac32a6, 0x0cf78383, 0x3ea1f02f, 0x0d28b894,
  0x3e978715, 0x0d59e586, 0x3e8cf75f, 0x0d8b0a3d,
  0x3e824114, 0x0dbc2698, 0x3e77643a, 0x0ded3a7b,
  0x3e6c60d7, 0x0e1e45c6, 0x3e6136f3, 0x0e4f485c,
  0x3e55e694, 0x0e80421e, 0x3e4a6fc1, 0x0eb132ef,
  0x3e3ed282, 0x0ee21aaf, 0x3e330ede, 0x0f12f941,
  0x3e2724db, 0x0f43ce86, 0x3e1b1482, 0x0f749a61,
  0x3e0eddd9, 0x0fa55cb4, 0x3e0280e9, 0x0fd6155f,
  0x3df5fdb8, 0x1006c446, 0x3de9544f, 0x1037694b,
  0x3ddc84b5, 0x1068044e, 0x3dcf8ef3, 0x10989532,
  0x3dc2730f, 0x10c91bda, 0x3db53113, 0x10f99827,
  0x3da7c907, 0x112a09fc, 0x3d9a3af2, 0x115a713a,
  0x3d8c86de, 0x118acdc4, 0x3d7eacd2, 0x11bb1f7c,
  0x3d70acd7, 0x11eb6643, 0x3d6286f6, 0x121ba1fd,
  0x3d543b37, 0x124bd28c, 0x3d45c9a4, 0x127bf7d1,
  0x3d373245, 0x12ac11af, 0x3d287523, 0x12dc2009,
  0x3d199248, 0x130c22c1, 0x3d0a89bc, 0x133c19b8,
  0x3cfb5b89, 0x136c04d2, 0x3cec07b8, 0x139be3f2,
  0x3cdc8e52, 0x13cbb6f8, 0x3cccef62, 0x13fb7dc9,
  0x3cbd2af0, 0x142b3846, 0x3cad4107, 0x145ae653,
  0x3c9d31b0, 0x148a87d1, 0x3c8cfcf6, 0x14ba1ca3,
  0x3c7ca2e2, 0x14e9a4ac, 0x3c6c237e, 0x15191fcf,
  0x3c5b7ed4, 0x15488dee, 0x3c4ab4ef, 0x1577eeec,
  0x3c39c5da, 0x15a742ac, 0x3c28b19e, 0x15d68911,
  0x3c177845, 0x1605c1fd, 0x3c0619dc, 0x1634ed53,
  0x3bf4966c, 0x16640af7, 0x3be2ee01, 0x16931acb,
  0x3bd120a4, 0x16c21cb2, 0x3bbf2e62, 0x16f1108f,
  0x3bad1744, 0x171ff646, 0x3b9adb57, 0x174ecdb8,
  0x3b887aa6, 0x177d96ca, 0x3b75f53c, 0x17ac515f,
  0x3b634b23, 0x17dafd59, 0x3b507c69, 0x18099a9c,
  0x3b3d8918, 0x1838290c, 0x3b2a713d, 0x1866a88a,
  0x3b1734e2, 0x189518fc, 0x3b03d414, 0x18c37a44,
  0x3af04edf, 0x18f1cc45, 0x3adca54e, 0x19200ee3,
  0x3ac8d76f, 0x194e4201, 0x3ab4e54c, 0x197c6584,
  0x3aa0cef3, 0x19aa794d, 0x3a8c9470, 0x19d87d42,
  0x3a7835cf, 0x1a067145, 0x3a63b31d, 0x1a34553b,
  0x3a4f0c67, 0x1a622907, 0x3a3a41b9, 0x1a8fec8c,
  0x3a25531f, 0x1abd9faf, 0x3a1040a8, 0x1aeb4253,
  0x39fb0a60, 0x1b18d45c, 0x39e5b054, 0x1b4655ae,
  0x39d03291, 0x1b73c62d, 0x39ba9125, 0x1ba125bd,
  0x39a4cc1c, 0x1bce7442, 0x398ee385, 0x1bfbb1a0,
  0x3978d76c, 0x1c28ddbb, 0x3962a7e0, 0x1c55f878,
  0x394c54ee, 0x1c8301b9, 0x3935dea4, 0x1caff965,
  0x391f4510, 0x1cdcdf5e, 0x3908883f, 0x1d09b389,
  0x38f1a840, 0x1d3675cb, 0x38daa520, 0x1d632608,
  0x38c37eef, 0x1d8fc424, 0x38ac35ba, 0x1dbc5004,
  0x3894c98f, 0x1de8c98c, 0x387d3a7e, 0x1e1530a1,
  0x38658894, 0x1e418528, 0x384db3e0, 0x1e6dc705,
  0x3835bc71, 0x1e99f61d, 0x381da256, 0x1ec61254,
  0x3805659e, 0x1ef21b90, 0x37ed0657, 0x1f1e11b5,
  0x37d48490, 0x1f49f4a8, 0x37bbe05a, 0x1f75c44e,
  0x37a319c2, 0x1fa1808c, 0x378a30d8, 0x1fcd2948,
  0x377125ac, 0x1ff8be65, 0x3757f84c, 0x20243fca,
  0x373ea8ca, 0x204fad5b, 0x37253733, 0x207b06fe,
  0x370ba398, 0x20a64c97, 0x36f1ee09, 0x20d17e0d,
  0x36d81695, 0x20fc9b44, 0x36be1d4c, 0x2127a423,
  0x36a4023f, 0x2152988d, 0x3689c57d, 0x217d786a,
  0x366f6717, 0x21a8439e, 0x3654e71d, 0x21d2fa0f,
  0x363a45a0, 0x21fd9ba3, 0x361f82af, 0x2228283f,
  0x36049e5b, 0x22529fca, 0x35e998b5, 0x227d0228,
  0x35ce71ce, 0x22a74f40, 0x35b329b5, 0x22d186f8,
  0x3597c07d, 0x22fba936, 0x357c3636, 0x2325b5df,
  0x35608af1, 0x234facda, 0x3544bebf, 0x23798e0d,
  0x3528d1b1, 0x23a3595e, 0x350cc3d8, 0x23cd0eb3,
  0x34f09546, 0x23f6adf3, 0x34d4460c, 0x24203704,
  0x34b7d63c, 0x2449a9cc, 0x349b45e7, 0x24730631,
  0x347e951f, 0x249c4c1b, 0x3461c3f5, 0x24c57b6f,
  0x3444d27b, 0x24ee9415, 0x3427c0c3, 0x251795f3,
  0x340a8edf, 0x254080ef, 0x33ed3ce1, 0x256954f1,
  0x33cfcadc, 0x259211df, 0x33b238e0, 0x25bab7a0,
  0x33948701, 0x25e3461b, 0x3376b551, 0x260bbd37,
  0x3358c3e2, 0x26341cdb, 0x333ab2c6, 0x265c64ef,
  0x331c8211, 0x26849558, 0x32fe31d5, 0x26acadff,
  0x32dfc224, 0x26d4aecb, 0x32c13311, 0x26fc97a3,
  0x32a284b0, 0x2724686e, 0x3283b712, 0x274c2115,
  0x3264ca4c, 0x2773c17d, 0x3245be70, 0x279b4990,
  0x32269391, 0x27c2b934, 0x320749c3, 0x27ea1052,
  0x31e7e118, 0x28114ed0, 0x31c859a5, 0x28387498,
  0x31a8b37c, 0x285f8190, 0x3188eeb2, 0x288675a0,
  0x31690b59, 0x28ad50b1, 0x31490986, 0x28d412ab,
  0x3128e94c, 0x28fabb75, 0x3108aabf, 0x29214af8,
  0x30e84df3, 0x2947c11c, 0x30c7d2fb, 0x296e1dc9,
  0x30a739ed, 0x299460e8, 0x308682dc, 0x29ba8a61,
  0x3065addb, 0x29e09a1c, 0x3044bb00, 0x2a069003,
  0x3023aa5f, 0x2a2c6bfd, 0x30027c0c, 0x2a522df3,
  0x2fe1301c, 0x2a77d5ce, 0x2fbfc6a3, 0x2a9d6377,
  0x2f9e3fb6, 0x2ac2d6d6, 0x2f7c9b69, 0x2ae82fd5,
  0x2f5ad9d1, 0x2b0d6e5c, 0x2f38fb03, 0x2b329255,
  0x2f16ff14, 0x2b579ba8, 0x2ef4e619, 0x2b7c8a3f,
  0x2ed2b027, 0x2ba15e03, 0x2eb05d53, 0x2bc616dd,
  0x2e8dedb3, 0x2beab4b6, 0x2e6b615a, 0x2c0f3779,
  0x2e48b860, 0x2c339f0e, 0x2e25f2d8, 0x2c57eb5e,
  0x2e0310d9, 0x2c7c1c55, 0x2de01278, 0x2ca031da,
  0x2dbcf7cb, 0x2cc42bd9, 0x2d99c0e7, 0x2ce80a3a,
  0x2d766de2, 0x2d0bcce8, 0x2d52fed2, 0x2d2f73cd,
  0x1fffd886, 0xffcdbc1e, 0x1ffe9cb4, 0xff69364a,
  0x1ffc251e, 0xff04b646, 0x1ff871db, 0xfea03ff3,
  0x1ff38310, 0xfe3bd72f, 0x1fed58ed, 0xfdd77fd9,
  0x1fe5f3af, 0xfd733dd1, 0x1fdd53a0, 0xfd0f14f3,
  0x1fd37914, 0xfcab091b, 0x1fc8646d, 0xfc471e27,
  0x1fbc1618, 0xfbe357ee, 0x1fae8e8e, 0xfb7fba4b,
  0x1f9fce56, 0xfb1c4914, 0x1f8fd600, 0xfab9081f,
  0x1f7ea62a, 0xfa55fb3f, 0x1f6c3f7e, 0xf9f32646,
  0x1f58a2b1, 0xf9908d03, 0x1f43d086, 0xf92e3344,
  0x1f2dc9c9, 0xf8cc1cd3, 0x1f168f54, 0xf86a4d78,
  0x1efe220c, 0xf808c8f9, 0x1ee482e2, 0xf7a79318,
  0x1ec9b2d4, 0xf746af94, 0x1eadb2e9, 0xf6e6222a,
  0x1e908436, 0xf685ee93, 0x1e7227db, 0xf6261883,
  0x1e529f04, 0xf5c6a3ad, 0x1e31eae8, 0xf56793c0,
  0x1e100cca, 0xf508ec64, 0x1ded05f8, 0xf4aab141,
  0x1dc8d7cb, 0xf44ce5f8, 0x1da383a9, 0xf3ef8e28,
  0x1d7d0b03, 0xf392ad69, 0x1d556f53, 0xf336474f,
  0x1d2cb221, 0xf2da5f6c, 0x1d02d4ff, 0xf27ef94a,
  0x1cd7d98a, 0xf224186e, 0x1cabc16a, 0xf1c9c05b,
  0x1c7e8e52, 0xf16ff48c, 0x1c504201, 0xf116b876,
  0x1c20de40, 0xf0be0f8b, 0x1bf064e1, 0xf065fd35,
  0x1bbed7c5, 0xf00e84da, 0x1b8c38d2, 0xefb7a9d9,
  0x1b5889ff, 0xef616f8c, 0x1b23cd47, 0xef0bd945,
  0x1aee04b4, 0xeeb6ea51, 0x1ab73259, 0xee62a5f6,
  0x1a7f5853, 0xee0f0f74, 0x1a4678c8, 0xedbc2a04,
  0x1a0c95eb, 0xed69f8d9, 0x19d1b1f6, 0xed187f1c,
  0x1995cf2f, 0xecc7bff3, 0x1958efe5, 0xec77be7a,
  0x191b1670, 0xec287dc7, 0x18dc4533, 0xebda00e8,
  0x189c7e9a, 0xeb8c4ae4, 0x185bc51b, 0xeb3f5eba,
  0x181a1b34, 0xeaf33f61, 0x17d7836d, 0xeaa7efc7,
  0x17940057, 0xea5d72d6, 0x174f948e, 0xea13cb6a,
  0x170a42b3, 0xe9cafc5d, 0x16c40d74, 0xe983087b,
  0x167cf785, 0xe93bf28c, 0x163503a3, 0xe8f5bd4d,
  0x15ec3496, 0xe8b06b72, 0x15a28d2a, 0xe86bffa9,
  0x15581039, 0xe8287c93, 0x150cc09f, 0xe7e5e4cc,
  0x14c0a146, 0xe7a43ae5, 0x1473b51c, 0xe7638166,
  0x1425ff18, 0xe723bacd, 0x13d78239, 0xe6e4e990,
  0x13884186, 0xe6a7101b, 0x1338400d, 0xe66a30d1,
  0x12e780e4, 0xe62e4e0a, 0x12960727, 0xe5f36a15,
  0x1243d5fc, 0xe5b98738, 0x11f0f08c, 0xe580a7ad,
  0x119d5a0a, 0xe548cda7, 0x114915af, 0xe511fb4c,
  0x10f426bb, 0xe4dc32b9, 0x109e9074, 0xe4a77601,
  0x10485627, 0xe473c72e, 0x0ff17b26, 0xe441283b,
  0x0f9a02cb, 0xe40f9b1f, 0x0f41f075, 0xe3df21c0,
  0x0ee9478a, 0xe3afbdff, 0x0e900b74, 0xe38171ae,
  0x0e363fa5, 0xe3543e96, 0x0ddbe792, 0xe3282676,
  0x0d8106b6, 0xe2fd2b01, 0x0d25a094, 0xe2d34ddf,
  0x0cc9b8b1, 0xe2aa90ad, 0x0c6d5297, 0xe282f4fd,
  0x0c1071d8, 0xe25c7c57, 0x0bb31a08, 0xe2372835,
  0x0b554ebf, 0xe212fa08, 0x0af7139c, 0xe1eff336,
  0x0a986c40, 0xe1ce1518, 0x0a395c53, 0xe1ad60fc,
  0x09d9e77d, 0xe18dd825, 0x097a116d, 0xe16f7bca,
  0x0919ddd6, 0xe1524d17, 0x08b9506c, 0xe1364d2c,
  0x08586ce8, 0xe11b7d1e, 0x07f73707, 0xe101ddf4,
  0x0795b288, 0xe0e970ac, 0x0733e32d, 0xe0d23637,
  0x06d1ccbc, 0xe0bc2f7a, 0x066f72fd, 0xe0a75d4f,
  0x060cd9ba, 0xe093c082, 0x05aa04c1, 0xe08159d6,
  0x0546f7e1, 0xe0702a00, 0x04e3b6ec, 0xe06031aa,
  0x048045b5, 0xe0517172, 0x041ca812, 0xe043e9e8,
  0x03b8e1d9, 0xe0379b93, 0x0354f6e5, 0xe02c86ec,
  0x02f0eb0d, 0xe022ac60, 0x028cc22f, 0xe01a0c51,
  0x02288027, 0xe012a713, 0x01c428d1, 0xe00c7cf0,
  0x015fc00d, 0xe0078e25, 0x00fb49ba, 0xe003dae2,
  0x0096c9b6, 0xe001634c, 0x003243e2, 0xe000277a,
};

static ogg_int16_t bitrevlook_1024[256]={
  0x01fe, 0x0000, 0x00fe, 0x0100,
  0x017e, 0x0080, 0x007e, 0x0180,
  0x01be, 0x0040, 0x00be, 0x0140,
  0x013e, 0x00c0, 0x003e, 0x01c0,
  0x01de, 0x0020, 0x00de, 0x0120,
  0x015e, 0x00a0, 0x005e, 0x01a0,
  0x019e, 0x0060, 0x009e, 0x0160,
  0x011e, 0x00e0, 0x001e, 0x01e0,
  0x01ee, 0x0010, 0x00ee, 0x0110,
  0x016e, 0x0090, 0x006e, 0x0190,
  0x01ae, 0x0050, 0x00ae, 0x0150,
  0x012e, 0x00d0, 0x002e, 0x01d0,
  0x01ce, 0x0030, 0x00ce, 0x0130,
  0x014e, 0x00b0, 0x004e, 0x01b0,
  0x018e, 0x0070, 0x008e, 0x0170,
  0x010e, 0x00f0, 0x000e, 0x01f0,
  0x01f6, 0x0008, 0x00f6, 0x0108,
  0x0176, 0x0088, 0x0076, 0x0188,
  0x01b6, 0x0048, 0x00b6, 0x0148,
  0x0136, 0x00c8, 0x0036, 0x01c8,
  0x01d6, 0x0028, 0x00d6, 0x0128,
  0x0156, 0x00a8, 0x0056, 0x01a8,
  0x0196, 0x0068, 0x0096, 0x0168,
  0x0116, 0x00e8, 0x0016, 0x01e8,
  0x01e6, 0x0018, 0x00e6, 0x0118,
  0x0166, 0x0098, 0x0066, 0x0198,
  0x01a6, 0x0058, 0x00a6, 0x0158,
  0x0126, 0x00d8, 0x0026, 0x01d8,
  0x01c6, 0x0038, 0x00c6, 0x0138,
  0x0146, 0x00b8, 0x0046, 0x01b8,
  0x0186, 0x0078, 0x0086, 0x0178,
  0x0106, 0x00f8, 0x0006, 0x01f8,
  0x01fa, 0x0004, 0x00fa, 0x0104,
  0x017a, 0x0084, 0x007a, 0x0184,
  0x01ba, 0x0044, 0x00ba, 0x0144,
  0x013a, 0x00c4, 0x003a, 0x01c4,
  0x01da, 0x0024, 0x00da, 0x0124,
  0x015a, 0x00a4, 0x005a, 0x01a4,
  0x019a, 0x0064, 0x009a, 0x0164,
  0x011a, 0x00e4, 0x001a, 0x01e4,
  0x01ea, 0x0014, 0x00ea, 0x0114,
  0x016a, 0x0094, 0x006a, 0x0194,
  0x01aa, 0x0054, 0x00aa, 0x0154,
  0x012a, 0x00d4, 0x002a, 0x01d4,
  0x01ca, 0x0034, 0x00ca, 0x0134,
  0x014a, 0x00b4, 0x004a, 0x01b4,
  0x018a, 0x0074, 0x008a, 0x0174,
  0x010a, 0x00f4, 0x000a, 0x01f4,
  0x01f2, 0x000c, 0x00f2, 0x010c,
  0x0172, 0x008c, 0x0072, 0x018c,
  0x01b2, 0x004c, 0x00b2, 0x014c,
  0x0132, 0x00cc, 0x0032, 0x01cc,
  0x01d2, 0x002c, 0x00d2, 0x012c,
  0x0152, 0x00ac, 0x0052, 0x01ac,
  0x0192, 0x006c, 0x0092, 0x016c,
  0x0112, 0x00ec, 0x0012, 0x01ec,
  0x01e2, 0x001c, 0x00e2, 0x011c,
  0x0162, 0x009c, 0x0062, 0x019c,
  0x01a2, 0x005c, 0x00a2, 0x015c,
  0x0122, 0x00dc, 0x0022, 0x01dc,
  0x01c2, 0x003c, 0x00c2, 0x013c,
  0x0142, 0x00bc, 0x0042, 0x01bc,
  0x0182, 0x007c, 0x0082, 0x017c,
  0x0102, 0x00fc, 0x0002, 0x01fc,
};

static ogg_int32_t triglook_2048[2560]={
  0x40000000, 0x00000000, 0x3fffb10b, 0xff9b783c,
  0x3ffec42d, 0xff36f170, 0x3ffd3969, 0xfed26c94,
  0x3ffb10c1, 0xfe6deaa1, 0x3ff84a3c, 0xfe096c8d,
  0x3ff4e5e0, 0xfda4f351, 0x3ff0e3b6, 0xfd407fe6,
  0x3fec43c7, 0xfcdc1342, 0x3fe7061f, 0xfc77ae5e,
  0x3fe12acb, 0xfc135231, 0x3fdab1d9, 0xfbaeffb3,
  0x3fd39b5a, 0xfb4ab7db, 0x3fcbe75e, 0xfae67ba2,
  0x3fc395f9, 0xfa824bfd, 0x3fbaa740, 0xfa1e29e5,
  0x3fb11b48, 0xf9ba1651, 0x3fa6f228, 0xf9561237,
  0x3f9c2bfb, 0xf8f21e8e, 0x3f90c8da, 0xf88e3c4d,
  0x3f84c8e2, 0xf82a6c6a, 0x3f782c30, 0xf7c6afdc,
  0x3f6af2e3, 0xf7630799, 0x3f5d1d1d, 0xf6ff7496,
  0x3f4eaafe, 0xf69bf7c9, 0x3f3f9cab, 0xf6389228,
  0x3f2ff24a, 0xf5d544a7, 0x3f1fabff, 0xf572103d,
  0x3f0ec9f5, 0xf50ef5de, 0x3efd4c54, 0xf4abf67e,
  0x3eeb3347, 0xf4491311, 0x3ed87efc, 0xf3e64c8c,
  0x3ec52fa0, 0xf383a3e2, 0x3eb14563, 0xf3211a07,
  0x3e9cc076, 0xf2beafed, 0x3e87a10c, 0xf25c6688,
  0x3e71e759, 0xf1fa3ecb, 0x3e5b9392, 0xf19839a6,
  0x3e44a5ef, 0xf136580d, 0x3e2d1ea8, 0xf0d49af1,
  0x3e14fdf7, 0xf0730342, 0x3dfc4418, 0xf01191f3,
  0x3de2f148, 0xefb047f2, 0x3dc905c5, 0xef4f2630,
  0x3dae81cf, 0xeeee2d9d, 0x3d9365a8, 0xee8d5f29,
  0x3d77b192, 0xee2cbbc1, 0x3d5b65d2, 0xedcc4454,
  0x3d3e82ae, 0xed6bf9d1, 0x3d21086c, 0xed0bdd25,
  0x3d02f757, 0xecabef3d, 0x3ce44fb7, 0xec4c3106,
  0x3cc511d9, 0xebeca36c, 0x3ca53e09, 0xeb8d475b,
  0x3c84d496, 0xeb2e1dbe, 0x3c63d5d1, 0xeacf277f,
  0x3c42420a, 0xea70658a, 0x3c201994, 0xea11d8c8,
  0x3bfd5cc4, 0xe9b38223, 0x3bda0bf0, 0xe9556282,
  0x3bb6276e, 0xe8f77acf, 0x3b91af97, 0xe899cbf1,
  0x3b6ca4c4, 0xe83c56cf, 0x3b470753, 0xe7df1c50,
  0x3b20d79e, 0xe7821d59, 0x3afa1605, 0xe7255ad1,
  0x3ad2c2e8, 0xe6c8d59c, 0x3aaadea6, 0xe66c8e9f,
  0x3a8269a3, 0xe61086bc, 0x3a596442, 0xe5b4bed8,
  0x3a2fcee8, 0xe55937d5, 0x3a05a9fd, 0xe4fdf294,
  0x39daf5e8, 0xe4a2eff6, 0x39afb313, 0xe44830dd,
  0x3983e1e8, 0xe3edb628, 0x395782d3, 0xe39380b6,
  0x392a9642, 0xe3399167, 0x38fd1ca4, 0xe2dfe917,
  0x38cf1669, 0xe28688a4, 0x38a08402, 0xe22d70eb,
  0x387165e3, 0xe1d4a2c8, 0x3841bc7f, 0xe17c1f15,
  0x3811884d, 0xe123e6ad, 0x37e0c9c3, 0xe0cbfa6a,
  0x37af8159, 0xe0745b24, 0x377daf89, 0xe01d09b4,
  0x374b54ce, 0xdfc606f1, 0x371871a5, 0xdf6f53b3,
  0x36e5068a, 0xdf18f0ce, 0x36b113fd, 0xdec2df18,
  0x367c9a7e, 0xde6d1f65, 0x36479a8e, 0xde17b28a,
  0x361214b0, 0xddc29958, 0x35dc0968, 0xdd6dd4a2,
  0x35a5793c, 0xdd196538, 0x356e64b2, 0xdcc54bec,
  0x3536cc52, 0xdc71898d, 0x34feb0a5, 0xdc1e1ee9,
  0x34c61236, 0xdbcb0cce, 0x348cf190, 0xdb785409,
  0x34534f41, 0xdb25f566, 0x34192bd5, 0xdad3f1b1,
  0x33de87de, 0xda8249b4, 0x33a363ec, 0xda30fe38,
  0x3367c090, 0xd9e01006, 0x332b9e5e, 0xd98f7fe6,
  0x32eefdea, 0xd93f4e9e, 0x32b1dfc9, 0xd8ef7cf4,
  0x32744493, 0xd8a00bae, 0x32362ce0, 0xd850fb8e,
  0x31f79948, 0xd8024d59, 0x31b88a66, 0xd7b401d1,
  0x317900d6, 0xd76619b6, 0x3138fd35, 0xd71895c9,
  0x30f8801f, 0xd6cb76c9, 0x30b78a36, 0xd67ebd74,
  0x30761c18, 0xd6326a88, 0x30343667, 0xd5e67ec1,
  0x2ff1d9c7, 0xd59afadb, 0x2faf06da, 0xd54fdf8f,
  0x2f6bbe45, 0xd5052d97, 0x2f2800af, 0xd4bae5ab,
  0x2ee3cebe, 0xd4710883, 0x2e9f291b, 0xd42796d5,
  0x2e5a1070, 0xd3de9156, 0x2e148566, 0xd395f8ba,
  0x2dce88aa, 0xd34dcdb4, 0x2d881ae8, 0xd30610f7,
  0x2d413ccd, 0xd2bec333, 0x2cf9ef09, 0xd277e518,
  0x2cb2324c, 0xd2317756, 0x2c6a0746, 0xd1eb7a9a,
  0x2c216eaa, 0xd1a5ef90, 0x2bd8692b, 0xd160d6e5,
  0x2b8ef77d, 0xd11c3142, 0x2b451a55, 0xd0d7ff51,
  0x2afad269, 0xd09441bb, 0x2ab02071, 0xd050f926,
  0x2a650525, 0xd00e2639, 0x2a19813f, 0xcfcbc999,
  0x29cd9578, 0xcf89e3e8, 0x2981428c, 0xcf4875ca,
  0x29348937, 0xcf077fe1, 0x28e76a37, 0xcec702cb,
  0x2899e64a, 0xce86ff2a, 0x284bfe2f, 0xce47759a,
  0x27fdb2a7, 0xce0866b8, 0x27af0472, 0xcdc9d320,
  0x275ff452, 0xcd8bbb6d, 0x2710830c, 0xcd4e2037,
  0x26c0b162, 0xcd110216, 0x2670801a, 0xccd461a2,
  0x261feffa, 0xcc983f70, 0x25cf01c8, 0xcc5c9c14,
  0x257db64c, 0xcc217822, 0x252c0e4f, 0xcbe6d42b,
  0x24da0a9a, 0xcbacb0bf, 0x2487abf7, 0xcb730e70,
  0x2434f332, 0xcb39edca, 0x23e1e117, 0xcb014f5b,
  0x238e7673, 0xcac933ae, 0x233ab414, 0xca919b4e,
  0x22e69ac8, 0xca5a86c4, 0x22922b5e, 0xca23f698,
  0x223d66a8, 0xc9edeb50, 0x21e84d76, 0xc9b86572,
  0x2192e09b, 0xc9836582, 0x213d20e8, 0xc94eec03,
  0x20e70f32, 0xc91af976, 0x2090ac4d, 0xc8e78e5b,
  0x2039f90f, 0xc8b4ab32, 0x1fe2f64c, 0xc8825077,
  0x1f8ba4dc, 0xc8507ea7, 0x1f340596, 0xc81f363d,
  0x1edc1953, 0xc7ee77b3, 0x1e83e0eb, 0xc7be4381,
  0x1e2b5d38, 0xc78e9a1d, 0x1dd28f15, 0xc75f7bfe,
  0x1d79775c, 0xc730e997, 0x1d2016e9, 0xc702e35c,
  0x1cc66e99, 0xc6d569be, 0x1c6c7f4a, 0xc6a87d2d,
  0x1c1249d8, 0xc67c1e18, 0x1bb7cf23, 0xc6504ced,
  0x1b5d100a, 0xc6250a18, 0x1b020d6c, 0xc5fa5603,
  0x1aa6c82b, 0xc5d03118, 0x1a4b4128, 0xc5a69bbe,
  0x19ef7944, 0xc57d965d, 0x19937161, 0xc555215a,
  0x19372a64, 0xc52d3d18, 0x18daa52f, 0xc505e9fb,
  0x187de2a7, 0xc4df2862, 0x1820e3b0, 0xc4b8f8ad,
  0x17c3a931, 0xc4935b3c, 0x1766340f, 0xc46e5069,
  0x17088531, 0xc449d892, 0x16aa9d7e, 0xc425f410,
  0x164c7ddd, 0xc402a33c, 0x15ee2738, 0xc3dfe66c,
  0x158f9a76, 0xc3bdbdf6, 0x1530d881, 0xc39c2a2f,
  0x14d1e242, 0xc37b2b6a, 0x1472b8a5, 0xc35ac1f7,
  0x14135c94, 0xc33aee27, 0x13b3cefa, 0xc31bb049,
  0x135410c3, 0xc2fd08a9, 0x12f422db, 0xc2def794,
  0x1294062f, 0xc2c17d52, 0x1233bbac, 0xc2a49a2e,
  0x11d3443f, 0xc2884e6e, 0x1172a0d7, 0xc26c9a58,
  0x1111d263, 0xc2517e31, 0x10b0d9d0, 0xc236fa3b,
  0x104fb80e, 0xc21d0eb8, 0x0fee6e0d, 0xc203bbe8,
  0x0f8cfcbe, 0xc1eb0209, 0x0f2b650f, 0xc1d2e158,
  0x0ec9a7f3, 0xc1bb5a11, 0x0e67c65a, 0xc1a46c6e,
  0x0e05c135, 0xc18e18a7, 0x0da39978, 0xc1785ef4,
  0x0d415013, 0xc1633f8a, 0x0cdee5f9, 0xc14eba9d,
  0x0c7c5c1e, 0xc13ad060, 0x0c19b374, 0xc1278104,
  0x0bb6ecef, 0xc114ccb9, 0x0b540982, 0xc102b3ac,
  0x0af10a22, 0xc0f1360b, 0x0a8defc3, 0xc0e05401,
  0x0a2abb59, 0xc0d00db6, 0x09c76dd8, 0xc0c06355,
  0x09640837, 0xc0b15502, 0x09008b6a, 0xc0a2e2e3,
  0x089cf867, 0xc0950d1d, 0x08395024, 0xc087d3d0,
  0x07d59396, 0xc07b371e, 0x0771c3b3, 0xc06f3726,
  0x070de172, 0xc063d405, 0x06a9edc9, 0xc0590dd8,
  0x0645e9af, 0xc04ee4b8, 0x05e1d61b, 0xc04558c0,
  0x057db403, 0xc03c6a07, 0x0519845e, 0xc03418a2,
  0x04b54825, 0xc02c64a6, 0x0451004d, 0xc0254e27,
  0x03ecadcf, 0xc01ed535, 0x038851a2, 0xc018f9e1,
  0x0323ecbe, 0xc013bc39, 0x02bf801a, 0xc00f1c4a,
  0x025b0caf, 0xc00b1a20, 0x01f69373, 0xc007b5c4,
  0x0192155f, 0xc004ef3f, 0x012d936c, 0xc002c697,
  0x00c90e90, 0xc0013bd3, 0x006487c4, 0xc0004ef5,
  0x00000000, 0xc0000000, 0xff9b783c, 0xc0004ef5,
  0xff36f170, 0xc0013bd3, 0xfed26c94, 0xc002c697,
  0xfe6deaa1, 0xc004ef3f, 0xfe096c8d, 0xc007b5c4,
  0xfda4f351, 0xc00b1a20, 0xfd407fe6, 0xc00f1c4a,
  0xfcdc1342, 0xc013bc39, 0xfc77ae5e, 0xc018f9e1,
  0xfc135231, 0xc01ed535, 0xfbaeffb3, 0xc0254e27,
  0xfb4ab7db, 0xc02c64a6, 0xfae67ba2, 0xc03418a2,
  0xfa824bfd, 0xc03c6a07, 0xfa1e29e5, 0xc04558c0,
  0xf9ba1651, 0xc04ee4b8, 0xf9561237, 0xc0590dd8,
  0xf8f21e8e, 0xc063d405, 0xf88e3c4d, 0xc06f3726,
  0xf82a6c6a, 0xc07b371e, 0xf7c6afdc, 0xc087d3d0,
  0xf7630799, 0xc0950d1d, 0xf6ff7496, 0xc0a2e2e3,
  0xf69bf7c9, 0xc0b15502, 0xf6389228, 0xc0c06355,
  0xf5d544a7, 0xc0d00db6, 0xf572103d, 0xc0e05401,
  0xf50ef5de, 0xc0f1360b, 0xf4abf67e, 0xc102b3ac,
  0xf4491311, 0xc114ccb9, 0xf3e64c8c, 0xc1278104,
  0xf383a3e2, 0xc13ad060, 0xf3211a07, 0xc14eba9d,
  0xf2beafed, 0xc1633f8a, 0xf25c6688, 0xc1785ef4,
  0xf1fa3ecb, 0xc18e18a7, 0xf19839a6, 0xc1a46c6e,
  0xf136580d, 0xc1bb5a11, 0xf0d49af1, 0xc1d2e158,
  0xf0730342, 0xc1eb0209, 0xf01191f3, 0xc203bbe8,
  0xefb047f2, 0xc21d0eb8, 0xef4f2630, 0xc236fa3b,
  0xeeee2d9d, 0xc2517e31, 0xee8d5f29, 0xc26c9a58,
  0xee2cbbc1, 0xc2884e6e, 0xedcc4454, 0xc2a49a2e,
  0xed6bf9d1, 0xc2c17d52, 0xed0bdd25, 0xc2def794,
  0xecabef3d, 0xc2fd08a9, 0xec4c3106, 0xc31bb049,
  0xebeca36c, 0xc33aee27, 0xeb8d475b, 0xc35ac1f7,
  0xeb2e1dbe, 0xc37b2b6a, 0xeacf277f, 0xc39c2a2f,
  0xea70658a, 0xc3bdbdf6, 0xea11d8c8, 0xc3dfe66c,
  0xe9b38223, 0xc402a33c, 0xe9556282, 0xc425f410,
  0xe8f77acf, 0xc449d892, 0xe899cbf1, 0xc46e5069,
  0xe83c56cf, 0xc4935b3c, 0xe7df1c50, 0xc4b8f8ad,
  0xe7821d59, 0xc4df2862, 0xe7255ad1, 0xc505e9fb,
  0xe6c8d59c, 0xc52d3d18, 0xe66c8e9f, 0xc555215a,
  0xe61086bc, 0xc57d965d, 0xe5b4bed8, 0xc5a69bbe,
  0xe55937d5, 0xc5d03118, 0xe4fdf294, 0xc5fa5603,
  0xe4a2eff6, 0xc6250a18, 0xe44830dd, 0xc6504ced,
  0xe3edb628, 0xc67c1e18, 0xe39380b6, 0xc6a87d2d,
  0xe3399167, 0xc6d569be, 0xe2dfe917, 0xc702e35c,
  0xe28688a4, 0xc730e997, 0xe22d70eb, 0xc75f7bfe,
  0xe1d4a2c8, 0xc78e9a1d, 0xe17c1f15, 0xc7be4381,
  0xe123e6ad, 0xc7ee77b3, 0xe0cbfa6a, 0xc81f363d,
  0xe0745b24, 0xc8507ea7, 0xe01d09b4, 0xc8825077,
  0xdfc606f1, 0xc8b4ab32, 0xdf6f53b3, 0xc8e78e5b,
  0xdf18f0ce, 0xc91af976, 0xdec2df18, 0xc94eec03,
  0xde6d1f65, 0xc9836582, 0xde17b28a, 0xc9b86572,
  0xddc29958, 0xc9edeb50, 0xdd6dd4a2, 0xca23f698,
  0xdd196538, 0xca5a86c4, 0xdcc54bec, 0xca919b4e,
  0xdc71898d, 0xcac933ae, 0xdc1e1ee9, 0xcb014f5b,
  0xdbcb0cce, 0xcb39edca, 0xdb785409, 0xcb730e70,
  0xdb25f566, 0xcbacb0bf, 0xdad3f1b1, 0xcbe6d42b,
  0xda8249b4, 0xcc217822, 0xda30fe38, 0xcc5c9c14,
  0xd9e01006, 0xcc983f70, 0xd98f7fe6, 0xccd461a2,
  0xd93f4e9e, 0xcd110216, 0xd8ef7cf4, 0xcd4e2037,
  0xd8a00bae, 0xcd8bbb6d, 0xd850fb8e, 0xcdc9d320,
  0xd8024d59, 0xce0866b8, 0xd7b401d1, 0xce47759a,
  0xd76619b6, 0xce86ff2a, 0xd71895c9, 0xcec702cb,
  0xd6cb76c9, 0xcf077fe1, 0xd67ebd74, 0xcf4875ca,
  0xd6326a88, 0xcf89e3e8, 0xd5e67ec1, 0xcfcbc999,
  0xd59afadb, 0xd00e2639, 0xd54fdf8f, 0xd050f926,
  0xd5052d97, 0xd09441bb, 0xd4bae5ab, 0xd0d7ff51,
  0xd4710883, 0xd11c3142, 0xd42796d5, 0xd160d6e5,
  0xd3de9156, 0xd1a5ef90, 0xd395f8ba, 0xd1eb7a9a,
  0xd34dcdb4, 0xd2317756, 0xd30610f7, 0xd277e518,
  0xd2bec333, 0xd2bec333, 0xd277e518, 0xd30610f7,
  0xd2317756, 0xd34dcdb4, 0xd1eb7a9a, 0xd395f8ba,
  0xd1a5ef90, 0xd3de9156, 0xd160d6e5, 0xd42796d5,
  0xd11c3142, 0xd4710883, 0xd0d7ff51, 0xd4bae5ab,
  0xd09441bb, 0xd5052d97, 0xd050f926, 0xd54fdf8f,
  0xd00e2639, 0xd59afadb, 0xcfcbc999, 0xd5e67ec1,
  0xcf89e3e8, 0xd6326a88, 0xcf4875ca, 0xd67ebd74,
  0xcf077fe1, 0xd6cb76c9, 0xcec702cb, 0xd71895c9,
  0xce86ff2a, 0xd76619b6, 0xce47759a, 0xd7b401d1,
  0xce0866b8, 0xd8024d59, 0xcdc9d320, 0xd850fb8e,
  0xcd8bbb6d, 0xd8a00bae, 0xcd4e2037, 0xd8ef7cf4,
  0xcd110216, 0xd93f4e9e, 0xccd461a2, 0xd98f7fe6,
  0xcc983f70, 0xd9e01006, 0xcc5c9c14, 0xda30fe38,
  0xcc217822, 0xda8249b4, 0xcbe6d42b, 0xdad3f1b1,
  0xcbacb0bf, 0xdb25f566, 0xcb730e70, 0xdb785409,
  0xcb39edca, 0xdbcb0cce, 0xcb014f5b, 0xdc1e1ee9,
  0xcac933ae, 0xdc71898d, 0xca919b4e, 0xdcc54bec,
  0xca5a86c4, 0xdd196538, 0xca23f698, 0xdd6dd4a2,
  0xc9edeb50, 0xddc29958, 0xc9b86572, 0xde17b28a,
  0xc9836582, 0xde6d1f65, 0xc94eec03, 0xdec2df18,
  0xc91af976, 0xdf18f0ce, 0xc8e78e5b, 0xdf6f53b3,
  0xc8b4ab32, 0xdfc606f1, 0xc8825077, 0xe01d09b4,
  0xc8507ea7, 0xe0745b24, 0xc81f363d, 0xe0cbfa6a,
  0xc7ee77b3, 0xe123e6ad, 0xc7be4381, 0xe17c1f15,
  0xc78e9a1d, 0xe1d4a2c8, 0xc75f7bfe, 0xe22d70eb,
  0xc730e997, 0xe28688a4, 0xc702e35c, 0xe2dfe917,
  0xc6d569be, 0xe3399167, 0xc6a87d2d, 0xe39380b6,
  0xc67c1e18, 0xe3edb628, 0xc6504ced, 0xe44830dd,
  0xc6250a18, 0xe4a2eff6, 0xc5fa5603, 0xe4fdf294,
  0xc5d03118, 0xe55937d5, 0xc5a69bbe, 0xe5b4bed8,
  0xc57d965d, 0xe61086bc, 0xc555215a, 0xe66c8e9f,
  0xc52d3d18, 0xe6c8d59c, 0xc505e9fb, 0xe7255ad1,
  0xc4df2862, 0xe7821d59, 0xc4b8f8ad, 0xe7df1c50,
  0xc4935b3c, 0xe83c56cf, 0xc46e5069, 0xe899cbf1,
  0xc449d892, 0xe8f77acf, 0xc425f410, 0xe9556282,
  0xc402a33c, 0xe9b38223, 0xc3dfe66c, 0xea11d8c8,
  0xc3bdbdf6, 0xea70658a, 0xc39c2a2f, 0xeacf277f,
  0xc37b2b6a, 0xeb2e1dbe, 0xc35ac1f7, 0xeb8d475b,
  0xc33aee27, 0xebeca36c, 0xc31bb049, 0xec4c3106,
  0xc2fd08a9, 0xecabef3d, 0xc2def794, 0xed0bdd25,
  0xc2c17d52, 0xed6bf9d1, 0xc2a49a2e, 0xedcc4454,
  0xc2884e6e, 0xee2cbbc1, 0xc26c9a58, 0xee8d5f29,
  0xc2517e31, 0xeeee2d9d, 0xc236fa3b, 0xef4f2630,
  0xc21d0eb8, 0xefb047f2, 0xc203bbe8, 0xf01191f3,
  0xc1eb0209, 0xf0730342, 0xc1d2e158, 0xf0d49af1,
  0xc1bb5a11, 0xf136580d, 0xc1a46c6e, 0xf19839a6,
  0xc18e18a7, 0xf1fa3ecb, 0xc1785ef4, 0xf25c6688,
  0xc1633f8a, 0xf2beafed, 0xc14eba9d, 0xf3211a07,
  0xc13ad060, 0xf383a3e2, 0xc1278104, 0xf3e64c8c,
  0xc114ccb9, 0xf4491311, 0xc102b3ac, 0xf4abf67e,
  0xc0f1360b, 0xf50ef5de, 0xc0e05401, 0xf572103d,
  0xc0d00db6, 0xf5d544a7, 0xc0c06355, 0xf6389228,
  0xc0b15502, 0xf69bf7c9, 0xc0a2e2e3, 0xf6ff7496,
  0xc0950d1d, 0xf7630799, 0xc087d3d0, 0xf7c6afdc,
  0xc07b371e, 0xf82a6c6a, 0xc06f3726, 0xf88e3c4d,
  0xc063d405, 0xf8f21e8e, 0xc0590dd8, 0xf9561237,
  0xc04ee4b8, 0xf9ba1651, 0xc04558c0, 0xfa1e29e5,
  0xc03c6a07, 0xfa824bfd, 0xc03418a2, 0xfae67ba2,
  0xc02c64a6, 0xfb4ab7db, 0xc0254e27, 0xfbaeffb3,
  0xc01ed535, 0xfc135231, 0xc018f9e1, 0xfc77ae5e,
  0xc013bc39, 0xfcdc1342, 0xc00f1c4a, 0xfd407fe6,
  0xc00b1a20, 0xfda4f351, 0xc007b5c4, 0xfe096c8d,
  0xc004ef3f, 0xfe6deaa1, 0xc002c697, 0xfed26c94,
  0xc0013bd3, 0xff36f170, 0xc0004ef5, 0xff9b783c,
  0x3ffffec4, 0x000c90fe, 0x3ffff4e6, 0x0025b2f7,
  0x3fffe128, 0x003ed4ea, 0x3fffc38c, 0x0057f6d4,
  0x3fff9c12, 0x007118b0, 0x3fff6ab9, 0x008a3a7b,
  0x3fff2f82, 0x00a35c30, 0x3ffeea6c, 0x00bc7dcc,
  0x3ffe9b77, 0x00d59f4c, 0x3ffe42a4, 0x00eec0aa,
  0x3ffddff3, 0x0107e1e3, 0x3ffd7364, 0x012102f4,
  0x3ffcfcf6, 0x013a23d8, 0x3ffc7caa, 0x0153448c,
  0x3ffbf280, 0x016c650b, 0x3ffb5e78, 0x01858552,
  0x3ffac092, 0x019ea55d, 0x3ffa18cf, 0x01b7c528,
  0x3ff9672d, 0x01d0e4b0, 0x3ff8abae, 0x01ea03ef,
  0x3ff7e652, 0x020322e3, 0x3ff71718, 0x021c4188,
  0x3ff63e01, 0x02355fd9, 0x3ff55b0d, 0x024e7dd4,
  0x3ff46e3c, 0x02679b73, 0x3ff3778e, 0x0280b8b3,
  0x3ff27703, 0x0299d590, 0x3ff16c9c, 0x02b2f207,
  0x3ff05858, 0x02cc0e13, 0x3fef3a39, 0x02e529b0,
  0x3fee123d, 0x02fe44dc, 0x3fece065, 0x03175f91,
  0x3feba4b2, 0x033079cc, 0x3fea5f23, 0x03499389,
  0x3fe90fb9, 0x0362acc5, 0x3fe7b674, 0x037bc57b,
  0x3fe65354, 0x0394dda7, 0x3fe4e659, 0x03adf546,
  0x3fe36f84, 0x03c70c54, 0x3fe1eed5, 0x03e022cc,
  0x3fe0644b, 0x03f938ac, 0x3fdecfe8, 0x04124dee,
  0x3fdd31ac, 0x042b6290, 0x3fdb8996, 0x0444768d,
  0x3fd9d7a7, 0x045d89e2, 0x3fd81bdf, 0x04769c8b,
  0x3fd6563f, 0x048fae83, 0x3fd486c7, 0x04a8bfc7,
  0x3fd2ad77, 0x04c1d054, 0x3fd0ca4f, 0x04dae024,
  0x3fcedd50, 0x04f3ef35, 0x3fcce67a, 0x050cfd82,
  0x3fcae5cd, 0x05260b08, 0x3fc8db4a, 0x053f17c3,
  0x3fc6c6f0, 0x055823ae, 0x3fc4a8c1, 0x05712ec7,
  0x3fc280bc, 0x058a3908, 0x3fc04ee3, 0x05a3426f,
  0x3fbe1334, 0x05bc4af8, 0x3fbbcdb1, 0x05d5529e,
  0x3fb97e5a, 0x05ee595d, 0x3fb7252f, 0x06075f33,
  0x3fb4c231, 0x0620641a, 0x3fb2555f, 0x06396810,
  0x3fafdebb, 0x06526b10, 0x3fad5e45, 0x066b6d16,
  0x3faad3fd, 0x06846e1f, 0x3fa83fe3, 0x069d6e27,
  0x3fa5a1f9, 0x06b66d29, 0x3fa2fa3d, 0x06cf6b23,
  0x3fa048b2, 0x06e86810, 0x3f9d8d56, 0x070163eb,
  0x3f9ac82c, 0x071a5eb3, 0x3f97f932, 0x07335862,
  0x3f952069, 0x074c50f4, 0x3f923dd2, 0x07654867,
  0x3f8f516e, 0x077e3eb5, 0x3f8c5b3d, 0x079733dc,
  0x3f895b3e, 0x07b027d7, 0x3f865174, 0x07c91aa3,
  0x3f833ddd, 0x07e20c3b, 0x3f80207b, 0x07fafc9c,
  0x3f7cf94e, 0x0813ebc2, 0x3f79c857, 0x082cd9a9,
  0x3f768d96, 0x0845c64d, 0x3f73490b, 0x085eb1ab,
  0x3f6ffab8, 0x08779bbe, 0x3f6ca29c, 0x08908483,
  0x3f6940b8, 0x08a96bf6, 0x3f65d50d, 0x08c25213,
  0x3f625f9b, 0x08db36d6, 0x3f5ee063, 0x08f41a3c,
  0x3f5b5765, 0x090cfc40, 0x3f57c4a2, 0x0925dcdf,
  0x3f54281a, 0x093ebc14, 0x3f5081cd, 0x095799dd,
  0x3f4cd1be, 0x09707635, 0x3f4917eb, 0x09895118,
  0x3f455456, 0x09a22a83, 0x3f4186ff, 0x09bb0271,
  0x3f3dafe7, 0x09d3d8df, 0x3f39cf0e, 0x09ecadc9,
  0x3f35e476, 0x0a05812c, 0x3f31f01d, 0x0a1e5303,
  0x3f2df206, 0x0a37234a, 0x3f29ea31, 0x0a4ff1fe,
  0x3f25d89e, 0x0a68bf1b, 0x3f21bd4e, 0x0a818a9d,
  0x3f1d9842, 0x0a9a5480, 0x3f19697a, 0x0ab31cc1,
  0x3f1530f7, 0x0acbe35b, 0x3f10eeb9, 0x0ae4a84b,
  0x3f0ca2c2, 0x0afd6b8d, 0x3f084d12, 0x0b162d1d,
  0x3f03eda9, 0x0b2eecf8, 0x3eff8489, 0x0b47ab19,
  0x3efb11b1, 0x0b60677c, 0x3ef69523, 0x0b79221f,
  0x3ef20ee0, 0x0b91dafc, 0x3eed7ee7, 0x0baa9211,
  0x3ee8e53a, 0x0bc34759, 0x3ee441da, 0x0bdbfad1,
  0x3edf94c7, 0x0bf4ac75, 0x3edade01, 0x0c0d5c41,
  0x3ed61d8a, 0x0c260a31, 0x3ed15363, 0x0c3eb641,
  0x3ecc7f8b, 0x0c57606e, 0x3ec7a205, 0x0c7008b3,
  0x3ec2bad0, 0x0c88af0e, 0x3ebdc9ed, 0x0ca1537a,
  0x3eb8cf5d, 0x0cb9f5f3, 0x3eb3cb21, 0x0cd29676,
  0x3eaebd3a, 0x0ceb34fe, 0x3ea9a5a8, 0x0d03d189,
  0x3ea4846c, 0x0d1c6c11, 0x3e9f5988, 0x0d350495,
  0x3e9a24fb, 0x0d4d9b0e, 0x3e94e6c6, 0x0d662f7b,
  0x3e8f9eeb, 0x0d7ec1d6, 0x3e8a4d6a, 0x0d97521d,
  0x3e84f245, 0x0dafe04b, 0x3e7f8d7b, 0x0dc86c5d,
  0x3e7a1f0d, 0x0de0f64f, 0x3e74a6fd, 0x0df97e1d,
  0x3e6f254c, 0x0e1203c3, 0x3e6999fa, 0x0e2a873e,
  0x3e640507, 0x0e430889, 0x3e5e6676, 0x0e5b87a2,
  0x3e58be47, 0x0e740483, 0x3e530c7a, 0x0e8c7f2a,
  0x3e4d5110, 0x0ea4f793, 0x3e478c0b, 0x0ebd6db9,
  0x3e41bd6c, 0x0ed5e19a, 0x3e3be532, 0x0eee5331,
  0x3e360360, 0x0f06c27a, 0x3e3017f6, 0x0f1f2f73,
  0x3e2a22f4, 0x0f379a16, 0x3e24245d, 0x0f500260,
  0x3e1e1c30, 0x0f68684e, 0x3e180a6f, 0x0f80cbdc,
  0x3e11ef1b, 0x0f992d06, 0x3e0bca34, 0x0fb18bc8,
  0x3e059bbb, 0x0fc9e81e, 0x3dff63b2, 0x0fe24205,
  0x3df9221a, 0x0ffa9979, 0x3df2d6f3, 0x1012ee76,
  0x3dec823e, 0x102b40f8, 0x3de623fd, 0x104390fd,
  0x3ddfbc30, 0x105bde7f, 0x3dd94ad8, 0x1074297b,
  0x3dd2cff7, 0x108c71ee, 0x3dcc4b8d, 0x10a4b7d3,
  0x3dc5bd9b, 0x10bcfb28, 0x3dbf2622, 0x10d53be7,
  0x3db88524, 0x10ed7a0e, 0x3db1daa2, 0x1105b599,
  0x3dab269b, 0x111dee84, 0x3da46912, 0x113624cb,
  0x3d9da208, 0x114e586a, 0x3d96d17d, 0x1166895f,
  0x3d8ff772, 0x117eb7a4, 0x3d8913ea, 0x1196e337,
  0x3d8226e4, 0x11af0c13, 0x3d7b3061, 0x11c73235,
  0x3d743064, 0x11df5599, 0x3d6d26ec, 0x11f7763c,
  0x3d6613fb, 0x120f941a, 0x3d5ef793, 0x1227af2e,
  0x3d57d1b3, 0x123fc776, 0x3d50a25e, 0x1257dced,
  0x3d496994, 0x126fef90, 0x3d422757, 0x1287ff5b,
  0x3d3adba7, 0x12a00c4b, 0x3d338687, 0x12b8165b,
  0x3d2c27f6, 0x12d01d89, 0x3d24bff6, 0x12e821cf,
  0x3d1d4e88, 0x1300232c, 0x3d15d3ad, 0x1318219a,
  0x3d0e4f67, 0x13301d16, 0x3d06c1b6, 0x1348159d,
  0x3cff2a9d, 0x13600b2a, 0x3cf78a1b, 0x1377fdbb,
  0x3cefe032, 0x138fed4b, 0x3ce82ce4, 0x13a7d9d7,
  0x3ce07031, 0x13bfc35b, 0x3cd8aa1b, 0x13d7a9d3,
  0x3cd0daa2, 0x13ef8d3c, 0x3cc901c9, 0x14076d91,
  0x3cc11f90, 0x141f4ad1, 0x3cb933f9, 0x143724f5,
  0x3cb13f04, 0x144efbfc, 0x3ca940b3, 0x1466cfe1,
  0x3ca13908, 0x147ea0a0, 0x3c992803, 0x14966e36,
  0x3c910da5, 0x14ae38a0, 0x3c88e9f1, 0x14c5ffd9,
  0x3c80bce7, 0x14ddc3de, 0x3c788688, 0x14f584ac,
  0x3c7046d6, 0x150d423d, 0x3c67fdd1, 0x1524fc90,
  0x3c5fab7c, 0x153cb3a0, 0x3c574fd8, 0x1554676a,
  0x3c4eeae5, 0x156c17e9, 0x3c467ca6, 0x1583c51b,
  0x3c3e051b, 0x159b6efb, 0x3c358446, 0x15b31587,
  0x3c2cfa28, 0x15cab8ba, 0x3c2466c2, 0x15e25890,
  0x3c1bca16, 0x15f9f507, 0x3c132424, 0x16118e1a,
  0x3c0a74f0, 0x162923c5, 0x3c01bc78, 0x1640b606,
  0x3bf8fac0, 0x165844d8, 0x3bf02fc9, 0x166fd039,
  0x3be75b93, 0x16875823, 0x3bde7e20, 0x169edc94,
  0x3bd59771, 0x16b65d88, 0x3bcca789, 0x16cddafb,
  0x3bc3ae67, 0x16e554ea, 0x3bbaac0e, 0x16fccb51,
  0x3bb1a080, 0x17143e2d, 0x3ba88bbc, 0x172bad7a,
  0x3b9f6dc5, 0x17431933, 0x3b96469d, 0x175a8157,
  0x3b8d1644, 0x1771e5e0, 0x3b83dcbc, 0x178946cc,
  0x3b7a9a07, 0x17a0a417, 0x3b714e25, 0x17b7fdbd,
  0x3b67f919, 0x17cf53bb, 0x3b5e9ae4, 0x17e6a60c,
  0x3b553386, 0x17fdf4ae, 0x3b4bc303, 0x18153f9d,
  0x3b42495a, 0x182c86d5, 0x3b38c68e, 0x1843ca53,
  0x3b2f3aa0, 0x185b0a13, 0x3b25a591, 0x18724611,
  0x3b1c0764, 0x18897e4a, 0x3b126019, 0x18a0b2bb,
  0x3b08afb2, 0x18b7e35f, 0x3afef630, 0x18cf1034,
  0x3af53395, 0x18e63935, 0x3aeb67e3, 0x18fd5e5f,
  0x3ae1931a, 0x19147fae, 0x3ad7b53d, 0x192b9d1f,
  0x3acdce4d, 0x1942b6af, 0x3ac3de4c, 0x1959cc5a,
  0x3ab9e53a, 0x1970de1b, 0x3aafe31b, 0x1987ebf0,
  0x3aa5d7ee, 0x199ef5d6, 0x3a9bc3b6, 0x19b5fbc8,
  0x3a91a674, 0x19ccfdc2, 0x3a87802a, 0x19e3fbc3,
  0x3a7d50da, 0x19faf5c5, 0x3a731884, 0x1a11ebc5,
  0x3a68d72b, 0x1a28ddc0, 0x3a5e8cd0, 0x1a3fcbb3,
  0x3a543974, 0x1a56b599, 0x3a49dd1a, 0x1a6d9b70,
  0x3a3f77c3, 0x1a847d33, 0x3a350970, 0x1a9b5adf,
  0x3a2a9223, 0x1ab23471, 0x3a2011de, 0x1ac909e5,
  0x3a1588a2, 0x1adfdb37, 0x3a0af671, 0x1af6a865,
  0x3a005b4d, 0x1b0d716a, 0x39f5b737, 0x1b243643,
  0x39eb0a31, 0x1b3af6ec, 0x39e0543c, 0x1b51b363,
  0x39d5955a, 0x1b686ba3, 0x39cacd8d, 0x1b7f1fa9,
  0x39bffcd7, 0x1b95cf71, 0x39b52339, 0x1bac7af9,
  0x39aa40b4, 0x1bc3223c, 0x399f554b, 0x1bd9c537,
  0x399460ff, 0x1bf063e6, 0x398963d2, 0x1c06fe46,
  0x397e5dc6, 0x1c1d9454, 0x39734edc, 0x1c34260c,
  0x39683715, 0x1c4ab36b, 0x395d1675, 0x1c613c6d,
  0x3951ecfc, 0x1c77c10e, 0x3946baac, 0x1c8e414b,
  0x393b7f86, 0x1ca4bd21, 0x39303b8e, 0x1cbb348d,
  0x3924eec3, 0x1cd1a78a, 0x39199929, 0x1ce81615,
  0x390e3ac0, 0x1cfe802b, 0x3902d38b, 0x1d14e5c9,
  0x38f7638b, 0x1d2b46ea, 0x38ebeac2, 0x1d41a38c,
  0x38e06932, 0x1d57fbaa, 0x38d4dedd, 0x1d6e4f43,
  0x38c94bc4, 0x1d849e51, 0x38bdafea, 0x1d9ae8d2,
  0x38b20b4f, 0x1db12ec3, 0x38a65df6, 0x1dc7701f,
  0x389aa7e0, 0x1dddace4, 0x388ee910, 0x1df3e50d,
  0x38832187, 0x1e0a1898, 0x38775147, 0x1e204781,
  0x386b7852, 0x1e3671c5, 0x385f96a9, 0x1e4c9760,
  0x3853ac4f, 0x1e62b84f, 0x3847b946, 0x1e78d48e,
  0x383bbd8e, 0x1e8eec1b, 0x382fb92a, 0x1ea4fef0,
  0x3823ac1d, 0x1ebb0d0d, 0x38179666, 0x1ed1166b,
  0x380b780a, 0x1ee71b0a, 0x37ff5109, 0x1efd1ae4,
  0x37f32165, 0x1f1315f7, 0x37e6e921, 0x1f290c3f,
  0x37daa83d, 0x1f3efdb9, 0x37ce5ebd, 0x1f54ea62,
  0x37c20ca1, 0x1f6ad235, 0x37b5b1ec, 0x1f80b531,
  0x37a94ea0, 0x1f969350, 0x379ce2be, 0x1fac6c91,
  0x37906e49, 0x1fc240ef, 0x3783f143, 0x1fd81067,
  0x37776bac, 0x1feddaf6, 0x376add88, 0x2003a099,
  0x375e46d8, 0x2019614c, 0x3751a79e, 0x202f1d0b,
  0x3744ffdd, 0x2044d3d4, 0x37384f95, 0x205a85a3,
  0x372b96ca, 0x20703275, 0x371ed57c, 0x2085da46,
  0x37120bae, 0x209b7d13, 0x37053962, 0x20b11ad9,
  0x36f85e9a, 0x20c6b395, 0x36eb7b58, 0x20dc4742,
  0x36de8f9e, 0x20f1d5de, 0x36d19b6e, 0x21075f65,
  0x36c49ec9, 0x211ce3d5, 0x36b799b3, 0x21326329,
  0x36aa8c2c, 0x2147dd5f, 0x369d7637, 0x215d5273,
  0x369057d6, 0x2172c262, 0x3683310b, 0x21882d28,
  0x367601d7, 0x219d92c2, 0x3668ca3e, 0x21b2f32e,
  0x365b8a41, 0x21c84e67, 0x364e41e2, 0x21dda46a,
  0x3640f123, 0x21f2f534, 0x36339806, 0x220840c2,
  0x3626368d, 0x221d8711, 0x3618ccba, 0x2232c81c,
  0x360b5a90, 0x224803e2, 0x35fde011, 0x225d3a5e,
  0x35f05d3d, 0x22726b8e, 0x35e2d219, 0x2287976e,
  0x35d53ea5, 0x229cbdfa, 0x35c7a2e3, 0x22b1df30,
  0x35b9fed7, 0x22c6fb0c, 0x35ac5282, 0x22dc118c,
  0x359e9de5, 0x22f122ab, 0x3590e104, 0x23062e67,
  0x35831be0, 0x231b34bc, 0x35754e7c, 0x233035a7,
  0x356778d9, 0x23453125, 0x35599afa, 0x235a2733,
  0x354bb4e1, 0x236f17cc, 0x353dc68f, 0x238402ef,
  0x352fd008, 0x2398e898, 0x3521d14d, 0x23adc8c4,
  0x3513ca60, 0x23c2a36f, 0x3505bb44, 0x23d77896,
  0x34f7a3fb, 0x23ec4837, 0x34e98487, 0x2401124d,
  0x34db5cea, 0x2415d6d5, 0x34cd2d26, 0x242a95ce,
  0x34bef53d, 0x243f4f32, 0x34b0b533, 0x245402ff,
  0x34a26d08, 0x2468b132, 0x34941cbf, 0x247d59c8,
  0x3485c45b, 0x2491fcbe, 0x347763dd, 0x24a69a0f,
  0x3468fb47, 0x24bb31ba, 0x345a8a9d, 0x24cfc3ba,
  0x344c11e0, 0x24e4500e, 0x343d9112, 0x24f8d6b0,
  0x342f0836, 0x250d57a0, 0x3420774d, 0x2521d2d8,
  0x3411de5b, 0x25364857, 0x34033d61, 0x254ab818,
  0x33f49462, 0x255f2219, 0x33e5e360, 0x25738657,
  0x33d72a5d, 0x2587e4cf, 0x33c8695b, 0x259c3d7c,
  0x33b9a05d, 0x25b0905d, 0x33aacf65, 0x25c4dd6e,
  0x339bf675, 0x25d924ac, 0x338d1590, 0x25ed6614,
  0x337e2cb7, 0x2601a1a2, 0x336f3bee, 0x2615d754,
  0x33604336, 0x262a0727, 0x33514292, 0x263e3117,
  0x33423a04, 0x26525521, 0x3333298f, 0x26667342,
  0x33241134, 0x267a8b77, 0x3314f0f6, 0x268e9dbd,
  0x3305c8d7, 0x26a2aa11, 0x32f698db, 0x26b6b070,
  0x32e76102, 0x26cab0d6, 0x32d82150, 0x26deab41,
  0x32c8d9c6, 0x26f29fad, 0x32b98a67, 0x27068e18,
  0x32aa3336, 0x271a767e, 0x329ad435, 0x272e58dc,
  0x328b6d66, 0x27423530, 0x327bfecc, 0x27560b76,
  0x326c8868, 0x2769dbaa, 0x325d0a3e, 0x277da5cb,
  0x324d8450, 0x279169d5, 0x323df6a0, 0x27a527c4,
  0x322e6130, 0x27b8df97, 0x321ec403, 0x27cc9149,
  0x320f1f1c, 0x27e03cd8, 0x31ff727c, 0x27f3e241,
  0x31efbe27, 0x28078181, 0x31e0021e, 0x281b1a94,
  0x31d03e64, 0x282ead78, 0x31c072fb, 0x28423a2a,
  0x31b09fe7, 0x2855c0a6, 0x31a0c528, 0x286940ea,
  0x3190e2c3, 0x287cbaf3, 0x3180f8b8, 0x28902ebd,
  0x3171070c, 0x28a39c46, 0x31610dbf, 0x28b7038b,
  0x31510cd5, 0x28ca6488, 0x31410450, 0x28ddbf3b,
  0x3130f433, 0x28f113a0, 0x3120dc80, 0x290461b5,
  0x3110bd39, 0x2917a977, 0x31009661, 0x292aeae3,
  0x30f067fb, 0x293e25f5, 0x30e03208, 0x29515aab,
  0x30cff48c, 0x29648902, 0x30bfaf89, 0x2977b0f7,
  0x30af6302, 0x298ad287, 0x309f0ef8, 0x299dedaf,
  0x308eb36f, 0x29b1026c, 0x307e5069, 0x29c410ba,
  0x306de5e9, 0x29d71899, 0x305d73f0, 0x29ea1a03,
  0x304cfa83, 0x29fd14f6, 0x303c79a2, 0x2a100970,
  0x302bf151, 0x2a22f76e, 0x301b6193, 0x2a35deeb,
  0x300aca69, 0x2a48bfe7, 0x2ffa2bd6, 0x2a5b9a5d,
  0x2fe985de, 0x2a6e6e4b, 0x2fd8d882, 0x2a813bae,
  0x2fc823c5, 0x2a940283, 0x2fb767aa, 0x2aa6c2c6,
  0x2fa6a433, 0x2ab97c77, 0x2f95d963, 0x2acc2f90,
  0x2f85073c, 0x2adedc10, 0x2f742dc1, 0x2af181f3,
  0x2f634cf5, 0x2b042137, 0x2f5264da, 0x2b16b9d9,
  0x2f417573, 0x2b294bd5, 0x2f307ec2, 0x2b3bd72a,
  0x2f1f80ca, 0x2b4e5bd4, 0x2f0e7b8e, 0x2b60d9d0,
  0x2efd6f10, 0x2b73511c, 0x2eec5b53, 0x2b85c1b5,
  0x2edb405a, 0x2b982b97, 0x2eca1e27, 0x2baa8ec0,
  0x2eb8f4bc, 0x2bbceb2d, 0x2ea7c41e, 0x2bcf40dc,
  0x2e968c4d, 0x2be18fc9, 0x2e854d4d, 0x2bf3d7f2,
  0x2e740720, 0x2c061953, 0x2e62b9ca, 0x2c1853eb,
  0x2e51654c, 0x2c2a87b6, 0x2e4009aa, 0x2c3cb4b1,
  0x2e2ea6e6, 0x2c4edada, 0x2e1d3d03, 0x2c60fa2d,
  0x2e0bcc03, 0x2c7312a9, 0x2dfa53e9, 0x2c85244a,
  0x2de8d4b8, 0x2c972f0d, 0x2dd74e73, 0x2ca932ef,
  0x2dc5c11c, 0x2cbb2fef, 0x2db42cb6, 0x2ccd2609,
  0x2da29144, 0x2cdf153a, 0x2d90eec8, 0x2cf0fd80,
  0x2d7f4545, 0x2d02ded7, 0x2d6d94bf, 0x2d14b93d,
  0x2d5bdd36, 0x2d268cb0, 0x2d4a1eaf, 0x2d38592c,
  0x1ffff621, 0xffe6de07, 0x1fffa72d, 0xffb49a54,
  0x1fff0944, 0xff82575a, 0x1ffe1c68, 0xff501597,
  0x1ffce09d, 0xff1dd586, 0x1ffb55e4, 0xfeeb97a2,
  0x1ff97c42, 0xfeb95c69, 0x1ff753bb, 0xfe872456,
  0x1ff4dc55, 0xfe54efe4, 0x1ff21615, 0xfe22bf90,
  0x1fef0103, 0xfdf093d6, 0x1feb9d25, 0xfdbe6d31,
  0x1fe7ea85, 0xfd8c4c1e, 0x1fe3e92c, 0xfd5a3117,
  0x1fdf9923, 0xfd281c98, 0x1fdafa75, 0xfcf60f1e,
  0x1fd60d2e, 0xfcc40923, 0x1fd0d159, 0xfc920b22,
  0x1fcb4704, 0xfc601599, 0x1fc56e3b, 0xfc2e2900,
  0x1fbf470f, 0xfbfc45d5, 0x1fb8d18d, 0xfbca6c91,
  0x1fb20dc7, 0xfb989db0, 0x1faafbcb, 0xfb66d9ad,
  0x1fa39bac, 0xfb352102, 0x1f9bed7d, 0xfb03742a,
  0x1f93f150, 0xfad1d3a0, 0x1f8ba738, 0xfaa03fde,
  0x1f830f4a, 0xfa6eb95f, 0x1f7a299c, 0xfa3d409d,
  0x1f70f643, 0xfa0bd611, 0x1f677557, 0xf9da7a36,
  0x1f5da6ed, 0xf9a92d86, 0x1f538b20, 0xf977f079,
  0x1f492207, 0xf946c38b, 0x1f3e6bbc, 0xf915a733,
  0x1f33685a, 0xf8e49beb, 0x1f2817fc, 0xf8b3a22d,
  0x1f1c7abe, 0xf882ba70, 0x1f1090bd, 0xf851e52e,
  0x1f045a15, 0xf82122e0, 0x1ef7d6e5, 0xf7f073fd,
  0x1eeb074c, 0xf7bfd8fd, 0x1eddeb6a, 0xf78f5259,
  0x1ed0835f, 0xf75ee088, 0x1ec2cf4b, 0xf72e8402,
  0x1eb4cf51, 0xf6fe3d3e, 0x1ea68394, 0xf6ce0cb3,
  0x1e97ec36, 0xf69df2d9, 0x1e89095c, 0xf66df025,
  0x1e79db2a, 0xf63e050e, 0x1e6a61c5, 0xf60e320b,
  0x1e5a9d55, 0xf5de7792, 0x1e4a8e00, 0xf5aed617,
  0x1e3a33ec, 0xf57f4e12, 0x1e298f44, 0xf54fdff7,
  0x1e18a030, 0xf5208c3a, 0x1e0766d9, 0xf4f15352,
  0x1df5e36b, 0xf4c235b2, 0x1de4160f, 0xf49333ce,
  0x1dd1fef4, 0xf4644e1b, 0x1dbf9e44, 0xf435850d,
  0x1dacf42d, 0xf406d916, 0x1d9a00de, 0xf3d84aab,
  0x1d86c484, 0xf3a9da3d, 0x1d733f51, 0xf37b883f,
  0x1d5f7173, 0xf34d5524, 0x1d4b5b1b, 0xf31f415e,
  0x1d36fc7c, 0xf2f14d5e, 0x1d2255c7, 0xf2c37996,
  0x1d0d672f, 0xf295c677, 0x1cf830e9, 0xf2683471,
  0x1ce2b328, 0xf23ac3f6, 0x1cccee21, 0xf20d7574,
  0x1cb6e20a, 0xf1e0495c, 0x1ca08f1a, 0xf1b3401e,
  0x1c89f587, 0xf1865a29, 0x1c73158a, 0xf15997ea,
  0x1c5bef5a, 0xf12cf9d2, 0x1c448331, 0xf100804d,
  0x1c2cd149, 0xf0d42bc9, 0x1c14d9dc, 0xf0a7fcb5,
  0x1bfc9d26, 0xf07bf37d, 0x1be41b61, 0xf050108d,
  0x1bcb54cb, 0xf0245452, 0x1bb249a1, 0xeff8bf38,
  0x1b98fa20, 0xefcd51aa, 0x1b7f6687, 0xefa20c14,
  0x1b658f15, 0xef76eee0, 0x1b4b740a, 0xef4bfa78,
  0x1b3115a6, 0xef212f48, 0x1b16742a, 0xeef68db7,
  0x1afb8fd9, 0xeecc1630, 0x1ae068f3, 0xeea1c91b,
  0x1ac4ffbd, 0xee77a6e1, 0x1aa9547a, 0xee4dafe9,
  0x1a8d676e, 0xee23e49b, 0x1a7138df, 0xedfa455f,
  0x1a54c911, 0xedd0d29a, 0x1a38184a, 0xeda78cb3,
  0x1a1b26d3, 0xed7e7411, 0x19fdf4f1, 0xed558918,
  0x19e082ee, 0xed2ccc2d, 0x19c2d111, 0xed043db5,
  0x19a4dfa4, 0xecdbde14, 0x1986aef1, 0xecb3adad,
  0x19683f43, 0xec8bace4, 0x194990e4, 0xec63dc1c,
  0x192aa420, 0xec3c3bb6, 0x190b7943, 0xec14cc15,
  0x18ec109b, 0xebed8d9a, 0x18cc6a75, 0xebc680a5,
  0x18ac871f, 0xeb9fa597, 0x188c66e7, 0xeb78fcd0,
  0x186c0a1e, 0xeb5286af, 0x184b7112, 0xeb2c4393,
  0x182a9c14, 0xeb0633da, 0x18098b75, 0xeae057e3,
  0x17e83f88, 0xeabab00b, 0x17c6b89d, 0xea953cae,
  0x17a4f708, 0xea6ffe2a, 0x1782fb1c, 0xea4af4da,
  0x1760c52c, 0xea262119, 0x173e558e, 0xea018342,
  0x171bac96, 0xe9dd1bb0, 0x16f8ca9a, 0xe9b8eabd,
  0x16d5afef, 0xe994f0c1, 0x16b25ced, 0xe9712e15,
  0x168ed1eb, 0xe94da313, 0x166b0f3f, 0xe92a5011,
  0x16471543, 0xe9073566, 0x1622e450, 0xe8e4536a,
  0x15fe7cbe, 0xe8c1aa72, 0x15d9dee7, 0xe89f3ad4,
  0x15b50b26, 0xe87d04e4, 0x159001d6, 0xe85b08f8,
  0x156ac352, 0xe8394763, 0x15454ff5, 0xe817c078,
  0x151fa81d, 0xe7f6748b, 0x14f9cc26, 0xe7d563ec,
  0x14d3bc6d, 0xe7b48eee, 0x14ad7951, 0xe793f5e2,
  0x14870330, 0xe7739919, 0x14605a69, 0xe75378e1,
  0x14397f5b, 0xe733958b, 0x14127266, 0xe713ef65,
  0x13eb33eb, 0xe6f486bd, 0x13c3c44a, 0xe6d55be0,
  0x139c23e4, 0xe6b66f1c, 0x1374531c, 0xe697c0bd,
  0x134c5253, 0xe679510f, 0x132421ec, 0xe65b205c,
  0x12fbc24b, 0xe63d2eef, 0x12d333d3, 0xe61f7d12,
  0x12aa76e8, 0xe6020b0f, 0x12818bef, 0xe5e4d92d,
  0x1258734d, 0xe5c7e7b6, 0x122f2d66, 0xe5ab36ef,
  0x1205baa1, 0xe58ec721, 0x11dc1b65, 0xe5729892,
  0x11b25017, 0xe556ab86, 0x1188591f, 0xe53b0043,
  0x115e36e5, 0xe51f970d, 0x1133e9d0, 0xe5047027,
  0x11097249, 0xe4e98bd6, 0x10ded0b8, 0xe4ceea5a,
  0x10b40588, 0xe4b48bf6, 0x10891120, 0xe49a70eb,
  0x105df3ec, 0xe4809979, 0x1032ae56, 0xe46705e0,
  0x100740c8, 0xe44db65f, 0x0fdbabae, 0xe434ab35,
  0x0fafef73, 0xe41be49f, 0x0f840c83, 0xe40362da,
  0x0f58034b, 0xe3eb2624, 0x0f2bd437, 0xe3d32eb7,
  0x0eff7fb3, 0xe3bb7ccf, 0x0ed3062e, 0xe3a410a6,
  0x0ea66816, 0xe38cea76, 0x0e79a5d7, 0xe3760a79,
  0x0e4cbfe2, 0xe35f70e6, 0x0e1fb6a4, 0xe3491df6,
  0x0df28a8c, 0xe33311df, 0x0dc53c0a, 0xe31d4cd8,
  0x0d97cb8f, 0xe307cf17, 0x0d6a3989, 0xe2f298d1,
  0x0d3c866a, 0xe2ddaa39, 0x0d0eb2a2, 0xe2c90384,
  0x0ce0bea2, 0xe2b4a4e5, 0x0cb2aadc, 0xe2a08e8d,
  0x0c8477c1, 0xe28cc0af, 0x0c5625c3, 0xe2793b7c,
  0x0c27b555, 0xe265ff22, 0x0bf926ea, 0xe2530bd3,
  0x0bca7af3, 0xe24061bc, 0x0b9bb1e5, 0xe22e010c,
  0x0b6ccc32, 0xe21be9f1, 0x0b3dca4e, 0xe20a1c95,
  0x0b0eacae, 0xe1f89927, 0x0adf73c6, 0xe1e75fd0,
  0x0ab02009, 0xe1d670bc, 0x0a80b1ee, 0xe1c5cc14,
  0x0a5129e9, 0xe1b57200, 0x0a21886e, 0xe1a562ab,
  0x09f1cdf5, 0xe1959e3b, 0x09c1faf2, 0xe18624d6,
  0x09920fdb, 0xe176f6a4, 0x09620d27, 0xe16813ca,
  0x0931f34d, 0xe1597c6c, 0x0901c2c2, 0xe14b30af,
  0x08d17bfe, 0xe13d30b5, 0x08a11f78, 0xe12f7ca1,
  0x0870ada7, 0xe1221496, 0x08402703, 0xe114f8b4,
  0x080f8c03, 0xe108291b, 0x07dedd20, 0xe0fba5eb,
  0x07ae1ad2, 0xe0ef6f43, 0x077d4590, 0xe0e38542,
  0x074c5dd3, 0xe0d7e804, 0x071b6415, 0xe0cc97a6,
  0x06ea58cd, 0xe0c19444, 0x06b93c75, 0xe0b6ddf9,
  0x06880f87, 0xe0ac74e0, 0x0656d27a, 0xe0a25913,
  0x062585ca, 0xe0988aa9, 0x05f429ef, 0xe08f09bd,
  0x05c2bf63, 0xe085d664, 0x059146a1, 0xe07cf0b6,
  0x055fc022, 0xe07458c8, 0x052e2c60, 0xe06c0eb0,
  0x04fc8bd6, 0xe0641283, 0x04cadefe, 0xe05c6454,
  0x04992653, 0xe0550435, 0x04676250, 0xe04df239,
  0x0435936f, 0xe0472e73, 0x0403ba2b, 0xe040b8f1,
  0x03d1d700, 0xe03a91c5, 0x039fea67, 0xe034b8fc,
  0x036df4de, 0xe02f2ea7, 0x033bf6dd, 0xe029f2d2,
  0x0309f0e2, 0xe025058b, 0x02d7e368, 0xe02066dd,
  0x02a5cee9, 0xe01c16d4, 0x0273b3e2, 0xe018157b,
  0x024192cf, 0xe01462db, 0x020f6c2a, 0xe010fefd,
  0x01dd4070, 0xe00de9eb, 0x01ab101c, 0xe00b23ab,
  0x0178dbaa, 0xe008ac45, 0x0146a397, 0xe00683be,
  0x0114685e, 0xe004aa1c, 0x00e22a7a, 0xe0031f63,
  0x00afea69, 0xe001e398, 0x007da8a6, 0xe000f6bc,
  0x004b65ac, 0xe00058d3, 0x001921f9, 0xe00009df,
};

static ogg_int16_t bitrevlook_2048[512]={
  0x03fe, 0x0000, 0x01fe, 0x0200,
  0x02fe, 0x0100, 0x00fe, 0x0300,
  0x037e, 0x0080, 0x017e, 0x0280,
  0x027e, 0x0180, 0x007e, 0x0380,
  0x03be, 0x0040, 0x01be, 0x0240,
  0x02be, 0x0140, 0x00be, 0x0340,
  0x033e, 0x00c0, 0x013e, 0x02c0,
  0x023e, 0x01c0, 0x003e, 0x03c0,
  0x03de, 0x0020, 0x01de, 0x0220,
  0x02de, 0x0120, 0x00de, 0x0320,
  0x035e, 0x00a0, 0x015e, 0x02a0,
  0x025e, 0x01a0, 0x005e, 0x03a0,
  0x039e, 0x0060, 0x019e, 0x0260,
  0x029e, 0x0160, 0x009e, 0x0360,
  0x031e, 0x00e0, 0x011e, 0x02e0,
  0x021e, 0x01e0, 0x001e, 0x03e0,
  0x03ee, 0x0010, 0x01ee, 0x0210,
  0x02ee, 0x0110, 0x00ee, 0x0310,
  0x036e, 0x0090, 0x016e, 0x0290,
  0x026e, 0x0190, 0x006e, 0x0390,
  0x03ae, 0x0050, 0x01ae, 0x0250,
  0x02ae, 0x0150, 0x00ae, 0x0350,
  0x032e, 0x00d0, 0x012e, 0x02d0,
  0x022e, 0x01d0, 0x002e, 0x03d0,
  0x03ce, 0x0030, 0x01ce, 0x0230,
  0x02ce, 0x0130, 0x00ce, 0x0330,
  0x034e, 0x00b0, 0x014e, 0x02b0,
  0x024e, 0x01b0, 0x004e, 0x03b0,
  0x038e, 0x0070, 0x018e, 0x0270,
  0x028e, 0x0170, 0x008e, 0x0370,
  0x030e, 0x00f0, 0x010e, 0x02f0,
  0x020e, 0x01f0, 0x000e, 0x03f0,
  0x03f6, 0x0008, 0x01f6, 0x0208,
  0x02f6, 0x0108, 0x00f6, 0x0308,
  0x0376, 0x0088, 0x0176, 0x0288,
  0x0276, 0x0188, 0x0076, 0x0388,
  0x03b6, 0x0048, 0x01b6, 0x0248,
  0x02b6, 0x0148, 0x00b6, 0x0348,
  0x0336, 0x00c8, 0x0136, 0x02c8,
  0x0236, 0x01c8, 0x0036, 0x03c8,
  0x03d6, 0x0028, 0x01d6, 0x0228,
  0x02d6, 0x0128, 0x00d6, 0x0328,
  0x0356, 0x00a8, 0x0156, 0x02a8,
  0x0256, 0x01a8, 0x0056, 0x03a8,
  0x0396, 0x0068, 0x0196, 0x0268,
  0x0296, 0x0168, 0x0096, 0x0368,
  0x0316, 0x00e8, 0x0116, 0x02e8,
  0x0216, 0x01e8, 0x0016, 0x03e8,
  0x03e6, 0x0018, 0x01e6, 0x0218,
  0x02e6, 0x0118, 0x00e6, 0x0318,
  0x0366, 0x0098, 0x0166, 0x0298,
  0x0266, 0x0198, 0x0066, 0x0398,
  0x03a6, 0x0058, 0x01a6, 0x0258,
  0x02a6, 0x0158, 0x00a6, 0x0358,
  0x0326, 0x00d8, 0x0126, 0x02d8,
  0x0226, 0x01d8, 0x0026, 0x03d8,
  0x03c6, 0x0038, 0x01c6, 0x0238,
  0x02c6, 0x0138, 0x00c6, 0x0338,
  0x0346, 0x00b8, 0x0146, 0x02b8,
  0x0246, 0x01b8, 0x0046, 0x03b8,
  0x0386, 0x0078, 0x0186, 0x0278,
  0x0286, 0x0178, 0x0086, 0x0378,
  0x0306, 0x00f8, 0x0106, 0x02f8,
  0x0206, 0x01f8, 0x0006, 0x03f8,
  0x03fa, 0x0004, 0x01fa, 0x0204,
  0x02fa, 0x0104, 0x00fa, 0x0304,
  0x037a, 0x0084, 0x017a, 0x0284,
  0x027a, 0x0184, 0x007a, 0x0384,
  0x03ba, 0x0044, 0x01ba, 0x0244,
  0x02ba, 0x0144, 0x00ba, 0x0344,
  0x033a, 0x00c4, 0x013a, 0x02c4,
  0x023a, 0x01c4, 0x003a, 0x03c4,
  0x03da, 0x0024, 0x01da, 0x0224,
  0x02da, 0x0124, 0x00da, 0x0324,
  0x035a, 0x00a4, 0x015a, 0x02a4,
  0x025a, 0x01a4, 0x005a, 0x03a4,
  0x039a, 0x0064, 0x019a, 0x0264,
  0x029a, 0x0164, 0x009a, 0x0364,
  0x031a, 0x00e4, 0x011a, 0x02e4,
  0x021a, 0x01e4, 0x001a, 0x03e4,
  0x03ea, 0x0014, 0x01ea, 0x0214,
  0x02ea, 0x0114, 0x00ea, 0x0314,
  0x036a, 0x0094, 0x016a, 0x0294,
  0x026a, 0x0194, 0x006a, 0x0394,
  0x03aa, 0x0054, 0x01aa, 0x0254,
  0x02aa, 0x0154, 0x00aa, 0x0354,
  0x032a, 0x00d4, 0x012a, 0x02d4,
  0x022a, 0x01d4, 0x002a, 0x03d4,
  0x03ca, 0x0034, 0x01ca, 0x0234,
  0x02ca, 0x0134, 0x00ca, 0x0334,
  0x034a, 0x00b4, 0x014a, 0x02b4,
  0x024a, 0x01b4, 0x004a, 0x03b4,
  0x038a, 0x0074, 0x018a, 0x0274,
  0x028a, 0x0174, 0x008a, 0x0374,
  0x030a, 0x00f4, 0x010a, 0x02f4,
  0x020a, 0x01f4, 0x000a, 0x03f4,
  0x03f2, 0x000c, 0x01f2, 0x020c,
  0x02f2, 0x010c, 0x00f2, 0x030c,
  0x0372, 0x008c, 0x0172, 0x028c,
  0x0272, 0x018c, 0x0072, 0x038c,
  0x03b2, 0x004c, 0x01b2, 0x024c,
  0x02b2, 0x014c, 0x00b2, 0x034c,
  0x0332, 0x00cc, 0x0132, 0x02cc,
  0x0232, 0x01cc, 0x0032, 0x03cc,
  0x03d2, 0x002c, 0x01d2, 0x022c,
  0x02d2, 0x012c, 0x00d2, 0x032c,
  0x0352, 0x00ac, 0x0152, 0x02ac,
  0x0252, 0x01ac, 0x0052, 0x03ac,
  0x0392, 0x006c, 0x0192, 0x026c,
  0x0292, 0x016c, 0x0092, 0x036c,
  0x0312, 0x00ec, 0x0112, 0x02ec,
  0x0212, 0x01ec, 0x0012, 0x03ec,
  0x03e2, 0x001c, 0x01e2, 0x021c,
  0x02e2, 0x011c, 0x00e2, 0x031c,
  0x0362, 0x009c, 0x0162, 0x029c,
  0x0262, 0x019c, 0x0062, 0x039c,
  0x03a2, 0x005c, 0x01a2, 0x025c,
  0x02a2, 0x015c, 0x00a2, 0x035c,
  0x0322, 0x00dc, 0x0122, 0x02dc,
  0x0222, 0x01dc, 0x0022, 0x03dc,
  0x03c2, 0x003c, 0x01c2, 0x023c,
  0x02c2, 0x013c, 0x00c2, 0x033c,
  0x0342, 0x00bc, 0x0142, 0x02bc,
  0x0242, 0x01bc, 0x0042, 0x03bc,
  0x0382, 0x007c, 0x0182, 0x027c,
  0x0282, 0x017c, 0x0082, 0x037c,
  0x0302, 0x00fc, 0x0102, 0x02fc,
  0x0202, 0x01fc, 0x0002, 0x03fc,
};

static ogg_int32_t triglook_4096[5120]={
  0x40000000, 0x00000000, 0x3fffec43, 0xffcdbc0f,
  0x3fffb10b, 0xff9b783c, 0x3fff4e59, 0xff6934a8,
  0x3ffec42d, 0xff36f170, 0x3ffe1288, 0xff04aeb5,
  0x3ffd3969, 0xfed26c94, 0x3ffc38d1, 0xfea02b2e,
  0x3ffb10c1, 0xfe6deaa1, 0x3ff9c13a, 0xfe3bab0b,
  0x3ff84a3c, 0xfe096c8d, 0x3ff6abc8, 0xfdd72f45,
  0x3ff4e5e0, 0xfda4f351, 0x3ff2f884, 0xfd72b8d2,
  0x3ff0e3b6, 0xfd407fe6, 0x3feea776, 0xfd0e48ab,
  0x3fec43c7, 0xfcdc1342, 0x3fe9b8a9, 0xfca9dfc8,
  0x3fe7061f, 0xfc77ae5e, 0x3fe42c2a, 0xfc457f21,
  0x3fe12acb, 0xfc135231, 0x3fde0205, 0xfbe127ac,
  0x3fdab1d9, 0xfbaeffb3, 0x3fd73a4a, 0xfb7cda63,
  0x3fd39b5a, 0xfb4ab7db, 0x3fcfd50b, 0xfb18983b,
  0x3fcbe75e, 0xfae67ba2, 0x3fc7d258, 0xfab4622d,
  0x3fc395f9, 0xfa824bfd, 0x3fbf3246, 0xfa503930,
  0x3fbaa740, 0xfa1e29e5, 0x3fb5f4ea, 0xf9ec1e3b,
  0x3fb11b48, 0xf9ba1651, 0x3fac1a5b, 0xf9881245,
  0x3fa6f228, 0xf9561237, 0x3fa1a2b2, 0xf9241645,
  0x3f9c2bfb, 0xf8f21e8e, 0x3f968e07, 0xf8c02b31,
  0x3f90c8da, 0xf88e3c4d, 0x3f8adc77, 0xf85c5201,
  0x3f84c8e2, 0xf82a6c6a, 0x3f7e8e1e, 0xf7f88ba9,
  0x3f782c30, 0xf7c6afdc, 0x3f71a31b, 0xf794d922,
  0x3f6af2e3, 0xf7630799, 0x3f641b8d, 0xf7313b60,
  0x3f5d1d1d, 0xf6ff7496, 0x3f55f796, 0xf6cdb359,
  0x3f4eaafe, 0xf69bf7c9, 0x3f473759, 0xf66a4203,
  0x3f3f9cab, 0xf6389228, 0x3f37dafa, 0xf606e854,
  0x3f2ff24a, 0xf5d544a7, 0x3f27e29f, 0xf5a3a740,
  0x3f1fabff, 0xf572103d, 0x3f174e70, 0xf5407fbd,
  0x3f0ec9f5, 0xf50ef5de, 0x3f061e95, 0xf4dd72be,
  0x3efd4c54, 0xf4abf67e, 0x3ef45338, 0xf47a8139,
  0x3eeb3347, 0xf4491311, 0x3ee1ec87, 0xf417ac22,
  0x3ed87efc, 0xf3e64c8c, 0x3eceeaad, 0xf3b4f46c,
  0x3ec52fa0, 0xf383a3e2, 0x3ebb4ddb, 0xf3525b0b,
  0x3eb14563, 0xf3211a07, 0x3ea7163f, 0xf2efe0f2,
  0x3e9cc076, 0xf2beafed, 0x3e92440d, 0xf28d8715,
  0x3e87a10c, 0xf25c6688, 0x3e7cd778, 0xf22b4e66,
  0x3e71e759, 0xf1fa3ecb, 0x3e66d0b4, 0xf1c937d6,
  0x3e5b9392, 0xf19839a6, 0x3e502ff9, 0xf1674459,
  0x3e44a5ef, 0xf136580d, 0x3e38f57c, 0xf10574e0,
  0x3e2d1ea8, 0xf0d49af1, 0x3e212179, 0xf0a3ca5d,
  0x3e14fdf7, 0xf0730342, 0x3e08b42a, 0xf04245c0,
  0x3dfc4418, 0xf01191f3, 0x3defadca, 0xefe0e7f9,
  0x3de2f148, 0xefb047f2, 0x3dd60e99, 0xef7fb1fa,
  0x3dc905c5, 0xef4f2630, 0x3dbbd6d4, 0xef1ea4b2,
  0x3dae81cf, 0xeeee2d9d, 0x3da106bd, 0xeebdc110,
  0x3d9365a8, 0xee8d5f29, 0x3d859e96, 0xee5d0804,
  0x3d77b192, 0xee2cbbc1, 0x3d699ea3, 0xedfc7a7c,
  0x3d5b65d2, 0xedcc4454, 0x3d4d0728, 0xed9c1967,
  0x3d3e82ae, 0xed6bf9d1, 0x3d2fd86c, 0xed3be5b1,
  0x3d21086c, 0xed0bdd25, 0x3d1212b7, 0xecdbe04a,
  0x3d02f757, 0xecabef3d, 0x3cf3b653, 0xec7c0a1d,
  0x3ce44fb7, 0xec4c3106, 0x3cd4c38b, 0xec1c6417,
  0x3cc511d9, 0xebeca36c, 0x3cb53aaa, 0xebbcef23,
  0x3ca53e09, 0xeb8d475b, 0x3c951bff, 0xeb5dac2f,
  0x3c84d496, 0xeb2e1dbe, 0x3c7467d9, 0xeafe9c24,
  0x3c63d5d1, 0xeacf277f, 0x3c531e88, 0xea9fbfed,
  0x3c42420a, 0xea70658a, 0x3c314060, 0xea411874,
  0x3c201994, 0xea11d8c8, 0x3c0ecdb2, 0xe9e2a6a3,
  0x3bfd5cc4, 0xe9b38223, 0x3bebc6d5, 0xe9846b63,
  0x3bda0bf0, 0xe9556282, 0x3bc82c1f, 0xe926679c,
  0x3bb6276e, 0xe8f77acf, 0x3ba3fde7, 0xe8c89c37,
  0x3b91af97, 0xe899cbf1, 0x3b7f3c87, 0xe86b0a1a,
  0x3b6ca4c4, 0xe83c56cf, 0x3b59e85a, 0xe80db22d,
  0x3b470753, 0xe7df1c50, 0x3b3401bb, 0xe7b09555,
  0x3b20d79e, 0xe7821d59, 0x3b0d8909, 0xe753b479,
  0x3afa1605, 0xe7255ad1, 0x3ae67ea1, 0xe6f7107e,
  0x3ad2c2e8, 0xe6c8d59c, 0x3abee2e5, 0xe69aaa48,
  0x3aaadea6, 0xe66c8e9f, 0x3a96b636, 0xe63e82bc,
  0x3a8269a3, 0xe61086bc, 0x3a6df8f8, 0xe5e29abc,
  0x3a596442, 0xe5b4bed8, 0x3a44ab8e, 0xe586f32c,
  0x3a2fcee8, 0xe55937d5, 0x3a1ace5f, 0xe52b8cee,
  0x3a05a9fd, 0xe4fdf294, 0x39f061d2, 0xe4d068e2,
  0x39daf5e8, 0xe4a2eff6, 0x39c5664f, 0xe47587eb,
  0x39afb313, 0xe44830dd, 0x3999dc42, 0xe41aeae8,
  0x3983e1e8, 0xe3edb628, 0x396dc414, 0xe3c092b9,
  0x395782d3, 0xe39380b6, 0x39411e33, 0xe366803c,
  0x392a9642, 0xe3399167, 0x3913eb0e, 0xe30cb451,
  0x38fd1ca4, 0xe2dfe917, 0x38e62b13, 0xe2b32fd4,
  0x38cf1669, 0xe28688a4, 0x38b7deb4, 0xe259f3a3,
  0x38a08402, 0xe22d70eb, 0x38890663, 0xe2010099,
  0x387165e3, 0xe1d4a2c8, 0x3859a292, 0xe1a85793,
  0x3841bc7f, 0xe17c1f15, 0x3829b3b9, 0xe14ff96a,
  0x3811884d, 0xe123e6ad, 0x37f93a4b, 0xe0f7e6f9,
  0x37e0c9c3, 0xe0cbfa6a, 0x37c836c2, 0xe0a0211a,
  0x37af8159, 0xe0745b24, 0x3796a996, 0xe048a8a4,
  0x377daf89, 0xe01d09b4, 0x37649341, 0xdff17e70,
  0x374b54ce, 0xdfc606f1, 0x3731f440, 0xdf9aa354,
  0x371871a5, 0xdf6f53b3, 0x36fecd0e, 0xdf441828,
  0x36e5068a, 0xdf18f0ce, 0x36cb1e2a, 0xdeedddc0,
  0x36b113fd, 0xdec2df18, 0x3696e814, 0xde97f4f1,
  0x367c9a7e, 0xde6d1f65, 0x36622b4c, 0xde425e8f,
  0x36479a8e, 0xde17b28a, 0x362ce855, 0xdded1b6e,
  0x361214b0, 0xddc29958, 0x35f71fb1, 0xdd982c60,
  0x35dc0968, 0xdd6dd4a2, 0x35c0d1e7, 0xdd439236,
  0x35a5793c, 0xdd196538, 0x3589ff7a, 0xdcef4dc2,
  0x356e64b2, 0xdcc54bec, 0x3552a8f4, 0xdc9b5fd2,
  0x3536cc52, 0xdc71898d, 0x351acedd, 0xdc47c936,
  0x34feb0a5, 0xdc1e1ee9, 0x34e271bd, 0xdbf48abd,
  0x34c61236, 0xdbcb0cce, 0x34a99221, 0xdba1a534,
  0x348cf190, 0xdb785409, 0x34703095, 0xdb4f1967,
  0x34534f41, 0xdb25f566, 0x34364da6, 0xdafce821,
  0x34192bd5, 0xdad3f1b1, 0x33fbe9e2, 0xdaab122f,
  0x33de87de, 0xda8249b4, 0x33c105db, 0xda599859,
  0x33a363ec, 0xda30fe38, 0x3385a222, 0xda087b69,
  0x3367c090, 0xd9e01006, 0x3349bf48, 0xd9b7bc27,
  0x332b9e5e, 0xd98f7fe6, 0x330d5de3, 0xd9675b5a,
  0x32eefdea, 0xd93f4e9e, 0x32d07e85, 0xd91759c9,
  0x32b1dfc9, 0xd8ef7cf4, 0x329321c7, 0xd8c7b838,
  0x32744493, 0xd8a00bae, 0x32554840, 0xd878776d,
  0x32362ce0, 0xd850fb8e, 0x3216f287, 0xd829982b,
  0x31f79948, 0xd8024d59, 0x31d82137, 0xd7db1b34,
  0x31b88a66, 0xd7b401d1, 0x3198d4ea, 0xd78d014a,
  0x317900d6, 0xd76619b6, 0x31590e3e, 0xd73f4b2e,
  0x3138fd35, 0xd71895c9, 0x3118cdcf, 0xd6f1f99f,
  0x30f8801f, 0xd6cb76c9, 0x30d8143b, 0xd6a50d5d,
  0x30b78a36, 0xd67ebd74, 0x3096e223, 0xd6588725,
  0x30761c18, 0xd6326a88, 0x30553828, 0xd60c67b4,
  0x30343667, 0xd5e67ec1, 0x301316eb, 0xd5c0afc6,
  0x2ff1d9c7, 0xd59afadb, 0x2fd07f0f, 0xd5756016,
  0x2faf06da, 0xd54fdf8f, 0x2f8d713a, 0xd52a795d,
  0x2f6bbe45, 0xd5052d97, 0x2f49ee0f, 0xd4dffc54,
  0x2f2800af, 0xd4bae5ab, 0x2f05f637, 0xd495e9b3,
  0x2ee3cebe, 0xd4710883, 0x2ec18a58, 0xd44c4232,
  0x2e9f291b, 0xd42796d5, 0x2e7cab1c, 0xd4030684,
  0x2e5a1070, 0xd3de9156, 0x2e37592c, 0xd3ba3760,
  0x2e148566, 0xd395f8ba, 0x2df19534, 0xd371d579,
  0x2dce88aa, 0xd34dcdb4, 0x2dab5fdf, 0xd329e181,
  0x2d881ae8, 0xd30610f7, 0x2d64b9da, 0xd2e25c2b,
  0x2d413ccd, 0xd2bec333, 0x2d1da3d5, 0xd29b4626,
  0x2cf9ef09, 0xd277e518, 0x2cd61e7f, 0xd254a021,
  0x2cb2324c, 0xd2317756, 0x2c8e2a87, 0xd20e6acc,
  0x2c6a0746, 0xd1eb7a9a, 0x2c45c8a0, 0xd1c8a6d4,
  0x2c216eaa, 0xd1a5ef90, 0x2bfcf97c, 0xd18354e4,
  0x2bd8692b, 0xd160d6e5, 0x2bb3bdce, 0xd13e75a8,
  0x2b8ef77d, 0xd11c3142, 0x2b6a164d, 0xd0fa09c9,
  0x2b451a55, 0xd0d7ff51, 0x2b2003ac, 0xd0b611f1,
  0x2afad269, 0xd09441bb, 0x2ad586a3, 0xd0728ec6,
  0x2ab02071, 0xd050f926, 0x2a8a9fea, 0xd02f80f1,
  0x2a650525, 0xd00e2639, 0x2a3f503a, 0xcfece915,
  0x2a19813f, 0xcfcbc999, 0x29f3984c, 0xcfaac7d8,
  0x29cd9578, 0xcf89e3e8, 0x29a778db, 0xcf691ddd,
  0x2981428c, 0xcf4875ca, 0x295af2a3, 0xcf27ebc5,
  0x29348937, 0xcf077fe1, 0x290e0661, 0xcee73231,
  0x28e76a37, 0xcec702cb, 0x28c0b4d2, 0xcea6f1c2,
  0x2899e64a, 0xce86ff2a, 0x2872feb6, 0xce672b16,
  0x284bfe2f, 0xce47759a, 0x2824e4cc, 0xce27dec9,
  0x27fdb2a7, 0xce0866b8, 0x27d667d5, 0xcde90d79,
  0x27af0472, 0xcdc9d320, 0x27878893, 0xcdaab7c0,
  0x275ff452, 0xcd8bbb6d, 0x273847c8, 0xcd6cde39,
  0x2710830c, 0xcd4e2037, 0x26e8a637, 0xcd2f817b,
  0x26c0b162, 0xcd110216, 0x2698a4a6, 0xccf2a21d,
  0x2670801a, 0xccd461a2, 0x264843d9, 0xccb640b8,
  0x261feffa, 0xcc983f70, 0x25f78497, 0xcc7a5dde,
  0x25cf01c8, 0xcc5c9c14, 0x25a667a7, 0xcc3efa25,
  0x257db64c, 0xcc217822, 0x2554edd1, 0xcc04161e,
  0x252c0e4f, 0xcbe6d42b, 0x250317df, 0xcbc9b25a,
  0x24da0a9a, 0xcbacb0bf, 0x24b0e699, 0xcb8fcf6b,
  0x2487abf7, 0xcb730e70, 0x245e5acc, 0xcb566ddf,
  0x2434f332, 0xcb39edca, 0x240b7543, 0xcb1d8e43,
  0x23e1e117, 0xcb014f5b, 0x23b836ca, 0xcae53123,
  0x238e7673, 0xcac933ae, 0x2364a02e, 0xcaad570c,
  0x233ab414, 0xca919b4e, 0x2310b23e, 0xca760086,
  0x22e69ac8, 0xca5a86c4, 0x22bc6dca, 0xca3f2e19,
  0x22922b5e, 0xca23f698, 0x2267d3a0, 0xca08e04f,
  0x223d66a8, 0xc9edeb50, 0x2212e492, 0xc9d317ab,
  0x21e84d76, 0xc9b86572, 0x21bda171, 0xc99dd4b4,
  0x2192e09b, 0xc9836582, 0x21680b0f, 0xc96917ec,
  0x213d20e8, 0xc94eec03, 0x21122240, 0xc934e1d6,
  0x20e70f32, 0xc91af976, 0x20bbe7d8, 0xc90132f2,
  0x2090ac4d, 0xc8e78e5b, 0x20655cac, 0xc8ce0bc0,
  0x2039f90f, 0xc8b4ab32, 0x200e8190, 0xc89b6cbf,
  0x1fe2f64c, 0xc8825077, 0x1fb7575c, 0xc869566a,
  0x1f8ba4dc, 0xc8507ea7, 0x1f5fdee6, 0xc837c93e,
  0x1f340596, 0xc81f363d, 0x1f081907, 0xc806c5b5,
  0x1edc1953, 0xc7ee77b3, 0x1eb00696, 0xc7d64c47,
  0x1e83e0eb, 0xc7be4381, 0x1e57a86d, 0xc7a65d6e,
  0x1e2b5d38, 0xc78e9a1d, 0x1dfeff67, 0xc776f99d,
  0x1dd28f15, 0xc75f7bfe, 0x1da60c5d, 0xc748214c,
  0x1d79775c, 0xc730e997, 0x1d4cd02c, 0xc719d4ed,
  0x1d2016e9, 0xc702e35c, 0x1cf34baf, 0xc6ec14f2,
  0x1cc66e99, 0xc6d569be, 0x1c997fc4, 0xc6bee1cd,
  0x1c6c7f4a, 0xc6a87d2d, 0x1c3f6d47, 0xc6923bec,
  0x1c1249d8, 0xc67c1e18, 0x1be51518, 0xc66623be,
  0x1bb7cf23, 0xc6504ced, 0x1b8a7815, 0xc63a99b1,
  0x1b5d100a, 0xc6250a18, 0x1b2f971e, 0xc60f9e2e,
  0x1b020d6c, 0xc5fa5603, 0x1ad47312, 0xc5e531a1,
  0x1aa6c82b, 0xc5d03118, 0x1a790cd4, 0xc5bb5472,
  0x1a4b4128, 0xc5a69bbe, 0x1a1d6544, 0xc5920708,
  0x19ef7944, 0xc57d965d, 0x19c17d44, 0xc56949ca,
  0x19937161, 0xc555215a, 0x196555b8, 0xc5411d1b,
  0x19372a64, 0xc52d3d18, 0x1908ef82, 0xc519815f,
  0x18daa52f, 0xc505e9fb, 0x18ac4b87, 0xc4f276f7,
  0x187de2a7, 0xc4df2862, 0x184f6aab, 0xc4cbfe45,
  0x1820e3b0, 0xc4b8f8ad, 0x17f24dd3, 0xc4a617a6,
  0x17c3a931, 0xc4935b3c, 0x1794f5e6, 0xc480c379,
  0x1766340f, 0xc46e5069, 0x173763c9, 0xc45c0219,
  0x17088531, 0xc449d892, 0x16d99864, 0xc437d3e1,
  0x16aa9d7e, 0xc425f410, 0x167b949d, 0xc414392b,
  0x164c7ddd, 0xc402a33c, 0x161d595d, 0xc3f1324e,
  0x15ee2738, 0xc3dfe66c, 0x15bee78c, 0xc3cebfa0,
  0x158f9a76, 0xc3bdbdf6, 0x15604013, 0xc3ace178,
  0x1530d881, 0xc39c2a2f, 0x150163dc, 0xc38b9827,
  0x14d1e242, 0xc37b2b6a, 0x14a253d1, 0xc36ae401,
  0x1472b8a5, 0xc35ac1f7, 0x144310dd, 0xc34ac556,
  0x14135c94, 0xc33aee27, 0x13e39be9, 0xc32b3c75,
  0x13b3cefa, 0xc31bb049, 0x1383f5e3, 0xc30c49ad,
  0x135410c3, 0xc2fd08a9, 0x13241fb6, 0xc2eded49,
  0x12f422db, 0xc2def794, 0x12c41a4f, 0xc2d02794,
  0x1294062f, 0xc2c17d52, 0x1263e699, 0xc2b2f8d8,
  0x1233bbac, 0xc2a49a2e, 0x12038584, 0xc296615d,
  0x11d3443f, 0xc2884e6e, 0x11a2f7fc, 0xc27a616a,
  0x1172a0d7, 0xc26c9a58, 0x11423ef0, 0xc25ef943,
  0x1111d263, 0xc2517e31, 0x10e15b4e, 0xc244292c,
  0x10b0d9d0, 0xc236fa3b, 0x10804e06, 0xc229f167,
  0x104fb80e, 0xc21d0eb8, 0x101f1807, 0xc2105236,
  0x0fee6e0d, 0xc203bbe8, 0x0fbdba40, 0xc1f74bd6,
  0x0f8cfcbe, 0xc1eb0209, 0x0f5c35a3, 0xc1dede87,
  0x0f2b650f, 0xc1d2e158, 0x0efa8b20, 0xc1c70a84,
  0x0ec9a7f3, 0xc1bb5a11, 0x0e98bba7, 0xc1afd007,
  0x0e67c65a, 0xc1a46c6e, 0x0e36c82a, 0xc1992f4c,
  0x0e05c135, 0xc18e18a7, 0x0dd4b19a, 0xc1832888,
  0x0da39978, 0xc1785ef4, 0x0d7278eb, 0xc16dbbf3,
  0x0d415013, 0xc1633f8a, 0x0d101f0e, 0xc158e9c1,
  0x0cdee5f9, 0xc14eba9d, 0x0cada4f5, 0xc144b225,
  0x0c7c5c1e, 0xc13ad060, 0x0c4b0b94, 0xc1311553,
  0x0c19b374, 0xc1278104, 0x0be853de, 0xc11e1379,
  0x0bb6ecef, 0xc114ccb9, 0x0b857ec7, 0xc10bacc8,
  0x0b540982, 0xc102b3ac, 0x0b228d42, 0xc0f9e16b,
  0x0af10a22, 0xc0f1360b, 0x0abf8043, 0xc0e8b190,
  0x0a8defc3, 0xc0e05401, 0x0a5c58c0, 0xc0d81d61,
  0x0a2abb59, 0xc0d00db6, 0x09f917ac, 0xc0c82506,
  0x09c76dd8, 0xc0c06355, 0x0995bdfd, 0xc0b8c8a7,
  0x09640837, 0xc0b15502, 0x09324ca7, 0xc0aa086a,
  0x09008b6a, 0xc0a2e2e3, 0x08cec4a0, 0xc09be473,
  0x089cf867, 0xc0950d1d, 0x086b26de, 0xc08e5ce5,
  0x08395024, 0xc087d3d0, 0x08077457, 0xc08171e2,
  0x07d59396, 0xc07b371e, 0x07a3adff, 0xc0752389,
  0x0771c3b3, 0xc06f3726, 0x073fd4cf, 0xc06971f9,
  0x070de172, 0xc063d405, 0x06dbe9bb, 0xc05e5d4e,
  0x06a9edc9, 0xc0590dd8, 0x0677edbb, 0xc053e5a5,
  0x0645e9af, 0xc04ee4b8, 0x0613e1c5, 0xc04a0b16,
  0x05e1d61b, 0xc04558c0, 0x05afc6d0, 0xc040cdba,
  0x057db403, 0xc03c6a07, 0x054b9dd3, 0xc0382da8,
  0x0519845e, 0xc03418a2, 0x04e767c5, 0xc0302af5,
  0x04b54825, 0xc02c64a6, 0x0483259d, 0xc028c5b6,
  0x0451004d, 0xc0254e27, 0x041ed854, 0xc021fdfb,
  0x03ecadcf, 0xc01ed535, 0x03ba80df, 0xc01bd3d6,
  0x038851a2, 0xc018f9e1, 0x03562038, 0xc0164757,
  0x0323ecbe, 0xc013bc39, 0x02f1b755, 0xc011588a,
  0x02bf801a, 0xc00f1c4a, 0x028d472e, 0xc00d077c,
  0x025b0caf, 0xc00b1a20, 0x0228d0bb, 0xc0095438,
  0x01f69373, 0xc007b5c4, 0x01c454f5, 0xc0063ec6,
  0x0192155f, 0xc004ef3f, 0x015fd4d2, 0xc003c72f,
  0x012d936c, 0xc002c697, 0x00fb514b, 0xc001ed78,
  0x00c90e90, 0xc0013bd3, 0x0096cb58, 0xc000b1a7,
  0x006487c4, 0xc0004ef5, 0x003243f1, 0xc00013bd,
  0x00000000, 0xc0000000, 0xffcdbc0f, 0xc00013bd,
  0xff9b783c, 0xc0004ef5, 0xff6934a8, 0xc000b1a7,
  0xff36f170, 0xc0013bd3, 0xff04aeb5, 0xc001ed78,
  0xfed26c94, 0xc002c697, 0xfea02b2e, 0xc003c72f,
  0xfe6deaa1, 0xc004ef3f, 0xfe3bab0b, 0xc0063ec6,
  0xfe096c8d, 0xc007b5c4, 0xfdd72f45, 0xc0095438,
  0xfda4f351, 0xc00b1a20, 0xfd72b8d2, 0xc00d077c,
  0xfd407fe6, 0xc00f1c4a, 0xfd0e48ab, 0xc011588a,
  0xfcdc1342, 0xc013bc39, 0xfca9dfc8, 0xc0164757,
  0xfc77ae5e, 0xc018f9e1, 0xfc457f21, 0xc01bd3d6,
  0xfc135231, 0xc01ed535, 0xfbe127ac, 0xc021fdfb,
  0xfbaeffb3, 0xc0254e27, 0xfb7cda63, 0xc028c5b6,
  0xfb4ab7db, 0xc02c64a6, 0xfb18983b, 0xc0302af5,
  0xfae67ba2, 0xc03418a2, 0xfab4622d, 0xc0382da8,
  0xfa824bfd, 0xc03c6a07, 0xfa503930, 0xc040cdba,
  0xfa1e29e5, 0xc04558c0, 0xf9ec1e3b, 0xc04a0b16,
  0xf9ba1651, 0xc04ee4b8, 0xf9881245, 0xc053e5a5,
  0xf9561237, 0xc0590dd8, 0xf9241645, 0xc05e5d4e,
  0xf8f21e8e, 0xc063d405, 0xf8c02b31, 0xc06971f9,
  0xf88e3c4d, 0xc06f3726, 0xf85c5201, 0xc0752389,
  0xf82a6c6a, 0xc07b371e, 0xf7f88ba9, 0xc08171e2,
  0xf7c6afdc, 0xc087d3d0, 0xf794d922, 0xc08e5ce5,
  0xf7630799, 0xc0950d1d, 0xf7313b60, 0xc09be473,
  0xf6ff7496, 0xc0a2e2e3, 0xf6cdb359, 0xc0aa086a,
  0xf69bf7c9, 0xc0b15502, 0xf66a4203, 0xc0b8c8a7,
  0xf6389228, 0xc0c06355, 0xf606e854, 0xc0c82506,
  0xf5d544a7, 0xc0d00db6, 0xf5a3a740, 0xc0d81d61,
  0xf572103d, 0xc0e05401, 0xf5407fbd, 0xc0e8b190,
  0xf50ef5de, 0xc0f1360b, 0xf4dd72be, 0xc0f9e16b,
  0xf4abf67e, 0xc102b3ac, 0xf47a8139, 0xc10bacc8,
  0xf4491311, 0xc114ccb9, 0xf417ac22, 0xc11e1379,
  0xf3e64c8c, 0xc1278104, 0xf3b4f46c, 0xc1311553,
  0xf383a3e2, 0xc13ad060, 0xf3525b0b, 0xc144b225,
  0xf3211a07, 0xc14eba9d, 0xf2efe0f2, 0xc158e9c1,
  0xf2beafed, 0xc1633f8a, 0xf28d8715, 0xc16dbbf3,
  0xf25c6688, 0xc1785ef4, 0xf22b4e66, 0xc1832888,
  0xf1fa3ecb, 0xc18e18a7, 0xf1c937d6, 0xc1992f4c,
  0xf19839a6, 0xc1a46c6e, 0xf1674459, 0xc1afd007,
  0xf136580d, 0xc1bb5a11, 0xf10574e0, 0xc1c70a84,
  0xf0d49af1, 0xc1d2e158, 0xf0a3ca5d, 0xc1dede87,
  0xf0730342, 0xc1eb0209, 0xf04245c0, 0xc1f74bd6,
  0xf01191f3, 0xc203bbe8, 0xefe0e7f9, 0xc2105236,
  0xefb047f2, 0xc21d0eb8, 0xef7fb1fa, 0xc229f167,
  0xef4f2630, 0xc236fa3b, 0xef1ea4b2, 0xc244292c,
  0xeeee2d9d, 0xc2517e31, 0xeebdc110, 0xc25ef943,
  0xee8d5f29, 0xc26c9a58, 0xee5d0804, 0xc27a616a,
  0xee2cbbc1, 0xc2884e6e, 0xedfc7a7c, 0xc296615d,
  0xedcc4454, 0xc2a49a2e, 0xed9c1967, 0xc2b2f8d8,
  0xed6bf9d1, 0xc2c17d52, 0xed3be5b1, 0xc2d02794,
  0xed0bdd25, 0xc2def794, 0xecdbe04a, 0xc2eded49,
  0xecabef3d, 0xc2fd08a9, 0xec7c0a1d, 0xc30c49ad,
  0xec4c3106, 0xc31bb049, 0xec1c6417, 0xc32b3c75,
  0xebeca36c, 0xc33aee27, 0xebbcef23, 0xc34ac556,
  0xeb8d475b, 0xc35ac1f7, 0xeb5dac2f, 0xc36ae401,
  0xeb2e1dbe, 0xc37b2b6a, 0xeafe9c24, 0xc38b9827,
  0xeacf277f, 0xc39c2a2f, 0xea9fbfed, 0xc3ace178,
  0xea70658a, 0xc3bdbdf6, 0xea411874, 0xc3cebfa0,
  0xea11d8c8, 0xc3dfe66c, 0xe9e2a6a3, 0xc3f1324e,
  0xe9b38223, 0xc402a33c, 0xe9846b63, 0xc414392b,
  0xe9556282, 0xc425f410, 0xe926679c, 0xc437d3e1,
  0xe8f77acf, 0xc449d892, 0xe8c89c37, 0xc45c0219,
  0xe899cbf1, 0xc46e5069, 0xe86b0a1a, 0xc480c379,
  0xe83c56cf, 0xc4935b3c, 0xe80db22d, 0xc4a617a6,
  0xe7df1c50, 0xc4b8f8ad, 0xe7b09555, 0xc4cbfe45,
  0xe7821d59, 0xc4df2862, 0xe753b479, 0xc4f276f7,
  0xe7255ad1, 0xc505e9fb, 0xe6f7107e, 0xc519815f,
  0xe6c8d59c, 0xc52d3d18, 0xe69aaa48, 0xc5411d1b,
  0xe66c8e9f, 0xc555215a, 0xe63e82bc, 0xc56949ca,
  0xe61086bc, 0xc57d965d, 0xe5e29abc, 0xc5920708,
  0xe5b4bed8, 0xc5a69bbe, 0xe586f32c, 0xc5bb5472,
  0xe55937d5, 0xc5d03118, 0xe52b8cee, 0xc5e531a1,
  0xe4fdf294, 0xc5fa5603, 0xe4d068e2, 0xc60f9e2e,
  0xe4a2eff6, 0xc6250a18, 0xe47587eb, 0xc63a99b1,
  0xe44830dd, 0xc6504ced, 0xe41aeae8, 0xc66623be,
  0xe3edb628, 0xc67c1e18, 0xe3c092b9, 0xc6923bec,
  0xe39380b6, 0xc6a87d2d, 0xe366803c, 0xc6bee1cd,
  0xe3399167, 0xc6d569be, 0xe30cb451, 0xc6ec14f2,
  0xe2dfe917, 0xc702e35c, 0xe2b32fd4, 0xc719d4ed,
  0xe28688a4, 0xc730e997, 0xe259f3a3, 0xc748214c,
  0xe22d70eb, 0xc75f7bfe, 0xe2010099, 0xc776f99d,
  0xe1d4a2c8, 0xc78e9a1d, 0xe1a85793, 0xc7a65d6e,
  0xe17c1f15, 0xc7be4381, 0xe14ff96a, 0xc7d64c47,
  0xe123e6ad, 0xc7ee77b3, 0xe0f7e6f9, 0xc806c5b5,
  0xe0cbfa6a, 0xc81f363d, 0xe0a0211a, 0xc837c93e,
  0xe0745b24, 0xc8507ea7, 0xe048a8a4, 0xc869566a,
  0xe01d09b4, 0xc8825077, 0xdff17e70, 0xc89b6cbf,
  0xdfc606f1, 0xc8b4ab32, 0xdf9aa354, 0xc8ce0bc0,
  0xdf6f53b3, 0xc8e78e5b, 0xdf441828, 0xc90132f2,
  0xdf18f0ce, 0xc91af976, 0xdeedddc0, 0xc934e1d6,
  0xdec2df18, 0xc94eec03, 0xde97f4f1, 0xc96917ec,
  0xde6d1f65, 0xc9836582, 0xde425e8f, 0xc99dd4b4,
  0xde17b28a, 0xc9b86572, 0xdded1b6e, 0xc9d317ab,
  0xddc29958, 0xc9edeb50, 0xdd982c60, 0xca08e04f,
  0xdd6dd4a2, 0xca23f698, 0xdd439236, 0xca3f2e19,
  0xdd196538, 0xca5a86c4, 0xdcef4dc2, 0xca760086,
  0xdcc54bec, 0xca919b4e, 0xdc9b5fd2, 0xcaad570c,
  0xdc71898d, 0xcac933ae, 0xdc47c936, 0xcae53123,
  0xdc1e1ee9, 0xcb014f5b, 0xdbf48abd, 0xcb1d8e43,
  0xdbcb0cce, 0xcb39edca, 0xdba1a534, 0xcb566ddf,
  0xdb785409, 0xcb730e70, 0xdb4f1967, 0xcb8fcf6b,
  0xdb25f566, 0xcbacb0bf, 0xdafce821, 0xcbc9b25a,
  0xdad3f1b1, 0xcbe6d42b, 0xdaab122f, 0xcc04161e,
  0xda8249b4, 0xcc217822, 0xda599859, 0xcc3efa25,
  0xda30fe38, 0xcc5c9c14, 0xda087b69, 0xcc7a5dde,
  0xd9e01006, 0xcc983f70, 0xd9b7bc27, 0xccb640b8,
  0xd98f7fe6, 0xccd461a2, 0xd9675b5a, 0xccf2a21d,
  0xd93f4e9e, 0xcd110216, 0xd91759c9, 0xcd2f817b,
  0xd8ef7cf4, 0xcd4e2037, 0xd8c7b838, 0xcd6cde39,
  0xd8a00bae, 0xcd8bbb6d, 0xd878776d, 0xcdaab7c0,
  0xd850fb8e, 0xcdc9d320, 0xd829982b, 0xcde90d79,
  0xd8024d59, 0xce0866b8, 0xd7db1b34, 0xce27dec9,
  0xd7b401d1, 0xce47759a, 0xd78d014a, 0xce672b16,
  0xd76619b6, 0xce86ff2a, 0xd73f4b2e, 0xcea6f1c2,
  0xd71895c9, 0xcec702cb, 0xd6f1f99f, 0xcee73231,
  0xd6cb76c9, 0xcf077fe1, 0xd6a50d5d, 0xcf27ebc5,
  0xd67ebd74, 0xcf4875ca, 0xd6588725, 0xcf691ddd,
  0xd6326a88, 0xcf89e3e8, 0xd60c67b4, 0xcfaac7d8,
  0xd5e67ec1, 0xcfcbc999, 0xd5c0afc6, 0xcfece915,
  0xd59afadb, 0xd00e2639, 0xd5756016, 0xd02f80f1,
  0xd54fdf8f, 0xd050f926, 0xd52a795d, 0xd0728ec6,
  0xd5052d97, 0xd09441bb, 0xd4dffc54, 0xd0b611f1,
  0xd4bae5ab, 0xd0d7ff51, 0xd495e9b3, 0xd0fa09c9,
  0xd4710883, 0xd11c3142, 0xd44c4232, 0xd13e75a8,
  0xd42796d5, 0xd160d6e5, 0xd4030684, 0xd18354e4,
  0xd3de9156, 0xd1a5ef90, 0xd3ba3760, 0xd1c8a6d4,
  0xd395f8ba, 0xd1eb7a9a, 0xd371d579, 0xd20e6acc,
  0xd34dcdb4, 0xd2317756, 0xd329e181, 0xd254a021,
  0xd30610f7, 0xd277e518, 0xd2e25c2b, 0xd29b4626,
  0xd2bec333, 0xd2bec333, 0xd29b4626, 0xd2e25c2b,
  0xd277e518, 0xd30610f7, 0xd254a021, 0xd329e181,
  0xd2317756, 0xd34dcdb4, 0xd20e6acc, 0xd371d579,
  0xd1eb7a9a, 0xd395f8ba, 0xd1c8a6d4, 0xd3ba3760,
  0xd1a5ef90, 0xd3de9156, 0xd18354e4, 0xd4030684,
  0xd160d6e5, 0xd42796d5, 0xd13e75a8, 0xd44c4232,
  0xd11c3142, 0xd4710883, 0xd0fa09c9, 0xd495e9b3,
  0xd0d7ff51, 0xd4bae5ab, 0xd0b611f1, 0xd4dffc54,
  0xd09441bb, 0xd5052d97, 0xd0728ec6, 0xd52a795d,
  0xd050f926, 0xd54fdf8f, 0xd02f80f1, 0xd5756016,
  0xd00e2639, 0xd59afadb, 0xcfece915, 0xd5c0afc6,
  0xcfcbc999, 0xd5e67ec1, 0xcfaac7d8, 0xd60c67b4,
  0xcf89e3e8, 0xd6326a88, 0xcf691ddd, 0xd6588725,
  0xcf4875ca, 0xd67ebd74, 0xcf27ebc5, 0xd6a50d5d,
  0xcf077fe1, 0xd6cb76c9, 0xcee73231, 0xd6f1f99f,
  0xcec702cb, 0xd71895c9, 0xcea6f1c2, 0xd73f4b2e,
  0xce86ff2a, 0xd76619b6, 0xce672b16, 0xd78d014a,
  0xce47759a, 0xd7b401d1, 0xce27dec9, 0xd7db1b34,
  0xce0866b8, 0xd8024d59, 0xcde90d79, 0xd829982b,
  0xcdc9d320, 0xd850fb8e, 0xcdaab7c0, 0xd878776d,
  0xcd8bbb6d, 0xd8a00bae, 0xcd6cde39, 0xd8c7b838,
  0xcd4e2037, 0xd8ef7cf4, 0xcd2f817b, 0xd91759c9,
  0xcd110216, 0xd93f4e9e, 0xccf2a21d, 0xd9675b5a,
  0xccd461a2, 0xd98f7fe6, 0xccb640b8, 0xd9b7bc27,
  0xcc983f70, 0xd9e01006, 0xcc7a5dde, 0xda087b69,
  0xcc5c9c14, 0xda30fe38, 0xcc3efa25, 0xda599859,
  0xcc217822, 0xda8249b4, 0xcc04161e, 0xdaab122f,
  0xcbe6d42b, 0xdad3f1b1, 0xcbc9b25a, 0xdafce821,
  0xcbacb0bf, 0xdb25f566, 0xcb8fcf6b, 0xdb4f1967,
  0xcb730e70, 0xdb785409, 0xcb566ddf, 0xdba1a534,
  0xcb39edca, 0xdbcb0cce, 0xcb1d8e43, 0xdbf48abd,
  0xcb014f5b, 0xdc1e1ee9, 0xcae53123, 0xdc47c936,
  0xcac933ae, 0xdc71898d, 0xcaad570c, 0xdc9b5fd2,
  0xca919b4e, 0xdcc54bec, 0xca760086, 0xdcef4dc2,
  0xca5a86c4, 0xdd196538, 0xca3f2e19, 0xdd439236,
  0xca23f698, 0xdd6dd4a2, 0xca08e04f, 0xdd982c60,
  0xc9edeb50, 0xddc29958, 0xc9d317ab, 0xdded1b6e,
  0xc9b86572, 0xde17b28a, 0xc99dd4b4, 0xde425e8f,
  0xc9836582, 0xde6d1f65, 0xc96917ec, 0xde97f4f1,
  0xc94eec03, 0xdec2df18, 0xc934e1d6, 0xdeedddc0,
  0xc91af976, 0xdf18f0ce, 0xc90132f2, 0xdf441828,
  0xc8e78e5b, 0xdf6f53b3, 0xc8ce0bc0, 0xdf9aa354,
  0xc8b4ab32, 0xdfc606f1, 0xc89b6cbf, 0xdff17e70,
  0xc8825077, 0xe01d09b4, 0xc869566a, 0xe048a8a4,
  0xc8507ea7, 0xe0745b24, 0xc837c93e, 0xe0a0211a,
  0xc81f363d, 0xe0cbfa6a, 0xc806c5b5, 0xe0f7e6f9,
  0xc7ee77b3, 0xe123e6ad, 0xc7d64c47, 0xe14ff96a,
  0xc7be4381, 0xe17c1f15, 0xc7a65d6e, 0xe1a85793,
  0xc78e9a1d, 0xe1d4a2c8, 0xc776f99d, 0xe2010099,
  0xc75f7bfe, 0xe22d70eb, 0xc748214c, 0xe259f3a3,
  0xc730e997, 0xe28688a4, 0xc719d4ed, 0xe2b32fd4,
  0xc702e35c, 0xe2dfe917, 0xc6ec14f2, 0xe30cb451,
  0xc6d569be, 0xe3399167, 0xc6bee1cd, 0xe366803c,
  0xc6a87d2d, 0xe39380b6, 0xc6923bec, 0xe3c092b9,
  0xc67c1e18, 0xe3edb628, 0xc66623be, 0xe41aeae8,
  0xc6504ced, 0xe44830dd, 0xc63a99b1, 0xe47587eb,
  0xc6250a18, 0xe4a2eff6, 0xc60f9e2e, 0xe4d068e2,
  0xc5fa5603, 0xe4fdf294, 0xc5e531a1, 0xe52b8cee,
  0xc5d03118, 0xe55937d5, 0xc5bb5472, 0xe586f32c,
  0xc5a69bbe, 0xe5b4bed8, 0xc5920708, 0xe5e29abc,
  0xc57d965d, 0xe61086bc, 0xc56949ca, 0xe63e82bc,
  0xc555215a, 0xe66c8e9f, 0xc5411d1b, 0xe69aaa48,
  0xc52d3d18, 0xe6c8d59c, 0xc519815f, 0xe6f7107e,
  0xc505e9fb, 0xe7255ad1, 0xc4f276f7, 0xe753b479,
  0xc4df2862, 0xe7821d59, 0xc4cbfe45, 0xe7b09555,
  0xc4b8f8ad, 0xe7df1c50, 0xc4a617a6, 0xe80db22d,
  0xc4935b3c, 0xe83c56cf, 0xc480c379, 0xe86b0a1a,
  0xc46e5069, 0xe899cbf1, 0xc45c0219, 0xe8c89c37,
  0xc449d892, 0xe8f77acf, 0xc437d3e1, 0xe926679c,
  0xc425f410, 0xe9556282, 0xc414392b, 0xe9846b63,
  0xc402a33c, 0xe9b38223, 0xc3f1324e, 0xe9e2a6a3,
  0xc3dfe66c, 0xea11d8c8, 0xc3cebfa0, 0xea411874,
  0xc3bdbdf6, 0xea70658a, 0xc3ace178, 0xea9fbfed,
  0xc39c2a2f, 0xeacf277f, 0xc38b9827, 0xeafe9c24,
  0xc37b2b6a, 0xeb2e1dbe, 0xc36ae401, 0xeb5dac2f,
  0xc35ac1f7, 0xeb8d475b, 0xc34ac556, 0xebbcef23,
  0xc33aee27, 0xebeca36c, 0xc32b3c75, 0xec1c6417,
  0xc31bb049, 0xec4c3106, 0xc30c49ad, 0xec7c0a1d,
  0xc2fd08a9, 0xecabef3d, 0xc2eded49, 0xecdbe04a,
  0xc2def794, 0xed0bdd25, 0xc2d02794, 0xed3be5b1,
  0xc2c17d52, 0xed6bf9d1, 0xc2b2f8d8, 0xed9c1967,
  0xc2a49a2e, 0xedcc4454, 0xc296615d, 0xedfc7a7c,
  0xc2884e6e, 0xee2cbbc1, 0xc27a616a, 0xee5d0804,
  0xc26c9a58, 0xee8d5f29, 0xc25ef943, 0xeebdc110,
  0xc2517e31, 0xeeee2d9d, 0xc244292c, 0xef1ea4b2,
  0xc236fa3b, 0xef4f2630, 0xc229f167, 0xef7fb1fa,
  0xc21d0eb8, 0xefb047f2, 0xc2105236, 0xefe0e7f9,
  0xc203bbe8, 0xf01191f3, 0xc1f74bd6, 0xf04245c0,
  0xc1eb0209, 0xf0730342, 0xc1dede87, 0xf0a3ca5d,
  0xc1d2e158, 0xf0d49af1, 0xc1c70a84, 0xf10574e0,
  0xc1bb5a11, 0xf136580d, 0xc1afd007, 0xf1674459,
  0xc1a46c6e, 0xf19839a6, 0xc1992f4c, 0xf1c937d6,
  0xc18e18a7, 0xf1fa3ecb, 0xc1832888, 0xf22b4e66,
  0xc1785ef4, 0xf25c6688, 0xc16dbbf3, 0xf28d8715,
  0xc1633f8a, 0xf2beafed, 0xc158e9c1, 0xf2efe0f2,
  0xc14eba9d, 0xf3211a07, 0xc144b225, 0xf3525b0b,
  0xc13ad060, 0xf383a3e2, 0xc1311553, 0xf3b4f46c,
  0xc1278104, 0xf3e64c8c, 0xc11e1379, 0xf417ac22,
  0xc114ccb9, 0xf4491311, 0xc10bacc8, 0xf47a8139,
  0xc102b3ac, 0xf4abf67e, 0xc0f9e16b, 0xf4dd72be,
  0xc0f1360b, 0xf50ef5de, 0xc0e8b190, 0xf5407fbd,
  0xc0e05401, 0xf572103d, 0xc0d81d61, 0xf5a3a740,
  0xc0d00db6, 0xf5d544a7, 0xc0c82506, 0xf606e854,
  0xc0c06355, 0xf6389228, 0xc0b8c8a7, 0xf66a4203,
  0xc0b15502, 0xf69bf7c9, 0xc0aa086a, 0xf6cdb359,
  0xc0a2e2e3, 0xf6ff7496, 0xc09be473, 0xf7313b60,
  0xc0950d1d, 0xf7630799, 0xc08e5ce5, 0xf794d922,
  0xc087d3d0, 0xf7c6afdc, 0xc08171e2, 0xf7f88ba9,
  0xc07b371e, 0xf82a6c6a, 0xc0752389, 0xf85c5201,
  0xc06f3726, 0xf88e3c4d, 0xc06971f9, 0xf8c02b31,
  0xc063d405, 0xf8f21e8e, 0xc05e5d4e, 0xf9241645,
  0xc0590dd8, 0xf9561237, 0xc053e5a5, 0xf9881245,
  0xc04ee4b8, 0xf9ba1651, 0xc04a0b16, 0xf9ec1e3b,
  0xc04558c0, 0xfa1e29e5, 0xc040cdba, 0xfa503930,
  0xc03c6a07, 0xfa824bfd, 0xc0382da8, 0xfab4622d,
  0xc03418a2, 0xfae67ba2, 0xc0302af5, 0xfb18983b,
  0xc02c64a6, 0xfb4ab7db, 0xc028c5b6, 0xfb7cda63,
  0xc0254e27, 0xfbaeffb3, 0xc021fdfb, 0xfbe127ac,
  0xc01ed535, 0xfc135231, 0xc01bd3d6, 0xfc457f21,
  0xc018f9e1, 0xfc77ae5e, 0xc0164757, 0xfca9dfc8,
  0xc013bc39, 0xfcdc1342, 0xc011588a, 0xfd0e48ab,
  0xc00f1c4a, 0xfd407fe6, 0xc00d077c, 0xfd72b8d2,
  0xc00b1a20, 0xfda4f351, 0xc0095438, 0xfdd72f45,
  0xc007b5c4, 0xfe096c8d, 0xc0063ec6, 0xfe3bab0b,
  0xc004ef3f, 0xfe6deaa1, 0xc003c72f, 0xfea02b2e,
  0xc002c697, 0xfed26c94, 0xc001ed78, 0xff04aeb5,
  0xc0013bd3, 0xff36f170, 0xc000b1a7, 0xff6934a8,
  0xc0004ef5, 0xff9b783c, 0xc00013bd, 0xffcdbc0f,
  0x3fffffb1, 0x0006487f, 0x3ffffd39, 0x0012d97c,
  0x3ffff84a, 0x001f6a79, 0x3ffff0e3, 0x002bfb74,
  0x3fffe705, 0x00388c6e, 0x3fffdaae, 0x00451d66,
  0x3fffcbe0, 0x0051ae5b, 0x3fffba9b, 0x005e3f4c,
  0x3fffa6de, 0x006ad03b, 0x3fff90a9, 0x00776125,
  0x3fff77fc, 0x0083f20a, 0x3fff5cd8, 0x009082ea,
  0x3fff3f3c, 0x009d13c5, 0x3fff1f29, 0x00a9a49a,
  0x3ffefc9e, 0x00b63568, 0x3ffed79b, 0x00c2c62f,
  0x3ffeb021, 0x00cf56ef, 0x3ffe862f, 0x00dbe7a6,
  0x3ffe59c6, 0x00e87856, 0x3ffe2ae5, 0x00f508fc,
  0x3ffdf98c, 0x01019998, 0x3ffdc5bc, 0x010e2a2b,
  0x3ffd8f74, 0x011abab4, 0x3ffd56b5, 0x01274b31,
  0x3ffd1b7e, 0x0133dba3, 0x3ffcddd0, 0x01406c0a,
  0x3ffc9daa, 0x014cfc63, 0x3ffc5b0c, 0x01598cb1,
  0x3ffc15f7, 0x01661cf0, 0x3ffbce6b, 0x0172ad22,
  0x3ffb8467, 0x017f3d46, 0x3ffb37ec, 0x018bcd5b,
  0x3ffae8f9, 0x01985d60, 0x3ffa978e, 0x01a4ed56,
  0x3ffa43ac, 0x01b17d3c, 0x3ff9ed53, 0x01be0d11,
  0x3ff99483, 0x01ca9cd4, 0x3ff9393a, 0x01d72c87,
  0x3ff8db7b, 0x01e3bc26, 0x3ff87b44, 0x01f04bb4,
  0x3ff81896, 0x01fcdb2e, 0x3ff7b370, 0x02096a94,
  0x3ff74bd3, 0x0215f9e7, 0x3ff6e1bf, 0x02228924,
  0x3ff67534, 0x022f184d, 0x3ff60631, 0x023ba760,
  0x3ff594b7, 0x0248365d, 0x3ff520c5, 0x0254c544,
  0x3ff4aa5d, 0x02615414, 0x3ff4317d, 0x026de2cc,
  0x3ff3b626, 0x027a716c, 0x3ff33858, 0x0286fff3,
  0x3ff2b813, 0x02938e62, 0x3ff23556, 0x02a01cb8,
  0x3ff1b022, 0x02acaaf3, 0x3ff12878, 0x02b93914,
  0x3ff09e56, 0x02c5c71a, 0x3ff011bd, 0x02d25505,
  0x3fef82ad, 0x02dee2d4, 0x3feef126, 0x02eb7086,
  0x3fee5d28, 0x02f7fe1c, 0x3fedc6b4, 0x03048b94,
  0x3fed2dc8, 0x031118ef, 0x3fec9265, 0x031da62b,
  0x3febf48b, 0x032a3349, 0x3feb543b, 0x0336c047,
  0x3feab173, 0x03434d26, 0x3fea0c35, 0x034fd9e5,
  0x3fe96480, 0x035c6682, 0x3fe8ba54, 0x0368f2ff,
  0x3fe80db2, 0x03757f5a, 0x3fe75e98, 0x03820b93,
  0x3fe6ad08, 0x038e97a9, 0x3fe5f902, 0x039b239c,
  0x3fe54284, 0x03a7af6c, 0x3fe48990, 0x03b43b17,
  0x3fe3ce26, 0x03c0c69e, 0x3fe31045, 0x03cd5200,
  0x3fe24fed, 0x03d9dd3c, 0x3fe18d1f, 0x03e66852,
  0x3fe0c7da, 0x03f2f342, 0x3fe0001f, 0x03ff7e0b,
  0x3fdf35ed, 0x040c08ad, 0x3fde6945, 0x04189326,
  0x3fdd9a27, 0x04251d77, 0x3fdcc892, 0x0431a79f,
  0x3fdbf488, 0x043e319e, 0x3fdb1e06, 0x044abb73,
  0x3fda450f, 0x0457451d, 0x3fd969a1, 0x0463ce9d,
  0x3fd88bbe, 0x047057f1, 0x3fd7ab64, 0x047ce11a,
  0x3fd6c894, 0x04896a16, 0x3fd5e34e, 0x0495f2e5,
  0x3fd4fb91, 0x04a27b87, 0x3fd4115f, 0x04af03fc,
  0x3fd324b7, 0x04bb8c42, 0x3fd23599, 0x04c81459,
  0x3fd14405, 0x04d49c42, 0x3fd04ffc, 0x04e123fa,
  0x3fcf597c, 0x04edab83, 0x3fce6087, 0x04fa32db,
  0x3fcd651c, 0x0506ba01, 0x3fcc673b, 0x051340f6,
  0x3fcb66e4, 0x051fc7b9, 0x3fca6418, 0x052c4e4a,
  0x3fc95ed7, 0x0538d4a7, 0x3fc8571f, 0x05455ad1,
  0x3fc74cf3, 0x0551e0c7, 0x3fc64051, 0x055e6688,
  0x3fc53139, 0x056aec15, 0x3fc41fac, 0x0577716b,
  0x3fc30baa, 0x0583f68c, 0x3fc1f532, 0x05907b77,
  0x3fc0dc45, 0x059d002a, 0x3fbfc0e3, 0x05a984a6,
  0x3fbea30c, 0x05b608eb, 0x3fbd82bf, 0x05c28cf7,
  0x3fbc5ffe, 0x05cf10ca, 0x3fbb3ac7, 0x05db9463,
  0x3fba131b, 0x05e817c3, 0x3fb8e8fb, 0x05f49ae9,
  0x3fb7bc65, 0x06011dd4, 0x3fb68d5b, 0x060da083,
  0x3fb55bdc, 0x061a22f7, 0x3fb427e8, 0x0626a52f,
  0x3fb2f17f, 0x0633272a, 0x3fb1b8a2, 0x063fa8e7,
  0x3fb07d50, 0x064c2a67, 0x3faf3f89, 0x0658aba9,
  0x3fadff4e, 0x06652cac, 0x3facbc9f, 0x0671ad71,
  0x3fab777b, 0x067e2df5, 0x3faa2fe2, 0x068aae3a,
  0x3fa8e5d5, 0x06972e3d, 0x3fa79954, 0x06a3ae00,
  0x3fa64a5f, 0x06b02d81, 0x3fa4f8f6, 0x06bcacc1,
  0x3fa3a518, 0x06c92bbe, 0x3fa24ec6, 0x06d5aa77,
  0x3fa0f600, 0x06e228ee, 0x3f9f9ac6, 0x06eea720,
  0x3f9e3d19, 0x06fb250e, 0x3f9cdcf7, 0x0707a2b7,
  0x3f9b7a62, 0x0714201b, 0x3f9a1558, 0x07209d39,
  0x3f98addb, 0x072d1a10, 0x3f9743eb, 0x073996a1,
  0x3f95d787, 0x074612eb, 0x3f9468af, 0x07528eec,
  0x3f92f763, 0x075f0aa5, 0x3f9183a5, 0x076b8616,
  0x3f900d72, 0x0778013d, 0x3f8e94cd, 0x07847c1b,
  0x3f8d19b4, 0x0790f6ae, 0x3f8b9c28, 0x079d70f7,
  0x3f8a1c29, 0x07a9eaf5, 0x3f8899b7, 0x07b664a7,
  0x3f8714d1, 0x07c2de0d, 0x3f858d79, 0x07cf5726,
  0x3f8403ae, 0x07dbcff2, 0x3f827770, 0x07e84871,
  0x3f80e8bf, 0x07f4c0a1, 0x3f7f579b, 0x08013883,
  0x3f7dc405, 0x080db016, 0x3f7c2dfc, 0x081a275a,
  0x3f7a9580, 0x08269e4d, 0x3f78fa92, 0x083314f1,
  0x3f775d31, 0x083f8b43, 0x3f75bd5e, 0x084c0144,
  0x3f741b19, 0x085876f3, 0x3f727661, 0x0864ec4f,
  0x3f70cf38, 0x08716159, 0x3f6f259c, 0x087dd60f,
  0x3f6d798e, 0x088a4a72, 0x3f6bcb0e, 0x0896be80,
  0x3f6a1a1c, 0x08a3323a, 0x3f6866b8, 0x08afa59e,
  0x3f66b0e3, 0x08bc18ac, 0x3f64f89b, 0x08c88b65,
  0x3f633de2, 0x08d4fdc6, 0x3f6180b8, 0x08e16fd1,
  0x3f5fc11c, 0x08ede184, 0x3f5dff0e, 0x08fa52de,
  0x3f5c3a8f, 0x0906c3e0, 0x3f5a739e, 0x09133489,
  0x3f58aa3d, 0x091fa4d9, 0x3f56de6a, 0x092c14ce,
  0x3f551026, 0x09388469, 0x3f533f71, 0x0944f3a9,
  0x3f516c4b, 0x0951628d, 0x3f4f96b4, 0x095dd116,
  0x3f4dbeac, 0x096a3f42, 0x3f4be433, 0x0976ad11,
  0x3f4a074a, 0x09831a82, 0x3f4827f0, 0x098f8796,
  0x3f464626, 0x099bf44c, 0x3f4461eb, 0x09a860a2,
  0x3f427b3f, 0x09b4cc99, 0x3f409223, 0x09c13831,
  0x3f3ea697, 0x09cda368, 0x3f3cb89b, 0x09da0e3e,
  0x3f3ac82f, 0x09e678b4, 0x3f38d552, 0x09f2e2c7,
  0x3f36e006, 0x09ff4c78, 0x3f34e849, 0x0a0bb5c7,
  0x3f32ee1d, 0x0a181eb2, 0x3f30f181, 0x0a24873a,
  0x3f2ef276, 0x0a30ef5e, 0x3f2cf0fb, 0x0a3d571d,
  0x3f2aed10, 0x0a49be77, 0x3f28e6b6, 0x0a56256c,
  0x3f26ddec, 0x0a628bfa, 0x3f24d2b4, 0x0a6ef222,
  0x3f22c50c, 0x0a7b57e3, 0x3f20b4f5, 0x0a87bd3d,
  0x3f1ea26e, 0x0a94222f, 0x3f1c8d79, 0x0aa086b8,
  0x3f1a7615, 0x0aacead8, 0x3f185c43, 0x0ab94e8f,
  0x3f164001, 0x0ac5b1dc, 0x3f142151, 0x0ad214bf,
  0x3f120032, 0x0ade7737, 0x3f0fdca5, 0x0aead944,
  0x3f0db6a9, 0x0af73ae5, 0x3f0b8e3f, 0x0b039c1a,
  0x3f096367, 0x0b0ffce2, 0x3f073621, 0x0b1c5d3d,
  0x3f05066d, 0x0b28bd2a, 0x3f02d44a, 0x0b351caa,
  0x3f009fba, 0x0b417bba, 0x3efe68bc, 0x0b4dda5c,
  0x3efc2f50, 0x0b5a388d, 0x3ef9f377, 0x0b66964f,
  0x3ef7b530, 0x0b72f3a1, 0x3ef5747b, 0x0b7f5081,
  0x3ef3315a, 0x0b8bacf0, 0x3ef0ebcb, 0x0b9808ed,
  0x3eeea3ce, 0x0ba46477, 0x3eec5965, 0x0bb0bf8f,
  0x3eea0c8e, 0x0bbd1a33, 0x3ee7bd4b, 0x0bc97463,
  0x3ee56b9b, 0x0bd5ce1f, 0x3ee3177e, 0x0be22766,
  0x3ee0c0f4, 0x0bee8038, 0x3ede67fe, 0x0bfad894,
  0x3edc0c9b, 0x0c07307a, 0x3ed9aecc, 0x0c1387e9,
  0x3ed74e91, 0x0c1fdee1, 0x3ed4ebe9, 0x0c2c3562,
  0x3ed286d5, 0x0c388b6a, 0x3ed01f55, 0x0c44e0f9,
  0x3ecdb56a, 0x0c513610, 0x3ecb4912, 0x0c5d8aad,
  0x3ec8da4f, 0x0c69ded0, 0x3ec66920, 0x0c763278,
  0x3ec3f585, 0x0c8285a5, 0x3ec17f7f, 0x0c8ed857,
  0x3ebf070e, 0x0c9b2a8d, 0x3ebc8c31, 0x0ca77c47,
  0x3eba0ee9, 0x0cb3cd84, 0x3eb78f36, 0x0cc01e43,
  0x3eb50d18, 0x0ccc6e84, 0x3eb2888f, 0x0cd8be47,
  0x3eb0019c, 0x0ce50d8c, 0x3ead783d, 0x0cf15c51,
  0x3eaaec74, 0x0cfdaa96, 0x3ea85e41, 0x0d09f85b,
  0x3ea5cda3, 0x0d1645a0, 0x3ea33a9b, 0x0d229263,
  0x3ea0a529, 0x0d2edea5, 0x3e9e0d4c, 0x0d3b2a64,
  0x3e9b7306, 0x0d4775a1, 0x3e98d655, 0x0d53c05b,
  0x3e96373b, 0x0d600a91, 0x3e9395b7, 0x0d6c5443,
  0x3e90f1ca, 0x0d789d71, 0x3e8e4b72, 0x0d84e61a,
  0x3e8ba2b2, 0x0d912e3e, 0x3e88f788, 0x0d9d75db,
  0x3e8649f5, 0x0da9bcf2, 0x3e8399f9, 0x0db60383,
  0x3e80e794, 0x0dc2498c, 0x3e7e32c6, 0x0dce8f0d,
  0x3e7b7b90, 0x0ddad406, 0x3e78c1f0, 0x0de71876,
  0x3e7605e9, 0x0df35c5d, 0x3e734778, 0x0dff9fba,
  0x3e70869f, 0x0e0be28e, 0x3e6dc35e, 0x0e1824d6,
  0x3e6afdb5, 0x0e246693, 0x3e6835a4, 0x0e30a7c5,
  0x3e656b2b, 0x0e3ce86b, 0x3e629e4a, 0x0e492884,
  0x3e5fcf01, 0x0e556811, 0x3e5cfd51, 0x0e61a70f,
  0x3e5a2939, 0x0e6de580, 0x3e5752ba, 0x0e7a2363,
  0x3e5479d4, 0x0e8660b6, 0x3e519e86, 0x0e929d7a,
  0x3e4ec0d1, 0x0e9ed9af, 0x3e4be0b6, 0x0eab1553,
  0x3e48fe33, 0x0eb75066, 0x3e46194a, 0x0ec38ae8,
  0x3e4331fa, 0x0ecfc4d9, 0x3e404844, 0x0edbfe37,
  0x3e3d5c27, 0x0ee83702, 0x3e3a6da4, 0x0ef46f3b,
  0x3e377cbb, 0x0f00a6df, 0x3e34896c, 0x0f0cddf0,
  0x3e3193b7, 0x0f19146c, 0x3e2e9b9c, 0x0f254a53,
  0x3e2ba11b, 0x0f317fa5, 0x3e28a435, 0x0f3db461,
  0x3e25a4e9, 0x0f49e886, 0x3e22a338, 0x0f561c15,
  0x3e1f9f21, 0x0f624f0c, 0x3e1c98a6, 0x0f6e816b,
  0x3e198fc5, 0x0f7ab332, 0x3e168480, 0x0f86e460,
  0x3e1376d5, 0x0f9314f5, 0x3e1066c7, 0x0f9f44f0,
  0x3e0d5453, 0x0fab7451, 0x3e0a3f7b, 0x0fb7a317,
  0x3e07283f, 0x0fc3d143, 0x3e040e9f, 0x0fcffed2,
  0x3e00f29a, 0x0fdc2bc6, 0x3dfdd432, 0x0fe8581d,
  0x3dfab365, 0x0ff483d7, 0x3df79036, 0x1000aef3,
  0x3df46aa2, 0x100cd972, 0x3df142ab, 0x10190352,
  0x3dee1851, 0x10252c94, 0x3deaeb93, 0x10315535,
  0x3de7bc72, 0x103d7d38, 0x3de48aef, 0x1049a49a,
  0x3de15708, 0x1055cb5b, 0x3dde20bf, 0x1061f17b,
  0x3ddae813, 0x106e16f9, 0x3dd7ad05, 0x107a3bd5,
  0x3dd46f94, 0x1086600e, 0x3dd12fc1, 0x109283a5,
  0x3dcded8c, 0x109ea697, 0x3dcaa8f5, 0x10aac8e6,
  0x3dc761fc, 0x10b6ea90, 0x3dc418a1, 0x10c30b96,
  0x3dc0cce5, 0x10cf2bf6, 0x3dbd7ec7, 0x10db4baf,
  0x3dba2e48, 0x10e76ac3, 0x3db6db68, 0x10f38930,
  0x3db38627, 0x10ffa6f5, 0x3db02e84, 0x110bc413,
  0x3dacd481, 0x1117e088, 0x3da9781d, 0x1123fc55,
  0x3da61959, 0x11301779, 0x3da2b834, 0x113c31f3,
  0x3d9f54af, 0x11484bc2, 0x3d9beec9, 0x115464e8,
  0x3d988684, 0x11607d62, 0x3d951bde, 0x116c9531,
  0x3d91aed9, 0x1178ac53, 0x3d8e3f74, 0x1184c2ca,
  0x3d8acdb0, 0x1190d893, 0x3d87598c, 0x119cedaf,
  0x3d83e309, 0x11a9021d, 0x3d806a27, 0x11b515dd,
  0x3d7ceee5, 0x11c128ee, 0x3d797145, 0x11cd3b50,
  0x3d75f147, 0x11d94d02, 0x3d726ee9, 0x11e55e04,
  0x3d6eea2d, 0x11f16e56, 0x3d6b6313, 0x11fd7df6,
  0x3d67d99b, 0x12098ce5, 0x3d644dc4, 0x12159b22,
  0x3d60bf90, 0x1221a8ac, 0x3d5d2efe, 0x122db583,
  0x3d599c0e, 0x1239c1a7, 0x3d5606c1, 0x1245cd17,
  0x3d526f16, 0x1251d7d3, 0x3d4ed50f, 0x125de1da,
  0x3d4b38aa, 0x1269eb2b, 0x3d4799e8, 0x1275f3c7,
  0x3d43f8c9, 0x1281fbad, 0x3d40554e, 0x128e02dc,
  0x3d3caf76, 0x129a0954, 0x3d390742, 0x12a60f14,
  0x3d355cb1, 0x12b2141c, 0x3d31afc5, 0x12be186c,
  0x3d2e007c, 0x12ca1c03, 0x3d2a4ed8, 0x12d61ee0,
  0x3d269ad8, 0x12e22103, 0x3d22e47c, 0x12ee226c,
  0x3d1f2bc5, 0x12fa231b, 0x3d1b70b3, 0x1306230d,
  0x3d17b346, 0x13122245, 0x3d13f37e, 0x131e20c0,
  0x3d10315a, 0x132a1e7e, 0x3d0c6cdd, 0x13361b7f,
  0x3d08a604, 0x134217c2, 0x3d04dcd2, 0x134e1348,
  0x3d011145, 0x135a0e0e, 0x3cfd435e, 0x13660816,
  0x3cf9731d, 0x1372015f, 0x3cf5a082, 0x137df9e7,
  0x3cf1cb8e, 0x1389f1af, 0x3cedf440, 0x1395e8b7,
  0x3cea1a99, 0x13a1defd, 0x3ce63e98, 0x13add481,
  0x3ce2603f, 0x13b9c943, 0x3cde7f8d, 0x13c5bd42,
  0x3cda9c81, 0x13d1b07e, 0x3cd6b71e, 0x13dda2f7,
  0x3cd2cf62, 0x13e994ab, 0x3ccee54d, 0x13f5859b,
  0x3ccaf8e0, 0x140175c6, 0x3cc70a1c, 0x140d652c,
  0x3cc318ff, 0x141953cb, 0x3cbf258b, 0x142541a4,
  0x3cbb2fbf, 0x14312eb7, 0x3cb7379c, 0x143d1b02,
  0x3cb33d22, 0x14490685, 0x3caf4051, 0x1454f140,
  0x3cab4128, 0x1460db33, 0x3ca73fa9, 0x146cc45c,
  0x3ca33bd3, 0x1478acbc, 0x3c9f35a7, 0x14849452,
  0x3c9b2d24, 0x14907b1d, 0x3c97224c, 0x149c611d,
  0x3c93151d, 0x14a84652, 0x3c8f0598, 0x14b42abb,
  0x3c8af3be, 0x14c00e58, 0x3c86df8e, 0x14cbf127,
  0x3c82c909, 0x14d7d32a, 0x3c7eb02f, 0x14e3b45f,
  0x3c7a94ff, 0x14ef94c6, 0x3c76777b, 0x14fb745e,
  0x3c7257a2, 0x15075327, 0x3c6e3574, 0x15133120,
  0x3c6a10f2, 0x151f0e4a, 0x3c65ea1c, 0x152aeaa3,
  0x3c61c0f1, 0x1536c62b, 0x3c5d9573, 0x1542a0e1,
  0x3c5967a1, 0x154e7ac6, 0x3c55377b, 0x155a53d9,
  0x3c510501, 0x15662c18, 0x3c4cd035, 0x15720385,
  0x3c489915, 0x157dda1e, 0x3c445fa2, 0x1589afe3,
  0x3c4023dd, 0x159584d3, 0x3c3be5c5, 0x15a158ee,
  0x3c37a55a, 0x15ad2c34, 0x3c33629d, 0x15b8fea4,
  0x3c2f1d8e, 0x15c4d03e, 0x3c2ad62d, 0x15d0a100,
  0x3c268c7a, 0x15dc70eb, 0x3c224075, 0x15e83fff,
  0x3c1df21f, 0x15f40e3a, 0x3c19a178, 0x15ffdb9d,
  0x3c154e7f, 0x160ba826, 0x3c10f935, 0x161773d6,
  0x3c0ca19b, 0x16233eac, 0x3c0847b0, 0x162f08a8,
  0x3c03eb74, 0x163ad1c8, 0x3bff8ce8, 0x16469a0d,
  0x3bfb2c0c, 0x16526176, 0x3bf6c8e0, 0x165e2803,
  0x3bf26364, 0x1669edb3, 0x3bedfb99, 0x1675b286,
  0x3be9917e, 0x1681767c, 0x3be52513, 0x168d3993,
  0x3be0b65a, 0x1698fbcb, 0x3bdc4552, 0x16a4bd25,
  0x3bd7d1fa, 0x16b07d9f, 0x3bd35c54, 0x16bc3d39,
  0x3bcee460, 0x16c7fbf3, 0x3bca6a1d, 0x16d3b9cc,
  0x3bc5ed8d, 0x16df76c3, 0x3bc16eae, 0x16eb32d9,
  0x3bbced82, 0x16f6ee0d, 0x3bb86a08, 0x1702a85e,
  0x3bb3e440, 0x170e61cc, 0x3baf5c2c, 0x171a1a56,
  0x3baad1ca, 0x1725d1fc, 0x3ba6451b, 0x173188be,
  0x3ba1b620, 0x173d3e9b, 0x3b9d24d8, 0x1748f393,
  0x3b989144, 0x1754a7a4, 0x3b93fb63, 0x17605ad0,
  0x3b8f6337, 0x176c0d15, 0x3b8ac8bf, 0x1777be72,
  0x3b862bfb, 0x17836ee8, 0x3b818ceb, 0x178f1e76,
  0x3b7ceb90, 0x179acd1c, 0x3b7847eb, 0x17a67ad8,
  0x3b73a1fa, 0x17b227ab, 0x3b6ef9be, 0x17bdd394,
  0x3b6a4f38, 0x17c97e93, 0x3b65a268, 0x17d528a7,
  0x3b60f34d, 0x17e0d1d0, 0x3b5c41e8, 0x17ec7a0d,
  0x3b578e39, 0x17f8215e, 0x3b52d841, 0x1803c7c3,
  0x3b4e1fff, 0x180f6d3a, 0x3b496574, 0x181b11c4,
  0x3b44a8a0, 0x1826b561, 0x3b3fe982, 0x1832580e,
  0x3b3b281c, 0x183df9cd, 0x3b36646e, 0x18499a9d,
  0x3b319e77, 0x18553a7d, 0x3b2cd637, 0x1860d96d,
  0x3b280bb0, 0x186c776c, 0x3b233ee1, 0x1878147a,
  0x3b1e6fca, 0x1883b097, 0x3b199e6c, 0x188f4bc2,
  0x3b14cac6, 0x189ae5fa, 0x3b0ff4d9, 0x18a67f3f,
  0x3b0b1ca6, 0x18b21791, 0x3b06422c, 0x18bdaef0,
  0x3b01656b, 0x18c9455a, 0x3afc8663, 0x18d4dad0,
  0x3af7a516, 0x18e06f50, 0x3af2c183, 0x18ec02db,
  0x3aeddba9, 0x18f79571, 0x3ae8f38b, 0x1903270f,
  0x3ae40926, 0x190eb7b7, 0x3adf1c7d, 0x191a4767,
  0x3ada2d8e, 0x1925d620, 0x3ad53c5b, 0x193163e1,
  0x3ad048e3, 0x193cf0a9, 0x3acb5327, 0x19487c77,
  0x3ac65b26, 0x1954074d, 0x3ac160e1, 0x195f9128,
  0x3abc6458, 0x196b1a09, 0x3ab7658c, 0x1976a1ef,
  0x3ab2647c, 0x198228d9, 0x3aad6129, 0x198daec8,
  0x3aa85b92, 0x199933bb, 0x3aa353b9, 0x19a4b7b1,
  0x3a9e499d, 0x19b03aaa, 0x3a993d3e, 0x19bbbca6,
  0x3a942e9d, 0x19c73da3, 0x3a8f1dba, 0x19d2bda2,
  0x3a8a0a95, 0x19de3ca2, 0x3a84f52f, 0x19e9baa3,
  0x3a7fdd86, 0x19f537a4, 0x3a7ac39d, 0x1a00b3a5,
  0x3a75a772, 0x1a0c2ea5, 0x3a708906, 0x1a17a8a5,
  0x3a6b6859, 0x1a2321a2, 0x3a66456c, 0x1a2e999e,
  0x3a61203e, 0x1a3a1097, 0x3a5bf8d1, 0x1a45868e,
  0x3a56cf23, 0x1a50fb81, 0x3a51a335, 0x1a5c6f70,
  0x3a4c7508, 0x1a67e25c, 0x3a47449c, 0x1a735442,
  0x3a4211f0, 0x1a7ec524, 0x3a3cdd05, 0x1a8a3500,
  0x3a37a5dc, 0x1a95a3d6, 0x3a326c74, 0x1aa111a6,
  0x3a2d30cd, 0x1aac7e6f, 0x3a27f2e9, 0x1ab7ea31,
  0x3a22b2c6, 0x1ac354eb, 0x3a1d7066, 0x1acebe9d,
  0x3a182bc8, 0x1ada2746, 0x3a12e4ed, 0x1ae58ee6,
  0x3a0d9bd4, 0x1af0f57d, 0x3a08507f, 0x1afc5b0a,
  0x3a0302ed, 0x1b07bf8c, 0x39fdb31e, 0x1b132304,
  0x39f86113, 0x1b1e8571, 0x39f30ccc, 0x1b29e6d2,
  0x39edb649, 0x1b354727, 0x39e85d8a, 0x1b40a66f,
  0x39e3028f, 0x1b4c04aa, 0x39dda55a, 0x1b5761d8,
  0x39d845e9, 0x1b62bdf8, 0x39d2e43d, 0x1b6e190a,
  0x39cd8056, 0x1b79730d, 0x39c81a36, 0x1b84cc01,
  0x39c2b1da, 0x1b9023e5, 0x39bd4745, 0x1b9b7ab9,
  0x39b7da76, 0x1ba6d07d, 0x39b26b6d, 0x1bb22530,
  0x39acfa2b, 0x1bbd78d2, 0x39a786af, 0x1bc8cb61,
  0x39a210fb, 0x1bd41cdf, 0x399c990d, 0x1bdf6d4a,
  0x39971ee7, 0x1beabca1, 0x3991a289, 0x1bf60ae6,
  0x398c23f3, 0x1c015816, 0x3986a324, 0x1c0ca432,
  0x3981201e, 0x1c17ef39, 0x397b9ae0, 0x1c23392b,
  0x3976136b, 0x1c2e8207, 0x397089bf, 0x1c39c9cd,
  0x396afddc, 0x1c45107c, 0x39656fc2, 0x1c505614,
  0x395fdf71, 0x1c5b9a95, 0x395a4ceb, 0x1c66ddfe,
  0x3954b82e, 0x1c72204f, 0x394f213c, 0x1c7d6187,
  0x39498814, 0x1c88a1a6, 0x3943ecb6, 0x1c93e0ab,
  0x393e4f23, 0x1c9f1e96, 0x3938af5c, 0x1caa5b66,
  0x39330d5f, 0x1cb5971c, 0x392d692f, 0x1cc0d1b6,
  0x3927c2c9, 0x1ccc0b35, 0x39221a30, 0x1cd74397,
  0x391c6f63, 0x1ce27add, 0x3916c262, 0x1cedb106,
  0x3911132d, 0x1cf8e611, 0x390b61c6, 0x1d0419fe,
  0x3905ae2b, 0x1d0f4ccd, 0x38fff85e, 0x1d1a7e7d,
  0x38fa405e, 0x1d25af0d, 0x38f4862c, 0x1d30de7e,
  0x38eec9c7, 0x1d3c0ccf, 0x38e90b31, 0x1d473a00,
  0x38e34a69, 0x1d52660f, 0x38dd8770, 0x1d5d90fd,
  0x38d7c245, 0x1d68baca, 0x38d1fae9, 0x1d73e374,
  0x38cc315d, 0x1d7f0afb, 0x38c665a0, 0x1d8a315f,
  0x38c097b2, 0x1d9556a0, 0x38bac795, 0x1da07abc,
  0x38b4f547, 0x1dab9db5, 0x38af20ca, 0x1db6bf88,
  0x38a94a1e, 0x1dc1e036, 0x38a37142, 0x1dccffbf,
  0x389d9637, 0x1dd81e21, 0x3897b8fe, 0x1de33b5d,
  0x3891d995, 0x1dee5771, 0x388bf7ff, 0x1df9725f,
  0x3886143b, 0x1e048c24, 0x38802e48, 0x1e0fa4c2,
  0x387a4628, 0x1e1abc36, 0x38745bdb, 0x1e25d282,
  0x386e6f60, 0x1e30e7a4, 0x386880b8, 0x1e3bfb9c,
  0x38628fe4, 0x1e470e69, 0x385c9ce3, 0x1e52200c,
  0x3856a7b6, 0x1e5d3084, 0x3850b05d, 0x1e683fcf,
  0x384ab6d8, 0x1e734def, 0x3844bb28, 0x1e7e5ae2,
  0x383ebd4c, 0x1e8966a8, 0x3838bd45, 0x1e947141,
  0x3832bb13, 0x1e9f7aac, 0x382cb6b7, 0x1eaa82e9,
  0x3826b030, 0x1eb589f7, 0x3820a77f, 0x1ec08fd6,
  0x381a9ca4, 0x1ecb9486, 0x38148f9f, 0x1ed69805,
  0x380e8071, 0x1ee19a54, 0x38086f19, 0x1eec9b73,
  0x38025b98, 0x1ef79b60, 0x37fc45ef, 0x1f029a1c,
  0x37f62e1d, 0x1f0d97a5, 0x37f01423, 0x1f1893fc,
  0x37e9f801, 0x1f238f20, 0x37e3d9b7, 0x1f2e8911,
  0x37ddb945, 0x1f3981ce, 0x37d796ac, 0x1f447957,
  0x37d171eb, 0x1f4f6fab, 0x37cb4b04, 0x1f5a64cb,
  0x37c521f6, 0x1f6558b5, 0x37bef6c2, 0x1f704b69,
  0x37b8c968, 0x1f7b3ce6, 0x37b299e7, 0x1f862d2d,
  0x37ac6841, 0x1f911c3d, 0x37a63476, 0x1f9c0a15,
  0x379ffe85, 0x1fa6f6b6, 0x3799c66f, 0x1fb1e21d,
  0x37938c34, 0x1fbccc4d, 0x378d4fd5, 0x1fc7b542,
  0x37871152, 0x1fd29cff, 0x3780d0aa, 0x1fdd8381,
  0x377a8ddf, 0x1fe868c8, 0x377448f0, 0x1ff34cd5,
  0x376e01de, 0x1ffe2fa6, 0x3767b8a9, 0x2009113c,
  0x37616d51, 0x2013f196, 0x375b1fd7, 0x201ed0b2,
  0x3754d03a, 0x2029ae92, 0x374e7e7b, 0x20348b35,
  0x37482a9a, 0x203f6699, 0x3741d497, 0x204a40bf,
  0x373b7c73, 0x205519a7, 0x3735222f, 0x205ff14f,
  0x372ec5c9, 0x206ac7b8, 0x37286742, 0x20759ce1,
  0x3722069b, 0x208070ca, 0x371ba3d4, 0x208b4372,
  0x37153eee, 0x209614d9, 0x370ed7e7, 0x20a0e4fe,
  0x37086ec1, 0x20abb3e1, 0x3702037c, 0x20b68181,
  0x36fb9618, 0x20c14ddf, 0x36f52695, 0x20cc18f9,
  0x36eeb4f4, 0x20d6e2d0, 0x36e84135, 0x20e1ab63,
  0x36e1cb58, 0x20ec72b1, 0x36db535d, 0x20f738ba,
  0x36d4d945, 0x2101fd7e, 0x36ce5d10, 0x210cc0fc,
  0x36c7debd, 0x21178334, 0x36c15e4e, 0x21224425,
  0x36badbc3, 0x212d03cf, 0x36b4571b, 0x2137c232,
  0x36add058, 0x21427f4d, 0x36a74779, 0x214d3b1f,
  0x36a0bc7e, 0x2157f5a9, 0x369a2f69, 0x2162aeea,
  0x3693a038, 0x216d66e2, 0x368d0eed, 0x21781d8f,
  0x36867b87, 0x2182d2f2, 0x367fe608, 0x218d870b,
  0x36794e6e, 0x219839d8, 0x3672b4bb, 0x21a2eb5a,
  0x366c18ee, 0x21ad9b8f, 0x36657b08, 0x21b84a79,
  0x365edb09, 0x21c2f815, 0x365838f2, 0x21cda465,
  0x365194c3, 0x21d84f66, 0x364aee7b, 0x21e2f91a,
  0x3644461b, 0x21eda17f, 0x363d9ba4, 0x21f84895,
  0x3636ef16, 0x2202ee5d, 0x36304070, 0x220d92d4,
  0x36298fb4, 0x221835fb, 0x3622dce1, 0x2222d7d2,
  0x361c27f7, 0x222d7858, 0x361570f8, 0x2238178d,
  0x360eb7e3, 0x2242b56f, 0x3607fcb8, 0x224d5200,
  0x36013f78, 0x2257ed3e, 0x35fa8023, 0x22628729,
  0x35f3beba, 0x226d1fc1, 0x35ecfb3c, 0x2277b705,
  0x35e635a9, 0x22824cf5, 0x35df6e03, 0x228ce191,
  0x35d8a449, 0x229774d7, 0x35d1d87c, 0x22a206c8,
  0x35cb0a9b, 0x22ac9763, 0x35c43aa7, 0x22b726a8,
  0x35bd68a1, 0x22c1b496, 0x35b69489, 0x22cc412d,
  0x35afbe5e, 0x22d6cc6d, 0x35a8e621, 0x22e15655,
  0x35a20bd3, 0x22ebdee5, 0x359b2f73, 0x22f6661c,
  0x35945103, 0x2300ebf9, 0x358d7081, 0x230b707e,
  0x35868def, 0x2315f3a8, 0x357fa94d, 0x23207579,
  0x3578c29b, 0x232af5ee, 0x3571d9d9, 0x23357509,
  0x356aef08, 0x233ff2c8, 0x35640227, 0x234a6f2b,
  0x355d1337, 0x2354ea32, 0x35562239, 0x235f63dc,
  0x354f2f2c, 0x2369dc29, 0x35483a11, 0x23745318,
  0x354142e9, 0x237ec8aa, 0x353a49b2, 0x23893cdd,
  0x35334e6f, 0x2393afb2, 0x352c511e, 0x239e2127,
  0x352551c0, 0x23a8913d, 0x351e5056, 0x23b2fff3,
  0x35174ce0, 0x23bd6d48, 0x3510475e, 0x23c7d93d,
  0x35093fd0, 0x23d243d1, 0x35023636, 0x23dcad03,
  0x34fb2a92, 0x23e714d3, 0x34f41ce2, 0x23f17b41,
  0x34ed0d28, 0x23fbe04c, 0x34e5fb63, 0x240643f4,
  0x34dee795, 0x2410a639, 0x34d7d1bc, 0x241b0719,
  0x34d0b9da, 0x24256695, 0x34c99fef, 0x242fc4ad,
  0x34c283fb, 0x243a215f, 0x34bb65fe, 0x24447cac,
  0x34b445f8, 0x244ed692, 0x34ad23eb, 0x24592f13,
  0x34a5ffd5, 0x2463862c, 0x349ed9b8, 0x246ddbdf,
  0x3497b194, 0x2478302a, 0x34908768, 0x2482830d,
  0x34895b36, 0x248cd487, 0x34822cfd, 0x24972499,
  0x347afcbe, 0x24a17342, 0x3473ca79, 0x24abc082,
  0x346c962f, 0x24b60c57, 0x34655fdf, 0x24c056c2,
  0x345e2789, 0x24ca9fc2, 0x3456ed2f, 0x24d4e757,
  0x344fb0d1, 0x24df2d81, 0x3448726e, 0x24e9723f,
  0x34413207, 0x24f3b590, 0x3439ef9c, 0x24fdf775,
  0x3432ab2e, 0x250837ed, 0x342b64bd, 0x251276f7,
  0x34241c49, 0x251cb493, 0x341cd1d2, 0x2526f0c1,
  0x34158559, 0x25312b81, 0x340e36dd, 0x253b64d1,
  0x3406e660, 0x25459cb2, 0x33ff93e2, 0x254fd323,
  0x33f83f62, 0x255a0823, 0x33f0e8e2, 0x25643bb3,
  0x33e99061, 0x256e6dd2, 0x33e235df, 0x25789e80,
  0x33dad95e, 0x2582cdbc, 0x33d37adc, 0x258cfb85,
  0x33cc1a5b, 0x259727dc, 0x33c4b7db, 0x25a152c0,
  0x33bd535c, 0x25ab7c30, 0x33b5ecde, 0x25b5a42d,
  0x33ae8462, 0x25bfcab6, 0x33a719e8, 0x25c9efca,
  0x339fad70, 0x25d41369, 0x33983efb, 0x25de3592,
  0x3390ce88, 0x25e85646, 0x33895c18, 0x25f27584,
  0x3381e7ac, 0x25fc934b, 0x337a7144, 0x2606af9c,
  0x3372f8df, 0x2610ca75, 0x336b7e7e, 0x261ae3d6,
  0x33640223, 0x2624fbbf, 0x335c83cb, 0x262f1230,
  0x33550379, 0x26392728, 0x334d812d, 0x26433aa7,
  0x3345fce6, 0x264d4cac, 0x333e76a4, 0x26575d37,
  0x3336ee6a, 0x26616c48, 0x332f6435, 0x266b79dd,
  0x3327d808, 0x267585f8, 0x332049e1, 0x267f9097,
  0x3318b9c2, 0x268999ba, 0x331127ab, 0x2693a161,
  0x3309939c, 0x269da78b, 0x3301fd95, 0x26a7ac38,
  0x32fa6596, 0x26b1af67, 0x32f2cba1, 0x26bbb119,
  0x32eb2fb5, 0x26c5b14c, 0x32e391d2, 0x26cfb000,
  0x32dbf1f8, 0x26d9ad36, 0x32d45029, 0x26e3a8ec,
  0x32ccac64, 0x26eda322, 0x32c506aa, 0x26f79bd8,
  0x32bd5efb, 0x2701930e, 0x32b5b557, 0x270b88c2,
  0x32ae09be, 0x27157cf5, 0x32a65c32, 0x271f6fa6,
  0x329eacb1, 0x272960d6, 0x3296fb3d, 0x27335082,
  0x328f47d5, 0x273d3eac, 0x3287927b, 0x27472b53,
  0x327fdb2d, 0x27511676, 0x327821ee, 0x275b0014,
  0x327066bc, 0x2764e82f, 0x3268a998, 0x276ecec5,
  0x3260ea83, 0x2778b3d5, 0x3259297d, 0x27829760,
  0x32516686, 0x278c7965, 0x3249a19e, 0x279659e3,
  0x3241dac6, 0x27a038db, 0x323a11fe, 0x27aa164c,
  0x32324746, 0x27b3f235, 0x322a7a9e, 0x27bdcc97,
  0x3222ac08, 0x27c7a570, 0x321adb83, 0x27d17cc1,
  0x3213090f, 0x27db5288, 0x320b34ad, 0x27e526c6,
  0x32035e5d, 0x27eef97b, 0x31fb8620, 0x27f8caa5,
  0x31f3abf5, 0x28029a45, 0x31ebcfdd, 0x280c685a,
  0x31e3f1d8, 0x281634e4, 0x31dc11e8, 0x281fffe2,
  0x31d4300b, 0x2829c954, 0x31cc4c42, 0x2833913a,
  0x31c4668d, 0x283d5793, 0x31bc7eee, 0x28471c5e,
  0x31b49564, 0x2850df9d, 0x31aca9ef, 0x285aa14d,
  0x31a4bc90, 0x2864616f, 0x319ccd46, 0x286e2002,
  0x3194dc14, 0x2877dd07, 0x318ce8f7, 0x2881987c,
  0x3184f3f2, 0x288b5261, 0x317cfd04, 0x28950ab6,
  0x3175042e, 0x289ec17a, 0x316d096f, 0x28a876ae,
  0x31650cc9, 0x28b22a50, 0x315d0e3b, 0x28bbdc61,
  0x31550dc6, 0x28c58cdf, 0x314d0b6a, 0x28cf3bcc,
  0x31450728, 0x28d8e925, 0x313d00ff, 0x28e294eb,
  0x3134f8f1, 0x28ec3f1e, 0x312ceefc, 0x28f5e7bd,
  0x3124e322, 0x28ff8ec8, 0x311cd564, 0x2909343e,
  0x3114c5c0, 0x2912d81f, 0x310cb438, 0x291c7a6a,
  0x3104a0cc, 0x29261b20, 0x30fc8b7d, 0x292fba40,
  0x30f47449, 0x293957c9, 0x30ec5b33, 0x2942f3bb,
  0x30e4403a, 0x294c8e16, 0x30dc235e, 0x295626da,
  0x30d404a0, 0x295fbe06, 0x30cbe400, 0x29695399,
  0x30c3c17e, 0x2972e793, 0x30bb9d1c, 0x297c79f5,
  0x30b376d8, 0x29860abd, 0x30ab4eb3, 0x298f99eb,
  0x30a324af, 0x2999277f, 0x309af8ca, 0x29a2b378,
  0x3092cb05, 0x29ac3dd7, 0x308a9b61, 0x29b5c69a,
  0x308269de, 0x29bf4dc1, 0x307a367c, 0x29c8d34d,
  0x3072013c, 0x29d2573c, 0x3069ca1e, 0x29dbd98e,
  0x30619121, 0x29e55a43, 0x30595648, 0x29eed95b,
  0x30511991, 0x29f856d5, 0x3048dafd, 0x2a01d2b0,
  0x30409a8d, 0x2a0b4ced, 0x30385840, 0x2a14c58b,
  0x30301418, 0x2a1e3c8a, 0x3027ce14, 0x2a27b1e9,
  0x301f8634, 0x2a3125a8, 0x30173c7a, 0x2a3a97c7,
  0x300ef0e5, 0x2a440844, 0x3006a376, 0x2a4d7721,
  0x2ffe542d, 0x2a56e45c, 0x2ff6030a, 0x2a604ff5,
  0x2fedb00d, 0x2a69b9ec, 0x2fe55b38, 0x2a732241,
  0x2fdd048a, 0x2a7c88f2, 0x2fd4ac04, 0x2a85ee00,
  0x2fcc51a5, 0x2a8f516b, 0x2fc3f56f, 0x2a98b331,
  0x2fbb9761, 0x2aa21353, 0x2fb3377c, 0x2aab71d0,
  0x2faad5c1, 0x2ab4cea9, 0x2fa2722f, 0x2abe29db,
  0x2f9a0cc7, 0x2ac78368, 0x2f91a589, 0x2ad0db4e,
  0x2f893c75, 0x2ada318e, 0x2f80d18d, 0x2ae38627,
  0x2f7864cf, 0x2aecd919, 0x2f6ff63d, 0x2af62a63,
  0x2f6785d7, 0x2aff7a05, 0x2f5f139d, 0x2b08c7ff,
  0x2f569f90, 0x2b121450, 0x2f4e29af, 0x2b1b5ef8,
  0x2f45b1fb, 0x2b24a7f6, 0x2f3d3875, 0x2b2def4b,
  0x2f34bd1d, 0x2b3734f5, 0x2f2c3ff2, 0x2b4078f5,
  0x2f23c0f6, 0x2b49bb4a, 0x2f1b4029, 0x2b52fbf4,
  0x2f12bd8b, 0x2b5c3af2, 0x2f0a391d, 0x2b657844,
  0x2f01b2de, 0x2b6eb3ea, 0x2ef92acf, 0x2b77ede3,
  0x2ef0a0f0, 0x2b812630, 0x2ee81543, 0x2b8a5cce,
  0x2edf87c6, 0x2b9391c0, 0x2ed6f87a, 0x2b9cc503,
  0x2ece6761, 0x2ba5f697, 0x2ec5d479, 0x2baf267d,
  0x2ebd3fc4, 0x2bb854b4, 0x2eb4a942, 0x2bc1813b,
  0x2eac10f2, 0x2bcaac12, 0x2ea376d6, 0x2bd3d53a,
  0x2e9adaee, 0x2bdcfcb0, 0x2e923d39, 0x2be62276,
  0x2e899db9, 0x2bef468a, 0x2e80fc6e, 0x2bf868ed,
  0x2e785958, 0x2c01899e, 0x2e6fb477, 0x2c0aa89c,
  0x2e670dcb, 0x2c13c5e8, 0x2e5e6556, 0x2c1ce181,
  0x2e55bb17, 0x2c25fb66, 0x2e4d0f0f, 0x2c2f1398,
  0x2e44613e, 0x2c382a16, 0x2e3bb1a4, 0x2c413edf,
  0x2e330042, 0x2c4a51f3, 0x2e2a4d18, 0x2c536353,
  0x2e219826, 0x2c5c72fd, 0x2e18e16d, 0x2c6580f1,
  0x2e1028ed, 0x2c6e8d2e, 0x2e076ea7, 0x2c7797b6,
  0x2dfeb29a, 0x2c80a086, 0x2df5f4c7, 0x2c89a79f,
  0x2ded352f, 0x2c92ad01, 0x2de473d1, 0x2c9bb0ab,
  0x2ddbb0ae, 0x2ca4b29c, 0x2dd2ebc7, 0x2cadb2d5,
  0x2dca251c, 0x2cb6b155, 0x2dc15cac, 0x2cbfae1b,
  0x2db89279, 0x2cc8a928, 0x2dafc683, 0x2cd1a27b,
  0x2da6f8ca, 0x2cda9a14, 0x2d9e294e, 0x2ce38ff1,
  0x2d955810, 0x2cec8414, 0x2d8c8510, 0x2cf5767c,
  0x2d83b04f, 0x2cfe6728, 0x2d7ad9cc, 0x2d075617,
  0x2d720189, 0x2d10434a, 0x2d692784, 0x2d192ec1,
  0x2d604bc0, 0x2d22187a, 0x2d576e3c, 0x2d2b0076,
  0x2d4e8ef9, 0x2d33e6b4, 0x2d45adf6, 0x2d3ccb34,
  0x1ffffd88, 0xfff36f03, 0x1fffe9cb, 0xffda4d10,
  0x1fffc251, 0xffc12b34, 0x1fff8719, 0xffa8097f,
  0x1fff3825, 0xff8ee800, 0x1ffed574, 0xff75c6c8,
  0x1ffe5f06, 0xff5ca5e4, 0x1ffdd4dc, 0xff438565,
  0x1ffd36f6, 0xff2a655a, 0x1ffc8555, 0xff1145d4,
  0x1ffbbff8, 0xfef826e0, 0x1ffae6e1, 0xfedf088f,
  0x1ff9fa10, 0xfec5eaf1, 0x1ff8f986, 0xfeacce14,
  0x1ff7e542, 0xfe93b208, 0x1ff6bd46, 0xfe7a96dd,
  0x1ff58193, 0xfe617ca3, 0x1ff43229, 0xfe486368,
  0x1ff2cf09, 0xfe2f4b3c, 0x1ff15834, 0xfe16342f,
  0x1fefcdaa, 0xfdfd1e50, 0x1fee2f6e, 0xfde409ae,
  0x1fec7d7f, 0xfdcaf65a, 0x1feab7df, 0xfdb1e462,
  0x1fe8de8f, 0xfd98d3d6, 0x1fe6f190, 0xfd7fc4c6,
  0x1fe4f0e3, 0xfd66b740, 0x1fe2dc8a, 0xfd4dab55,
  0x1fe0b485, 0xfd34a114, 0x1fde78d7, 0xfd1b988c,
  0x1fdc297f, 0xfd0291cd, 0x1fd9c681, 0xfce98ce6,
  0x1fd74fdd, 0xfcd089e7, 0x1fd4c595, 0xfcb788de,
  0x1fd227ab, 0xfc9e89dc, 0x1fcf761f, 0xfc858cf0,
  0x1fccb0f4, 0xfc6c9229, 0x1fc9d82c, 0xfc539997,
  0x1fc6ebc7, 0xfc3aa349, 0x1fc3ebc9, 0xfc21af4e,
  0x1fc0d833, 0xfc08bdb7, 0x1fbdb106, 0xfbefce91,
  0x1fba7645, 0xfbd6e1ed, 0x1fb727f2, 0xfbbdf7db,
  0x1fb3c60e, 0xfba51068, 0x1fb0509c, 0xfb8c2ba5,
  0x1facc79e, 0xfb7349a2, 0x1fa92b16, 0xfb5a6a6d,
  0x1fa57b06, 0xfb418e15, 0x1fa1b771, 0xfb28b4ab,
  0x1f9de059, 0xfb0fde3d, 0x1f99f5c1, 0xfaf70adb,
  0x1f95f7aa, 0xfade3a95, 0x1f91e617, 0xfac56d78,
  0x1f8dc10b, 0xfaaca395, 0x1f898888, 0xfa93dcfc,
  0x1f853c91, 0xfa7b19ba, 0x1f80dd28, 0xfa6259e0,
  0x1f7c6a51, 0xfa499d7d, 0x1f77e40d, 0xfa30e4a0,
  0x1f734a60, 0xfa182f58, 0x1f6e9d4d, 0xf9ff7db5,
  0x1f69dcd6, 0xf9e6cfc6, 0x1f6508ff, 0xf9ce2599,
  0x1f6021ca, 0xf9b57f3f, 0x1f5b273a, 0xf99cdcc6,
  0x1f561953, 0xf9843e3e, 0x1f50f818, 0xf96ba3b6,
  0x1f4bc38b, 0xf9530d3d, 0x1f467bb0, 0xf93a7ae2,
  0x1f41208a, 0xf921ecb4, 0x1f3bb21d, 0xf90962c3,
  0x1f36306b, 0xf8f0dd1d, 0x1f309b79, 0xf8d85bd2,
  0x1f2af34a, 0xf8bfdef1, 0x1f2537e1, 0xf8a76689,
  0x1f1f6941, 0xf88ef2a9, 0x1f19876f, 0xf8768360,
  0x1f13926e, 0xf85e18bd, 0x1f0d8a41, 0xf845b2cf,
  0x1f076eed, 0xf82d51a6, 0x1f014074, 0xf814f550,
  0x1efafedc, 0xf7fc9ddd, 0x1ef4aa28, 0xf7e44b5b,
  0x1eee425b, 0xf7cbfdd9, 0x1ee7c779, 0xf7b3b567,
  0x1ee13988, 0xf79b7213, 0x1eda988a, 0xf78333ec,
  0x1ed3e484, 0xf76afb02, 0x1ecd1d79, 0xf752c763,
  0x1ec6436f, 0xf73a991e, 0x1ebf5669, 0xf7227042,
  0x1eb8566c, 0xf70a4cde, 0x1eb1437b, 0xf6f22f01,
  0x1eaa1d9c, 0xf6da16ba, 0x1ea2e4d2, 0xf6c20418,
  0x1e9b9923, 0xf6a9f728, 0x1e943a92, 0xf691effb,
  0x1e8cc924, 0xf679eea0, 0x1e8544de, 0xf661f324,
  0x1e7dadc4, 0xf649fd97, 0x1e7603dc, 0xf6320e07,
  0x1e6e4729, 0xf61a2484, 0x1e6677b1, 0xf602411b,
  0x1e5e9578, 0xf5ea63dd, 0x1e56a084, 0xf5d28cd7,
  0x1e4e98d8, 0xf5babc18, 0x1e467e7b, 0xf5a2f1af,
  0x1e3e5171, 0xf58b2daa, 0x1e3611bf, 0xf5737019,
  0x1e2dbf6a, 0xf55bb909, 0x1e255a78, 0xf544088a,
  0x1e1ce2ed, 0xf52c5eaa, 0x1e1458cf, 0xf514bb78,
  0x1e0bbc23, 0xf4fd1f02, 0x1e030cee, 0xf4e58956,
  0x1dfa4b36, 0xf4cdfa85, 0x1df17700, 0xf4b6729b,
  0x1de89052, 0xf49ef1a7, 0x1ddf9731, 0xf48777b8,
  0x1dd68ba2, 0xf47004dd, 0x1dcd6dac, 0xf4589924,
  0x1dc43d53, 0xf441349b, 0x1dbafa9e, 0xf429d751,
  0x1db1a592, 0xf4128153, 0x1da83e35, 0xf3fb32b2,
  0x1d9ec48c, 0xf3e3eb7a, 0x1d95389e, 0xf3ccabbb,
  0x1d8b9a71, 0xf3b57382, 0x1d81ea0a, 0xf39e42de,
  0x1d78276f, 0xf38719de, 0x1d6e52a7, 0xf36ff88f,
  0x1d646bb7, 0xf358deff, 0x1d5a72a6, 0xf341cd3e,
  0x1d50677a, 0xf32ac359, 0x1d464a38, 0xf313c15f,
  0x1d3c1ae8, 0xf2fcc75d, 0x1d31d98f, 0xf2e5d562,
  0x1d278633, 0xf2ceeb7d, 0x1d1d20dc, 0xf2b809ba,
  0x1d12a990, 0xf2a13029, 0x1d082054, 0xf28a5ed7,
  0x1cfd8530, 0xf27395d2, 0x1cf2d82a, 0xf25cd529,
  0x1ce81949, 0xf2461ce9, 0x1cdd4892, 0xf22f6d21,
  0x1cd2660e, 0xf218c5df, 0x1cc771c2, 0xf2022730,
  0x1cbc6bb6, 0xf1eb9122, 0x1cb153f0, 0xf1d503c4,
  0x1ca62a77, 0xf1be7f23, 0x1c9aef52, 0xf1a8034e,
  0x1c8fa288, 0xf1919051, 0x1c84441f, 0xf17b263b,
  0x1c78d420, 0xf164c51b, 0x1c6d5290, 0xf14e6cfc,
  0x1c61bf77, 0xf1381dee, 0x1c561add, 0xf121d7fe,
  0x1c4a64c8, 0xf10b9b3a, 0x1c3e9d3f, 0xf0f567af,
  0x1c32c44a, 0xf0df3d6c, 0x1c26d9f0, 0xf0c91c7e,
  0x1c1ade39, 0xf0b304f2, 0x1c0ed12b, 0xf09cf6d6,
  0x1c02b2cf, 0xf086f238, 0x1bf6832b, 0xf070f726,
  0x1bea4248, 0xf05b05ac, 0x1bddf02d, 0xf0451dd9,
  0x1bd18ce1, 0xf02f3fba, 0x1bc5186c, 0xf0196b5c,
  0x1bb892d6, 0xf003a0cd, 0x1babfc26, 0xefede01b,
  0x1b9f5465, 0xefd82952, 0x1b929b99, 0xefc27c81,
  0x1b85d1cc, 0xefacd9b4, 0x1b78f704, 0xef9740f9,
  0x1b6c0b4a, 0xef81b25e, 0x1b5f0ea6, 0xef6c2def,
  0x1b520120, 0xef56b3b9, 0x1b44e2bf, 0xef4143cb,
  0x1b37b38c, 0xef2bde31, 0x1b2a738f, 0xef1682f8,
  0x1b1d22d0, 0xef01322f, 0x1b0fc157, 0xeeebebe0,
  0x1b024f2d, 0xeed6b01b, 0x1af4cc5b, 0xeec17eec,
  0x1ae738e7, 0xeeac5860, 0x1ad994db, 0xee973c84,
  0x1acbe03f, 0xee822b65, 0x1abe1b1b, 0xee6d2511,
  0x1ab04578, 0xee582993, 0x1aa25f5f, 0xee4338f9,
  0x1a9468d8, 0xee2e5351, 0x1a8661ec, 0xee1978a6,
  0x1a784aa3, 0xee04a906, 0x1a6a2306, 0xedefe47e,
  0x1a5beb1e, 0xeddb2b1a, 0x1a4da2f4, 0xedc67ce7,
  0x1a3f4a8f, 0xedb1d9f3, 0x1a30e1fa, 0xed9d4248,
  0x1a22693d, 0xed88b5f5, 0x1a13e061, 0xed743507,
  0x1a054770, 0xed5fbf88, 0x19f69e71, 0xed4b5588,
  0x19e7e56e, 0xed36f711, 0x19d91c70, 0xed22a430,
  0x19ca4381, 0xed0e5cf2, 0x19bb5aa8, 0xecfa2164,
  0x19ac61f1, 0xece5f192, 0x199d5963, 0xecd1cd89,
  0x198e4109, 0xecbdb554, 0x197f18ea, 0xeca9a900,
  0x196fe112, 0xec95a89a, 0x19609989, 0xec81b42f,
  0x19514258, 0xec6dcbc9, 0x1941db89, 0xec59ef76,
  0x19326526, 0xec461f41, 0x1922df38, 0xec325b38,
  0x191349c9, 0xec1ea366, 0x1903a4e1, 0xec0af7d7,
  0x18f3f08c, 0xebf75898, 0x18e42cd3, 0xebe3c5b4,
  0x18d459be, 0xebd03f38, 0x18c47759, 0xebbcc530,
  0x18b485ad, 0xeba957a7, 0x18a484c3, 0xeb95f6ab,
  0x189474a6, 0xeb82a246, 0x1884555f, 0xeb6f5a84,
  0x187426f9, 0xeb5c1f72, 0x1863e97e, 0xeb48f11b,
  0x18539cf6, 0xeb35cf8c, 0x1843416e, 0xeb22bad0,
  0x1832d6ee, 0xeb0fb2f2, 0x18225d80, 0xeafcb7ff,
  0x1811d530, 0xeae9ca02, 0x18013e06, 0xead6e907,
  0x17f0980e, 0xeac41519, 0x17dfe351, 0xeab14e45,
  0x17cf1fdb, 0xea9e9495, 0x17be4db4, 0xea8be815,
  0x17ad6ce8, 0xea7948d2, 0x179c7d82, 0xea66b6d5,
  0x178b7f8a, 0xea54322c, 0x177a730d, 0xea41bae0,
  0x17695814, 0xea2f50ff, 0x17582eaa, 0xea1cf492,
  0x1746f6d9, 0xea0aa5a5, 0x1735b0ad, 0xe9f86444,
  0x17245c30, 0xe9e63079, 0x1712f96c, 0xe9d40a51,
  0x1701886d, 0xe9c1f1d6, 0x16f0093c, 0xe9afe713,
  0x16de7be6, 0xe99dea14, 0x16cce074, 0xe98bfae3,
  0x16bb36f1, 0xe97a198c, 0x16a97f69, 0xe9684619,
  0x1697b9e7, 0xe9568097, 0x1685e674, 0xe944c90f,
  0x1674051d, 0xe9331f8c, 0x166215ec, 0xe921841a,
  0x165018ed, 0xe90ff6c4, 0x163e0e2a, 0xe8fe7793,
  0x162bf5af, 0xe8ed0694, 0x1619cf87, 0xe8dba3d0,
  0x16079bbc, 0xe8ca4f53, 0x15f55a5b, 0xe8b90927,
  0x15e30b6e, 0xe8a7d156, 0x15d0af01, 0xe896a7ec,
  0x15be4520, 0xe8858cf3, 0x15abcdd4, 0xe8748076,
  0x1599492b, 0xe863827e, 0x1586b72e, 0xe8529318,
  0x157417eb, 0xe841b24c, 0x15616b6b, 0xe830e025,
  0x154eb1bb, 0xe8201caf, 0x153beae7, 0xe80f67f2,
  0x152916f9, 0xe7fec1fa, 0x151635fe, 0xe7ee2ad0,
  0x15034801, 0xe7dda280, 0x14f04d0e, 0xe7cd2912,
  0x14dd4530, 0xe7bcbe92, 0x14ca3074, 0xe7ac630a,
  0x14b70ee5, 0xe79c1682, 0x14a3e08e, 0xe78bd907,
  0x1490a57c, 0xe77baaa1, 0x147d5dba, 0xe76b8b5a,
  0x146a0955, 0xe75b7b3d, 0x1456a859, 0xe74b7a53,
  0x14433ad0, 0xe73b88a7, 0x142fc0c8, 0xe72ba642,
  0x141c3a4c, 0xe71bd32d, 0x1408a768, 0xe70c0f74,
  0x13f50829, 0xe6fc5b1f, 0x13e15c9a, 0xe6ecb637,
  0x13cda4c8, 0xe6dd20c8, 0x13b9e0bf, 0xe6cd9ada,
  0x13a6108a, 0xe6be2477, 0x13923437, 0xe6aebda8,
  0x137e4bd1, 0xe69f6677, 0x136a5766, 0xe6901eee,
  0x13565700, 0xe680e716, 0x13424aac, 0xe671bef7,
  0x132e3277, 0xe662a69d, 0x131a0e6e, 0xe6539e0f,
  0x1305de9c, 0xe644a558, 0x12f1a30e, 0xe635bc7f,
  0x12dd5bd0, 0xe626e390, 0x12c908ef, 0xe6181a92,
  0x12b4aa78, 0xe609618f, 0x12a04078, 0xe5fab890,
  0x128bcaf9, 0xe5ec1f9f, 0x12774a0b, 0xe5dd96c3,
  0x1262bdb8, 0xe5cf1e06, 0x124e260d, 0xe5c0b571,
  0x12398319, 0xe5b25d0c, 0x1224d4e6, 0xe5a414e2,
  0x12101b82, 0xe595dcfa, 0x11fb56fa, 0xe587b55d,
  0x11e6875a, 0xe5799e14, 0x11d1acaf, 0xe56b9728,
  0x11bcc707, 0xe55da0a1, 0x11a7d66d, 0xe54fba88,
  0x1192daef, 0xe541e4e5, 0x117dd49b, 0xe5341fc1,
  0x1168c37c, 0xe5266b25, 0x1153a7a0, 0xe518c719,
  0x113e8114, 0xe50b33a5, 0x11294fe5, 0xe4fdb0d3,
  0x11141420, 0xe4f03ea9, 0x10fecdd1, 0xe4e2dd30,
  0x10e97d08, 0xe4d58c71, 0x10d421cf, 0xe4c84c74,
  0x10bebc35, 0xe4bb1d41, 0x10a94c47, 0xe4adfee0,
  0x1093d211, 0xe4a0f15a, 0x107e4da2, 0xe493f4b6,
  0x1068bf07, 0xe48708fc, 0x1053264c, 0xe47a2e34,
  0x103d837f, 0xe46d6467, 0x1027d6ae, 0xe460ab9b,
  0x10121fe5, 0xe45403da, 0x0ffc5f33, 0xe4476d2a,
  0x0fe694a4, 0xe43ae794, 0x0fd0c046, 0xe42e731f,
  0x0fbae227, 0xe4220fd3, 0x0fa4fa54, 0xe415bdb8,
  0x0f8f08da, 0xe4097cd5, 0x0f790dc8, 0xe3fd4d31,
  0x0f63092a, 0xe3f12ed5, 0x0f4cfb0e, 0xe3e521c7,
  0x0f36e382, 0xe3d92610, 0x0f20c294, 0xe3cd3bb6,
  0x0f0a9851, 0xe3c162c1, 0x0ef464c6, 0xe3b59b38,
  0x0ede2802, 0xe3a9e523, 0x0ec7e212, 0xe39e4089,
  0x0eb19304, 0xe392ad70, 0x0e9b3ae5, 0xe3872be0,
  0x0e84d9c5, 0xe37bbbe1, 0x0e6e6faf, 0xe3705d78,
  0x0e57fcb2, 0xe36510ae, 0x0e4180dd, 0xe359d589,
  0x0e2afc3c, 0xe34eac10, 0x0e146ede, 0xe343944a,
  0x0dfdd8d0, 0xe3388e3e, 0x0de73a21, 0xe32d99f2,
  0x0dd092df, 0xe322b76e, 0x0db9e317, 0xe317e6b7,
  0x0da32ad7, 0xe30d27d6, 0x0d8c6a2e, 0xe3027ad0,
  0x0d75a129, 0xe2f7dfac, 0x0d5ecfd7, 0xe2ed5670,
  0x0d47f646, 0xe2e2df24, 0x0d311483, 0xe2d879cd,
  0x0d1a2a9e, 0xe2ce2671, 0x0d0338a3, 0xe2c3e518,
  0x0cec3ea1, 0xe2b9b5c8, 0x0cd53ca7, 0xe2af9886,
  0x0cbe32c2, 0xe2a58d5a, 0x0ca72101, 0xe29b9449,
  0x0c900771, 0xe291ad59, 0x0c78e622, 0xe287d891,
  0x0c61bd22, 0xe27e15f6, 0x0c4a8c7e, 0xe274658f,
  0x0c335445, 0xe26ac762, 0x0c1c1486, 0xe2613b74,
  0x0c04cd4e, 0xe257c1cb, 0x0bed7ead, 0xe24e5a6e,
  0x0bd628af, 0xe2450562, 0x0bbecb65, 0xe23bc2ad,
  0x0ba766dc, 0xe2329254, 0x0b8ffb23, 0xe229745e,
  0x0b788848, 0xe22068cf, 0x0b610e59, 0xe2176fae,
  0x0b498d65, 0xe20e8900, 0x0b32057b, 0xe205b4ca,
  0x0b1a76aa, 0xe1fcf312, 0x0b02e0fe, 0xe1f443dd,
  0x0aeb4488, 0xe1eba731, 0x0ad3a156, 0xe1e31d13,
  0x0abbf776, 0xe1daa588, 0x0aa446f7, 0xe1d24096,
  0x0a8c8fe7, 0xe1c9ee41, 0x0a74d256, 0xe1c1ae8f,
  0x0a5d0e51, 0xe1b98185, 0x0a4543e8, 0xe1b16728,
  0x0a2d7329, 0xe1a95f7c, 0x0a159c23, 0xe1a16a88,
  0x09fdbee5, 0xe199884f, 0x09e5db7c, 0xe191b8d7,
  0x09cdf1f9, 0xe189fc24, 0x09b60269, 0xe182523c,
  0x099e0cdc, 0xe17abb22, 0x09861160, 0xe17336dc,
  0x096e1005, 0xe16bc56e, 0x095608d8, 0xe16466dd,
  0x093dfbe8, 0xe15d1b2e, 0x0925e946, 0xe155e264,
  0x090dd0ff, 0xe14ebc85, 0x08f5b322, 0xe147a994,
  0x08dd8fbe, 0xe140a997, 0x08c566e2, 0xe139bc91,
  0x08ad389d, 0xe132e287, 0x089504fe, 0xe12c1b7c,
  0x087ccc14, 0xe1256776, 0x08648ded, 0xe11ec678,
  0x084c4a99, 0xe1183887, 0x08340227, 0xe111bda5,
  0x081bb4a5, 0xe10b55d8, 0x08036223, 0xe1050124,
  0x07eb0ab0, 0xe0febf8c, 0x07d2ae5a, 0xe0f89113,
  0x07ba4d31, 0xe0f275bf, 0x07a1e743, 0xe0ec6d92,
  0x07897ca0, 0xe0e67891, 0x07710d57, 0xe0e096bf,
  0x07589977, 0xe0dac81f, 0x0740210f, 0xe0d50cb6,
  0x0727a42e, 0xe0cf6487, 0x070f22e3, 0xe0c9cf95,
  0x06f69d3d, 0xe0c44de3, 0x06de134c, 0xe0bedf76,
  0x06c5851e, 0xe0b98450, 0x06acf2c3, 0xe0b43c75,
  0x06945c4a, 0xe0af07e8, 0x067bc1c2, 0xe0a9e6ad,
  0x0663233a, 0xe0a4d8c6, 0x064a80c1, 0xe09fde36,
  0x0631da67, 0xe09af701, 0x0619303a, 0xe096232a,
  0x0600824b, 0xe09162b3, 0x05e7d0a8, 0xe08cb5a0,
  0x05cf1b60, 0xe0881bf3, 0x05b66283, 0xe08395af,
  0x059da620, 0xe07f22d8, 0x0584e646, 0xe07ac36f,
  0x056c2304, 0xe0767778, 0x05535c6b, 0xe0723ef5,
  0x053a9288, 0xe06e19e9, 0x0521c56b, 0xe06a0856,
  0x0508f525, 0xe0660a3f, 0x04f021c3, 0xe0621fa7,
  0x04d74b55, 0xe05e488f, 0x04be71eb, 0xe05a84fa,
  0x04a59593, 0xe056d4ea, 0x048cb65e, 0xe0533862,
  0x0473d45b, 0xe04faf64, 0x045aef98, 0xe04c39f2,
  0x04420825, 0xe048d80e, 0x04291e13, 0xe04589bb,
  0x0410316f, 0xe0424efa, 0x03f74249, 0xe03f27cd,
  0x03de50b2, 0xe03c1437, 0x03c55cb7, 0xe0391439,
  0x03ac6669, 0xe03627d4, 0x03936dd7, 0xe0334f0c,
  0x037a7310, 0xe03089e1, 0x03617624, 0xe02dd855,
  0x03487722, 0xe02b3a6b, 0x032f7619, 0xe028b023,
  0x0316731a, 0xe026397f, 0x02fd6e33, 0xe023d681,
  0x02e46774, 0xe0218729, 0x02cb5eec, 0xe01f4b7b,
  0x02b254ab, 0xe01d2376, 0x029948c0, 0xe01b0f1d,
  0x02803b3a, 0xe0190e70, 0x02672c2a, 0xe0172171,
  0x024e1b9e, 0xe0154821, 0x023509a6, 0xe0138281,
  0x021bf652, 0xe011d092, 0x0202e1b0, 0xe0103256,
  0x01e9cbd1, 0xe00ea7cc, 0x01d0b4c4, 0xe00d30f7,
  0x01b79c98, 0xe00bcdd7, 0x019e835d, 0xe00a7e6d,
  0x01856923, 0xe00942ba, 0x016c4df8, 0xe0081abe,
  0x015331ec, 0xe007067a, 0x013a150f, 0xe00605f0,
  0x0120f771, 0xe005191f, 0x0107d920, 0xe0044008,
  0x00eeba2c, 0xe0037aab, 0x00d59aa6, 0xe002c90a,
  0x00bc7a9b, 0xe0022b24, 0x00a35a1c, 0xe001a0fa,
  0x008a3938, 0xe0012a8c, 0x00711800, 0xe000c7db,
  0x0057f681, 0xe00078e7, 0x003ed4cc, 0xe0003daf,
  0x0025b2f0, 0xe0001635, 0x000c90fd, 0xe0000278,
};

static ogg_int16_t bitrevlook_4096[1024]={
  0x07fe, 0x0000, 0x03fe, 0x0400,
  0x05fe, 0x0200, 0x01fe, 0x0600,
  0x06fe, 0x0100, 0x02fe, 0x0500,
  0x04fe, 0x0300, 0x00fe, 0x0700,
  0x077e, 0x0080, 0x037e, 0x0480,
  0x057e, 0x0280, 0x017e, 0x0680,
  0x067e, 0x0180, 0x027e, 0x0580,
  0x047e, 0x0380, 0x007e, 0x0780,
  0x07be, 0x0040, 0x03be, 0x0440,
  0x05be, 0x0240, 0x01be, 0x0640,
  0x06be, 0x0140, 0x02be, 0x0540,
  0x04be, 0x0340, 0x00be, 0x0740,
  0x073e, 0x00c0, 0x033e, 0x04c0,
  0x053e, 0x02c0, 0x013e, 0x06c0,
  0x063e, 0x01c0, 0x023e, 0x05c0,
  0x043e, 0x03c0, 0x003e, 0x07c0,
  0x07de, 0x0020, 0x03de, 0x0420,
  0x05de, 0x0220, 0x01de, 0x0620,
  0x06de, 0x0120, 0x02de, 0x0520,
  0x04de, 0x0320, 0x00de, 0x0720,
  0x075e, 0x00a0, 0x035e, 0x04a0,
  0x055e, 0x02a0, 0x015e, 0x06a0,
  0x065e, 0x01a0, 0x025e, 0x05a0,
  0x045e, 0x03a0, 0x005e, 0x07a0,
  0x079e, 0x0060, 0x039e, 0x0460,
  0x059e, 0x0260, 0x019e, 0x0660,
  0x069e, 0x0160, 0x029e, 0x0560,
  0x049e, 0x0360, 0x009e, 0x0760,
  0x071e, 0x00e0, 0x031e, 0x04e0,
  0x051e, 0x02e0, 0x011e, 0x06e0,
  0x061e, 0x01e0, 0x021e, 0x05e0,
  0x041e, 0x03e0, 0x001e, 0x07e0,
  0x07ee, 0x0010, 0x03ee, 0x0410,
  0x05ee, 0x0210, 0x01ee, 0x0610,
  0x06ee, 0x0110, 0x02ee, 0x0510,
  0x04ee, 0x0310, 0x00ee, 0x0710,
  0x076e, 0x0090, 0x036e, 0x0490,
  0x056e, 0x0290, 0x016e, 0x0690,
  0x066e, 0x0190, 0x026e, 0x0590,
  0x046e, 0x0390, 0x006e, 0x0790,
  0x07ae, 0x0050, 0x03ae, 0x0450,
  0x05ae, 0x0250, 0x01ae, 0x0650,
  0x06ae, 0x0150, 0x02ae, 0x0550,
  0x04ae, 0x0350, 0x00ae, 0x0750,
  0x072e, 0x00d0, 0x032e, 0x04d0,
  0x052e, 0x02d0, 0x012e, 0x06d0,
  0x062e, 0x01d0, 0x022e, 0x05d0,
  0x042e, 0x03d0, 0x002e, 0x07d0,
  0x07ce, 0x0030, 0x03ce, 0x0430,
  0x05ce, 0x0230, 0x01ce, 0x0630,
  0x06ce, 0x0130, 0x02ce, 0x0530,
  0x04ce, 0x0330, 0x00ce, 0x0730,
  0x074e, 0x00b0, 0x034e, 0x04b0,
  0x054e, 0x02b0, 0x014e, 0x06b0,
  0x064e, 0x01b0, 0x024e, 0x05b0,
  0x044e, 0x03b0, 0x004e, 0x07b0,
  0x078e, 0x0070, 0x038e, 0x0470,
  0x058e, 0x0270, 0x018e, 0x0670,
  0x068e, 0x0170, 0x028e, 0x0570,
  0x048e, 0x0370, 0x008e, 0x0770,
  0x070e, 0x00f0, 0x030e, 0x04f0,
  0x050e, 0x02f0, 0x010e, 0x06f0,
  0x060e, 0x01f0, 0x020e, 0x05f0,
  0x040e, 0x03f0, 0x000e, 0x07f0,
  0x07f6, 0x0008, 0x03f6, 0x0408,
  0x05f6, 0x0208, 0x01f6, 0x0608,
  0x06f6, 0x0108, 0x02f6, 0x0508,
  0x04f6, 0x0308, 0x00f6, 0x0708,
  0x0776, 0x0088, 0x0376, 0x0488,
  0x0576, 0x0288, 0x0176, 0x0688,
  0x0676, 0x0188, 0x0276, 0x0588,
  0x0476, 0x0388, 0x0076, 0x0788,
  0x07b6, 0x0048, 0x03b6, 0x0448,
  0x05b6, 0x0248, 0x01b6, 0x0648,
  0x06b6, 0x0148, 0x02b6, 0x0548,
  0x04b6, 0x0348, 0x00b6, 0x0748,
  0x0736, 0x00c8, 0x0336, 0x04c8,
  0x0536, 0x02c8, 0x0136, 0x06c8,
  0x0636, 0x01c8, 0x0236, 0x05c8,
  0x0436, 0x03c8, 0x0036, 0x07c8,
  0x07d6, 0x0028, 0x03d6, 0x0428,
  0x05d6, 0x0228, 0x01d6, 0x0628,
  0x06d6, 0x0128, 0x02d6, 0x0528,
  0x04d6, 0x0328, 0x00d6, 0x0728,
  0x0756, 0x00a8, 0x0356, 0x04a8,
  0x0556, 0x02a8, 0x0156, 0x06a8,
  0x0656, 0x01a8, 0x0256, 0x05a8,
  0x0456, 0x03a8, 0x0056, 0x07a8,
  0x0796, 0x0068, 0x0396, 0x0468,
  0x0596, 0x0268, 0x0196, 0x0668,
  0x0696, 0x0168, 0x0296, 0x0568,
  0x0496, 0x0368, 0x0096, 0x0768,
  0x0716, 0x00e8, 0x0316, 0x04e8,
  0x0516, 0x02e8, 0x0116, 0x06e8,
  0x0616, 0x01e8, 0x0216, 0x05e8,
  0x0416, 0x03e8, 0x0016, 0x07e8,
  0x07e6, 0x0018, 0x03e6, 0x0418,
  0x05e6, 0x0218, 0x01e6, 0x0618,
  0x06e6, 0x0118, 0x02e6, 0x0518,
  0x04e6, 0x0318, 0x00e6, 0x0718,
  0x0766, 0x0098, 0x0366, 0x0498,
  0x0566, 0x0298, 0x0166, 0x0698,
  0x0666, 0x0198, 0x0266, 0x0598,
  0x0466, 0x0398, 0x0066, 0x0798,
  0x07a6, 0x0058, 0x03a6, 0x0458,
  0x05a6, 0x0258, 0x01a6, 0x0658,
  0x06a6, 0x0158, 0x02a6, 0x0558,
  0x04a6, 0x0358, 0x00a6, 0x0758,
  0x0726, 0x00d8, 0x0326, 0x04d8,
  0x0526, 0x02d8, 0x0126, 0x06d8,
  0x0626, 0x01d8, 0x0226, 0x05d8,
  0x0426, 0x03d8, 0x0026, 0x07d8,
  0x07c6, 0x0038, 0x03c6, 0x0438,
  0x05c6, 0x0238, 0x01c6, 0x0638,
  0x06c6, 0x0138, 0x02c6, 0x0538,
  0x04c6, 0x0338, 0x00c6, 0x0738,
  0x0746, 0x00b8, 0x0346, 0x04b8,
  0x0546, 0x02b8, 0x0146, 0x06b8,
  0x0646, 0x01b8, 0x0246, 0x05b8,
  0x0446, 0x03b8, 0x0046, 0x07b8,
  0x0786, 0x0078, 0x0386, 0x0478,
  0x0586, 0x0278, 0x0186, 0x0678,
  0x0686, 0x0178, 0x0286, 0x0578,
  0x0486, 0x0378, 0x0086, 0x0778,
  0x0706, 0x00f8, 0x0306, 0x04f8,
  0x0506, 0x02f8, 0x0106, 0x06f8,
  0x0606, 0x01f8, 0x0206, 0x05f8,
  0x0406, 0x03f8, 0x0006, 0x07f8,
  0x07fa, 0x0004, 0x03fa, 0x0404,
  0x05fa, 0x0204, 0x01fa, 0x0604,
  0x06fa, 0x0104, 0x02fa, 0x0504,
  0x04fa, 0x0304, 0x00fa, 0x0704,
  0x077a, 0x0084, 0x037a, 0x0484,
  0x057a, 0x0284, 0x017a, 0x0684,
  0x067a, 0x0184, 0x027a, 0x0584,
  0x047a, 0x0384, 0x007a, 0x0784,
  0x07ba, 0x0044, 0x03ba, 0x0444,
  0x05ba, 0x0244, 0x01ba, 0x0644,
  0x06ba, 0x0144, 0x02ba, 0x0544,
  0x04ba, 0x0344, 0x00ba, 0x0744,
  0x073a, 0x00c4, 0x033a, 0x04c4,
  0x053a, 0x02c4, 0x013a, 0x06c4,
  0x063a, 0x01c4, 0x023a, 0x05c4,
  0x043a, 0x03c4, 0x003a, 0x07c4,
  0x07da, 0x0024, 0x03da, 0x0424,
  0x05da, 0x0224, 0x01da, 0x0624,
  0x06da, 0x0124, 0x02da, 0x0524,
  0x04da, 0x0324, 0x00da, 0x0724,
  0x075a, 0x00a4, 0x035a, 0x04a4,
  0x055a, 0x02a4, 0x015a, 0x06a4,
  0x065a, 0x01a4, 0x025a, 0x05a4,
  0x045a, 0x03a4, 0x005a, 0x07a4,
  0x079a, 0x0064, 0x039a, 0x0464,
  0x059a, 0x0264, 0x019a, 0x0664,
  0x069a, 0x0164, 0x029a, 0x0564,
  0x049a, 0x0364, 0x009a, 0x0764,
  0x071a, 0x00e4, 0x031a, 0x04e4,
  0x051a, 0x02e4, 0x011a, 0x06e4,
  0x061a, 0x01e4, 0x021a, 0x05e4,
  0x041a, 0x03e4, 0x001a, 0x07e4,
  0x07ea, 0x0014, 0x03ea, 0x0414,
  0x05ea, 0x0214, 0x01ea, 0x0614,
  0x06ea, 0x0114, 0x02ea, 0x0514,
  0x04ea, 0x0314, 0x00ea, 0x0714,
  0x076a, 0x0094, 0x036a, 0x0494,
  0x056a, 0x0294, 0x016a, 0x0694,
  0x066a, 0x0194, 0x026a, 0x0594,
  0x046a, 0x0394, 0x006a, 0x0794,
  0x07aa, 0x0054, 0x03aa, 0x0454,
  0x05aa, 0x0254, 0x01aa, 0x0654,
  0x06aa, 0x0154, 0x02aa, 0x0554,
  0x04aa, 0x0354, 0x00aa, 0x0754,
  0x072a, 0x00d4, 0x032a, 0x04d4,
  0x052a, 0x02d4, 0x012a, 0x06d4,
  0x062a, 0x01d4, 0x022a, 0x05d4,
  0x042a, 0x03d4, 0x002a, 0x07d4,
  0x07ca, 0x0034, 0x03ca, 0x0434,
  0x05ca, 0x0234, 0x01ca, 0x0634,
  0x06ca, 0x0134, 0x02ca, 0x0534,
  0x04ca, 0x0334, 0x00ca, 0x0734,
  0x074a, 0x00b4, 0x034a, 0x04b4,
  0x054a, 0x02b4, 0x014a, 0x06b4,
  0x064a, 0x01b4, 0x024a, 0x05b4,
  0x044a, 0x03b4, 0x004a, 0x07b4,
  0x078a, 0x0074, 0x038a, 0x0474,
  0x058a, 0x0274, 0x018a, 0x0674,
  0x068a, 0x0174, 0x028a, 0x0574,
  0x048a, 0x0374, 0x008a, 0x0774,
  0x070a, 0x00f4, 0x030a, 0x04f4,
  0x050a, 0x02f4, 0x010a, 0x06f4,
  0x060a, 0x01f4, 0x020a, 0x05f4,
  0x040a, 0x03f4, 0x000a, 0x07f4,
  0x07f2, 0x000c, 0x03f2, 0x040c,
  0x05f2, 0x020c, 0x01f2, 0x060c,
  0x06f2, 0x010c, 0x02f2, 0x050c,
  0x04f2, 0x030c, 0x00f2, 0x070c,
  0x0772, 0x008c, 0x0372, 0x048c,
  0x0572, 0x028c, 0x0172, 0x068c,
  0x0672, 0x018c, 0x0272, 0x058c,
  0x0472, 0x038c, 0x0072, 0x078c,
  0x07b2, 0x004c, 0x03b2, 0x044c,
  0x05b2, 0x024c, 0x01b2, 0x064c,
  0x06b2, 0x014c, 0x02b2, 0x054c,
  0x04b2, 0x034c, 0x00b2, 0x074c,
  0x0732, 0x00cc, 0x0332, 0x04cc,
  0x0532, 0x02cc, 0x0132, 0x06cc,
  0x0632, 0x01cc, 0x0232, 0x05cc,
  0x0432, 0x03cc, 0x0032, 0x07cc,
  0x07d2, 0x002c, 0x03d2, 0x042c,
  0x05d2, 0x022c, 0x01d2, 0x062c,
  0x06d2, 0x012c, 0x02d2, 0x052c,
  0x04d2, 0x032c, 0x00d2, 0x072c,
  0x0752, 0x00ac, 0x0352, 0x04ac,
  0x0552, 0x02ac, 0x0152, 0x06ac,
  0x0652, 0x01ac, 0x0252, 0x05ac,
  0x0452, 0x03ac, 0x0052, 0x07ac,
  0x0792, 0x006c, 0x0392, 0x046c,
  0x0592, 0x026c, 0x0192, 0x066c,
  0x0692, 0x016c, 0x0292, 0x056c,
  0x0492, 0x036c, 0x0092, 0x076c,
  0x0712, 0x00ec, 0x0312, 0x04ec,
  0x0512, 0x02ec, 0x0112, 0x06ec,
  0x0612, 0x01ec, 0x0212, 0x05ec,
  0x0412, 0x03ec, 0x0012, 0x07ec,
  0x07e2, 0x001c, 0x03e2, 0x041c,
  0x05e2, 0x021c, 0x01e2, 0x061c,
  0x06e2, 0x011c, 0x02e2, 0x051c,
  0x04e2, 0x031c, 0x00e2, 0x071c,
  0x0762, 0x009c, 0x0362, 0x049c,
  0x0562, 0x029c, 0x0162, 0x069c,
  0x0662, 0x019c, 0x0262, 0x059c,
  0x0462, 0x039c, 0x0062, 0x079c,
  0x07a2, 0x005c, 0x03a2, 0x045c,
  0x05a2, 0x025c, 0x01a2, 0x065c,
  0x06a2, 0x015c, 0x02a2, 0x055c,
  0x04a2, 0x035c, 0x00a2, 0x075c,
  0x0722, 0x00dc, 0x0322, 0x04dc,
  0x0522, 0x02dc, 0x0122, 0x06dc,
  0x0622, 0x01dc, 0x0222, 0x05dc,
  0x0422, 0x03dc, 0x0022, 0x07dc,
  0x07c2, 0x003c, 0x03c2, 0x043c,
  0x05c2, 0x023c, 0x01c2, 0x063c,
  0x06c2, 0x013c, 0x02c2, 0x053c,
  0x04c2, 0x033c, 0x00c2, 0x073c,
  0x0742, 0x00bc, 0x0342, 0x04bc,
  0x0542, 0x02bc, 0x0142, 0x06bc,
  0x0642, 0x01bc, 0x0242, 0x05bc,
  0x0442, 0x03bc, 0x0042, 0x07bc,
  0x0782, 0x007c, 0x0382, 0x047c,
  0x0582, 0x027c, 0x0182, 0x067c,
  0x0682, 0x017c, 0x0282, 0x057c,
  0x0482, 0x037c, 0x0082, 0x077c,
  0x0702, 0x00fc, 0x0302, 0x04fc,
  0x0502, 0x02fc, 0x0102, 0x06fc,
  0x0602, 0x01fc, 0x0202, 0x05fc,
  0x0402, 0x03fc, 0x0002, 0x07fc,
};

static ogg_int32_t triglook_8192[10240]={
  0x40000000, 0x00000000, 0x3ffffb11, 0xffe6de05,
  0x3fffec43, 0xffcdbc0f, 0x3fffd396, 0xffb49a1f,
  0x3fffb10b, 0xff9b783c, 0x3fff84a1, 0xff825668,
  0x3fff4e59, 0xff6934a8, 0x3fff0e32, 0xff5012fe,
  0x3ffec42d, 0xff36f170, 0x3ffe704a, 0xff1dd001,
  0x3ffe1288, 0xff04aeb5, 0x3ffdaae7, 0xfeeb8d8f,
  0x3ffd3969, 0xfed26c94, 0x3ffcbe0c, 0xfeb94bc8,
  0x3ffc38d1, 0xfea02b2e, 0x3ffba9b8, 0xfe870aca,
  0x3ffb10c1, 0xfe6deaa1, 0x3ffa6dec, 0xfe54cab5,
  0x3ff9c13a, 0xfe3bab0b, 0x3ff90aaa, 0xfe228ba7,
  0x3ff84a3c, 0xfe096c8d, 0x3ff77ff1, 0xfdf04dc0,
  0x3ff6abc8, 0xfdd72f45, 0x3ff5cdc3, 0xfdbe111e,
  0x3ff4e5e0, 0xfda4f351, 0x3ff3f420, 0xfd8bd5e1,
  0x3ff2f884, 0xfd72b8d2, 0x3ff1f30b, 0xfd599c28,
  0x3ff0e3b6, 0xfd407fe6, 0x3fefca84, 0xfd276410,
  0x3feea776, 0xfd0e48ab, 0x3fed7a8c, 0xfcf52dbb,
  0x3fec43c7, 0xfcdc1342, 0x3feb0326, 0xfcc2f945,
  0x3fe9b8a9, 0xfca9dfc8, 0x3fe86452, 0xfc90c6cf,
  0x3fe7061f, 0xfc77ae5e, 0x3fe59e12, 0xfc5e9678,
  0x3fe42c2a, 0xfc457f21, 0x3fe2b067, 0xfc2c685d,
  0x3fe12acb, 0xfc135231, 0x3fdf9b55, 0xfbfa3c9f,
  0x3fde0205, 0xfbe127ac, 0x3fdc5edc, 0xfbc8135c,
  0x3fdab1d9, 0xfbaeffb3, 0x3fd8fafe, 0xfb95ecb4,
  0x3fd73a4a, 0xfb7cda63, 0x3fd56fbe, 0xfb63c8c4,
  0x3fd39b5a, 0xfb4ab7db, 0x3fd1bd1e, 0xfb31a7ac,
  0x3fcfd50b, 0xfb18983b, 0x3fcde320, 0xfaff898c,
  0x3fcbe75e, 0xfae67ba2, 0x3fc9e1c6, 0xfacd6e81,
  0x3fc7d258, 0xfab4622d, 0x3fc5b913, 0xfa9b56ab,
  0x3fc395f9, 0xfa824bfd, 0x3fc1690a, 0xfa694229,
  0x3fbf3246, 0xfa503930, 0x3fbcf1ad, 0xfa373119,
  0x3fbaa740, 0xfa1e29e5, 0x3fb852ff, 0xfa05239a,
  0x3fb5f4ea, 0xf9ec1e3b, 0x3fb38d02, 0xf9d319cc,
  0x3fb11b48, 0xf9ba1651, 0x3fae9fbb, 0xf9a113cd,
  0x3fac1a5b, 0xf9881245, 0x3fa98b2a, 0xf96f11bc,
  0x3fa6f228, 0xf9561237, 0x3fa44f55, 0xf93d13b8,
  0x3fa1a2b2, 0xf9241645, 0x3f9eec3e, 0xf90b19e0,
  0x3f9c2bfb, 0xf8f21e8e, 0x3f9961e8, 0xf8d92452,
  0x3f968e07, 0xf8c02b31, 0x3f93b058, 0xf8a7332e,
  0x3f90c8da, 0xf88e3c4d, 0x3f8dd78f, 0xf8754692,
  0x3f8adc77, 0xf85c5201, 0x3f87d792, 0xf8435e9d,
  0x3f84c8e2, 0xf82a6c6a, 0x3f81b065, 0xf8117b6d,
  0x3f7e8e1e, 0xf7f88ba9, 0x3f7b620c, 0xf7df9d22,
  0x3f782c30, 0xf7c6afdc, 0x3f74ec8a, 0xf7adc3db,
  0x3f71a31b, 0xf794d922, 0x3f6e4fe3, 0xf77befb5,
  0x3f6af2e3, 0xf7630799, 0x3f678c1c, 0xf74a20d0,
  0x3f641b8d, 0xf7313b60, 0x3f60a138, 0xf718574b,
  0x3f5d1d1d, 0xf6ff7496, 0x3f598f3c, 0xf6e69344,
  0x3f55f796, 0xf6cdb359, 0x3f52562c, 0xf6b4d4d9,
  0x3f4eaafe, 0xf69bf7c9, 0x3f4af60d, 0xf6831c2b,
  0x3f473759, 0xf66a4203, 0x3f436ee3, 0xf6516956,
  0x3f3f9cab, 0xf6389228, 0x3f3bc0b3, 0xf61fbc7b,
  0x3f37dafa, 0xf606e854, 0x3f33eb81, 0xf5ee15b7,
  0x3f2ff24a, 0xf5d544a7, 0x3f2bef53, 0xf5bc7529,
  0x3f27e29f, 0xf5a3a740, 0x3f23cc2e, 0xf58adaf0,
  0x3f1fabff, 0xf572103d, 0x3f1b8215, 0xf559472b,
  0x3f174e70, 0xf5407fbd, 0x3f13110f, 0xf527b9f7,
  0x3f0ec9f5, 0xf50ef5de, 0x3f0a7921, 0xf4f63374,
  0x3f061e95, 0xf4dd72be, 0x3f01ba50, 0xf4c4b3c0,
  0x3efd4c54, 0xf4abf67e, 0x3ef8d4a1, 0xf4933afa,
  0x3ef45338, 0xf47a8139, 0x3eefc81a, 0xf461c940,
  0x3eeb3347, 0xf4491311, 0x3ee694c1, 0xf4305eb0,
  0x3ee1ec87, 0xf417ac22, 0x3edd3a9a, 0xf3fefb6a,
  0x3ed87efc, 0xf3e64c8c, 0x3ed3b9ad, 0xf3cd9f8b,
  0x3eceeaad, 0xf3b4f46c, 0x3eca11fe, 0xf39c4b32,
  0x3ec52fa0, 0xf383a3e2, 0x3ec04394, 0xf36afe7e,
  0x3ebb4ddb, 0xf3525b0b, 0x3eb64e75, 0xf339b98d,
  0x3eb14563, 0xf3211a07, 0x3eac32a6, 0xf3087c7d,
  0x3ea7163f, 0xf2efe0f2, 0x3ea1f02f, 0xf2d7476c,
  0x3e9cc076, 0xf2beafed, 0x3e978715, 0xf2a61a7a,
  0x3e92440d, 0xf28d8715, 0x3e8cf75f, 0xf274f5c3,
  0x3e87a10c, 0xf25c6688, 0x3e824114, 0xf243d968,
  0x3e7cd778, 0xf22b4e66, 0x3e77643a, 0xf212c585,
  0x3e71e759, 0xf1fa3ecb, 0x3e6c60d7, 0xf1e1ba3a,
  0x3e66d0b4, 0xf1c937d6, 0x3e6136f3, 0xf1b0b7a4,
  0x3e5b9392, 0xf19839a6, 0x3e55e694, 0xf17fbde2,
  0x3e502ff9, 0xf1674459, 0x3e4a6fc1, 0xf14ecd11,
  0x3e44a5ef, 0xf136580d, 0x3e3ed282, 0xf11de551,
  0x3e38f57c, 0xf10574e0, 0x3e330ede, 0xf0ed06bf,
  0x3e2d1ea8, 0xf0d49af1, 0x3e2724db, 0xf0bc317a,
  0x3e212179, 0xf0a3ca5d, 0x3e1b1482, 0xf08b659f,
  0x3e14fdf7, 0xf0730342, 0x3e0eddd9, 0xf05aa34c,
  0x3e08b42a, 0xf04245c0, 0x3e0280e9, 0xf029eaa1,
  0x3dfc4418, 0xf01191f3, 0x3df5fdb8, 0xeff93bba,
  0x3defadca, 0xefe0e7f9, 0x3de9544f, 0xefc896b5,
  0x3de2f148, 0xefb047f2, 0x3ddc84b5, 0xef97fbb2,
  0x3dd60e99, 0xef7fb1fa, 0x3dcf8ef3, 0xef676ace,
  0x3dc905c5, 0xef4f2630, 0x3dc2730f, 0xef36e426,
  0x3dbbd6d4, 0xef1ea4b2, 0x3db53113, 0xef0667d9,
  0x3dae81cf, 0xeeee2d9d, 0x3da7c907, 0xeed5f604,
  0x3da106bd, 0xeebdc110, 0x3d9a3af2, 0xeea58ec6,
  0x3d9365a8, 0xee8d5f29, 0x3d8c86de, 0xee75323c,
  0x3d859e96, 0xee5d0804, 0x3d7eacd2, 0xee44e084,
  0x3d77b192, 0xee2cbbc1, 0x3d70acd7, 0xee1499bd,
  0x3d699ea3, 0xedfc7a7c, 0x3d6286f6, 0xede45e03,
  0x3d5b65d2, 0xedcc4454, 0x3d543b37, 0xedb42d74,
  0x3d4d0728, 0xed9c1967, 0x3d45c9a4, 0xed84082f,
  0x3d3e82ae, 0xed6bf9d1, 0x3d373245, 0xed53ee51,
  0x3d2fd86c, 0xed3be5b1, 0x3d287523, 0xed23dff7,
  0x3d21086c, 0xed0bdd25, 0x3d199248, 0xecf3dd3f,
  0x3d1212b7, 0xecdbe04a, 0x3d0a89bc, 0xecc3e648,
  0x3d02f757, 0xecabef3d, 0x3cfb5b89, 0xec93fb2e,
  0x3cf3b653, 0xec7c0a1d, 0x3cec07b8, 0xec641c0e,
  0x3ce44fb7, 0xec4c3106, 0x3cdc8e52, 0xec344908,
  0x3cd4c38b, 0xec1c6417, 0x3cccef62, 0xec048237,
  0x3cc511d9, 0xebeca36c, 0x3cbd2af0, 0xebd4c7ba,
  0x3cb53aaa, 0xebbcef23, 0x3cad4107, 0xeba519ad,
  0x3ca53e09, 0xeb8d475b, 0x3c9d31b0, 0xeb75782f,
  0x3c951bff, 0xeb5dac2f, 0x3c8cfcf6, 0xeb45e35d,
  0x3c84d496, 0xeb2e1dbe, 0x3c7ca2e2, 0xeb165b54,
  0x3c7467d9, 0xeafe9c24, 0x3c6c237e, 0xeae6e031,
  0x3c63d5d1, 0xeacf277f, 0x3c5b7ed4, 0xeab77212,
  0x3c531e88, 0xea9fbfed, 0x3c4ab4ef, 0xea881114,
  0x3c42420a, 0xea70658a, 0x3c39c5da, 0xea58bd54,
  0x3c314060, 0xea411874, 0x3c28b19e, 0xea2976ef,
  0x3c201994, 0xea11d8c8, 0x3c177845, 0xe9fa3e03,
  0x3c0ecdb2, 0xe9e2a6a3, 0x3c0619dc, 0xe9cb12ad,
  0x3bfd5cc4, 0xe9b38223, 0x3bf4966c, 0xe99bf509,
  0x3bebc6d5, 0xe9846b63, 0x3be2ee01, 0xe96ce535,
  0x3bda0bf0, 0xe9556282, 0x3bd120a4, 0xe93de34e,
  0x3bc82c1f, 0xe926679c, 0x3bbf2e62, 0xe90eef71,
  0x3bb6276e, 0xe8f77acf, 0x3bad1744, 0xe8e009ba,
  0x3ba3fde7, 0xe8c89c37, 0x3b9adb57, 0xe8b13248,
  0x3b91af97, 0xe899cbf1, 0x3b887aa6, 0xe8826936,
  0x3b7f3c87, 0xe86b0a1a, 0x3b75f53c, 0xe853aea1,
  0x3b6ca4c4, 0xe83c56cf, 0x3b634b23, 0xe82502a7,
  0x3b59e85a, 0xe80db22d, 0x3b507c69, 0xe7f66564,
  0x3b470753, 0xe7df1c50, 0x3b3d8918, 0xe7c7d6f4,
  0x3b3401bb, 0xe7b09555, 0x3b2a713d, 0xe7995776,
  0x3b20d79e, 0xe7821d59, 0x3b1734e2, 0xe76ae704,
  0x3b0d8909, 0xe753b479, 0x3b03d414, 0xe73c85bc,
  0x3afa1605, 0xe7255ad1, 0x3af04edf, 0xe70e33bb,
  0x3ae67ea1, 0xe6f7107e, 0x3adca54e, 0xe6dff11d,
  0x3ad2c2e8, 0xe6c8d59c, 0x3ac8d76f, 0xe6b1bdff,
  0x3abee2e5, 0xe69aaa48, 0x3ab4e54c, 0xe6839a7c,
  0x3aaadea6, 0xe66c8e9f, 0x3aa0cef3, 0xe65586b3,
  0x3a96b636, 0xe63e82bc, 0x3a8c9470, 0xe62782be,
  0x3a8269a3, 0xe61086bc, 0x3a7835cf, 0xe5f98ebb,
  0x3a6df8f8, 0xe5e29abc, 0x3a63b31d, 0xe5cbaac5,
  0x3a596442, 0xe5b4bed8, 0x3a4f0c67, 0xe59dd6f9,
  0x3a44ab8e, 0xe586f32c, 0x3a3a41b9, 0xe5701374,
  0x3a2fcee8, 0xe55937d5, 0x3a25531f, 0xe5426051,
  0x3a1ace5f, 0xe52b8cee, 0x3a1040a8, 0xe514bdad,
  0x3a05a9fd, 0xe4fdf294, 0x39fb0a60, 0xe4e72ba4,
  0x39f061d2, 0xe4d068e2, 0x39e5b054, 0xe4b9aa52,
  0x39daf5e8, 0xe4a2eff6, 0x39d03291, 0xe48c39d3,
  0x39c5664f, 0xe47587eb, 0x39ba9125, 0xe45eda43,
  0x39afb313, 0xe44830dd, 0x39a4cc1c, 0xe4318bbe,
  0x3999dc42, 0xe41aeae8, 0x398ee385, 0xe4044e60,
  0x3983e1e8, 0xe3edb628, 0x3978d76c, 0xe3d72245,
  0x396dc414, 0xe3c092b9, 0x3962a7e0, 0xe3aa0788,
  0x395782d3, 0xe39380b6, 0x394c54ee, 0xe37cfe47,
  0x39411e33, 0xe366803c, 0x3935dea4, 0xe350069b,
  0x392a9642, 0xe3399167, 0x391f4510, 0xe32320a2,
  0x3913eb0e, 0xe30cb451, 0x3908883f, 0xe2f64c77,
  0x38fd1ca4, 0xe2dfe917, 0x38f1a840, 0xe2c98a35,
  0x38e62b13, 0xe2b32fd4, 0x38daa520, 0xe29cd9f8,
  0x38cf1669, 0xe28688a4, 0x38c37eef, 0xe2703bdc,
  0x38b7deb4, 0xe259f3a3, 0x38ac35ba, 0xe243affc,
  0x38a08402, 0xe22d70eb, 0x3894c98f, 0xe2173674,
  0x38890663, 0xe2010099, 0x387d3a7e, 0xe1eacf5f,
  0x387165e3, 0xe1d4a2c8, 0x38658894, 0xe1be7ad8,
  0x3859a292, 0xe1a85793, 0x384db3e0, 0xe19238fb,
  0x3841bc7f, 0xe17c1f15, 0x3835bc71, 0xe16609e3,
  0x3829b3b9, 0xe14ff96a, 0x381da256, 0xe139edac,
  0x3811884d, 0xe123e6ad, 0x3805659e, 0xe10de470,
  0x37f93a4b, 0xe0f7e6f9, 0x37ed0657, 0xe0e1ee4b,
  0x37e0c9c3, 0xe0cbfa6a, 0x37d48490, 0xe0b60b58,
  0x37c836c2, 0xe0a0211a, 0x37bbe05a, 0xe08a3bb2,
  0x37af8159, 0xe0745b24, 0x37a319c2, 0xe05e7f74,
  0x3796a996, 0xe048a8a4, 0x378a30d8, 0xe032d6b8,
  0x377daf89, 0xe01d09b4, 0x377125ac, 0xe007419b,
  0x37649341, 0xdff17e70, 0x3757f84c, 0xdfdbc036,
  0x374b54ce, 0xdfc606f1, 0x373ea8ca, 0xdfb052a5,
  0x3731f440, 0xdf9aa354, 0x37253733, 0xdf84f902,
  0x371871a5, 0xdf6f53b3, 0x370ba398, 0xdf59b369,
  0x36fecd0e, 0xdf441828, 0x36f1ee09, 0xdf2e81f3,
  0x36e5068a, 0xdf18f0ce, 0x36d81695, 0xdf0364bc,
  0x36cb1e2a, 0xdeedddc0, 0x36be1d4c, 0xded85bdd,
  0x36b113fd, 0xdec2df18, 0x36a4023f, 0xdead6773,
  0x3696e814, 0xde97f4f1, 0x3689c57d, 0xde828796,
  0x367c9a7e, 0xde6d1f65, 0x366f6717, 0xde57bc62,
  0x36622b4c, 0xde425e8f, 0x3654e71d, 0xde2d05f1,
  0x36479a8e, 0xde17b28a, 0x363a45a0, 0xde02645d,
  0x362ce855, 0xdded1b6e, 0x361f82af, 0xddd7d7c1,
  0x361214b0, 0xddc29958, 0x36049e5b, 0xddad6036,
  0x35f71fb1, 0xdd982c60, 0x35e998b5, 0xdd82fdd8,
  0x35dc0968, 0xdd6dd4a2, 0x35ce71ce, 0xdd58b0c0,
  0x35c0d1e7, 0xdd439236, 0x35b329b5, 0xdd2e7908,
  0x35a5793c, 0xdd196538, 0x3597c07d, 0xdd0456ca,
  0x3589ff7a, 0xdcef4dc2, 0x357c3636, 0xdcda4a21,
  0x356e64b2, 0xdcc54bec, 0x35608af1, 0xdcb05326,
  0x3552a8f4, 0xdc9b5fd2, 0x3544bebf, 0xdc8671f3,
  0x3536cc52, 0xdc71898d, 0x3528d1b1, 0xdc5ca6a2,
  0x351acedd, 0xdc47c936, 0x350cc3d8, 0xdc32f14d,
  0x34feb0a5, 0xdc1e1ee9, 0x34f09546, 0xdc09520d,
  0x34e271bd, 0xdbf48abd, 0x34d4460c, 0xdbdfc8fc,
  0x34c61236, 0xdbcb0cce, 0x34b7d63c, 0xdbb65634,
  0x34a99221, 0xdba1a534, 0x349b45e7, 0xdb8cf9cf,
  0x348cf190, 0xdb785409, 0x347e951f, 0xdb63b3e5,
  0x34703095, 0xdb4f1967, 0x3461c3f5, 0xdb3a8491,
  0x34534f41, 0xdb25f566, 0x3444d27b, 0xdb116beb,
  0x34364da6, 0xdafce821, 0x3427c0c3, 0xdae86a0d,
  0x34192bd5, 0xdad3f1b1, 0x340a8edf, 0xdabf7f11,
  0x33fbe9e2, 0xdaab122f, 0x33ed3ce1, 0xda96ab0f,
  0x33de87de, 0xda8249b4, 0x33cfcadc, 0xda6dee21,
  0x33c105db, 0xda599859, 0x33b238e0, 0xda454860,
  0x33a363ec, 0xda30fe38, 0x33948701, 0xda1cb9e5,
  0x3385a222, 0xda087b69, 0x3376b551, 0xd9f442c9,
  0x3367c090, 0xd9e01006, 0x3358c3e2, 0xd9cbe325,
  0x3349bf48, 0xd9b7bc27, 0x333ab2c6, 0xd9a39b11,
  0x332b9e5e, 0xd98f7fe6, 0x331c8211, 0xd97b6aa8,
  0x330d5de3, 0xd9675b5a, 0x32fe31d5, 0xd9535201,
  0x32eefdea, 0xd93f4e9e, 0x32dfc224, 0xd92b5135,
  0x32d07e85, 0xd91759c9, 0x32c13311, 0xd903685d,
  0x32b1dfc9, 0xd8ef7cf4, 0x32a284b0, 0xd8db9792,
  0x329321c7, 0xd8c7b838, 0x3283b712, 0xd8b3deeb,
  0x32744493, 0xd8a00bae, 0x3264ca4c, 0xd88c3e83,
  0x32554840, 0xd878776d, 0x3245be70, 0xd864b670,
  0x32362ce0, 0xd850fb8e, 0x32269391, 0xd83d46cc,
  0x3216f287, 0xd829982b, 0x320749c3, 0xd815efae,
  0x31f79948, 0xd8024d59, 0x31e7e118, 0xd7eeb130,
  0x31d82137, 0xd7db1b34, 0x31c859a5, 0xd7c78b68,
  0x31b88a66, 0xd7b401d1, 0x31a8b37c, 0xd7a07e70,
  0x3198d4ea, 0xd78d014a, 0x3188eeb2, 0xd7798a60,
  0x317900d6, 0xd76619b6, 0x31690b59, 0xd752af4f,
  0x31590e3e, 0xd73f4b2e, 0x31490986, 0xd72bed55,
  0x3138fd35, 0xd71895c9, 0x3128e94c, 0xd705448b,
  0x3118cdcf, 0xd6f1f99f, 0x3108aabf, 0xd6deb508,
  0x30f8801f, 0xd6cb76c9, 0x30e84df3, 0xd6b83ee4,
  0x30d8143b, 0xd6a50d5d, 0x30c7d2fb, 0xd691e237,
  0x30b78a36, 0xd67ebd74, 0x30a739ed, 0xd66b9f18,
  0x3096e223, 0xd6588725, 0x308682dc, 0xd645759f,
  0x30761c18, 0xd6326a88, 0x3065addb, 0xd61f65e4,
  0x30553828, 0xd60c67b4, 0x3044bb00, 0xd5f96ffd,
  0x30343667, 0xd5e67ec1, 0x3023aa5f, 0xd5d39403,
  0x301316eb, 0xd5c0afc6, 0x30027c0c, 0xd5add20d,
  0x2ff1d9c7, 0xd59afadb, 0x2fe1301c, 0xd5882a32,
  0x2fd07f0f, 0xd5756016, 0x2fbfc6a3, 0xd5629c89,
  0x2faf06da, 0xd54fdf8f, 0x2f9e3fb6, 0xd53d292a,
  0x2f8d713a, 0xd52a795d, 0x2f7c9b69, 0xd517d02b,
  0x2f6bbe45, 0xd5052d97, 0x2f5ad9d1, 0xd4f291a4,
  0x2f49ee0f, 0xd4dffc54, 0x2f38fb03, 0xd4cd6dab,
  0x2f2800af, 0xd4bae5ab, 0x2f16ff14, 0xd4a86458,
  0x2f05f637, 0xd495e9b3, 0x2ef4e619, 0xd48375c1,
  0x2ee3cebe, 0xd4710883, 0x2ed2b027, 0xd45ea1fd,
  0x2ec18a58, 0xd44c4232, 0x2eb05d53, 0xd439e923,
  0x2e9f291b, 0xd42796d5, 0x2e8dedb3, 0xd4154b4a,
  0x2e7cab1c, 0xd4030684, 0x2e6b615a, 0xd3f0c887,
  0x2e5a1070, 0xd3de9156, 0x2e48b860, 0xd3cc60f2,
  0x2e37592c, 0xd3ba3760, 0x2e25f2d8, 0xd3a814a2,
  0x2e148566, 0xd395f8ba, 0x2e0310d9, 0xd383e3ab,
  0x2df19534, 0xd371d579, 0x2de01278, 0xd35fce26,
  0x2dce88aa, 0xd34dcdb4, 0x2dbcf7cb, 0xd33bd427,
  0x2dab5fdf, 0xd329e181, 0x2d99c0e7, 0xd317f5c6,
  0x2d881ae8, 0xd30610f7, 0x2d766de2, 0xd2f43318,
  0x2d64b9da, 0xd2e25c2b, 0x2d52fed2, 0xd2d08c33,
  0x2d413ccd, 0xd2bec333, 0x2d2f73cd, 0xd2ad012e,
  0x2d1da3d5, 0xd29b4626, 0x2d0bcce8, 0xd289921e,
  0x2cf9ef09, 0xd277e518, 0x2ce80a3a, 0xd2663f19,
  0x2cd61e7f, 0xd254a021, 0x2cc42bd9, 0xd2430835,
  0x2cb2324c, 0xd2317756, 0x2ca031da, 0xd21fed88,
  0x2c8e2a87, 0xd20e6acc, 0x2c7c1c55, 0xd1fcef27,
  0x2c6a0746, 0xd1eb7a9a, 0x2c57eb5e, 0xd1da0d28,
  0x2c45c8a0, 0xd1c8a6d4, 0x2c339f0e, 0xd1b747a0,
  0x2c216eaa, 0xd1a5ef90, 0x2c0f3779, 0xd1949ea6,
  0x2bfcf97c, 0xd18354e4, 0x2beab4b6, 0xd172124d,
  0x2bd8692b, 0xd160d6e5, 0x2bc616dd, 0xd14fa2ad,
  0x2bb3bdce, 0xd13e75a8, 0x2ba15e03, 0xd12d4fd9,
  0x2b8ef77d, 0xd11c3142, 0x2b7c8a3f, 0xd10b19e7,
  0x2b6a164d, 0xd0fa09c9, 0x2b579ba8, 0xd0e900ec,
  0x2b451a55, 0xd0d7ff51, 0x2b329255, 0xd0c704fd,
  0x2b2003ac, 0xd0b611f1, 0x2b0d6e5c, 0xd0a5262f,
  0x2afad269, 0xd09441bb, 0x2ae82fd5, 0xd0836497,
  0x2ad586a3, 0xd0728ec6, 0x2ac2d6d6, 0xd061c04a,
  0x2ab02071, 0xd050f926, 0x2a9d6377, 0xd040395d,
  0x2a8a9fea, 0xd02f80f1, 0x2a77d5ce, 0xd01ecfe4,
  0x2a650525, 0xd00e2639, 0x2a522df3, 0xcffd83f4,
  0x2a3f503a, 0xcfece915, 0x2a2c6bfd, 0xcfdc55a1,
  0x2a19813f, 0xcfcbc999, 0x2a069003, 0xcfbb4500,
  0x29f3984c, 0xcfaac7d8, 0x29e09a1c, 0xcf9a5225,
  0x29cd9578, 0xcf89e3e8, 0x29ba8a61, 0xcf797d24,
  0x29a778db, 0xcf691ddd, 0x299460e8, 0xcf58c613,
  0x2981428c, 0xcf4875ca, 0x296e1dc9, 0xcf382d05,
  0x295af2a3, 0xcf27ebc5, 0x2947c11c, 0xcf17b20d,
  0x29348937, 0xcf077fe1, 0x29214af8, 0xcef75541,
  0x290e0661, 0xcee73231, 0x28fabb75, 0xced716b4,
  0x28e76a37, 0xcec702cb, 0x28d412ab, 0xceb6f67a,
  0x28c0b4d2, 0xcea6f1c2, 0x28ad50b1, 0xce96f4a7,
  0x2899e64a, 0xce86ff2a, 0x288675a0, 0xce77114e,
  0x2872feb6, 0xce672b16, 0x285f8190, 0xce574c84,
  0x284bfe2f, 0xce47759a, 0x28387498, 0xce37a65b,
  0x2824e4cc, 0xce27dec9, 0x28114ed0, 0xce181ee8,
  0x27fdb2a7, 0xce0866b8, 0x27ea1052, 0xcdf8b63d,
  0x27d667d5, 0xcde90d79, 0x27c2b934, 0xcdd96c6f,
  0x27af0472, 0xcdc9d320, 0x279b4990, 0xcdba4190,
  0x27878893, 0xcdaab7c0, 0x2773c17d, 0xcd9b35b4,
  0x275ff452, 0xcd8bbb6d, 0x274c2115, 0xcd7c48ee,
  0x273847c8, 0xcd6cde39, 0x2724686e, 0xcd5d7b50,
  0x2710830c, 0xcd4e2037, 0x26fc97a3, 0xcd3eccef,
  0x26e8a637, 0xcd2f817b, 0x26d4aecb, 0xcd203ddc,
  0x26c0b162, 0xcd110216, 0x26acadff, 0xcd01ce2b,
  0x2698a4a6, 0xccf2a21d, 0x26849558, 0xcce37def,
  0x2670801a, 0xccd461a2, 0x265c64ef, 0xccc54d3a,
  0x264843d9, 0xccb640b8, 0x26341cdb, 0xcca73c1e,
  0x261feffa, 0xcc983f70, 0x260bbd37, 0xcc894aaf,
  0x25f78497, 0xcc7a5dde, 0x25e3461b, 0xcc6b78ff,
  0x25cf01c8, 0xcc5c9c14, 0x25bab7a0, 0xcc4dc720,
  0x25a667a7, 0xcc3efa25, 0x259211df, 0xcc303524,
  0x257db64c, 0xcc217822, 0x256954f1, 0xcc12c31f,
  0x2554edd1, 0xcc04161e, 0x254080ef, 0xcbf57121,
  0x252c0e4f, 0xcbe6d42b, 0x251795f3, 0xcbd83f3d,
  0x250317df, 0xcbc9b25a, 0x24ee9415, 0xcbbb2d85,
  0x24da0a9a, 0xcbacb0bf, 0x24c57b6f, 0xcb9e3c0b,
  0x24b0e699, 0xcb8fcf6b, 0x249c4c1b, 0xcb816ae1,
  0x2487abf7, 0xcb730e70, 0x24730631, 0xcb64ba19,
  0x245e5acc, 0xcb566ddf, 0x2449a9cc, 0xcb4829c4,
  0x2434f332, 0xcb39edca, 0x24203704, 0xcb2bb9f4,
  0x240b7543, 0xcb1d8e43, 0x23f6adf3, 0xcb0f6aba,
  0x23e1e117, 0xcb014f5b, 0x23cd0eb3, 0xcaf33c28,
  0x23b836ca, 0xcae53123, 0x23a3595e, 0xcad72e4f,
  0x238e7673, 0xcac933ae, 0x23798e0d, 0xcabb4141,
  0x2364a02e, 0xcaad570c, 0x234facda, 0xca9f750f,
  0x233ab414, 0xca919b4e, 0x2325b5df, 0xca83c9ca,
  0x2310b23e, 0xca760086, 0x22fba936, 0xca683f83,
  0x22e69ac8, 0xca5a86c4, 0x22d186f8, 0xca4cd64b,
  0x22bc6dca, 0xca3f2e19, 0x22a74f40, 0xca318e32,
  0x22922b5e, 0xca23f698, 0x227d0228, 0xca16674b,
  0x2267d3a0, 0xca08e04f, 0x22529fca, 0xc9fb61a5,
  0x223d66a8, 0xc9edeb50, 0x2228283f, 0xc9e07d51,
  0x2212e492, 0xc9d317ab, 0x21fd9ba3, 0xc9c5ba60,
  0x21e84d76, 0xc9b86572, 0x21d2fa0f, 0xc9ab18e3,
  0x21bda171, 0xc99dd4b4, 0x21a8439e, 0xc99098e9,
  0x2192e09b, 0xc9836582, 0x217d786a, 0xc9763a83,
  0x21680b0f, 0xc96917ec, 0x2152988d, 0xc95bfdc1,
  0x213d20e8, 0xc94eec03, 0x2127a423, 0xc941e2b4,
  0x21122240, 0xc934e1d6, 0x20fc9b44, 0xc927e96b,
  0x20e70f32, 0xc91af976, 0x20d17e0d, 0xc90e11f7,
  0x20bbe7d8, 0xc90132f2, 0x20a64c97, 0xc8f45c68,
  0x2090ac4d, 0xc8e78e5b, 0x207b06fe, 0xc8dac8cd,
  0x20655cac, 0xc8ce0bc0, 0x204fad5b, 0xc8c15736,
  0x2039f90f, 0xc8b4ab32, 0x20243fca, 0xc8a807b4,
  0x200e8190, 0xc89b6cbf, 0x1ff8be65, 0xc88eda54,
  0x1fe2f64c, 0xc8825077, 0x1fcd2948, 0xc875cf28,
  0x1fb7575c, 0xc869566a, 0x1fa1808c, 0xc85ce63e,
  0x1f8ba4dc, 0xc8507ea7, 0x1f75c44e, 0xc8441fa6,
  0x1f5fdee6, 0xc837c93e, 0x1f49f4a8, 0xc82b7b70,
  0x1f340596, 0xc81f363d, 0x1f1e11b5, 0xc812f9a9,
  0x1f081907, 0xc806c5b5, 0x1ef21b90, 0xc7fa9a62,
  0x1edc1953, 0xc7ee77b3, 0x1ec61254, 0xc7e25daa,
  0x1eb00696, 0xc7d64c47, 0x1e99f61d, 0xc7ca438f,
  0x1e83e0eb, 0xc7be4381, 0x1e6dc705, 0xc7b24c20,
  0x1e57a86d, 0xc7a65d6e, 0x1e418528, 0xc79a776c,
  0x1e2b5d38, 0xc78e9a1d, 0x1e1530a1, 0xc782c582,
  0x1dfeff67, 0xc776f99d, 0x1de8c98c, 0xc76b3671,
  0x1dd28f15, 0xc75f7bfe, 0x1dbc5004, 0xc753ca46,
  0x1da60c5d, 0xc748214c, 0x1d8fc424, 0xc73c8111,
  0x1d79775c, 0xc730e997, 0x1d632608, 0xc7255ae0,
  0x1d4cd02c, 0xc719d4ed, 0x1d3675cb, 0xc70e57c0,
  0x1d2016e9, 0xc702e35c, 0x1d09b389, 0xc6f777c1,
  0x1cf34baf, 0xc6ec14f2, 0x1cdcdf5e, 0xc6e0baf0,
  0x1cc66e99, 0xc6d569be, 0x1caff965, 0xc6ca215c,
  0x1c997fc4, 0xc6bee1cd, 0x1c8301b9, 0xc6b3ab12,
  0x1c6c7f4a, 0xc6a87d2d, 0x1c55f878, 0xc69d5820,
  0x1c3f6d47, 0xc6923bec, 0x1c28ddbb, 0xc6872894,
  0x1c1249d8, 0xc67c1e18, 0x1bfbb1a0, 0xc6711c7b,
  0x1be51518, 0xc66623be, 0x1bce7442, 0xc65b33e4,
  0x1bb7cf23, 0xc6504ced, 0x1ba125bd, 0xc6456edb,
  0x1b8a7815, 0xc63a99b1, 0x1b73c62d, 0xc62fcd6f,
  0x1b5d100a, 0xc6250a18, 0x1b4655ae, 0xc61a4fac,
  0x1b2f971e, 0xc60f9e2e, 0x1b18d45c, 0xc604f5a0,
  0x1b020d6c, 0xc5fa5603, 0x1aeb4253, 0xc5efbf58,
  0x1ad47312, 0xc5e531a1, 0x1abd9faf, 0xc5daace1,
  0x1aa6c82b, 0xc5d03118, 0x1a8fec8c, 0xc5c5be47,
  0x1a790cd4, 0xc5bb5472, 0x1a622907, 0xc5b0f399,
  0x1a4b4128, 0xc5a69bbe, 0x1a34553b, 0xc59c4ce3,
  0x1a1d6544, 0xc5920708, 0x1a067145, 0xc587ca31,
  0x19ef7944, 0xc57d965d, 0x19d87d42, 0xc5736b90,
  0x19c17d44, 0xc56949ca, 0x19aa794d, 0xc55f310d,
  0x19937161, 0xc555215a, 0x197c6584, 0xc54b1ab4,
  0x196555b8, 0xc5411d1b, 0x194e4201, 0xc5372891,
  0x19372a64, 0xc52d3d18, 0x19200ee3, 0xc5235ab2,
  0x1908ef82, 0xc519815f, 0x18f1cc45, 0xc50fb121,
  0x18daa52f, 0xc505e9fb, 0x18c37a44, 0xc4fc2bec,
  0x18ac4b87, 0xc4f276f7, 0x189518fc, 0xc4e8cb1e,
  0x187de2a7, 0xc4df2862, 0x1866a88a, 0xc4d58ec3,
  0x184f6aab, 0xc4cbfe45, 0x1838290c, 0xc4c276e8,
  0x1820e3b0, 0xc4b8f8ad, 0x18099a9c, 0xc4af8397,
  0x17f24dd3, 0xc4a617a6, 0x17dafd59, 0xc49cb4dd,
  0x17c3a931, 0xc4935b3c, 0x17ac515f, 0xc48a0ac4,
  0x1794f5e6, 0xc480c379, 0x177d96ca, 0xc477855a,
  0x1766340f, 0xc46e5069, 0x174ecdb8, 0xc46524a9,
  0x173763c9, 0xc45c0219, 0x171ff646, 0xc452e8bc,
  0x17088531, 0xc449d892, 0x16f1108f, 0xc440d19e,
  0x16d99864, 0xc437d3e1, 0x16c21cb2, 0xc42edf5c,
  0x16aa9d7e, 0xc425f410, 0x16931acb, 0xc41d11ff,
  0x167b949d, 0xc414392b, 0x16640af7, 0xc40b6994,
  0x164c7ddd, 0xc402a33c, 0x1634ed53, 0xc3f9e624,
  0x161d595d, 0xc3f1324e, 0x1605c1fd, 0xc3e887bb,
  0x15ee2738, 0xc3dfe66c, 0x15d68911, 0xc3d74e62,
  0x15bee78c, 0xc3cebfa0, 0x15a742ac, 0xc3c63a26,
  0x158f9a76, 0xc3bdbdf6, 0x1577eeec, 0xc3b54b11,
  0x15604013, 0xc3ace178, 0x15488dee, 0xc3a4812c,
  0x1530d881, 0xc39c2a2f, 0x15191fcf, 0xc393dc82,
  0x150163dc, 0xc38b9827, 0x14e9a4ac, 0xc3835d1e,
  0x14d1e242, 0xc37b2b6a, 0x14ba1ca3, 0xc373030a,
  0x14a253d1, 0xc36ae401, 0x148a87d1, 0xc362ce50,
  0x1472b8a5, 0xc35ac1f7, 0x145ae653, 0xc352bef9,
  0x144310dd, 0xc34ac556, 0x142b3846, 0xc342d510,
  0x14135c94, 0xc33aee27, 0x13fb7dc9, 0xc333109e,
  0x13e39be9, 0xc32b3c75, 0x13cbb6f8, 0xc32371ae,
  0x13b3cefa, 0xc31bb049, 0x139be3f2, 0xc313f848,
  0x1383f5e3, 0xc30c49ad, 0x136c04d2, 0xc304a477,
  0x135410c3, 0xc2fd08a9, 0x133c19b8, 0xc2f57644,
  0x13241fb6, 0xc2eded49, 0x130c22c1, 0xc2e66db8,
  0x12f422db, 0xc2def794, 0x12dc2009, 0xc2d78add,
  0x12c41a4f, 0xc2d02794, 0x12ac11af, 0xc2c8cdbb,
  0x1294062f, 0xc2c17d52, 0x127bf7d1, 0xc2ba365c,
  0x1263e699, 0xc2b2f8d8, 0x124bd28c, 0xc2abc4c9,
  0x1233bbac, 0xc2a49a2e, 0x121ba1fd, 0xc29d790a,
  0x12038584, 0xc296615d, 0x11eb6643, 0xc28f5329,
  0x11d3443f, 0xc2884e6e, 0x11bb1f7c, 0xc281532e,
  0x11a2f7fc, 0xc27a616a, 0x118acdc4, 0xc2737922,
  0x1172a0d7, 0xc26c9a58, 0x115a713a, 0xc265c50e,
  0x11423ef0, 0xc25ef943, 0x112a09fc, 0xc25836f9,
  0x1111d263, 0xc2517e31, 0x10f99827, 0xc24aceed,
  0x10e15b4e, 0xc244292c, 0x10c91bda, 0xc23d8cf1,
  0x10b0d9d0, 0xc236fa3b, 0x10989532, 0xc230710d,
  0x10804e06, 0xc229f167, 0x1068044e, 0xc2237b4b,
  0x104fb80e, 0xc21d0eb8, 0x1037694b, 0xc216abb1,
  0x101f1807, 0xc2105236, 0x1006c446, 0xc20a0248,
  0x0fee6e0d, 0xc203bbe8, 0x0fd6155f, 0xc1fd7f17,
  0x0fbdba40, 0xc1f74bd6, 0x0fa55cb4, 0xc1f12227,
  0x0f8cfcbe, 0xc1eb0209, 0x0f749a61, 0xc1e4eb7e,
  0x0f5c35a3, 0xc1dede87, 0x0f43ce86, 0xc1d8db25,
  0x0f2b650f, 0xc1d2e158, 0x0f12f941, 0xc1ccf122,
  0x0efa8b20, 0xc1c70a84, 0x0ee21aaf, 0xc1c12d7e,
  0x0ec9a7f3, 0xc1bb5a11, 0x0eb132ef, 0xc1b5903f,
  0x0e98bba7, 0xc1afd007, 0x0e80421e, 0xc1aa196c,
  0x0e67c65a, 0xc1a46c6e, 0x0e4f485c, 0xc19ec90d,
  0x0e36c82a, 0xc1992f4c, 0x0e1e45c6, 0xc1939f29,
  0x0e05c135, 0xc18e18a7, 0x0ded3a7b, 0xc1889bc6,
  0x0dd4b19a, 0xc1832888, 0x0dbc2698, 0xc17dbeec,
  0x0da39978, 0xc1785ef4, 0x0d8b0a3d, 0xc17308a1,
  0x0d7278eb, 0xc16dbbf3, 0x0d59e586, 0xc16878eb,
  0x0d415013, 0xc1633f8a, 0x0d28b894, 0xc15e0fd1,
  0x0d101f0e, 0xc158e9c1, 0x0cf78383, 0xc153cd5a,
  0x0cdee5f9, 0xc14eba9d, 0x0cc64673, 0xc149b18b,
  0x0cada4f5, 0xc144b225, 0x0c950182, 0xc13fbc6c,
  0x0c7c5c1e, 0xc13ad060, 0x0c63b4ce, 0xc135ee02,
  0x0c4b0b94, 0xc1311553, 0x0c326075, 0xc12c4653,
  0x0c19b374, 0xc1278104, 0x0c010496, 0xc122c566,
  0x0be853de, 0xc11e1379, 0x0bcfa150, 0xc1196b3f,
  0x0bb6ecef, 0xc114ccb9, 0x0b9e36c0, 0xc11037e6,
  0x0b857ec7, 0xc10bacc8, 0x0b6cc506, 0xc1072b5f,
  0x0b540982, 0xc102b3ac, 0x0b3b4c40, 0xc0fe45b0,
  0x0b228d42, 0xc0f9e16b, 0x0b09cc8c, 0xc0f586df,
  0x0af10a22, 0xc0f1360b, 0x0ad84609, 0xc0eceef1,
  0x0abf8043, 0xc0e8b190, 0x0aa6b8d5, 0xc0e47deb,
  0x0a8defc3, 0xc0e05401, 0x0a752510, 0xc0dc33d2,
  0x0a5c58c0, 0xc0d81d61, 0x0a438ad7, 0xc0d410ad,
  0x0a2abb59, 0xc0d00db6, 0x0a11ea49, 0xc0cc147f,
  0x09f917ac, 0xc0c82506, 0x09e04385, 0xc0c43f4d,
  0x09c76dd8, 0xc0c06355, 0x09ae96aa, 0xc0bc911d,
  0x0995bdfd, 0xc0b8c8a7, 0x097ce3d5, 0xc0b509f3,
  0x09640837, 0xc0b15502, 0x094b2b27, 0xc0ada9d4,
  0x09324ca7, 0xc0aa086a, 0x09196cbc, 0xc0a670c4,
  0x09008b6a, 0xc0a2e2e3, 0x08e7a8b5, 0xc09f5ec8,
  0x08cec4a0, 0xc09be473, 0x08b5df30, 0xc09873e4,
  0x089cf867, 0xc0950d1d, 0x0884104b, 0xc091b01d,
  0x086b26de, 0xc08e5ce5, 0x08523c25, 0xc08b1376,
  0x08395024, 0xc087d3d0, 0x082062de, 0xc0849df4,
  0x08077457, 0xc08171e2, 0x07ee8493, 0xc07e4f9b,
  0x07d59396, 0xc07b371e, 0x07bca163, 0xc078286e,
  0x07a3adff, 0xc0752389, 0x078ab96e, 0xc0722871,
  0x0771c3b3, 0xc06f3726, 0x0758ccd2, 0xc06c4fa8,
  0x073fd4cf, 0xc06971f9, 0x0726dbae, 0xc0669e18,
  0x070de172, 0xc063d405, 0x06f4e620, 0xc06113c2,
  0x06dbe9bb, 0xc05e5d4e, 0x06c2ec48, 0xc05bb0ab,
  0x06a9edc9, 0xc0590dd8, 0x0690ee44, 0xc05674d6,
  0x0677edbb, 0xc053e5a5, 0x065eec33, 0xc0516045,
  0x0645e9af, 0xc04ee4b8, 0x062ce634, 0xc04c72fe,
  0x0613e1c5, 0xc04a0b16, 0x05fadc66, 0xc047ad01,
  0x05e1d61b, 0xc04558c0, 0x05c8cee7, 0xc0430e53,
  0x05afc6d0, 0xc040cdba, 0x0596bdd7, 0xc03e96f6,
  0x057db403, 0xc03c6a07, 0x0564a955, 0xc03a46ed,
  0x054b9dd3, 0xc0382da8, 0x0532917f, 0xc0361e3a,
  0x0519845e, 0xc03418a2, 0x05007674, 0xc0321ce0,
  0x04e767c5, 0xc0302af5, 0x04ce5854, 0xc02e42e2,
  0x04b54825, 0xc02c64a6, 0x049c373c, 0xc02a9042,
  0x0483259d, 0xc028c5b6, 0x046a134c, 0xc0270502,
  0x0451004d, 0xc0254e27, 0x0437eca4, 0xc023a124,
  0x041ed854, 0xc021fdfb, 0x0405c361, 0xc02064ab,
  0x03ecadcf, 0xc01ed535, 0x03d397a3, 0xc01d4f99,
  0x03ba80df, 0xc01bd3d6, 0x03a16988, 0xc01a61ee,
  0x038851a2, 0xc018f9e1, 0x036f3931, 0xc0179bae,
  0x03562038, 0xc0164757, 0x033d06bb, 0xc014fcda,
  0x0323ecbe, 0xc013bc39, 0x030ad245, 0xc0128574,
  0x02f1b755, 0xc011588a, 0x02d89bf0, 0xc010357c,
  0x02bf801a, 0xc00f1c4a, 0x02a663d8, 0xc00e0cf5,
  0x028d472e, 0xc00d077c, 0x02742a1f, 0xc00c0be0,
  0x025b0caf, 0xc00b1a20, 0x0241eee2, 0xc00a323d,
  0x0228d0bb, 0xc0095438, 0x020fb240, 0xc008800f,
  0x01f69373, 0xc007b5c4, 0x01dd7459, 0xc006f556,
  0x01c454f5, 0xc0063ec6, 0x01ab354b, 0xc0059214,
  0x0192155f, 0xc004ef3f, 0x0178f536, 0xc0045648,
  0x015fd4d2, 0xc003c72f, 0x0146b438, 0xc00341f4,
  0x012d936c, 0xc002c697, 0x01147271, 0xc0025519,
  0x00fb514b, 0xc001ed78, 0x00e22fff, 0xc0018fb6,
  0x00c90e90, 0xc0013bd3, 0x00afed02, 0xc000f1ce,
  0x0096cb58, 0xc000b1a7, 0x007da998, 0xc0007b5f,
  0x006487c4, 0xc0004ef5, 0x004b65e1, 0xc0002c6a,
  0x003243f1, 0xc00013bd, 0x001921fb, 0xc00004ef,
  0x00000000, 0xc0000000, 0xffe6de05, 0xc00004ef,
  0xffcdbc0f, 0xc00013bd, 0xffb49a1f, 0xc0002c6a,
  0xff9b783c, 0xc0004ef5, 0xff825668, 0xc0007b5f,
  0xff6934a8, 0xc000b1a7, 0xff5012fe, 0xc000f1ce,
  0xff36f170, 0xc0013bd3, 0xff1dd001, 0xc0018fb6,
  0xff04aeb5, 0xc001ed78, 0xfeeb8d8f, 0xc0025519,
  0xfed26c94, 0xc002c697, 0xfeb94bc8, 0xc00341f4,
  0xfea02b2e, 0xc003c72f, 0xfe870aca, 0xc0045648,
  0xfe6deaa1, 0xc004ef3f, 0xfe54cab5, 0xc0059214,
  0xfe3bab0b, 0xc0063ec6, 0xfe228ba7, 0xc006f556,
  0xfe096c8d, 0xc007b5c4, 0xfdf04dc0, 0xc008800f,
  0xfdd72f45, 0xc0095438, 0xfdbe111e, 0xc00a323d,
  0xfda4f351, 0xc00b1a20, 0xfd8bd5e1, 0xc00c0be0,
  0xfd72b8d2, 0xc00d077c, 0xfd599c28, 0xc00e0cf5,
  0xfd407fe6, 0xc00f1c4a, 0xfd276410, 0xc010357c,
  0xfd0e48ab, 0xc011588a, 0xfcf52dbb, 0xc0128574,
  0xfcdc1342, 0xc013bc39, 0xfcc2f945, 0xc014fcda,
  0xfca9dfc8, 0xc0164757, 0xfc90c6cf, 0xc0179bae,
  0xfc77ae5e, 0xc018f9e1, 0xfc5e9678, 0xc01a61ee,
  0xfc457f21, 0xc01bd3d6, 0xfc2c685d, 0xc01d4f99,
  0xfc135231, 0xc01ed535, 0xfbfa3c9f, 0xc02064ab,
  0xfbe127ac, 0xc021fdfb, 0xfbc8135c, 0xc023a124,
  0xfbaeffb3, 0xc0254e27, 0xfb95ecb4, 0xc0270502,
  0xfb7cda63, 0xc028c5b6, 0xfb63c8c4, 0xc02a9042,
  0xfb4ab7db, 0xc02c64a6, 0xfb31a7ac, 0xc02e42e2,
  0xfb18983b, 0xc0302af5, 0xfaff898c, 0xc0321ce0,
  0xfae67ba2, 0xc03418a2, 0xfacd6e81, 0xc0361e3a,
  0xfab4622d, 0xc0382da8, 0xfa9b56ab, 0xc03a46ed,
  0xfa824bfd, 0xc03c6a07, 0xfa694229, 0xc03e96f6,
  0xfa503930, 0xc040cdba, 0xfa373119, 0xc0430e53,
  0xfa1e29e5, 0xc04558c0, 0xfa05239a, 0xc047ad01,
  0xf9ec1e3b, 0xc04a0b16, 0xf9d319cc, 0xc04c72fe,
  0xf9ba1651, 0xc04ee4b8, 0xf9a113cd, 0xc0516045,
  0xf9881245, 0xc053e5a5, 0xf96f11bc, 0xc05674d6,
  0xf9561237, 0xc0590dd8, 0xf93d13b8, 0xc05bb0ab,
  0xf9241645, 0xc05e5d4e, 0xf90b19e0, 0xc06113c2,
  0xf8f21e8e, 0xc063d405, 0xf8d92452, 0xc0669e18,
  0xf8c02b31, 0xc06971f9, 0xf8a7332e, 0xc06c4fa8,
  0xf88e3c4d, 0xc06f3726, 0xf8754692, 0xc0722871,
  0xf85c5201, 0xc0752389, 0xf8435e9d, 0xc078286e,
  0xf82a6c6a, 0xc07b371e, 0xf8117b6d, 0xc07e4f9b,
  0xf7f88ba9, 0xc08171e2, 0xf7df9d22, 0xc0849df4,
  0xf7c6afdc, 0xc087d3d0, 0xf7adc3db, 0xc08b1376,
  0xf794d922, 0xc08e5ce5, 0xf77befb5, 0xc091b01d,
  0xf7630799, 0xc0950d1d, 0xf74a20d0, 0xc09873e4,
  0xf7313b60, 0xc09be473, 0xf718574b, 0xc09f5ec8,
  0xf6ff7496, 0xc0a2e2e3, 0xf6e69344, 0xc0a670c4,
  0xf6cdb359, 0xc0aa086a, 0xf6b4d4d9, 0xc0ada9d4,
  0xf69bf7c9, 0xc0b15502, 0xf6831c2b, 0xc0b509f3,
  0xf66a4203, 0xc0b8c8a7, 0xf6516956, 0xc0bc911d,
  0xf6389228, 0xc0c06355, 0xf61fbc7b, 0xc0c43f4d,
  0xf606e854, 0xc0c82506, 0xf5ee15b7, 0xc0cc147f,
  0xf5d544a7, 0xc0d00db6, 0xf5bc7529, 0xc0d410ad,
  0xf5a3a740, 0xc0d81d61, 0xf58adaf0, 0xc0dc33d2,
  0xf572103d, 0xc0e05401, 0xf559472b, 0xc0e47deb,
  0xf5407fbd, 0xc0e8b190, 0xf527b9f7, 0xc0eceef1,
  0xf50ef5de, 0xc0f1360b, 0xf4f63374, 0xc0f586df,
  0xf4dd72be, 0xc0f9e16b, 0xf4c4b3c0, 0xc0fe45b0,
  0xf4abf67e, 0xc102b3ac, 0xf4933afa, 0xc1072b5f,
  0xf47a8139, 0xc10bacc8, 0xf461c940, 0xc11037e6,
  0xf4491311, 0xc114ccb9, 0xf4305eb0, 0xc1196b3f,
  0xf417ac22, 0xc11e1379, 0xf3fefb6a, 0xc122c566,
  0xf3e64c8c, 0xc1278104, 0xf3cd9f8b, 0xc12c4653,
  0xf3b4f46c, 0xc1311553, 0xf39c4b32, 0xc135ee02,
  0xf383a3e2, 0xc13ad060, 0xf36afe7e, 0xc13fbc6c,
  0xf3525b0b, 0xc144b225, 0xf339b98d, 0xc149b18b,
  0xf3211a07, 0xc14eba9d, 0xf3087c7d, 0xc153cd5a,
  0xf2efe0f2, 0xc158e9c1, 0xf2d7476c, 0xc15e0fd1,
  0xf2beafed, 0xc1633f8a, 0xf2a61a7a, 0xc16878eb,
  0xf28d8715, 0xc16dbbf3, 0xf274f5c3, 0xc17308a1,
  0xf25c6688, 0xc1785ef4, 0xf243d968, 0xc17dbeec,
  0xf22b4e66, 0xc1832888, 0xf212c585, 0xc1889bc6,
  0xf1fa3ecb, 0xc18e18a7, 0xf1e1ba3a, 0xc1939f29,
  0xf1c937d6, 0xc1992f4c, 0xf1b0b7a4, 0xc19ec90d,
  0xf19839a6, 0xc1a46c6e, 0xf17fbde2, 0xc1aa196c,
  0xf1674459, 0xc1afd007, 0xf14ecd11, 0xc1b5903f,
  0xf136580d, 0xc1bb5a11, 0xf11de551, 0xc1c12d7e,
  0xf10574e0, 0xc1c70a84, 0xf0ed06bf, 0xc1ccf122,
  0xf0d49af1, 0xc1d2e158, 0xf0bc317a, 0xc1d8db25,
  0xf0a3ca5d, 0xc1dede87, 0xf08b659f, 0xc1e4eb7e,
  0xf0730342, 0xc1eb0209, 0xf05aa34c, 0xc1f12227,
  0xf04245c0, 0xc1f74bd6, 0xf029eaa1, 0xc1fd7f17,
  0xf01191f3, 0xc203bbe8, 0xeff93bba, 0xc20a0248,
  0xefe0e7f9, 0xc2105236, 0xefc896b5, 0xc216abb1,
  0xefb047f2, 0xc21d0eb8, 0xef97fbb2, 0xc2237b4b,
  0xef7fb1fa, 0xc229f167, 0xef676ace, 0xc230710d,
  0xef4f2630, 0xc236fa3b, 0xef36e426, 0xc23d8cf1,
  0xef1ea4b2, 0xc244292c, 0xef0667d9, 0xc24aceed,
  0xeeee2d9d, 0xc2517e31, 0xeed5f604, 0xc25836f9,
  0xeebdc110, 0xc25ef943, 0xeea58ec6, 0xc265c50e,
  0xee8d5f29, 0xc26c9a58, 0xee75323c, 0xc2737922,
  0xee5d0804, 0xc27a616a, 0xee44e084, 0xc281532e,
  0xee2cbbc1, 0xc2884e6e, 0xee1499bd, 0xc28f5329,
  0xedfc7a7c, 0xc296615d, 0xede45e03, 0xc29d790a,
  0xedcc4454, 0xc2a49a2e, 0xedb42d74, 0xc2abc4c9,
  0xed9c1967, 0xc2b2f8d8, 0xed84082f, 0xc2ba365c,
  0xed6bf9d1, 0xc2c17d52, 0xed53ee51, 0xc2c8cdbb,
  0xed3be5b1, 0xc2d02794, 0xed23dff7, 0xc2d78add,
  0xed0bdd25, 0xc2def794, 0xecf3dd3f, 0xc2e66db8,
  0xecdbe04a, 0xc2eded49, 0xecc3e648, 0xc2f57644,
  0xecabef3d, 0xc2fd08a9, 0xec93fb2e, 0xc304a477,
  0xec7c0a1d, 0xc30c49ad, 0xec641c0e, 0xc313f848,
  0xec4c3106, 0xc31bb049, 0xec344908, 0xc32371ae,
  0xec1c6417, 0xc32b3c75, 0xec048237, 0xc333109e,
  0xebeca36c, 0xc33aee27, 0xebd4c7ba, 0xc342d510,
  0xebbcef23, 0xc34ac556, 0xeba519ad, 0xc352bef9,
  0xeb8d475b, 0xc35ac1f7, 0xeb75782f, 0xc362ce50,
  0xeb5dac2f, 0xc36ae401, 0xeb45e35d, 0xc373030a,
  0xeb2e1dbe, 0xc37b2b6a, 0xeb165b54, 0xc3835d1e,
  0xeafe9c24, 0xc38b9827, 0xeae6e031, 0xc393dc82,
  0xeacf277f, 0xc39c2a2f, 0xeab77212, 0xc3a4812c,
  0xea9fbfed, 0xc3ace178, 0xea881114, 0xc3b54b11,
  0xea70658a, 0xc3bdbdf6, 0xea58bd54, 0xc3c63a26,
  0xea411874, 0xc3cebfa0, 0xea2976ef, 0xc3d74e62,
  0xea11d8c8, 0xc3dfe66c, 0xe9fa3e03, 0xc3e887bb,
  0xe9e2a6a3, 0xc3f1324e, 0xe9cb12ad, 0xc3f9e624,
  0xe9b38223, 0xc402a33c, 0xe99bf509, 0xc40b6994,
  0xe9846b63, 0xc414392b, 0xe96ce535, 0xc41d11ff,
  0xe9556282, 0xc425f410, 0xe93de34e, 0xc42edf5c,
  0xe926679c, 0xc437d3e1, 0xe90eef71, 0xc440d19e,
  0xe8f77acf, 0xc449d892, 0xe8e009ba, 0xc452e8bc,
  0xe8c89c37, 0xc45c0219, 0xe8b13248, 0xc46524a9,
  0xe899cbf1, 0xc46e5069, 0xe8826936, 0xc477855a,
  0xe86b0a1a, 0xc480c379, 0xe853aea1, 0xc48a0ac4,
  0xe83c56cf, 0xc4935b3c, 0xe82502a7, 0xc49cb4dd,
  0xe80db22d, 0xc4a617a6, 0xe7f66564, 0xc4af8397,
  0xe7df1c50, 0xc4b8f8ad, 0xe7c7d6f4, 0xc4c276e8,
  0xe7b09555, 0xc4cbfe45, 0xe7995776, 0xc4d58ec3,
  0xe7821d59, 0xc4df2862, 0xe76ae704, 0xc4e8cb1e,
  0xe753b479, 0xc4f276f7, 0xe73c85bc, 0xc4fc2bec,
  0xe7255ad1, 0xc505e9fb, 0xe70e33bb, 0xc50fb121,
  0xe6f7107e, 0xc519815f, 0xe6dff11d, 0xc5235ab2,
  0xe6c8d59c, 0xc52d3d18, 0xe6b1bdff, 0xc5372891,
  0xe69aaa48, 0xc5411d1b, 0xe6839a7c, 0xc54b1ab4,
  0xe66c8e9f, 0xc555215a, 0xe65586b3, 0xc55f310d,
  0xe63e82bc, 0xc56949ca, 0xe62782be, 0xc5736b90,
  0xe61086bc, 0xc57d965d, 0xe5f98ebb, 0xc587ca31,
  0xe5e29abc, 0xc5920708, 0xe5cbaac5, 0xc59c4ce3,
  0xe5b4bed8, 0xc5a69bbe, 0xe59dd6f9, 0xc5b0f399,
  0xe586f32c, 0xc5bb5472, 0xe5701374, 0xc5c5be47,
  0xe55937d5, 0xc5d03118, 0xe5426051, 0xc5daace1,
  0xe52b8cee, 0xc5e531a1, 0xe514bdad, 0xc5efbf58,
  0xe4fdf294, 0xc5fa5603, 0xe4e72ba4, 0xc604f5a0,
  0xe4d068e2, 0xc60f9e2e, 0xe4b9aa52, 0xc61a4fac,
  0xe4a2eff6, 0xc6250a18, 0xe48c39d3, 0xc62fcd6f,
  0xe47587eb, 0xc63a99b1, 0xe45eda43, 0xc6456edb,
  0xe44830dd, 0xc6504ced, 0xe4318bbe, 0xc65b33e4,
  0xe41aeae8, 0xc66623be, 0xe4044e60, 0xc6711c7b,
  0xe3edb628, 0xc67c1e18, 0xe3d72245, 0xc6872894,
  0xe3c092b9, 0xc6923bec, 0xe3aa0788, 0xc69d5820,
  0xe39380b6, 0xc6a87d2d, 0xe37cfe47, 0xc6b3ab12,
  0xe366803c, 0xc6bee1cd, 0xe350069b, 0xc6ca215c,
  0xe3399167, 0xc6d569be, 0xe32320a2, 0xc6e0baf0,
  0xe30cb451, 0xc6ec14f2, 0xe2f64c77, 0xc6f777c1,
  0xe2dfe917, 0xc702e35c, 0xe2c98a35, 0xc70e57c0,
  0xe2b32fd4, 0xc719d4ed, 0xe29cd9f8, 0xc7255ae0,
  0xe28688a4, 0xc730e997, 0xe2703bdc, 0xc73c8111,
  0xe259f3a3, 0xc748214c, 0xe243affc, 0xc753ca46,
  0xe22d70eb, 0xc75f7bfe, 0xe2173674, 0xc76b3671,
  0xe2010099, 0xc776f99d, 0xe1eacf5f, 0xc782c582,
  0xe1d4a2c8, 0xc78e9a1d, 0xe1be7ad8, 0xc79a776c,
  0xe1a85793, 0xc7a65d6e, 0xe19238fb, 0xc7b24c20,
  0xe17c1f15, 0xc7be4381, 0xe16609e3, 0xc7ca438f,
  0xe14ff96a, 0xc7d64c47, 0xe139edac, 0xc7e25daa,
  0xe123e6ad, 0xc7ee77b3, 0xe10de470, 0xc7fa9a62,
  0xe0f7e6f9, 0xc806c5b5, 0xe0e1ee4b, 0xc812f9a9,
  0xe0cbfa6a, 0xc81f363d, 0xe0b60b58, 0xc82b7b70,
  0xe0a0211a, 0xc837c93e, 0xe08a3bb2, 0xc8441fa6,
  0xe0745b24, 0xc8507ea7, 0xe05e7f74, 0xc85ce63e,
  0xe048a8a4, 0xc869566a, 0xe032d6b8, 0xc875cf28,
  0xe01d09b4, 0xc8825077, 0xe007419b, 0xc88eda54,
  0xdff17e70, 0xc89b6cbf, 0xdfdbc036, 0xc8a807b4,
  0xdfc606f1, 0xc8b4ab32, 0xdfb052a5, 0xc8c15736,
  0xdf9aa354, 0xc8ce0bc0, 0xdf84f902, 0xc8dac8cd,
  0xdf6f53b3, 0xc8e78e5b, 0xdf59b369, 0xc8f45c68,
  0xdf441828, 0xc90132f2, 0xdf2e81f3, 0xc90e11f7,
  0xdf18f0ce, 0xc91af976, 0xdf0364bc, 0xc927e96b,
  0xdeedddc0, 0xc934e1d6, 0xded85bdd, 0xc941e2b4,
  0xdec2df18, 0xc94eec03, 0xdead6773, 0xc95bfdc1,
  0xde97f4f1, 0xc96917ec, 0xde828796, 0xc9763a83,
  0xde6d1f65, 0xc9836582, 0xde57bc62, 0xc99098e9,
  0xde425e8f, 0xc99dd4b4, 0xde2d05f1, 0xc9ab18e3,
  0xde17b28a, 0xc9b86572, 0xde02645d, 0xc9c5ba60,
  0xdded1b6e, 0xc9d317ab, 0xddd7d7c1, 0xc9e07d51,
  0xddc29958, 0xc9edeb50, 0xddad6036, 0xc9fb61a5,
  0xdd982c60, 0xca08e04f, 0xdd82fdd8, 0xca16674b,
  0xdd6dd4a2, 0xca23f698, 0xdd58b0c0, 0xca318e32,
  0xdd439236, 0xca3f2e19, 0xdd2e7908, 0xca4cd64b,
  0xdd196538, 0xca5a86c4, 0xdd0456ca, 0xca683f83,
  0xdcef4dc2, 0xca760086, 0xdcda4a21, 0xca83c9ca,
  0xdcc54bec, 0xca919b4e, 0xdcb05326, 0xca9f750f,
  0xdc9b5fd2, 0xcaad570c, 0xdc8671f3, 0xcabb4141,
  0xdc71898d, 0xcac933ae, 0xdc5ca6a2, 0xcad72e4f,
  0xdc47c936, 0xcae53123, 0xdc32f14d, 0xcaf33c28,
  0xdc1e1ee9, 0xcb014f5b, 0xdc09520d, 0xcb0f6aba,
  0xdbf48abd, 0xcb1d8e43, 0xdbdfc8fc, 0xcb2bb9f4,
  0xdbcb0cce, 0xcb39edca, 0xdbb65634, 0xcb4829c4,
  0xdba1a534, 0xcb566ddf, 0xdb8cf9cf, 0xcb64ba19,
  0xdb785409, 0xcb730e70, 0xdb63b3e5, 0xcb816ae1,
  0xdb4f1967, 0xcb8fcf6b, 0xdb3a8491, 0xcb9e3c0b,
  0xdb25f566, 0xcbacb0bf, 0xdb116beb, 0xcbbb2d85,
  0xdafce821, 0xcbc9b25a, 0xdae86a0d, 0xcbd83f3d,
  0xdad3f1b1, 0xcbe6d42b, 0xdabf7f11, 0xcbf57121,
  0xdaab122f, 0xcc04161e, 0xda96ab0f, 0xcc12c31f,
  0xda8249b4, 0xcc217822, 0xda6dee21, 0xcc303524,
  0xda599859, 0xcc3efa25, 0xda454860, 0xcc4dc720,
  0xda30fe38, 0xcc5c9c14, 0xda1cb9e5, 0xcc6b78ff,
  0xda087b69, 0xcc7a5dde, 0xd9f442c9, 0xcc894aaf,
  0xd9e01006, 0xcc983f70, 0xd9cbe325, 0xcca73c1e,
  0xd9b7bc27, 0xccb640b8, 0xd9a39b11, 0xccc54d3a,
  0xd98f7fe6, 0xccd461a2, 0xd97b6aa8, 0xcce37def,
  0xd9675b5a, 0xccf2a21d, 0xd9535201, 0xcd01ce2b,
  0xd93f4e9e, 0xcd110216, 0xd92b5135, 0xcd203ddc,
  0xd91759c9, 0xcd2f817b, 0xd903685d, 0xcd3eccef,
  0xd8ef7cf4, 0xcd4e2037, 0xd8db9792, 0xcd5d7b50,
  0xd8c7b838, 0xcd6cde39, 0xd8b3deeb, 0xcd7c48ee,
  0xd8a00bae, 0xcd8bbb6d, 0xd88c3e83, 0xcd9b35b4,
  0xd878776d, 0xcdaab7c0, 0xd864b670, 0xcdba4190,
  0xd850fb8e, 0xcdc9d320, 0xd83d46cc, 0xcdd96c6f,
  0xd829982b, 0xcde90d79, 0xd815efae, 0xcdf8b63d,
  0xd8024d59, 0xce0866b8, 0xd7eeb130, 0xce181ee8,
  0xd7db1b34, 0xce27dec9, 0xd7c78b68, 0xce37a65b,
  0xd7b401d1, 0xce47759a, 0xd7a07e70, 0xce574c84,
  0xd78d014a, 0xce672b16, 0xd7798a60, 0xce77114e,
  0xd76619b6, 0xce86ff2a, 0xd752af4f, 0xce96f4a7,
  0xd73f4b2e, 0xcea6f1c2, 0xd72bed55, 0xceb6f67a,
  0xd71895c9, 0xcec702cb, 0xd705448b, 0xced716b4,
  0xd6f1f99f, 0xcee73231, 0xd6deb508, 0xcef75541,
  0xd6cb76c9, 0xcf077fe1, 0xd6b83ee4, 0xcf17b20d,
  0xd6a50d5d, 0xcf27ebc5, 0xd691e237, 0xcf382d05,
  0xd67ebd74, 0xcf4875ca, 0xd66b9f18, 0xcf58c613,
  0xd6588725, 0xcf691ddd, 0xd645759f, 0xcf797d24,
  0xd6326a88, 0xcf89e3e8, 0xd61f65e4, 0xcf9a5225,
  0xd60c67b4, 0xcfaac7d8, 0xd5f96ffd, 0xcfbb4500,
  0xd5e67ec1, 0xcfcbc999, 0xd5d39403, 0xcfdc55a1,
  0xd5c0afc6, 0xcfece915, 0xd5add20d, 0xcffd83f4,
  0xd59afadb, 0xd00e2639, 0xd5882a32, 0xd01ecfe4,
  0xd5756016, 0xd02f80f1, 0xd5629c89, 0xd040395d,
  0xd54fdf8f, 0xd050f926, 0xd53d292a, 0xd061c04a,
  0xd52a795d, 0xd0728ec6, 0xd517d02b, 0xd0836497,
  0xd5052d97, 0xd09441bb, 0xd4f291a4, 0xd0a5262f,
  0xd4dffc54, 0xd0b611f1, 0xd4cd6dab, 0xd0c704fd,
  0xd4bae5ab, 0xd0d7ff51, 0xd4a86458, 0xd0e900ec,
  0xd495e9b3, 0xd0fa09c9, 0xd48375c1, 0xd10b19e7,
  0xd4710883, 0xd11c3142, 0xd45ea1fd, 0xd12d4fd9,
  0xd44c4232, 0xd13e75a8, 0xd439e923, 0xd14fa2ad,
  0xd42796d5, 0xd160d6e5, 0xd4154b4a, 0xd172124d,
  0xd4030684, 0xd18354e4, 0xd3f0c887, 0xd1949ea6,
  0xd3de9156, 0xd1a5ef90, 0xd3cc60f2, 0xd1b747a0,
  0xd3ba3760, 0xd1c8a6d4, 0xd3a814a2, 0xd1da0d28,
  0xd395f8ba, 0xd1eb7a9a, 0xd383e3ab, 0xd1fcef27,
  0xd371d579, 0xd20e6acc, 0xd35fce26, 0xd21fed88,
  0xd34dcdb4, 0xd2317756, 0xd33bd427, 0xd2430835,
  0xd329e181, 0xd254a021, 0xd317f5c6, 0xd2663f19,
  0xd30610f7, 0xd277e518, 0xd2f43318, 0xd289921e,
  0xd2e25c2b, 0xd29b4626, 0xd2d08c33, 0xd2ad012e,
  0xd2bec333, 0xd2bec333, 0xd2ad012e, 0xd2d08c33,
  0xd29b4626, 0xd2e25c2b, 0xd289921e, 0xd2f43318,
  0xd277e518, 0xd30610f7, 0xd2663f19, 0xd317f5c6,
  0xd254a021, 0xd329e181, 0xd2430835, 0xd33bd427,
  0xd2317756, 0xd34dcdb4, 0xd21fed88, 0xd35fce26,
  0xd20e6acc, 0xd371d579, 0xd1fcef27, 0xd383e3ab,
  0xd1eb7a9a, 0xd395f8ba, 0xd1da0d28, 0xd3a814a2,
  0xd1c8a6d4, 0xd3ba3760, 0xd1b747a0, 0xd3cc60f2,
  0xd1a5ef90, 0xd3de9156, 0xd1949ea6, 0xd3f0c887,
  0xd18354e4, 0xd4030684, 0xd172124d, 0xd4154b4a,
  0xd160d6e5, 0xd42796d5, 0xd14fa2ad, 0xd439e923,
  0xd13e75a8, 0xd44c4232, 0xd12d4fd9, 0xd45ea1fd,
  0xd11c3142, 0xd4710883, 0xd10b19e7, 0xd48375c1,
  0xd0fa09c9, 0xd495e9b3, 0xd0e900ec, 0xd4a86458,
  0xd0d7ff51, 0xd4bae5ab, 0xd0c704fd, 0xd4cd6dab,
  0xd0b611f1, 0xd4dffc54, 0xd0a5262f, 0xd4f291a4,
  0xd09441bb, 0xd5052d97, 0xd0836497, 0xd517d02b,
  0xd0728ec6, 0xd52a795d, 0xd061c04a, 0xd53d292a,
  0xd050f926, 0xd54fdf8f, 0xd040395d, 0xd5629c89,
  0xd02f80f1, 0xd5756016, 0xd01ecfe4, 0xd5882a32,
  0xd00e2639, 0xd59afadb, 0xcffd83f4, 0xd5add20d,
  0xcfece915, 0xd5c0afc6, 0xcfdc55a1, 0xd5d39403,
  0xcfcbc999, 0xd5e67ec1, 0xcfbb4500, 0xd5f96ffd,
  0xcfaac7d8, 0xd60c67b4, 0xcf9a5225, 0xd61f65e4,
  0xcf89e3e8, 0xd6326a88, 0xcf797d24, 0xd645759f,
  0xcf691ddd, 0xd6588725, 0xcf58c613, 0xd66b9f18,
  0xcf4875ca, 0xd67ebd74, 0xcf382d05, 0xd691e237,
  0xcf27ebc5, 0xd6a50d5d, 0xcf17b20d, 0xd6b83ee4,
  0xcf077fe1, 0xd6cb76c9, 0xcef75541, 0xd6deb508,
  0xcee73231, 0xd6f1f99f, 0xced716b4, 0xd705448b,
  0xcec702cb, 0xd71895c9, 0xceb6f67a, 0xd72bed55,
  0xcea6f1c2, 0xd73f4b2e, 0xce96f4a7, 0xd752af4f,
  0xce86ff2a, 0xd76619b6, 0xce77114e, 0xd7798a60,
  0xce672b16, 0xd78d014a, 0xce574c84, 0xd7a07e70,
  0xce47759a, 0xd7b401d1, 0xce37a65b, 0xd7c78b68,
  0xce27dec9, 0xd7db1b34, 0xce181ee8, 0xd7eeb130,
  0xce0866b8, 0xd8024d59, 0xcdf8b63d, 0xd815efae,
  0xcde90d79, 0xd829982b, 0xcdd96c6f, 0xd83d46cc,
  0xcdc9d320, 0xd850fb8e, 0xcdba4190, 0xd864b670,
  0xcdaab7c0, 0xd878776d, 0xcd9b35b4, 0xd88c3e83,
  0xcd8bbb6d, 0xd8a00bae, 0xcd7c48ee, 0xd8b3deeb,
  0xcd6cde39, 0xd8c7b838, 0xcd5d7b50, 0xd8db9792,
  0xcd4e2037, 0xd8ef7cf4, 0xcd3eccef, 0xd903685d,
  0xcd2f817b, 0xd91759c9, 0xcd203ddc, 0xd92b5135,
  0xcd110216, 0xd93f4e9e, 0xcd01ce2b, 0xd9535201,
  0xccf2a21d, 0xd9675b5a, 0xcce37def, 0xd97b6aa8,
  0xccd461a2, 0xd98f7fe6, 0xccc54d3a, 0xd9a39b11,
  0xccb640b8, 0xd9b7bc27, 0xcca73c1e, 0xd9cbe325,
  0xcc983f70, 0xd9e01006, 0xcc894aaf, 0xd9f442c9,
  0xcc7a5dde, 0xda087b69, 0xcc6b78ff, 0xda1cb9e5,
  0xcc5c9c14, 0xda30fe38, 0xcc4dc720, 0xda454860,
  0xcc3efa25, 0xda599859, 0xcc303524, 0xda6dee21,
  0xcc217822, 0xda8249b4, 0xcc12c31f, 0xda96ab0f,
  0xcc04161e, 0xdaab122f, 0xcbf57121, 0xdabf7f11,
  0xcbe6d42b, 0xdad3f1b1, 0xcbd83f3d, 0xdae86a0d,
  0xcbc9b25a, 0xdafce821, 0xcbbb2d85, 0xdb116beb,
  0xcbacb0bf, 0xdb25f566, 0xcb9e3c0b, 0xdb3a8491,
  0xcb8fcf6b, 0xdb4f1967, 0xcb816ae1, 0xdb63b3e5,
  0xcb730e70, 0xdb785409, 0xcb64ba19, 0xdb8cf9cf,
  0xcb566ddf, 0xdba1a534, 0xcb4829c4, 0xdbb65634,
  0xcb39edca, 0xdbcb0cce, 0xcb2bb9f4, 0xdbdfc8fc,
  0xcb1d8e43, 0xdbf48abd, 0xcb0f6aba, 0xdc09520d,
  0xcb014f5b, 0xdc1e1ee9, 0xcaf33c28, 0xdc32f14d,
  0xcae53123, 0xdc47c936, 0xcad72e4f, 0xdc5ca6a2,
  0xcac933ae, 0xdc71898d, 0xcabb4141, 0xdc8671f3,
  0xcaad570c, 0xdc9b5fd2, 0xca9f750f, 0xdcb05326,
  0xca919b4e, 0xdcc54bec, 0xca83c9ca, 0xdcda4a21,
  0xca760086, 0xdcef4dc2, 0xca683f83, 0xdd0456ca,
  0xca5a86c4, 0xdd196538, 0xca4cd64b, 0xdd2e7908,
  0xca3f2e19, 0xdd439236, 0xca318e32, 0xdd58b0c0,
  0xca23f698, 0xdd6dd4a2, 0xca16674b, 0xdd82fdd8,
  0xca08e04f, 0xdd982c60, 0xc9fb61a5, 0xddad6036,
  0xc9edeb50, 0xddc29958, 0xc9e07d51, 0xddd7d7c1,
  0xc9d317ab, 0xdded1b6e, 0xc9c5ba60, 0xde02645d,
  0xc9b86572, 0xde17b28a, 0xc9ab18e3, 0xde2d05f1,
  0xc99dd4b4, 0xde425e8f, 0xc99098e9, 0xde57bc62,
  0xc9836582, 0xde6d1f65, 0xc9763a83, 0xde828796,
  0xc96917ec, 0xde97f4f1, 0xc95bfdc1, 0xdead6773,
  0xc94eec03, 0xdec2df18, 0xc941e2b4, 0xded85bdd,
  0xc934e1d6, 0xdeedddc0, 0xc927e96b, 0xdf0364bc,
  0xc91af976, 0xdf18f0ce, 0xc90e11f7, 0xdf2e81f3,
  0xc90132f2, 0xdf441828, 0xc8f45c68, 0xdf59b369,
  0xc8e78e5b, 0xdf6f53b3, 0xc8dac8cd, 0xdf84f902,
  0xc8ce0bc0, 0xdf9aa354, 0xc8c15736, 0xdfb052a5,
  0xc8b4ab32, 0xdfc606f1, 0xc8a807b4, 0xdfdbc036,
  0xc89b6cbf, 0xdff17e70, 0xc88eda54, 0xe007419b,
  0xc8825077, 0xe01d09b4, 0xc875cf28, 0xe032d6b8,
  0xc869566a, 0xe048a8a4, 0xc85ce63e, 0xe05e7f74,
  0xc8507ea7, 0xe0745b24, 0xc8441fa6, 0xe08a3bb2,
  0xc837c93e, 0xe0a0211a, 0xc82b7b70, 0xe0b60b58,
  0xc81f363d, 0xe0cbfa6a, 0xc812f9a9, 0xe0e1ee4b,
  0xc806c5b5, 0xe0f7e6f9, 0xc7fa9a62, 0xe10de470,
  0xc7ee77b3, 0xe123e6ad, 0xc7e25daa, 0xe139edac,
  0xc7d64c47, 0xe14ff96a, 0xc7ca438f, 0xe16609e3,
  0xc7be4381, 0xe17c1f15, 0xc7b24c20, 0xe19238fb,
  0xc7a65d6e, 0xe1a85793, 0xc79a776c, 0xe1be7ad8,
  0xc78e9a1d, 0xe1d4a2c8, 0xc782c582, 0xe1eacf5f,
  0xc776f99d, 0xe2010099, 0xc76b3671, 0xe2173674,
  0xc75f7bfe, 0xe22d70eb, 0xc753ca46, 0xe243affc,
  0xc748214c, 0xe259f3a3, 0xc73c8111, 0xe2703bdc,
  0xc730e997, 0xe28688a4, 0xc7255ae0, 0xe29cd9f8,
  0xc719d4ed, 0xe2b32fd4, 0xc70e57c0, 0xe2c98a35,
  0xc702e35c, 0xe2dfe917, 0xc6f777c1, 0xe2f64c77,
  0xc6ec14f2, 0xe30cb451, 0xc6e0baf0, 0xe32320a2,
  0xc6d569be, 0xe3399167, 0xc6ca215c, 0xe350069b,
  0xc6bee1cd, 0xe366803c, 0xc6b3ab12, 0xe37cfe47,
  0xc6a87d2d, 0xe39380b6, 0xc69d5820, 0xe3aa0788,
  0xc6923bec, 0xe3c092b9, 0xc6872894, 0xe3d72245,
  0xc67c1e18, 0xe3edb628, 0xc6711c7b, 0xe4044e60,
  0xc66623be, 0xe41aeae8, 0xc65b33e4, 0xe4318bbe,
  0xc6504ced, 0xe44830dd, 0xc6456edb, 0xe45eda43,
  0xc63a99b1, 0xe47587eb, 0xc62fcd6f, 0xe48c39d3,
  0xc6250a18, 0xe4a2eff6, 0xc61a4fac, 0xe4b9aa52,
  0xc60f9e2e, 0xe4d068e2, 0xc604f5a0, 0xe4e72ba4,
  0xc5fa5603, 0xe4fdf294, 0xc5efbf58, 0xe514bdad,
  0xc5e531a1, 0xe52b8cee, 0xc5daace1, 0xe5426051,
  0xc5d03118, 0xe55937d5, 0xc5c5be47, 0xe5701374,
  0xc5bb5472, 0xe586f32c, 0xc5b0f399, 0xe59dd6f9,
  0xc5a69bbe, 0xe5b4bed8, 0xc59c4ce3, 0xe5cbaac5,
  0xc5920708, 0xe5e29abc, 0xc587ca31, 0xe5f98ebb,
  0xc57d965d, 0xe61086bc, 0xc5736b90, 0xe62782be,
  0xc56949ca, 0xe63e82bc, 0xc55f310d, 0xe65586b3,
  0xc555215a, 0xe66c8e9f, 0xc54b1ab4, 0xe6839a7c,
  0xc5411d1b, 0xe69aaa48, 0xc5372891, 0xe6b1bdff,
  0xc52d3d18, 0xe6c8d59c, 0xc5235ab2, 0xe6dff11d,
  0xc519815f, 0xe6f7107e, 0xc50fb121, 0xe70e33bb,
  0xc505e9fb, 0xe7255ad1, 0xc4fc2bec, 0xe73c85bc,
  0xc4f276f7, 0xe753b479, 0xc4e8cb1e, 0xe76ae704,
  0xc4df2862, 0xe7821d59, 0xc4d58ec3, 0xe7995776,
  0xc4cbfe45, 0xe7b09555, 0xc4c276e8, 0xe7c7d6f4,
  0xc4b8f8ad, 0xe7df1c50, 0xc4af8397, 0xe7f66564,
  0xc4a617a6, 0xe80db22d, 0xc49cb4dd, 0xe82502a7,
  0xc4935b3c, 0xe83c56cf, 0xc48a0ac4, 0xe853aea1,
  0xc480c379, 0xe86b0a1a, 0xc477855a, 0xe8826936,
  0xc46e5069, 0xe899cbf1, 0xc46524a9, 0xe8b13248,
  0xc45c0219, 0xe8c89c37, 0xc452e8bc, 0xe8e009ba,
  0xc449d892, 0xe8f77acf, 0xc440d19e, 0xe90eef71,
  0xc437d3e1, 0xe926679c, 0xc42edf5c, 0xe93de34e,
  0xc425f410, 0xe9556282, 0xc41d11ff, 0xe96ce535,
  0xc414392b, 0xe9846b63, 0xc40b6994, 0xe99bf509,
  0xc402a33c, 0xe9b38223, 0xc3f9e624, 0xe9cb12ad,
  0xc3f1324e, 0xe9e2a6a3, 0xc3e887bb, 0xe9fa3e03,
  0xc3dfe66c, 0xea11d8c8, 0xc3d74e62, 0xea2976ef,
  0xc3cebfa0, 0xea411874, 0xc3c63a26, 0xea58bd54,
  0xc3bdbdf6, 0xea70658a, 0xc3b54b11, 0xea881114,
  0xc3ace178, 0xea9fbfed, 0xc3a4812c, 0xeab77212,
  0xc39c2a2f, 0xeacf277f, 0xc393dc82, 0xeae6e031,
  0xc38b9827, 0xeafe9c24, 0xc3835d1e, 0xeb165b54,
  0xc37b2b6a, 0xeb2e1dbe, 0xc373030a, 0xeb45e35d,
  0xc36ae401, 0xeb5dac2f, 0xc362ce50, 0xeb75782f,
  0xc35ac1f7, 0xeb8d475b, 0xc352bef9, 0xeba519ad,
  0xc34ac556, 0xebbcef23, 0xc342d510, 0xebd4c7ba,
  0xc33aee27, 0xebeca36c, 0xc333109e, 0xec048237,
  0xc32b3c75, 0xec1c6417, 0xc32371ae, 0xec344908,
  0xc31bb049, 0xec4c3106, 0xc313f848, 0xec641c0e,
  0xc30c49ad, 0xec7c0a1d, 0xc304a477, 0xec93fb2e,
  0xc2fd08a9, 0xecabef3d, 0xc2f57644, 0xecc3e648,
  0xc2eded49, 0xecdbe04a, 0xc2e66db8, 0xecf3dd3f,
  0xc2def794, 0xed0bdd25, 0xc2d78add, 0xed23dff7,
  0xc2d02794, 0xed3be5b1, 0xc2c8cdbb, 0xed53ee51,
  0xc2c17d52, 0xed6bf9d1, 0xc2ba365c, 0xed84082f,
  0xc2b2f8d8, 0xed9c1967, 0xc2abc4c9, 0xedb42d74,
  0xc2a49a2e, 0xedcc4454, 0xc29d790a, 0xede45e03,
  0xc296615d, 0xedfc7a7c, 0xc28f5329, 0xee1499bd,
  0xc2884e6e, 0xee2cbbc1, 0xc281532e, 0xee44e084,
  0xc27a616a, 0xee5d0804, 0xc2737922, 0xee75323c,
  0xc26c9a58, 0xee8d5f29, 0xc265c50e, 0xeea58ec6,
  0xc25ef943, 0xeebdc110, 0xc25836f9, 0xeed5f604,
  0xc2517e31, 0xeeee2d9d, 0xc24aceed, 0xef0667d9,
  0xc244292c, 0xef1ea4b2, 0xc23d8cf1, 0xef36e426,
  0xc236fa3b, 0xef4f2630, 0xc230710d, 0xef676ace,
  0xc229f167, 0xef7fb1fa, 0xc2237b4b, 0xef97fbb2,
  0xc21d0eb8, 0xefb047f2, 0xc216abb1, 0xefc896b5,
  0xc2105236, 0xefe0e7f9, 0xc20a0248, 0xeff93bba,
  0xc203bbe8, 0xf01191f3, 0xc1fd7f17, 0xf029eaa1,
  0xc1f74bd6, 0xf04245c0, 0xc1f12227, 0xf05aa34c,
  0xc1eb0209, 0xf0730342, 0xc1e4eb7e, 0xf08b659f,
  0xc1dede87, 0xf0a3ca5d, 0xc1d8db25, 0xf0bc317a,
  0xc1d2e158, 0xf0d49af1, 0xc1ccf122, 0xf0ed06bf,
  0xc1c70a84, 0xf10574e0, 0xc1c12d7e, 0xf11de551,
  0xc1bb5a11, 0xf136580d, 0xc1b5903f, 0xf14ecd11,
  0xc1afd007, 0xf1674459, 0xc1aa196c, 0xf17fbde2,
  0xc1a46c6e, 0xf19839a6, 0xc19ec90d, 0xf1b0b7a4,
  0xc1992f4c, 0xf1c937d6, 0xc1939f29, 0xf1e1ba3a,
  0xc18e18a7, 0xf1fa3ecb, 0xc1889bc6, 0xf212c585,
  0xc1832888, 0xf22b4e66, 0xc17dbeec, 0xf243d968,
  0xc1785ef4, 0xf25c6688, 0xc17308a1, 0xf274f5c3,
  0xc16dbbf3, 0xf28d8715, 0xc16878eb, 0xf2a61a7a,
  0xc1633f8a, 0xf2beafed, 0xc15e0fd1, 0xf2d7476c,
  0xc158e9c1, 0xf2efe0f2, 0xc153cd5a, 0xf3087c7d,
  0xc14eba9d, 0xf3211a07, 0xc149b18b, 0xf339b98d,
  0xc144b225, 0xf3525b0b, 0xc13fbc6c, 0xf36afe7e,
  0xc13ad060, 0xf383a3e2, 0xc135ee02, 0xf39c4b32,
  0xc1311553, 0xf3b4f46c, 0xc12c4653, 0xf3cd9f8b,
  0xc1278104, 0xf3e64c8c, 0xc122c566, 0xf3fefb6a,
  0xc11e1379, 0xf417ac22, 0xc1196b3f, 0xf4305eb0,
  0xc114ccb9, 0xf4491311, 0xc11037e6, 0xf461c940,
  0xc10bacc8, 0xf47a8139, 0xc1072b5f, 0xf4933afa,
  0xc102b3ac, 0xf4abf67e, 0xc0fe45b0, 0xf4c4b3c0,
  0xc0f9e16b, 0xf4dd72be, 0xc0f586df, 0xf4f63374,
  0xc0f1360b, 0xf50ef5de, 0xc0eceef1, 0xf527b9f7,
  0xc0e8b190, 0xf5407fbd, 0xc0e47deb, 0xf559472b,
  0xc0e05401, 0xf572103d, 0xc0dc33d2, 0xf58adaf0,
  0xc0d81d61, 0xf5a3a740, 0xc0d410ad, 0xf5bc7529,
  0xc0d00db6, 0xf5d544a7, 0xc0cc147f, 0xf5ee15b7,
  0xc0c82506, 0xf606e854, 0xc0c43f4d, 0xf61fbc7b,
  0xc0c06355, 0xf6389228, 0xc0bc911d, 0xf6516956,
  0xc0b8c8a7, 0xf66a4203, 0xc0b509f3, 0xf6831c2b,
  0xc0b15502, 0xf69bf7c9, 0xc0ada9d4, 0xf6b4d4d9,
  0xc0aa086a, 0xf6cdb359, 0xc0a670c4, 0xf6e69344,
  0xc0a2e2e3, 0xf6ff7496, 0xc09f5ec8, 0xf718574b,
  0xc09be473, 0xf7313b60, 0xc09873e4, 0xf74a20d0,
  0xc0950d1d, 0xf7630799, 0xc091b01d, 0xf77befb5,
  0xc08e5ce5, 0xf794d922, 0xc08b1376, 0xf7adc3db,
  0xc087d3d0, 0xf7c6afdc, 0xc0849df4, 0xf7df9d22,
  0xc08171e2, 0xf7f88ba9, 0xc07e4f9b, 0xf8117b6d,
  0xc07b371e, 0xf82a6c6a, 0xc078286e, 0xf8435e9d,
  0xc0752389, 0xf85c5201, 0xc0722871, 0xf8754692,
  0xc06f3726, 0xf88e3c4d, 0xc06c4fa8, 0xf8a7332e,
  0xc06971f9, 0xf8c02b31, 0xc0669e18, 0xf8d92452,
  0xc063d405, 0xf8f21e8e, 0xc06113c2, 0xf90b19e0,
  0xc05e5d4e, 0xf9241645, 0xc05bb0ab, 0xf93d13b8,
  0xc0590dd8, 0xf9561237, 0xc05674d6, 0xf96f11bc,
  0xc053e5a5, 0xf9881245, 0xc0516045, 0xf9a113cd,
  0xc04ee4b8, 0xf9ba1651, 0xc04c72fe, 0xf9d319cc,
  0xc04a0b16, 0xf9ec1e3b, 0xc047ad01, 0xfa05239a,
  0xc04558c0, 0xfa1e29e5, 0xc0430e53, 0xfa373119,
  0xc040cdba, 0xfa503930, 0xc03e96f6, 0xfa694229,
  0xc03c6a07, 0xfa824bfd, 0xc03a46ed, 0xfa9b56ab,
  0xc0382da8, 0xfab4622d, 0xc0361e3a, 0xfacd6e81,
  0xc03418a2, 0xfae67ba2, 0xc0321ce0, 0xfaff898c,
  0xc0302af5, 0xfb18983b, 0xc02e42e2, 0xfb31a7ac,
  0xc02c64a6, 0xfb4ab7db, 0xc02a9042, 0xfb63c8c4,
  0xc028c5b6, 0xfb7cda63, 0xc0270502, 0xfb95ecb4,
  0xc0254e27, 0xfbaeffb3, 0xc023a124, 0xfbc8135c,
  0xc021fdfb, 0xfbe127ac, 0xc02064ab, 0xfbfa3c9f,
  0xc01ed535, 0xfc135231, 0xc01d4f99, 0xfc2c685d,
  0xc01bd3d6, 0xfc457f21, 0xc01a61ee, 0xfc5e9678,
  0xc018f9e1, 0xfc77ae5e, 0xc0179bae, 0xfc90c6cf,
  0xc0164757, 0xfca9dfc8, 0xc014fcda, 0xfcc2f945,
  0xc013bc39, 0xfcdc1342, 0xc0128574, 0xfcf52dbb,
  0xc011588a, 0xfd0e48ab, 0xc010357c, 0xfd276410,
  0xc00f1c4a, 0xfd407fe6, 0xc00e0cf5, 0xfd599c28,
  0xc00d077c, 0xfd72b8d2, 0xc00c0be0, 0xfd8bd5e1,
  0xc00b1a20, 0xfda4f351, 0xc00a323d, 0xfdbe111e,
  0xc0095438, 0xfdd72f45, 0xc008800f, 0xfdf04dc0,
  0xc007b5c4, 0xfe096c8d, 0xc006f556, 0xfe228ba7,
  0xc0063ec6, 0xfe3bab0b, 0xc0059214, 0xfe54cab5,
  0xc004ef3f, 0xfe6deaa1, 0xc0045648, 0xfe870aca,
  0xc003c72f, 0xfea02b2e, 0xc00341f4, 0xfeb94bc8,
  0xc002c697, 0xfed26c94, 0xc0025519, 0xfeeb8d8f,
  0xc001ed78, 0xff04aeb5, 0xc0018fb6, 0xff1dd001,
  0xc0013bd3, 0xff36f170, 0xc000f1ce, 0xff5012fe,
  0xc000b1a7, 0xff6934a8, 0xc0007b5f, 0xff825668,
  0xc0004ef5, 0xff9b783c, 0xc0002c6a, 0xffb49a1f,
  0xc00013bd, 0xffcdbc0f, 0xc00004ef, 0xffe6de05,
  0x3fffffec, 0x0003243f, 0x3fffff4e, 0x00096cbe,
  0x3ffffe13, 0x000fb53d, 0x3ffffc39, 0x0015fdbb,
  0x3ffff9c1, 0x001c463a, 0x3ffff6ac, 0x00228eb8,
  0x3ffff2f8, 0x0028d736, 0x3fffeea7, 0x002f1fb3,
  0x3fffe9b7, 0x00356830, 0x3fffe42a, 0x003bb0ac,
  0x3fffddff, 0x0041f928, 0x3fffd736, 0x004841a3,
  0x3fffcfcf, 0x004e8a1e, 0x3fffc7ca, 0x0054d297,
  0x3fffbf27, 0x005b1b10, 0x3fffb5e7, 0x00616388,
  0x3fffac08, 0x0067abff, 0x3fffa18c, 0x006df475,
  0x3fff9671, 0x00743cea, 0x3fff8ab9, 0x007a855e,
  0x3fff7e63, 0x0080cdd1, 0x3fff716e, 0x00871643,
  0x3fff63dc, 0x008d5eb3, 0x3fff55ac, 0x0093a722,
  0x3fff46df, 0x0099ef8f, 0x3fff3773, 0x00a037fb,
  0x3fff2769, 0x00a68065, 0x3fff16c1, 0x00acc8ce,
  0x3fff057c, 0x00b31135, 0x3ffef399, 0x00b9599a,
  0x3ffee117, 0x00bfa1fe, 0x3ffecdf8, 0x00c5ea60,
  0x3ffeba3b, 0x00cc32c0, 0x3ffea5e0, 0x00d27b1d,
  0x3ffe90e7, 0x00d8c379, 0x3ffe7b50, 0x00df0bd3,
  0x3ffe651b, 0x00e5542b, 0x3ffe4e49, 0x00eb9c80,
  0x3ffe36d8, 0x00f1e4d3, 0x3ffe1eca, 0x00f82d24,
  0x3ffe061e, 0x00fe7572, 0x3ffdecd3, 0x0104bdbe,
  0x3ffdd2eb, 0x010b0608, 0x3ffdb865, 0x01114e4e,
  0x3ffd9d42, 0x01179693, 0x3ffd8180, 0x011dded4,
  0x3ffd6520, 0x01242713, 0x3ffd4823, 0x012a6f4f,
  0x3ffd2a87, 0x0130b788, 0x3ffd0c4e, 0x0136ffbe,
  0x3ffced77, 0x013d47f1, 0x3ffcce02, 0x01439021,
  0x3ffcadef, 0x0149d84e, 0x3ffc8d3e, 0x01502078,
  0x3ffc6bef, 0x0156689f, 0x3ffc4a02, 0x015cb0c2,
  0x3ffc2778, 0x0162f8e2, 0x3ffc0450, 0x016940fe,
  0x3ffbe089, 0x016f8917, 0x3ffbbc25, 0x0175d12c,
  0x3ffb9723, 0x017c193e, 0x3ffb7183, 0x0182614c,
  0x3ffb4b46, 0x0188a957, 0x3ffb246a, 0x018ef15e,
  0x3ffafcf1, 0x01953960, 0x3ffad4d9, 0x019b815f,
  0x3ffaac24, 0x01a1c95a, 0x3ffa82d1, 0x01a81151,
  0x3ffa58e0, 0x01ae5944, 0x3ffa2e51, 0x01b4a133,
  0x3ffa0325, 0x01bae91d, 0x3ff9d75a, 0x01c13103,
  0x3ff9aaf2, 0x01c778e5, 0x3ff97dec, 0x01cdc0c3,
  0x3ff95048, 0x01d4089c, 0x3ff92206, 0x01da5070,
  0x3ff8f326, 0x01e09840, 0x3ff8c3a8, 0x01e6e00b,
  0x3ff8938d, 0x01ed27d2, 0x3ff862d4, 0x01f36f94,
  0x3ff8317d, 0x01f9b751, 0x3ff7ff88, 0x01ffff09,
  0x3ff7ccf5, 0x020646bc, 0x3ff799c4, 0x020c8e6b,
  0x3ff765f6, 0x0212d614, 0x3ff7318a, 0x02191db8,
  0x3ff6fc7f, 0x021f6557, 0x3ff6c6d7, 0x0225acf1,
  0x3ff69092, 0x022bf485, 0x3ff659ae, 0x02323c14,
  0x3ff6222d, 0x0238839e, 0x3ff5ea0d, 0x023ecb22,
  0x3ff5b150, 0x024512a0, 0x3ff577f6, 0x024b5a19,
  0x3ff53dfd, 0x0251a18c, 0x3ff50366, 0x0257e8fa,
  0x3ff4c832, 0x025e3062, 0x3ff48c60, 0x026477c4,
  0x3ff44ff0, 0x026abf20, 0x3ff412e2, 0x02710676,
  0x3ff3d537, 0x02774dc6, 0x3ff396ee, 0x027d9510,
  0x3ff35807, 0x0283dc54, 0x3ff31882, 0x028a2392,
  0x3ff2d85f, 0x02906ac9, 0x3ff2979f, 0x0296b1fa,
  0x3ff25640, 0x029cf925, 0x3ff21444, 0x02a34049,
  0x3ff1d1aa, 0x02a98766, 0x3ff18e73, 0x02afce7e,
  0x3ff14a9e, 0x02b6158e, 0x3ff1062a, 0x02bc5c98,
  0x3ff0c11a, 0x02c2a39b, 0x3ff07b6b, 0x02c8ea97,
  0x3ff0351e, 0x02cf318d, 0x3fefee34, 0x02d5787b,
  0x3fefa6ac, 0x02dbbf63, 0x3fef5e87, 0x02e20643,
  0x3fef15c3, 0x02e84d1c, 0x3feecc62, 0x02ee93ee,
  0x3fee8263, 0x02f4dab9, 0x3fee37c6, 0x02fb217d,
  0x3fedec8c, 0x03016839, 0x3feda0b4, 0x0307aeee,
  0x3fed543e, 0x030df59b, 0x3fed072a, 0x03143c41,
  0x3fecb979, 0x031a82df, 0x3fec6b2a, 0x0320c976,
  0x3fec1c3d, 0x03271005, 0x3febccb2, 0x032d568c,
  0x3feb7c8a, 0x03339d0b, 0x3feb2bc4, 0x0339e382,
  0x3feada60, 0x034029f2, 0x3fea885f, 0x03467059,
  0x3fea35c0, 0x034cb6b8, 0x3fe9e283, 0x0352fd0f,
  0x3fe98ea8, 0x0359435e, 0x3fe93a30, 0x035f89a5,
  0x3fe8e51a, 0x0365cfe3, 0x3fe88f67, 0x036c1619,
  0x3fe83915, 0x03725c46, 0x3fe7e226, 0x0378a26b,
  0x3fe78a9a, 0x037ee888, 0x3fe7326f, 0x03852e9c,
  0x3fe6d9a7, 0x038b74a7, 0x3fe68042, 0x0391baa9,
  0x3fe6263e, 0x039800a3, 0x3fe5cb9d, 0x039e4693,
  0x3fe5705f, 0x03a48c7b, 0x3fe51482, 0x03aad25a,
  0x3fe4b808, 0x03b11830, 0x3fe45af1, 0x03b75dfc,
  0x3fe3fd3b, 0x03bda3c0, 0x3fe39ee8, 0x03c3e97a,
  0x3fe33ff8, 0x03ca2f2b, 0x3fe2e06a, 0x03d074d2,
  0x3fe2803e, 0x03d6ba71, 0x3fe21f74, 0x03dd0005,
  0x3fe1be0d, 0x03e34591, 0x3fe15c09, 0x03e98b12,
  0x3fe0f966, 0x03efd08a, 0x3fe09626, 0x03f615f8,
  0x3fe03249, 0x03fc5b5d, 0x3fdfcdce, 0x0402a0b7,
  0x3fdf68b5, 0x0408e608, 0x3fdf02fe, 0x040f2b4f,
  0x3fde9caa, 0x0415708b, 0x3fde35b9, 0x041bb5be,
  0x3fddce2a, 0x0421fae7, 0x3fdd65fd, 0x04284005,
  0x3fdcfd33, 0x042e8519, 0x3fdc93cb, 0x0434ca23,
  0x3fdc29c5, 0x043b0f22, 0x3fdbbf22, 0x04415417,
  0x3fdb53e2, 0x04479901, 0x3fdae804, 0x044ddde1,
  0x3fda7b88, 0x045422b7, 0x3fda0e6f, 0x045a6781,
  0x3fd9a0b8, 0x0460ac41, 0x3fd93263, 0x0466f0f6,
  0x3fd8c372, 0x046d35a0, 0x3fd853e2, 0x04737a3f,
  0x3fd7e3b5, 0x0479bed4, 0x3fd772eb, 0x0480035d,
  0x3fd70183, 0x048647db, 0x3fd68f7d, 0x048c8c4e,
  0x3fd61cda, 0x0492d0b6, 0x3fd5a99a, 0x04991512,
  0x3fd535bc, 0x049f5963, 0x3fd4c140, 0x04a59da9,
  0x3fd44c27, 0x04abe1e3, 0x3fd3d670, 0x04b22612,
  0x3fd3601c, 0x04b86a35, 0x3fd2e92b, 0x04beae4c,
  0x3fd2719c, 0x04c4f258, 0x3fd1f96f, 0x04cb3658,
  0x3fd180a5, 0x04d17a4c, 0x3fd1073e, 0x04d7be34,
  0x3fd08d39, 0x04de0211, 0x3fd01297, 0x04e445e1,
  0x3fcf9757, 0x04ea89a5, 0x3fcf1b7a, 0x04f0cd5d,
  0x3fce9eff, 0x04f71109, 0x3fce21e7, 0x04fd54a9,
  0x3fcda431, 0x0503983c, 0x3fcd25de, 0x0509dbc3,
  0x3fcca6ee, 0x05101f3e, 0x3fcc2760, 0x051662ac,
  0x3fcba735, 0x051ca60d, 0x3fcb266c, 0x0522e962,
  0x3fcaa506, 0x05292cab, 0x3fca2303, 0x052f6fe6,
  0x3fc9a062, 0x0535b315, 0x3fc91d24, 0x053bf637,
  0x3fc89948, 0x0542394c, 0x3fc814cf, 0x05487c53,
  0x3fc78fb9, 0x054ebf4e, 0x3fc70a05, 0x0555023c,
  0x3fc683b4, 0x055b451d, 0x3fc5fcc6, 0x056187f0,
  0x3fc5753a, 0x0567cab6, 0x3fc4ed11, 0x056e0d6f,
  0x3fc4644a, 0x0574501b, 0x3fc3dae6, 0x057a92b9,
  0x3fc350e5, 0x0580d549, 0x3fc2c647, 0x058717cc,
  0x3fc23b0b, 0x058d5a41, 0x3fc1af32, 0x05939ca9,
  0x3fc122bb, 0x0599df03, 0x3fc095a8, 0x05a0214f,
  0x3fc007f6, 0x05a6638d, 0x3fbf79a8, 0x05aca5bd,
  0x3fbeeabc, 0x05b2e7df, 0x3fbe5b33, 0x05b929f3,
  0x3fbdcb0d, 0x05bf6bf9, 0x3fbd3a4a, 0x05c5adf1,
  0x3fbca8e9, 0x05cbefda, 0x3fbc16eb, 0x05d231b5,
  0x3fbb8450, 0x05d87382, 0x3fbaf117, 0x05deb541,
  0x3fba5d41, 0x05e4f6f1, 0x3fb9c8ce, 0x05eb3892,
  0x3fb933be, 0x05f17a25, 0x3fb89e11, 0x05f7bba9,
  0x3fb807c6, 0x05fdfd1f, 0x3fb770de, 0x06043e85,
  0x3fb6d959, 0x060a7fdd, 0x3fb64136, 0x0610c126,
  0x3fb5a877, 0x06170260, 0x3fb50f1a, 0x061d438b,
  0x3fb47520, 0x062384a6, 0x3fb3da89, 0x0629c5b3,
  0x3fb33f54, 0x063006b1, 0x3fb2a383, 0x0636479f,
  0x3fb20714, 0x063c887e, 0x3fb16a08, 0x0642c94d,
  0x3fb0cc5f, 0x06490a0d, 0x3fb02e19, 0x064f4abe,
  0x3faf8f36, 0x06558b5f, 0x3faeefb6, 0x065bcbf0,
  0x3fae4f98, 0x06620c72, 0x3fadaedd, 0x06684ce3,
  0x3fad0d86, 0x066e8d45, 0x3fac6b91, 0x0674cd98,
  0x3fabc8ff, 0x067b0dda, 0x3fab25d0, 0x06814e0c,
  0x3faa8203, 0x06878e2e, 0x3fa9dd9a, 0x068dce41,
  0x3fa93894, 0x06940e42, 0x3fa892f0, 0x069a4e34,
  0x3fa7ecb0, 0x06a08e16, 0x3fa745d2, 0x06a6cde7,
  0x3fa69e57, 0x06ad0da7, 0x3fa5f640, 0x06b34d58,
  0x3fa54d8b, 0x06b98cf7, 0x3fa4a439, 0x06bfcc86,
  0x3fa3fa4a, 0x06c60c05, 0x3fa34fbe, 0x06cc4b72,
  0x3fa2a495, 0x06d28acf, 0x3fa1f8d0, 0x06d8ca1b,
  0x3fa14c6d, 0x06df0957, 0x3fa09f6d, 0x06e54881,
  0x3f9ff1d0, 0x06eb879a, 0x3f9f4396, 0x06f1c6a2,
  0x3f9e94bf, 0x06f80599, 0x3f9de54b, 0x06fe447f,
  0x3f9d353a, 0x07048354, 0x3f9c848d, 0x070ac217,
  0x3f9bd342, 0x071100c9, 0x3f9b215a, 0x07173f69,
  0x3f9a6ed6, 0x071d7df8, 0x3f99bbb4, 0x0723bc75,
  0x3f9907f6, 0x0729fae1, 0x3f98539a, 0x0730393b,
  0x3f979ea2, 0x07367784, 0x3f96e90d, 0x073cb5ba,
  0x3f9632da, 0x0742f3df, 0x3f957c0b, 0x074931f2,
  0x3f94c4a0, 0x074f6ff3, 0x3f940c97, 0x0755ade1,
  0x3f9353f1, 0x075bebbe, 0x3f929aaf, 0x07622988,
  0x3f91e0cf, 0x07686741, 0x3f912653, 0x076ea4e7,
  0x3f906b3a, 0x0774e27a, 0x3f8faf84, 0x077b1ffc,
  0x3f8ef331, 0x07815d6b, 0x3f8e3642, 0x07879ac7,
  0x3f8d78b5, 0x078dd811, 0x3f8cba8c, 0x07941548,
  0x3f8bfbc6, 0x079a526c, 0x3f8b3c63, 0x07a08f7e,
  0x3f8a7c64, 0x07a6cc7d, 0x3f89bbc7, 0x07ad0968,
  0x3f88fa8e, 0x07b34641, 0x3f8838b8, 0x07b98307,
  0x3f877645, 0x07bfbfba, 0x3f86b336, 0x07c5fc5a,
  0x3f85ef8a, 0x07cc38e7, 0x3f852b41, 0x07d27560,
  0x3f84665b, 0x07d8b1c6, 0x3f83a0d9, 0x07deee19,
  0x3f82daba, 0x07e52a58, 0x3f8213fe, 0x07eb6684,
  0x3f814ca6, 0x07f1a29c, 0x3f8084b0, 0x07f7dea1,
  0x3f7fbc1f, 0x07fe1a92, 0x3f7ef2f0, 0x0804566f,
  0x3f7e2925, 0x080a9239, 0x3f7d5ebd, 0x0810cdef,
  0x3f7c93b9, 0x08170990, 0x3f7bc817, 0x081d451e,
  0x3f7afbda, 0x08238098, 0x3f7a2eff, 0x0829bbfe,
  0x3f796188, 0x082ff74f, 0x3f789374, 0x0836328d,
  0x3f77c4c4, 0x083c6db6, 0x3f76f577, 0x0842a8cb,
  0x3f76258e, 0x0848e3cb, 0x3f755508, 0x084f1eb7,
  0x3f7483e5, 0x0855598f, 0x3f73b226, 0x085b9451,
  0x3f72dfca, 0x0861cf00, 0x3f720cd2, 0x08680999,
  0x3f71393d, 0x086e441e, 0x3f70650b, 0x08747e8e,
  0x3f6f903d, 0x087ab8e9, 0x3f6ebad3, 0x0880f330,
  0x3f6de4cc, 0x08872d61, 0x3f6d0e29, 0x088d677d,
  0x3f6c36e9, 0x0893a184, 0x3f6b5f0c, 0x0899db76,
  0x3f6a8693, 0x08a01553, 0x3f69ad7e, 0x08a64f1b,
  0x3f68d3cc, 0x08ac88cd, 0x3f67f97d, 0x08b2c26a,
  0x3f671e93, 0x08b8fbf1, 0x3f66430b, 0x08bf3563,
  0x3f6566e8, 0x08c56ebf, 0x3f648a28, 0x08cba805,
  0x3f63accb, 0x08d1e136, 0x3f62ced2, 0x08d81a51,
  0x3f61f03d, 0x08de5356, 0x3f61110b, 0x08e48c46,
  0x3f60313d, 0x08eac51f, 0x3f5f50d3, 0x08f0fde3,
  0x3f5e6fcc, 0x08f73690, 0x3f5d8e29, 0x08fd6f27,
  0x3f5cabe9, 0x0903a7a8, 0x3f5bc90d, 0x0909e013,
  0x3f5ae595, 0x09101868, 0x3f5a0181, 0x091650a6,
  0x3f591cd0, 0x091c88cd, 0x3f583783, 0x0922c0df,
  0x3f575199, 0x0928f8d9, 0x3f566b14, 0x092f30bd,
  0x3f5583f2, 0x0935688b, 0x3f549c33, 0x093ba042,
  0x3f53b3d9, 0x0941d7e2, 0x3f52cae2, 0x09480f6b,
  0x3f51e14f, 0x094e46dd, 0x3f50f720, 0x09547e38,
  0x3f500c54, 0x095ab57c, 0x3f4f20ed, 0x0960eca9,
  0x3f4e34e9, 0x096723bf, 0x3f4d4848, 0x096d5abe,
  0x3f4c5b0c, 0x097391a6, 0x3f4b6d34, 0x0979c876,
  0x3f4a7ebf, 0x097fff2f, 0x3f498fae, 0x098635d0,
  0x3f48a001, 0x098c6c5a, 0x3f47afb8, 0x0992a2cc,
  0x3f46bed3, 0x0998d927, 0x3f45cd51, 0x099f0f6a,
  0x3f44db34, 0x09a54595, 0x3f43e87a, 0x09ab7ba9,
  0x3f42f525, 0x09b1b1a4, 0x3f420133, 0x09b7e788,
  0x3f410ca5, 0x09be1d54, 0x3f40177b, 0x09c45308,
  0x3f3f21b5, 0x09ca88a3, 0x3f3e2b53, 0x09d0be27,
  0x3f3d3455, 0x09d6f392, 0x3f3c3cba, 0x09dd28e5,
  0x3f3b4484, 0x09e35e1f, 0x3f3a4bb2, 0x09e99342,
  0x3f395244, 0x09efc84b, 0x3f38583a, 0x09f5fd3d,
  0x3f375d93, 0x09fc3215, 0x3f366251, 0x0a0266d5,
  0x3f356673, 0x0a089b7c, 0x3f3469f9, 0x0a0ed00b,
  0x3f336ce3, 0x0a150481, 0x3f326f31, 0x0a1b38de,
  0x3f3170e3, 0x0a216d22, 0x3f3071f9, 0x0a27a14d,
  0x3f2f7273, 0x0a2dd55e, 0x3f2e7252, 0x0a340957,
  0x3f2d7194, 0x0a3a3d37, 0x3f2c703a, 0x0a4070fd,
  0x3f2b6e45, 0x0a46a4aa, 0x3f2a6bb4, 0x0a4cd83e,
  0x3f296887, 0x0a530bb8, 0x3f2864be, 0x0a593f19,
  0x3f276059, 0x0a5f7260, 0x3f265b59, 0x0a65a58e,
  0x3f2555bc, 0x0a6bd8a2, 0x3f244f84, 0x0a720b9c,
  0x3f2348b0, 0x0a783e7d, 0x3f224140, 0x0a7e7143,
  0x3f213935, 0x0a84a3f0, 0x3f20308d, 0x0a8ad683,
  0x3f1f274a, 0x0a9108fc, 0x3f1e1d6c, 0x0a973b5b,
  0x3f1d12f1, 0x0a9d6d9f, 0x3f1c07db, 0x0aa39fca,
  0x3f1afc29, 0x0aa9d1da, 0x3f19efdb, 0x0ab003d0,
  0x3f18e2f2, 0x0ab635ab, 0x3f17d56d, 0x0abc676d,
  0x3f16c74c, 0x0ac29913, 0x3f15b88f, 0x0ac8ca9f,
  0x3f14a937, 0x0acefc11, 0x3f139944, 0x0ad52d67,
  0x3f1288b4, 0x0adb5ea3, 0x3f117789, 0x0ae18fc5,
  0x3f1065c3, 0x0ae7c0cb, 0x3f0f5360, 0x0aedf1b7,
  0x3f0e4063, 0x0af42287, 0x3f0d2cc9, 0x0afa533d,
  0x3f0c1894, 0x0b0083d7, 0x3f0b03c4, 0x0b06b456,
  0x3f09ee58, 0x0b0ce4ba, 0x3f08d850, 0x0b131503,
  0x3f07c1ad, 0x0b194531, 0x3f06aa6e, 0x0b1f7543,
  0x3f059294, 0x0b25a539, 0x3f047a1e, 0x0b2bd515,
  0x3f03610d, 0x0b3204d4, 0x3f024760, 0x0b383478,
  0x3f012d18, 0x0b3e6400, 0x3f001235, 0x0b44936d,
  0x3efef6b6, 0x0b4ac2be, 0x3efdda9b, 0x0b50f1f3,
  0x3efcbde5, 0x0b57210b, 0x3efba094, 0x0b5d5008,
  0x3efa82a7, 0x0b637ee9, 0x3ef9641f, 0x0b69adae,
  0x3ef844fc, 0x0b6fdc57, 0x3ef7253d, 0x0b760ae3,
  0x3ef604e3, 0x0b7c3953, 0x3ef4e3ed, 0x0b8267a7,
  0x3ef3c25c, 0x0b8895df, 0x3ef2a030, 0x0b8ec3fa,
  0x3ef17d69, 0x0b94f1f8, 0x3ef05a06, 0x0b9b1fda,
  0x3eef3608, 0x0ba14d9f, 0x3eee116e, 0x0ba77b48,
  0x3eecec39, 0x0bada8d4, 0x3eebc669, 0x0bb3d642,
  0x3eea9ffe, 0x0bba0395, 0x3ee978f8, 0x0bc030ca,
  0x3ee85156, 0x0bc65de2, 0x3ee72919, 0x0bcc8add,
  0x3ee60041, 0x0bd2b7bb, 0x3ee4d6ce, 0x0bd8e47c,
  0x3ee3acbf, 0x0bdf111f, 0x3ee28216, 0x0be53da6,
  0x3ee156d1, 0x0beb6a0f, 0x3ee02af1, 0x0bf1965a,
  0x3edefe76, 0x0bf7c288, 0x3eddd15f, 0x0bfdee99,
  0x3edca3ae, 0x0c041a8c, 0x3edb7562, 0x0c0a4661,
  0x3eda467a, 0x0c107219, 0x3ed916f7, 0x0c169db3,
  0x3ed7e6da, 0x0c1cc92f, 0x3ed6b621, 0x0c22f48d,
  0x3ed584cd, 0x0c291fcd, 0x3ed452de, 0x0c2f4aef,
  0x3ed32054, 0x0c3575f3, 0x3ed1ed2f, 0x0c3ba0d9,
  0x3ed0b970, 0x0c41cba1, 0x3ecf8515, 0x0c47f64a,
  0x3ece501f, 0x0c4e20d6, 0x3ecd1a8e, 0x0c544b43,
  0x3ecbe462, 0x0c5a7591, 0x3ecaad9b, 0x0c609fc1,
  0x3ec9763a, 0x0c66c9d3, 0x3ec83e3d, 0x0c6cf3c5,
  0x3ec705a6, 0x0c731d9a, 0x3ec5cc73, 0x0c79474f,
  0x3ec492a6, 0x0c7f70e6, 0x3ec3583e, 0x0c859a5e,
  0x3ec21d3b, 0x0c8bc3b7, 0x3ec0e19d, 0x0c91ecf1,
  0x3ebfa564, 0x0c98160c, 0x3ebe6891, 0x0c9e3f07,
  0x3ebd2b22, 0x0ca467e4, 0x3ebbed19, 0x0caa90a2,
  0x3ebaae75, 0x0cb0b940, 0x3eb96f36, 0x0cb6e1bf,
  0x3eb82f5d, 0x0cbd0a1f, 0x3eb6eee9, 0x0cc3325f,
  0x3eb5adda, 0x0cc95a80, 0x3eb46c30, 0x0ccf8281,
  0x3eb329ec, 0x0cd5aa62, 0x3eb1e70d, 0x0cdbd224,
  0x3eb0a393, 0x0ce1f9c7, 0x3eaf5f7e, 0x0ce82149,
  0x3eae1acf, 0x0cee48ab, 0x3eacd585, 0x0cf46fee,
  0x3eab8fa1, 0x0cfa9711, 0x3eaa4922, 0x0d00be13,
  0x3ea90208, 0x0d06e4f6, 0x3ea7ba54, 0x0d0d0bb8,
  0x3ea67205, 0x0d13325b, 0x3ea5291b, 0x0d1958dd,
  0x3ea3df97, 0x0d1f7f3e, 0x3ea29578, 0x0d25a57f,
  0x3ea14abf, 0x0d2bcba0, 0x3e9fff6b, 0x0d31f1a1,
  0x3e9eb37d, 0x0d381780, 0x3e9d66f4, 0x0d3e3d40,
  0x3e9c19d1, 0x0d4462de, 0x3e9acc13, 0x0d4a885c,
  0x3e997dbb, 0x0d50adb9, 0x3e982ec9, 0x0d56d2f5,
  0x3e96df3b, 0x0d5cf810, 0x3e958f14, 0x0d631d0a,
  0x3e943e52, 0x0d6941e3, 0x3e92ecf6, 0x0d6f669b,
  0x3e919aff, 0x0d758b32, 0x3e90486e, 0x0d7bafa8,
  0x3e8ef542, 0x0d81d3fc, 0x3e8da17c, 0x0d87f830,
  0x3e8c4d1c, 0x0d8e1c41, 0x3e8af821, 0x0d944032,
  0x3e89a28d, 0x0d9a6400, 0x3e884c5d, 0x0da087ae,
  0x3e86f594, 0x0da6ab39, 0x3e859e30, 0x0daccea3,
  0x3e844632, 0x0db2f1eb, 0x3e82ed9a, 0x0db91512,
  0x3e819467, 0x0dbf3816, 0x3e803a9b, 0x0dc55af9,
  0x3e7ee034, 0x0dcb7db9, 0x3e7d8533, 0x0dd1a058,
  0x3e7c2997, 0x0dd7c2d4, 0x3e7acd62, 0x0ddde52f,
  0x3e797092, 0x0de40767, 0x3e781328, 0x0dea297d,
  0x3e76b524, 0x0df04b70, 0x3e755686, 0x0df66d41,
  0x3e73f74e, 0x0dfc8ef0, 0x3e72977c, 0x0e02b07c,
  0x3e71370f, 0x0e08d1e6, 0x3e6fd609, 0x0e0ef32d,
  0x3e6e7468, 0x0e151451, 0x3e6d122e, 0x0e1b3552,
  0x3e6baf59, 0x0e215631, 0x3e6a4beb, 0x0e2776ed,
  0x3e68e7e2, 0x0e2d9786, 0x3e67833f, 0x0e33b7fc,
  0x3e661e03, 0x0e39d84f, 0x3e64b82c, 0x0e3ff87f,
  0x3e6351bc, 0x0e46188b, 0x3e61eab2, 0x0e4c3875,
  0x3e60830d, 0x0e52583b, 0x3e5f1acf, 0x0e5877de,
  0x3e5db1f7, 0x0e5e975d, 0x3e5c4885, 0x0e64b6b9,
  0x3e5ade79, 0x0e6ad5f1, 0x3e5973d3, 0x0e70f506,
  0x3e580894, 0x0e7713f7, 0x3e569cba, 0x0e7d32c5,
  0x3e553047, 0x0e83516f, 0x3e53c33a, 0x0e896ff5,
  0x3e525593, 0x0e8f8e57, 0x3e50e752, 0x0e95ac95,
  0x3e4f7878, 0x0e9bcaaf, 0x3e4e0904, 0x0ea1e8a5,
  0x3e4c98f6, 0x0ea80677, 0x3e4b284f, 0x0eae2425,
  0x3e49b70d, 0x0eb441af, 0x3e484533, 0x0eba5f14,
  0x3e46d2be, 0x0ec07c55, 0x3e455fb0, 0x0ec69972,
  0x3e43ec08, 0x0eccb66a, 0x3e4277c6, 0x0ed2d33e,
  0x3e4102eb, 0x0ed8efed, 0x3e3f8d76, 0x0edf0c77,
  0x3e3e1768, 0x0ee528dd, 0x3e3ca0c0, 0x0eeb451e,
  0x3e3b297e, 0x0ef1613a, 0x3e39b1a3, 0x0ef77d32,
  0x3e38392f, 0x0efd9904, 0x3e36c021, 0x0f03b4b1,
  0x3e354679, 0x0f09d03a, 0x3e33cc38, 0x0f0feb9d,
  0x3e32515d, 0x0f1606db, 0x3e30d5e9, 0x0f1c21f4,
  0x3e2f59dc, 0x0f223ce8, 0x3e2ddd35, 0x0f2857b6,
  0x3e2c5ff5, 0x0f2e725f, 0x3e2ae21b, 0x0f348ce2,
  0x3e2963a8, 0x0f3aa740, 0x3e27e49b, 0x0f40c178,
  0x3e2664f5, 0x0f46db8b, 0x3e24e4b6, 0x0f4cf578,
  0x3e2363dd, 0x0f530f3f, 0x3e21e26c, 0x0f5928e1,
  0x3e206060, 0x0f5f425c, 0x3e1eddbc, 0x0f655bb2,
  0x3e1d5a7e, 0x0f6b74e1, 0x3e1bd6a7, 0x0f718deb,
  0x3e1a5237, 0x0f77a6ce, 0x3e18cd2d, 0x0f7dbf8c,
  0x3e17478a, 0x0f83d823, 0x3e15c14f, 0x0f89f094,
  0x3e143a79, 0x0f9008de, 0x3e12b30b, 0x0f962102,
  0x3e112b04, 0x0f9c3900, 0x3e0fa263, 0x0fa250d7,
  0x3e0e1929, 0x0fa86887, 0x3e0c8f57, 0x0fae8011,
  0x3e0b04eb, 0x0fb49774, 0x3e0979e6, 0x0fbaaeb1,
  0x3e07ee47, 0x0fc0c5c6, 0x3e066210, 0x0fc6dcb5,
  0x3e04d540, 0x0fccf37d, 0x3e0347d7, 0x0fd30a1e,
  0x3e01b9d5, 0x0fd92098, 0x3e002b39, 0x0fdf36ea,
  0x3dfe9c05, 0x0fe54d16, 0x3dfd0c38, 0x0feb631a,
  0x3dfb7bd2, 0x0ff178f7, 0x3df9ead3, 0x0ff78ead,
  0x3df8593b, 0x0ffda43b, 0x3df6c70a, 0x1003b9a2,
  0x3df53440, 0x1009cee1, 0x3df3a0de, 0x100fe3f9,
  0x3df20ce2, 0x1015f8e9, 0x3df0784e, 0x101c0db1,
  0x3deee321, 0x10222252, 0x3ded4d5b, 0x102836cb,
  0x3debb6fc, 0x102e4b1c, 0x3dea2004, 0x10345f45,
  0x3de88874, 0x103a7346, 0x3de6f04b, 0x1040871f,
  0x3de55789, 0x10469ad0, 0x3de3be2e, 0x104cae59,
  0x3de2243b, 0x1052c1b9, 0x3de089af, 0x1058d4f2,
  0x3ddeee8a, 0x105ee802, 0x3ddd52cd, 0x1064fae9,
  0x3ddbb677, 0x106b0da8, 0x3dda1989, 0x1071203f,
  0x3dd87c02, 0x107732ad, 0x3dd6dde2, 0x107d44f2,
  0x3dd53f29, 0x1083570f, 0x3dd39fd8, 0x10896903,
  0x3dd1ffef, 0x108f7ace, 0x3dd05f6d, 0x10958c71,
  0x3dcebe52, 0x109b9dea, 0x3dcd1c9f, 0x10a1af3a,
  0x3dcb7a54, 0x10a7c062, 0x3dc9d770, 0x10add160,
  0x3dc833f3, 0x10b3e235, 0x3dc68fdf, 0x10b9f2e1,
  0x3dc4eb31, 0x10c00364, 0x3dc345eb, 0x10c613bd,
  0x3dc1a00d, 0x10cc23ed, 0x3dbff997, 0x10d233f4,
  0x3dbe5288, 0x10d843d1, 0x3dbcaae1, 0x10de5384,
  0x3dbb02a1, 0x10e4630e, 0x3db959c9, 0x10ea726e,
  0x3db7b059, 0x10f081a4, 0x3db60651, 0x10f690b1,
  0x3db45bb0, 0x10fc9f94, 0x3db2b077, 0x1102ae4c,
  0x3db104a6, 0x1108bcdb, 0x3daf583d, 0x110ecb40,
  0x3dadab3b, 0x1114d97b, 0x3dabfda1, 0x111ae78b,
  0x3daa4f6f, 0x1120f572, 0x3da8a0a5, 0x1127032e,
  0x3da6f143, 0x112d10c0, 0x3da54149, 0x11331e27,
  0x3da390b6, 0x11392b64, 0x3da1df8c, 0x113f3876,
  0x3da02dc9, 0x1145455e, 0x3d9e7b6e, 0x114b521c,
  0x3d9cc87b, 0x11515eae, 0x3d9b14f1, 0x11576b16,
  0x3d9960ce, 0x115d7753, 0x3d97ac13, 0x11638366,
  0x3d95f6c1, 0x11698f4d, 0x3d9440d6, 0x116f9b09,
  0x3d928a53, 0x1175a69b, 0x3d90d339, 0x117bb201,
  0x3d8f1b86, 0x1181bd3c, 0x3d8d633c, 0x1187c84c,
  0x3d8baa5a, 0x118dd331, 0x3d89f0e0, 0x1193ddea,
  0x3d8836ce, 0x1199e878, 0x3d867c24, 0x119ff2db,
  0x3d84c0e2, 0x11a5fd12, 0x3d830509, 0x11ac071e,
  0x3d814898, 0x11b210fe, 0x3d7f8b8f, 0x11b81ab2,
  0x3d7dcdef, 0x11be243a, 0x3d7c0fb6, 0x11c42d97,
  0x3d7a50e6, 0x11ca36c8, 0x3d78917e, 0x11d03fcd,
  0x3d76d17f, 0x11d648a6, 0x3d7510e8, 0x11dc5153,
  0x3d734fb9, 0x11e259d4, 0x3d718df3, 0x11e86229,
  0x3d6fcb95, 0x11ee6a52, 0x3d6e08a0, 0x11f4724f,
  0x3d6c4513, 0x11fa7a1f, 0x3d6a80ee, 0x120081c3,
  0x3d68bc32, 0x1206893a, 0x3d66f6de, 0x120c9085,
  0x3d6530f3, 0x121297a3, 0x3d636a70, 0x12189e95,
  0x3d61a356, 0x121ea55a, 0x3d5fdba4, 0x1224abf3,
  0x3d5e135b, 0x122ab25e, 0x3d5c4a7b, 0x1230b89d,
  0x3d5a8103, 0x1236beaf, 0x3d58b6f4, 0x123cc494,
  0x3d56ec4d, 0x1242ca4c, 0x3d55210f, 0x1248cfd7,
  0x3d53553a, 0x124ed535, 0x3d5188cd, 0x1254da66,
  0x3d4fbbc9, 0x125adf69, 0x3d4dee2e, 0x1260e43f,
  0x3d4c1ffc, 0x1266e8e8, 0x3d4a5132, 0x126ced63,
  0x3d4881d1, 0x1272f1b1, 0x3d46b1d9, 0x1278f5d2,
  0x3d44e14a, 0x127ef9c5, 0x3d431023, 0x1284fd8a,
  0x3d413e65, 0x128b0121, 0x3d3f6c11, 0x1291048b,
  0x3d3d9925, 0x129707c7, 0x3d3bc5a2, 0x129d0ad5,
  0x3d39f188, 0x12a30db5, 0x3d381cd6, 0x12a91067,
  0x3d36478e, 0x12af12ec, 0x3d3471af, 0x12b51542,
  0x3d329b39, 0x12bb1769, 0x3d30c42b, 0x12c11963,
  0x3d2eec87, 0x12c71b2e, 0x3d2d144c, 0x12cd1ccc,
  0x3d2b3b7a, 0x12d31e3a, 0x3d296210, 0x12d91f7a,
  0x3d278810, 0x12df208c, 0x3d25ad7a, 0x12e5216f,
  0x3d23d24c, 0x12eb2224, 0x3d21f687, 0x12f122aa,
  0x3d201a2c, 0x12f72301, 0x3d1e3d39, 0x12fd2329,
  0x3d1c5fb0, 0x13032322, 0x3d1a8190, 0x130922ed,
  0x3d18a2da, 0x130f2288, 0x3d16c38c, 0x131521f5,
  0x3d14e3a8, 0x131b2132, 0x3d13032d, 0x13212041,
  0x3d11221c, 0x13271f20, 0x3d0f4074, 0x132d1dd0,
  0x3d0d5e35, 0x13331c50, 0x3d0b7b5f, 0x13391aa1,
  0x3d0997f3, 0x133f18c3, 0x3d07b3f0, 0x134516b5,
  0x3d05cf57, 0x134b1478, 0x3d03ea27, 0x1351120b,
  0x3d020461, 0x13570f6f, 0x3d001e04, 0x135d0ca2,
  0x3cfe3710, 0x136309a6, 0x3cfc4f86, 0x1369067a,
  0x3cfa6766, 0x136f031f, 0x3cf87eaf, 0x1374ff93,
  0x3cf69561, 0x137afbd7, 0x3cf4ab7e, 0x1380f7eb,
  0x3cf2c103, 0x1386f3cf, 0x3cf0d5f3, 0x138cef83,
  0x3ceeea4c, 0x1392eb07, 0x3cecfe0f, 0x1398e65a,
  0x3ceb113b, 0x139ee17d, 0x3ce923d1, 0x13a4dc70,
  0x3ce735d1, 0x13aad732, 0x3ce5473a, 0x13b0d1c3,
  0x3ce3580e, 0x13b6cc24, 0x3ce1684b, 0x13bcc655,
  0x3cdf77f2, 0x13c2c054, 0x3cdd8702, 0x13c8ba23,
  0x3cdb957d, 0x13ceb3c1, 0x3cd9a361, 0x13d4ad2f,
  0x3cd7b0af, 0x13daa66b, 0x3cd5bd67, 0x13e09f76,
  0x3cd3c989, 0x13e69850, 0x3cd1d515, 0x13ec90fa,
  0x3ccfe00b, 0x13f28972, 0x3ccdea6a, 0x13f881b8,
  0x3ccbf434, 0x13fe79ce, 0x3cc9fd68, 0x140471b2,
  0x3cc80605, 0x140a6965, 0x3cc60e0d, 0x141060e6,
  0x3cc4157f, 0x14165836, 0x3cc21c5b, 0x141c4f54,
  0x3cc022a0, 0x14224641, 0x3cbe2850, 0x14283cfc,
  0x3cbc2d6b, 0x142e3385, 0x3cba31ef, 0x143429dc,
  0x3cb835dd, 0x143a2002, 0x3cb63936, 0x144015f5,
  0x3cb43bf9, 0x14460bb7, 0x3cb23e26, 0x144c0147,
  0x3cb03fbd, 0x1451f6a4, 0x3cae40bf, 0x1457ebd0,
  0x3cac412a, 0x145de0c9, 0x3caa4100, 0x1463d590,
  0x3ca84041, 0x1469ca25, 0x3ca63eec, 0x146fbe87,
  0x3ca43d01, 0x1475b2b7, 0x3ca23a80, 0x147ba6b4,
  0x3ca0376a, 0x14819a7f, 0x3c9e33be, 0x14878e18,
  0x3c9c2f7d, 0x148d817d, 0x3c9a2aa6, 0x149374b0,
  0x3c98253a, 0x149967b0, 0x3c961f38, 0x149f5a7e,
  0x3c9418a1, 0x14a54d18, 0x3c921174, 0x14ab3f7f,
  0x3c9009b2, 0x14b131b4, 0x3c8e015a, 0x14b723b5,
  0x3c8bf86d, 0x14bd1584, 0x3c89eeea, 0x14c3071f,
  0x3c87e4d2, 0x14c8f887, 0x3c85da25, 0x14cee9bb,
  0x3c83cee2, 0x14d4dabd, 0x3c81c30a, 0x14dacb8b,
  0x3c7fb69d, 0x14e0bc25, 0x3c7da99b, 0x14e6ac8c,
  0x3c7b9c03, 0x14ec9cbf, 0x3c798dd6, 0x14f28cbf,
  0x3c777f14, 0x14f87c8b, 0x3c756fbd, 0x14fe6c23,
  0x3c735fd0, 0x15045b88, 0x3c714f4e, 0x150a4ab9,
  0x3c6f3e37, 0x151039b5, 0x3c6d2c8b, 0x1516287e,
  0x3c6b1a4a, 0x151c1713, 0x3c690774, 0x15220573,
  0x3c66f409, 0x1527f3a0, 0x3c64e009, 0x152de198,
  0x3c62cb74, 0x1533cf5c, 0x3c60b649, 0x1539bcec,
  0x3c5ea08a, 0x153faa47, 0x3c5c8a36, 0x1545976e,
  0x3c5a734d, 0x154b8461, 0x3c585bcf, 0x1551711e,
  0x3c5643bc, 0x15575da8, 0x3c542b14, 0x155d49fc,
  0x3c5211d8, 0x1563361c, 0x3c4ff806, 0x15692207,
  0x3c4ddda0, 0x156f0dbe, 0x3c4bc2a5, 0x1574f93f,
  0x3c49a715, 0x157ae48c, 0x3c478af0, 0x1580cfa3,
  0x3c456e37, 0x1586ba86, 0x3c4350e9, 0x158ca533,
  0x3c413306, 0x15928fab, 0x3c3f148f, 0x159879ee,
  0x3c3cf582, 0x159e63fc, 0x3c3ad5e2, 0x15a44dd4,
  0x3c38b5ac, 0x15aa3777, 0x3c3694e2, 0x15b020e4,
  0x3c347384, 0x15b60a1c, 0x3c325191, 0x15bbf31f,
  0x3c302f09, 0x15c1dbeb, 0x3c2e0bed, 0x15c7c482,
  0x3c2be83d, 0x15cdace4, 0x3c29c3f8, 0x15d3950f,
  0x3c279f1e, 0x15d97d05, 0x3c2579b0, 0x15df64c5,
  0x3c2353ae, 0x15e54c4e, 0x3c212d17, 0x15eb33a2,
  0x3c1f05ec, 0x15f11ac0, 0x3c1cde2d, 0x15f701a7,
  0x3c1ab5d9, 0x15fce859, 0x3c188cf1, 0x1602ced4,
  0x3c166375, 0x1608b518, 0x3c143964, 0x160e9b27,
  0x3c120ebf, 0x161480ff, 0x3c0fe386, 0x161a66a0,
  0x3c0db7b9, 0x16204c0b, 0x3c0b8b58, 0x16263140,
  0x3c095e62, 0x162c163d, 0x3c0730d9, 0x1631fb04,
  0x3c0502bb, 0x1637df95, 0x3c02d409, 0x163dc3ee,
  0x3c00a4c3, 0x1643a810, 0x3bfe74e9, 0x16498bfc,
  0x3bfc447b, 0x164f6fb1, 0x3bfa1379, 0x1655532e,
  0x3bf7e1e3, 0x165b3675, 0x3bf5afb9, 0x16611984,
  0x3bf37cfb, 0x1666fc5c, 0x3bf149a9, 0x166cdefd,
  0x3bef15c3, 0x1672c166, 0x3bece149, 0x1678a398,
  0x3beaac3c, 0x167e8593, 0x3be8769b, 0x16846756,
  0x3be64065, 0x168a48e2, 0x3be4099c, 0x16902a36,
  0x3be1d240, 0x16960b52, 0x3bdf9a4f, 0x169bec37,
  0x3bdd61cb, 0x16a1cce3, 0x3bdb28b3, 0x16a7ad58,
  0x3bd8ef07, 0x16ad8d95, 0x3bd6b4c8, 0x16b36d9a,
  0x3bd479f5, 0x16b94d67, 0x3bd23e8f, 0x16bf2cfc,
  0x3bd00295, 0x16c50c59, 0x3bcdc607, 0x16caeb7e,
  0x3bcb88e5, 0x16d0ca6a, 0x3bc94b31, 0x16d6a91f,
  0x3bc70ce8, 0x16dc879a, 0x3bc4ce0c, 0x16e265de,
  0x3bc28e9d, 0x16e843e9, 0x3bc04e9a, 0x16ee21bb,
  0x3bbe0e04, 0x16f3ff55, 0x3bbbccda, 0x16f9dcb6,
  0x3bb98b1d, 0x16ffb9df, 0x3bb748cd, 0x170596ce,
  0x3bb505e9, 0x170b7385, 0x3bb2c272, 0x17115003,
  0x3bb07e68, 0x17172c49, 0x3bae39ca, 0x171d0855,
  0x3babf499, 0x1722e428, 0x3ba9aed5, 0x1728bfc2,
  0x3ba7687e, 0x172e9b23, 0x3ba52194, 0x1734764b,
  0x3ba2da16, 0x173a5139, 0x3ba09205, 0x17402bee,
  0x3b9e4961, 0x1746066a, 0x3b9c002a, 0x174be0ad,
  0x3b99b660, 0x1751bab5, 0x3b976c03, 0x17579485,
  0x3b952112, 0x175d6e1b, 0x3b92d58f, 0x17634777,
  0x3b908979, 0x17692099, 0x3b8e3cd0, 0x176ef982,
  0x3b8bef94, 0x1774d231, 0x3b89a1c5, 0x177aaaa6,
  0x3b875363, 0x178082e1, 0x3b85046e, 0x17865ae2,
  0x3b82b4e6, 0x178c32a9, 0x3b8064cc, 0x17920a35,
  0x3b7e141e, 0x1797e188, 0x3b7bc2de, 0x179db8a1,
  0x3b79710b, 0x17a38f7f, 0x3b771ea5, 0x17a96623,
  0x3b74cbad, 0x17af3c8c, 0x3b727822, 0x17b512bb,
  0x3b702404, 0x17bae8b0, 0x3b6dcf54, 0x17c0be6a,
  0x3b6b7a11, 0x17c693ea, 0x3b69243b, 0x17cc692e,
  0x3b66cdd3, 0x17d23e38, 0x3b6476d8, 0x17d81308,
  0x3b621f4a, 0x17dde79c, 0x3b5fc72a, 0x17e3bbf6,
  0x3b5d6e78, 0x17e99014, 0x3b5b1533, 0x17ef63f8,
  0x3b58bb5c, 0x17f537a0, 0x3b5660f2, 0x17fb0b0e,
  0x3b5405f6, 0x1800de40, 0x3b51aa67, 0x1806b137,
  0x3b4f4e46, 0x180c83f3, 0x3b4cf193, 0x18125673,
  0x3b4a944d, 0x181828b8, 0x3b483676, 0x181dfac2,
  0x3b45d80b, 0x1823cc90, 0x3b43790f, 0x18299e22,
  0x3b411980, 0x182f6f79, 0x3b3eb960, 0x18354094,
  0x3b3c58ad, 0x183b1174, 0x3b39f767, 0x1840e218,
  0x3b379590, 0x1846b280, 0x3b353327, 0x184c82ab,
  0x3b32d02b, 0x1852529b, 0x3b306c9d, 0x1858224f,
  0x3b2e087e, 0x185df1c7, 0x3b2ba3cc, 0x1863c103,
  0x3b293e89, 0x18699003, 0x3b26d8b3, 0x186f5ec6,
  0x3b24724b, 0x18752d4d, 0x3b220b52, 0x187afb98,
  0x3b1fa3c6, 0x1880c9a6, 0x3b1d3ba9, 0x18869778,
  0x3b1ad2fa, 0x188c650e, 0x3b1869b9, 0x18923266,
  0x3b15ffe6, 0x1897ff82, 0x3b139582, 0x189dcc62,
  0x3b112a8b, 0x18a39905, 0x3b0ebf03, 0x18a9656b,
  0x3b0c52e9, 0x18af3194, 0x3b09e63e, 0x18b4fd80,
  0x3b077901, 0x18bac92f, 0x3b050b32, 0x18c094a1,
  0x3b029cd1, 0x18c65fd7, 0x3b002ddf, 0x18cc2acf,
  0x3afdbe5c, 0x18d1f589, 0x3afb4e47, 0x18d7c007,
  0x3af8dda0, 0x18dd8a47, 0x3af66c68, 0x18e3544a,
  0x3af3fa9e, 0x18e91e10, 0x3af18843, 0x18eee798,
  0x3aef1556, 0x18f4b0e2, 0x3aeca1d8, 0x18fa79ef,
  0x3aea2dc9, 0x190042bf, 0x3ae7b928, 0x19060b50,
  0x3ae543f6, 0x190bd3a4, 0x3ae2ce32, 0x19119bba,
  0x3ae057de, 0x19176393, 0x3adde0f8, 0x191d2b2d,
  0x3adb6980, 0x1922f289, 0x3ad8f178, 0x1928b9a8,
  0x3ad678de, 0x192e8088, 0x3ad3ffb3, 0x1934472a,
  0x3ad185f7, 0x193a0d8e, 0x3acf0baa, 0x193fd3b4,
  0x3acc90cc, 0x1945999b, 0x3aca155d, 0x194b5f44,
  0x3ac7995c, 0x195124af, 0x3ac51ccb, 0x1956e9db,
  0x3ac29fa9, 0x195caec9, 0x3ac021f5, 0x19627378,
  0x3abda3b1, 0x196837e8, 0x3abb24db, 0x196dfc1a,
  0x3ab8a575, 0x1973c00d, 0x3ab6257e, 0x197983c1,
  0x3ab3a4f6, 0x197f4736, 0x3ab123dd, 0x19850a6d,
  0x3aaea234, 0x198acd64, 0x3aac1ff9, 0x1990901d,
  0x3aa99d2e, 0x19965296, 0x3aa719d2, 0x199c14d0,
  0x3aa495e6, 0x19a1d6cb, 0x3aa21168, 0x19a79887,
  0x3a9f8c5a, 0x19ad5a04, 0x3a9d06bc, 0x19b31b41,
  0x3a9a808c, 0x19b8dc3e, 0x3a97f9cc, 0x19be9cfd,
  0x3a95727c, 0x19c45d7b, 0x3a92ea9b, 0x19ca1dbb,
  0x3a906229, 0x19cfddba, 0x3a8dd927, 0x19d59d7a,
  0x3a8b4f95, 0x19db5cfa, 0x3a88c572, 0x19e11c3a,
  0x3a863abe, 0x19e6db3b, 0x3a83af7b, 0x19ec99fb,
  0x3a8123a6, 0x19f2587c, 0x3a7e9742, 0x19f816bc,
  0x3a7c0a4d, 0x19fdd4bd, 0x3a797cc8, 0x1a03927d,
  0x3a76eeb2, 0x1a094ffd, 0x3a74600d, 0x1a0f0d3d,
  0x3a71d0d7, 0x1a14ca3d, 0x3a6f4111, 0x1a1a86fc,
  0x3a6cb0ba, 0x1a20437b, 0x3a6a1fd4, 0x1a25ffb9,
  0x3a678e5d, 0x1a2bbbb7, 0x3a64fc57, 0x1a317775,
  0x3a6269c0, 0x1a3732f1, 0x3a5fd699, 0x1a3cee2d,
  0x3a5d42e2, 0x1a42a929, 0x3a5aae9b, 0x1a4863e3,
  0x3a5819c4, 0x1a4e1e5d, 0x3a55845d, 0x1a53d895,
  0x3a52ee67, 0x1a59928d, 0x3a5057e0, 0x1a5f4c44,
  0x3a4dc0c9, 0x1a6505b9, 0x3a4b2923, 0x1a6abeee,
  0x3a4890ed, 0x1a7077e1, 0x3a45f827, 0x1a763093,
  0x3a435ed1, 0x1a7be904, 0x3a40c4eb, 0x1a81a134,
  0x3a3e2a76, 0x1a875922, 0x3a3b8f71, 0x1a8d10ce,
  0x3a38f3dc, 0x1a92c839, 0x3a3657b8, 0x1a987f63,
  0x3a33bb04, 0x1a9e364b, 0x3a311dc0, 0x1aa3ecf1,
  0x3a2e7fed, 0x1aa9a355, 0x3a2be18a, 0x1aaf5978,
  0x3a294298, 0x1ab50f59, 0x3a26a316, 0x1abac4f8,
  0x3a240305, 0x1ac07a55, 0x3a216264, 0x1ac62f70,
  0x3a1ec134, 0x1acbe449, 0x3a1c1f74, 0x1ad198e0,
  0x3a197d25, 0x1ad74d34, 0x3a16da47, 0x1add0147,
  0x3a1436d9, 0x1ae2b517, 0x3a1192dc, 0x1ae868a5,
  0x3a0eee50, 0x1aee1bf0, 0x3a0c4935, 0x1af3cef9,
  0x3a09a38a, 0x1af981c0, 0x3a06fd50, 0x1aff3444,
  0x3a045687, 0x1b04e685, 0x3a01af2f, 0x1b0a9883,
  0x39ff0747, 0x1b104a3f, 0x39fc5ed1, 0x1b15fbb8,
  0x39f9b5cb, 0x1b1bacef, 0x39f70c37, 0x1b215de2,
  0x39f46213, 0x1b270e93, 0x39f1b761, 0x1b2cbf00,
  0x39ef0c1f, 0x1b326f2b, 0x39ec604e, 0x1b381f12,
  0x39e9b3ef, 0x1b3dceb6, 0x39e70701, 0x1b437e17,
  0x39e45983, 0x1b492d35, 0x39e1ab77, 0x1b4edc0f,
  0x39defcdd, 0x1b548aa6, 0x39dc4db3, 0x1b5a38f9,
  0x39d99dfa, 0x1b5fe709, 0x39d6edb3, 0x1b6594d6,
  0x39d43cdd, 0x1b6b425f, 0x39d18b79, 0x1b70efa4,
  0x39ced986, 0x1b769ca6, 0x39cc2704, 0x1b7c4963,
  0x39c973f3, 0x1b81f5dd, 0x39c6c054, 0x1b87a213,
  0x39c40c27, 0x1b8d4e06, 0x39c1576a, 0x1b92f9b4,
  0x39bea220, 0x1b98a51e, 0x39bbec47, 0x1b9e5044,
  0x39b935df, 0x1ba3fb26, 0x39b67ee9, 0x1ba9a5c4,
  0x39b3c765, 0x1baf501d, 0x39b10f52, 0x1bb4fa32,
  0x39ae56b1, 0x1bbaa403, 0x39ab9d81, 0x1bc04d8f,
  0x39a8e3c4, 0x1bc5f6d7, 0x39a62978, 0x1bcb9fda,
  0x39a36e9d, 0x1bd14899, 0x39a0b335, 0x1bd6f113,
  0x399df73e, 0x1bdc9949, 0x399b3ab9, 0x1be24139,
  0x39987da6, 0x1be7e8e5, 0x3995c005, 0x1bed904c,
  0x399301d6, 0x1bf3376f, 0x39904319, 0x1bf8de4c,
  0x398d83ce, 0x1bfe84e4, 0x398ac3f4, 0x1c042b37,
  0x3988038d, 0x1c09d145, 0x39854298, 0x1c0f770e,
  0x39828115, 0x1c151c91, 0x397fbf04, 0x1c1ac1cf,
  0x397cfc65, 0x1c2066c8, 0x397a3938, 0x1c260b7c,
  0x3977757d, 0x1c2bafea, 0x3974b135, 0x1c315412,
  0x3971ec5f, 0x1c36f7f5, 0x396f26fb, 0x1c3c9b93,
  0x396c610a, 0x1c423eea, 0x39699a8a, 0x1c47e1fc,
  0x3966d37d, 0x1c4d84c8, 0x39640be3, 0x1c53274f,
  0x396143bb, 0x1c58c98f, 0x395e7b05, 0x1c5e6b8a,
  0x395bb1c2, 0x1c640d3e, 0x3958e7f1, 0x1c69aead,
  0x39561d92, 0x1c6f4fd5, 0x395352a7, 0x1c74f0b7,
  0x3950872d, 0x1c7a9153, 0x394dbb27, 0x1c8031a9,
  0x394aee93, 0x1c85d1b8, 0x39482171, 0x1c8b7181,
  0x394553c3, 0x1c911104, 0x39428586, 0x1c96b040,
  0x393fb6bd, 0x1c9c4f35, 0x393ce767, 0x1ca1ede4,
  0x393a1783, 0x1ca78c4d, 0x39374712, 0x1cad2a6e,
  0x39347613, 0x1cb2c849, 0x3931a488, 0x1cb865dd,
  0x392ed270, 0x1cbe032a, 0x392bffca, 0x1cc3a031,
  0x39292c97, 0x1cc93cf0, 0x392658d8, 0x1cced968,
  0x3923848b, 0x1cd47599, 0x3920afb1, 0x1cda1183,
  0x391dda4b, 0x1cdfad26, 0x391b0457, 0x1ce54882,
  0x39182dd7, 0x1ceae396, 0x391556ca, 0x1cf07e63,
  0x39127f2f, 0x1cf618e9, 0x390fa708, 0x1cfbb327,
  0x390cce55, 0x1d014d1d, 0x3909f514, 0x1d06e6cc,
  0x39071b47, 0x1d0c8034, 0x390440ed, 0x1d121954,
  0x39016606, 0x1d17b22c, 0x38fe8a93, 0x1d1d4abc,
  0x38fbae93, 0x1d22e304, 0x38f8d206, 0x1d287b05,
  0x38f5f4ed, 0x1d2e12bd, 0x38f31747, 0x1d33aa2e,
  0x38f03915, 0x1d394156, 0x38ed5a56, 0x1d3ed837,
  0x38ea7b0b, 0x1d446ecf, 0x38e79b34, 0x1d4a051f,
  0x38e4bad0, 0x1d4f9b26, 0x38e1d9df, 0x1d5530e6,
  0x38def863, 0x1d5ac65d, 0x38dc165a, 0x1d605b8c,
  0x38d933c4, 0x1d65f072, 0x38d650a3, 0x1d6b850f,
  0x38d36cf5, 0x1d711964, 0x38d088bb, 0x1d76ad71,
  0x38cda3f4, 0x1d7c4134, 0x38cabea2, 0x1d81d4af,
  0x38c7d8c3, 0x1d8767e1, 0x38c4f259, 0x1d8cfaca,
  0x38c20b62, 0x1d928d6b, 0x38bf23df, 0x1d981fc2,
  0x38bc3bd1, 0x1d9db1d1, 0x38b95336, 0x1da34396,
  0x38b66a0f, 0x1da8d512, 0x38b3805c, 0x1dae6645,
  0x38b0961e, 0x1db3f72f, 0x38adab54, 0x1db987cf,
  0x38aabffd, 0x1dbf1826, 0x38a7d41b, 0x1dc4a834,
  0x38a4e7ad, 0x1dca37f8, 0x38a1fab4, 0x1dcfc773,
  0x389f0d2e, 0x1dd556a4, 0x389c1f1d, 0x1ddae58b,
  0x38993080, 0x1de07429, 0x38964158, 0x1de6027e,
  0x389351a4, 0x1deb9088, 0x38906164, 0x1df11e49,
  0x388d7099, 0x1df6abbf, 0x388a7f42, 0x1dfc38ec,
  0x38878d60, 0x1e01c5cf, 0x38849af2, 0x1e075268,
  0x3881a7f9, 0x1e0cdeb6, 0x387eb474, 0x1e126abb,
  0x387bc064, 0x1e17f675, 0x3878cbc9, 0x1e1d81e5,
  0x3875d6a2, 0x1e230d0b, 0x3872e0f0, 0x1e2897e6,
  0x386feab3, 0x1e2e2277, 0x386cf3ea, 0x1e33acbe,
  0x3869fc97, 0x1e3936ba, 0x386704b8, 0x1e3ec06b,
  0x38640c4d, 0x1e4449d2, 0x38611358, 0x1e49d2ee,
  0x385e19d8, 0x1e4f5bbf, 0x385b1fcc, 0x1e54e446,
  0x38582536, 0x1e5a6c82, 0x38552a14, 0x1e5ff473,
  0x38522e68, 0x1e657c19, 0x384f3230, 0x1e6b0373,
  0x384c356e, 0x1e708a83, 0x38493820, 0x1e761148,
  0x38463a48, 0x1e7b97c2, 0x38433be5, 0x1e811df0,
  0x38403cf7, 0x1e86a3d3, 0x383d3d7e, 0x1e8c296b,
  0x383a3d7b, 0x1e91aeb7, 0x38373ced, 0x1e9733b8,
  0x38343bd4, 0x1e9cb86e, 0x38313a30, 0x1ea23cd8,
  0x382e3802, 0x1ea7c0f6, 0x382b3549, 0x1ead44c9,
  0x38283205, 0x1eb2c850, 0x38252e37, 0x1eb84b8b,
  0x382229df, 0x1ebdce7b, 0x381f24fc, 0x1ec3511f,
  0x381c1f8e, 0x1ec8d376, 0x38191996, 0x1ece5582,
  0x38161314, 0x1ed3d742, 0x38130c07, 0x1ed958b6,
  0x38100470, 0x1eded9dd, 0x380cfc4f, 0x1ee45ab9,
  0x3809f3a3, 0x1ee9db48, 0x3806ea6d, 0x1eef5b8b,
  0x3803e0ac, 0x1ef4db81, 0x3800d662, 0x1efa5b2c,
  0x37fdcb8d, 0x1effda89, 0x37fac02e, 0x1f05599b,
  0x37f7b446, 0x1f0ad860, 0x37f4a7d2, 0x1f1056d8,
  0x37f19ad5, 0x1f15d503, 0x37ee8d4e, 0x1f1b52e2,
  0x37eb7f3d, 0x1f20d074, 0x37e870a2, 0x1f264db9,
  0x37e5617d, 0x1f2bcab2, 0x37e251ce, 0x1f31475d,
  0x37df4195, 0x1f36c3bc, 0x37dc30d2, 0x1f3c3fcd,
  0x37d91f86, 0x1f41bb92, 0x37d60daf, 0x1f473709,
  0x37d2fb4f, 0x1f4cb233, 0x37cfe865, 0x1f522d10,
  0x37ccd4f2, 0x1f57a7a0, 0x37c9c0f4, 0x1f5d21e2,
  0x37c6ac6d, 0x1f629bd7, 0x37c3975d, 0x1f68157f,
  0x37c081c3, 0x1f6d8ed9, 0x37bd6b9f, 0x1f7307e5,
  0x37ba54f2, 0x1f7880a4, 0x37b73dbb, 0x1f7df915,
  0x37b425fb, 0x1f837139, 0x37b10db1, 0x1f88e90e,
  0x37adf4de, 0x1f8e6096, 0x37aadb82, 0x1f93d7d0,
  0x37a7c19c, 0x1f994ebc, 0x37a4a72d, 0x1f9ec55b,
  0x37a18c34, 0x1fa43bab, 0x379e70b3, 0x1fa9b1ad,
  0x379b54a8, 0x1faf2761, 0x37983814, 0x1fb49cc7,
  0x37951af6, 0x1fba11de, 0x3791fd50, 0x1fbf86a7,
  0x378edf20, 0x1fc4fb22, 0x378bc068, 0x1fca6f4f,
  0x3788a126, 0x1fcfe32d, 0x3785815b, 0x1fd556bd,
  0x37826108, 0x1fdac9fe, 0x377f402b, 0x1fe03cf0,
  0x377c1ec5, 0x1fe5af94, 0x3778fcd7, 0x1feb21e9,
  0x3775da5f, 0x1ff093ef, 0x3772b75f, 0x1ff605a7,
  0x376f93d6, 0x1ffb7710, 0x376c6fc4, 0x2000e829,
  0x37694b2a, 0x200658f4, 0x37662606, 0x200bc970,
  0x3763005a, 0x2011399d, 0x375fda26, 0x2016a97a,
  0x375cb368, 0x201c1909, 0x37598c23, 0x20218848,
  0x37566454, 0x2026f738, 0x37533bfd, 0x202c65d9,
  0x3750131e, 0x2031d42a, 0x374ce9b6, 0x2037422c,
  0x3749bfc5, 0x203cafde, 0x3746954c, 0x20421d41,
  0x37436a4b, 0x20478a54, 0x37403ec1, 0x204cf717,
  0x373d12b0, 0x2052638b, 0x3739e615, 0x2057cfaf,
  0x3736b8f3, 0x205d3b83, 0x37338b48, 0x2062a708,
  0x37305d15, 0x2068123c, 0x372d2e5a, 0x206d7d21,
  0x3729ff17, 0x2072e7b5, 0x3726cf4c, 0x207851fa,
  0x37239ef8, 0x207dbbee, 0x37206e1d, 0x20832592,
  0x371d3cb9, 0x20888ee6, 0x371a0ace, 0x208df7ea,
  0x3716d85a, 0x2093609d, 0x3713a55f, 0x2098c900,
  0x371071dc, 0x209e3112, 0x370d3dd0, 0x20a398d5,
  0x370a093d, 0x20a90046, 0x3706d423, 0x20ae6767,
  0x37039e80, 0x20b3ce37, 0x37006856, 0x20b934b7,
  0x36fd31a4, 0x20be9ae6, 0x36f9fa6a, 0x20c400c4,
  0x36f6c2a9, 0x20c96651, 0x36f38a60, 0x20cecb8d,
  0x36f0518f, 0x20d43079, 0x36ed1837, 0x20d99513,
  0x36e9de58, 0x20def95c, 0x36e6a3f1, 0x20e45d55,
  0x36e36902, 0x20e9c0fc, 0x36e02d8c, 0x20ef2451,
  0x36dcf18f, 0x20f48756, 0x36d9b50a, 0x20f9ea09,
  0x36d677fe, 0x20ff4c6b, 0x36d33a6a, 0x2104ae7c,
  0x36cffc50, 0x210a103b, 0x36ccbdae, 0x210f71a8,
  0x36c97e85, 0x2114d2c4, 0x36c63ed4, 0x211a338e,
  0x36c2fe9d, 0x211f9407, 0x36bfbdde, 0x2124f42e,
  0x36bc7c98, 0x212a5403, 0x36b93acc, 0x212fb386,
  0x36b5f878, 0x213512b8, 0x36b2b59d, 0x213a7197,
  0x36af723b, 0x213fd025, 0x36ac2e53, 0x21452e60,
  0x36a8e9e3, 0x214a8c49, 0x36a5a4ed, 0x214fe9e1,
  0x36a25f70, 0x21554726, 0x369f196b, 0x215aa418,
  0x369bd2e1, 0x216000b9, 0x36988bcf, 0x21655d07,
  0x36954437, 0x216ab903, 0x3691fc18, 0x217014ac,
  0x368eb372, 0x21757003, 0x368b6a46, 0x217acb07,
  0x36882093, 0x218025b8, 0x3684d65a, 0x21858017,
  0x36818b9a, 0x218ada24, 0x367e4054, 0x219033dd,
  0x367af487, 0x21958d44, 0x3677a833, 0x219ae657,
  0x36745b5a, 0x21a03f18, 0x36710dfa, 0x21a59786,
  0x366dc013, 0x21aaefa1, 0x366a71a7, 0x21b04769,
  0x366722b4, 0x21b59ede, 0x3663d33b, 0x21baf5ff,
  0x3660833b, 0x21c04ccd, 0x365d32b6, 0x21c5a348,
  0x3659e1aa, 0x21caf970, 0x36569019, 0x21d04f44,
  0x36533e01, 0x21d5a4c5, 0x364feb63, 0x21daf9f2,
  0x364c983f, 0x21e04ecc, 0x36494495, 0x21e5a353,
  0x3645f065, 0x21eaf785, 0x36429bb0, 0x21f04b64,
  0x363f4674, 0x21f59eef, 0x363bf0b3, 0x21faf227,
  0x36389a6b, 0x2200450a, 0x3635439e, 0x2205979a,
  0x3631ec4c, 0x220ae9d6, 0x362e9473, 0x22103bbd,
  0x362b3c15, 0x22158d51, 0x3627e331, 0x221ade91,
  0x362489c7, 0x22202f7c, 0x36212fd8, 0x22258013,
  0x361dd564, 0x222ad056, 0x361a7a6a, 0x22302045,
  0x36171eea, 0x22356fdf, 0x3613c2e5, 0x223abf25,
  0x3610665a, 0x22400e16, 0x360d094a, 0x22455cb3,
  0x3609abb5, 0x224aaafc, 0x36064d9a, 0x224ff8ef,
  0x3602eefa, 0x2255468e, 0x35ff8fd5, 0x225a93d9,
  0x35fc302b, 0x225fe0ce, 0x35f8cffb, 0x22652d6f,
  0x35f56f46, 0x226a79bb, 0x35f20e0c, 0x226fc5b2,
  0x35eeac4d, 0x22751154, 0x35eb4a09, 0x227a5ca1,
  0x35e7e740, 0x227fa799, 0x35e483f2, 0x2284f23c,
  0x35e1201e, 0x228a3c8a, 0x35ddbbc6, 0x228f8682,
  0x35da56e9, 0x2294d025, 0x35d6f187, 0x229a1973,
  0x35d38ba1, 0x229f626c, 0x35d02535, 0x22a4ab0f,
  0x35ccbe45, 0x22a9f35c, 0x35c956d0, 0x22af3b54,
  0x35c5eed6, 0x22b482f7, 0x35c28658, 0x22b9ca43,
  0x35bf1d54, 0x22bf113b, 0x35bbb3cd, 0x22c457dc,
  0x35b849c0, 0x22c99e28, 0x35b4df30, 0x22cee41d,
  0x35b1741a, 0x22d429bd, 0x35ae0880, 0x22d96f07,
  0x35aa9c62, 0x22deb3fb, 0x35a72fbf, 0x22e3f899,
  0x35a3c298, 0x22e93ce1, 0x35a054ed, 0x22ee80d3,
  0x359ce6bd, 0x22f3c46e, 0x35997809, 0x22f907b3,
  0x359608d1, 0x22fe4aa2, 0x35929914, 0x23038d3b,
  0x358f28d3, 0x2308cf7d, 0x358bb80e, 0x230e1169,
  0x358846c5, 0x231352fe, 0x3584d4f8, 0x2318943d,
  0x358162a7, 0x231dd525, 0x357defd2, 0x232315b7,
  0x357a7c79, 0x232855f2, 0x3577089c, 0x232d95d6,
  0x3573943b, 0x2332d563, 0x35701f56, 0x23381499,
  0x356ca9ed, 0x233d5379, 0x35693401, 0x23429201,
  0x3565bd90, 0x2347d033, 0x3562469c, 0x234d0e0d,
  0x355ecf25, 0x23524b91, 0x355b5729, 0x235788bd,
  0x3557deaa, 0x235cc592, 0x355465a7, 0x23620210,
  0x3550ec21, 0x23673e36, 0x354d7217, 0x236c7a06,
  0x3549f789, 0x2371b57d, 0x35467c78, 0x2376f09e,
  0x354300e4, 0x237c2b66, 0x353f84cc, 0x238165d8,
  0x353c0831, 0x23869ff1, 0x35388b13, 0x238bd9b3,
  0x35350d71, 0x2391131e, 0x35318f4c, 0x23964c30,
  0x352e10a3, 0x239b84eb, 0x352a9178, 0x23a0bd4e,
  0x352711c9, 0x23a5f558, 0x35239197, 0x23ab2d0b,
  0x352010e2, 0x23b06466, 0x351c8faa, 0x23b59b69,
  0x35190def, 0x23bad214, 0x35158bb1, 0x23c00867,
  0x351208ef, 0x23c53e61, 0x350e85ab, 0x23ca7403,
  0x350b01e4, 0x23cfa94d, 0x35077d9a, 0x23d4de3f,
  0x3503f8ce, 0x23da12d8, 0x3500737e, 0x23df4718,
  0x34fcedac, 0x23e47b00, 0x34f96757, 0x23e9ae90,
  0x34f5e07f, 0x23eee1c7, 0x34f25924, 0x23f414a5,
  0x34eed147, 0x23f9472b, 0x34eb48e8, 0x23fe7958,
  0x34e7c005, 0x2403ab2c, 0x34e436a1, 0x2408dca7,
  0x34e0acb9, 0x240e0dc9, 0x34dd224f, 0x24133e92,
  0x34d99763, 0x24186f02, 0x34d60bf5, 0x241d9f1a,
  0x34d28004, 0x2422ced8, 0x34cef390, 0x2427fe3d,
  0x34cb669b, 0x242d2d48, 0x34c7d923, 0x24325bfb,
  0x34c44b29, 0x24378a54, 0x34c0bcac, 0x243cb854,
  0x34bd2dae, 0x2441e5fa, 0x34b99e2d, 0x24471347,
  0x34b60e2b, 0x244c403a, 0x34b27da6, 0x24516cd4,
  0x34aeec9f, 0x24569914, 0x34ab5b16, 0x245bc4fb,
  0x34a7c90c, 0x2460f088, 0x34a4367f, 0x24661bbb,
  0x34a0a370, 0x246b4694, 0x349d0fe0, 0x24707113,
  0x34997bce, 0x24759b39, 0x3495e73a, 0x247ac504,
  0x34925224, 0x247fee76, 0x348ebc8d, 0x2485178d,
  0x348b2673, 0x248a404b, 0x34878fd9, 0x248f68ae,
  0x3483f8bc, 0x249490b7, 0x3480611e, 0x2499b865,
  0x347cc8ff, 0x249edfba, 0x3479305e, 0x24a406b4,
  0x3475973b, 0x24a92d54, 0x3471fd97, 0x24ae5399,
  0x346e6372, 0x24b37983, 0x346ac8cb, 0x24b89f14,
  0x34672da3, 0x24bdc449, 0x346391fa, 0x24c2e924,
  0x345ff5cf, 0x24c80da4, 0x345c5923, 0x24cd31ca,
  0x3458bbf6, 0x24d25594, 0x34551e48, 0x24d77904,
  0x34518019, 0x24dc9c19, 0x344de168, 0x24e1bed3,
  0x344a4237, 0x24e6e132, 0x3446a284, 0x24ec0335,
  0x34430251, 0x24f124de, 0x343f619c, 0x24f6462c,
  0x343bc067, 0x24fb671e, 0x34381eb1, 0x250087b5,
  0x34347c7a, 0x2505a7f1, 0x3430d9c2, 0x250ac7d2,
  0x342d3689, 0x250fe757, 0x342992d0, 0x25150680,
  0x3425ee96, 0x251a254e, 0x342249db, 0x251f43c1,
  0x341ea4a0, 0x252461d8, 0x341afee4, 0x25297f93,
  0x341758a7, 0x252e9cf3, 0x3413b1ea, 0x2533b9f7,
  0x34100aac, 0x2538d69f, 0x340c62ee, 0x253df2eb,
  0x3408bab0, 0x25430edc, 0x340511f1, 0x25482a70,
  0x340168b2, 0x254d45a9, 0x33fdbef2, 0x25526085,
  0x33fa14b2, 0x25577b06, 0x33f669f2, 0x255c952a,
  0x33f2beb2, 0x2561aef2, 0x33ef12f2, 0x2566c85e,
  0x33eb66b1, 0x256be16d, 0x33e7b9f0, 0x2570fa20,
  0x33e40cb0, 0x25761277, 0x33e05eef, 0x257b2a71,
  0x33dcb0ae, 0x2580420f, 0x33d901ed, 0x25855951,
  0x33d552ac, 0x258a7035, 0x33d1a2ec, 0x258f86be,
  0x33cdf2ab, 0x25949ce9, 0x33ca41eb, 0x2599b2b8,
  0x33c690ab, 0x259ec82a, 0x33c2deeb, 0x25a3dd3f,
  0x33bf2cac, 0x25a8f1f7, 0x33bb79ec, 0x25ae0652,
  0x33b7c6ae, 0x25b31a51, 0x33b412ef, 0x25b82df2,
  0x33b05eb1, 0x25bd4136, 0x33aca9f4, 0x25c2541e,
  0x33a8f4b6, 0x25c766a8, 0x33a53efa, 0x25cc78d4,
  0x33a188be, 0x25d18aa4, 0x339dd203, 0x25d69c16,
  0x339a1ac8, 0x25dbad2b, 0x3396630e, 0x25e0bde2,
  0x3392aad4, 0x25e5ce3c, 0x338ef21c, 0x25eade39,
  0x338b38e4, 0x25efedd8, 0x33877f2d, 0x25f4fd19,
  0x3383c4f7, 0x25fa0bfd, 0x33800a42, 0x25ff1a83,
  0x337c4f0d, 0x260428ab, 0x3378935a, 0x26093675,
  0x3374d728, 0x260e43e2, 0x33711a76, 0x261350f0,
  0x336d5d46, 0x26185da1, 0x33699f97, 0x261d69f4,
  0x3365e169, 0x262275e8, 0x336222bc, 0x2627817f,
  0x335e6391, 0x262c8cb7, 0x335aa3e6, 0x26319792,
  0x3356e3bd, 0x2636a20d, 0x33532316, 0x263bac2b,
  0x334f61ef, 0x2640b5eb, 0x334ba04a, 0x2645bf4b,
  0x3347de27, 0x264ac84e, 0x33441b85, 0x264fd0f2,
  0x33405864, 0x2654d938, 0x333c94c5, 0x2659e11f,
  0x3338d0a8, 0x265ee8a7, 0x33350c0c, 0x2663efd1,
  0x333146f2, 0x2668f69b, 0x332d8159, 0x266dfd08,
  0x3329bb43, 0x26730315, 0x3325f4ae, 0x267808c3,
  0x33222d9a, 0x267d0e13, 0x331e6609, 0x26821303,
  0x331a9dfa, 0x26871795, 0x3316d56c, 0x268c1bc8,
  0x33130c60, 0x26911f9b, 0x330f42d7, 0x2696230f,
  0x330b78cf, 0x269b2624, 0x3307ae49, 0x26a028da,
  0x3303e346, 0x26a52b30, 0x330017c4, 0x26aa2d27,
  0x32fc4bc5, 0x26af2ebf, 0x32f87f48, 0x26b42ff7,
  0x32f4b24d, 0x26b930d0, 0x32f0e4d5, 0x26be3149,
  0x32ed16df, 0x26c33163, 0x32e9486b, 0x26c8311d,
  0x32e57979, 0x26cd3077, 0x32e1aa0a, 0x26d22f72,
  0x32ddda1e, 0x26d72e0c, 0x32da09b4, 0x26dc2c47,
  0x32d638cc, 0x26e12a22, 0x32d26767, 0x26e6279d,
  0x32ce9585, 0x26eb24b9, 0x32cac325, 0x26f02174,
  0x32c6f048, 0x26f51dcf, 0x32c31ced, 0x26fa19ca,
  0x32bf4916, 0x26ff1564, 0x32bb74c1, 0x2704109f,
  0x32b79fef, 0x27090b79, 0x32b3caa0, 0x270e05f3,
  0x32aff4d3, 0x2713000c, 0x32ac1e8a, 0x2717f9c6,
  0x32a847c4, 0x271cf31e, 0x32a47080, 0x2721ec16,
  0x32a098c0, 0x2726e4ae, 0x329cc083, 0x272bdce5,
  0x3298e7c9, 0x2730d4bb, 0x32950e92, 0x2735cc31,
  0x329134de, 0x273ac346, 0x328d5aad, 0x273fb9fa,
  0x32898000, 0x2744b04d, 0x3285a4d6, 0x2749a640,
  0x3281c92f, 0x274e9bd1, 0x327ded0c, 0x27539102,
  0x327a106c, 0x275885d1, 0x32763350, 0x275d7a40,
  0x327255b7, 0x27626e4d, 0x326e77a2, 0x276761f9,
  0x326a9910, 0x276c5544, 0x3266ba02, 0x2771482d,
  0x3262da77, 0x27763ab5, 0x325efa70, 0x277b2cdc,
  0x325b19ed, 0x27801ea2, 0x325738ee, 0x27851006,
  0x32535772, 0x278a0108, 0x324f757a, 0x278ef1a9,
  0x324b9306, 0x2793e1e8, 0x3247b016, 0x2798d1c6,
  0x3243ccaa, 0x279dc142, 0x323fe8c2, 0x27a2b05c,
  0x323c045e, 0x27a79f14, 0x32381f7e, 0x27ac8d6b,
  0x32343a22, 0x27b17b60, 0x3230544a, 0x27b668f2,
  0x322c6df7, 0x27bb5623, 0x32288727, 0x27c042f2,
  0x32249fdc, 0x27c52f5e, 0x3220b815, 0x27ca1b69,
  0x321ccfd2, 0x27cf0711, 0x3218e714, 0x27d3f257,
  0x3214fdda, 0x27d8dd3b, 0x32111425, 0x27ddc7bd,
  0x320d29f4, 0x27e2b1dc, 0x32093f47, 0x27e79b98,
  0x3205541f, 0x27ec84f3, 0x3201687c, 0x27f16dea,
  0x31fd7c5d, 0x27f65680, 0x31f98fc3, 0x27fb3eb2,
  0x31f5a2ae, 0x28002682, 0x31f1b51d, 0x28050def,
  0x31edc711, 0x2809f4fa, 0x31e9d88a, 0x280edba2,
  0x31e5e988, 0x2813c1e6, 0x31e1fa0a, 0x2818a7c8,
  0x31de0a12, 0x281d8d48, 0x31da199e, 0x28227264,
  0x31d628b0, 0x2827571d, 0x31d23746, 0x282c3b73,
  0x31ce4562, 0x28311f65, 0x31ca5303, 0x283602f5,
  0x31c66029, 0x283ae622, 0x31c26cd4, 0x283fc8eb,
  0x31be7904, 0x2844ab51, 0x31ba84b9, 0x28498d53,
  0x31b68ff4, 0x284e6ef2, 0x31b29ab4, 0x2853502e,
  0x31aea4fa, 0x28583106, 0x31aaaec5, 0x285d117b,
  0x31a6b815, 0x2861f18c, 0x31a2c0eb, 0x2866d139,
  0x319ec947, 0x286bb083, 0x319ad128, 0x28708f69,
  0x3196d88e, 0x28756deb, 0x3192df7a, 0x287a4c09,
  0x318ee5ec, 0x287f29c4, 0x318aebe4, 0x2884071a,
  0x3186f161, 0x2888e40d, 0x3182f665, 0x288dc09c,
  0x317efaee, 0x28929cc6, 0x317afefc, 0x2897788c,
  0x31770291, 0x289c53ef, 0x317305ac, 0x28a12eed,
  0x316f084d, 0x28a60987, 0x316b0a74, 0x28aae3bc,
  0x31670c20, 0x28afbd8d, 0x31630d53, 0x28b496fa,
  0x315f0e0c, 0x28b97002, 0x315b0e4c, 0x28be48a6,
  0x31570e11, 0x28c320e5, 0x31530d5d, 0x28c7f8c0,
  0x314f0c2f, 0x28ccd036, 0x314b0a87, 0x28d1a748,
  0x31470866, 0x28d67df4, 0x314305cb, 0x28db543c,
  0x313f02b7, 0x28e02a20, 0x313aff29, 0x28e4ff9e,
  0x3136fb22, 0x28e9d4b7, 0x3132f6a1, 0x28eea96c,
  0x312ef1a7, 0x28f37dbb, 0x312aec33, 0x28f851a6,
  0x3126e646, 0x28fd252b, 0x3122dfe0, 0x2901f84b,
  0x311ed901, 0x2906cb06, 0x311ad1a8, 0x290b9d5c,
  0x3116c9d7, 0x29106f4c, 0x3112c18c, 0x291540d8,
  0x310eb8c8, 0x291a11fd, 0x310aaf8b, 0x291ee2be,
  0x3106a5d5, 0x2923b319, 0x31029ba6, 0x2928830e,
  0x30fe90fe, 0x292d529e, 0x30fa85dd, 0x293221c8,
  0x30f67a44, 0x2936f08d, 0x30f26e31, 0x293bbeec,
  0x30ee61a6, 0x29408ce5, 0x30ea54a2, 0x29455a78,
  0x30e64725, 0x294a27a6, 0x30e23930, 0x294ef46e,
  0x30de2ac2, 0x2953c0cf, 0x30da1bdc, 0x29588ccb,
  0x30d60c7d, 0x295d5861, 0x30d1fca5, 0x29622391,
  0x30cdec55, 0x2966ee5a, 0x30c9db8d, 0x296bb8be,
  0x30c5ca4c, 0x297082bb, 0x30c1b893, 0x29754c52,
  0x30bda661, 0x297a1583, 0x30b993b8, 0x297ede4d,
  0x30b58096, 0x2983a6b1, 0x30b16cfc, 0x29886eaf,
  0x30ad58ea, 0x298d3646, 0x30a9445f, 0x2991fd76,
  0x30a52f5d, 0x2996c440, 0x30a119e2, 0x299b8aa4,
  0x309d03f0, 0x29a050a0, 0x3098ed86, 0x29a51636,
  0x3094d6a3, 0x29a9db65, 0x3090bf49, 0x29aea02e,
  0x308ca777, 0x29b3648f, 0x30888f2d, 0x29b8288a,
  0x3084766c, 0x29bcec1e, 0x30805d33, 0x29c1af4b,
  0x307c4382, 0x29c67210, 0x30782959, 0x29cb346f,
  0x30740eb9, 0x29cff667, 0x306ff3a1, 0x29d4b7f7,
  0x306bd812, 0x29d97920, 0x3067bc0b, 0x29de39e2,
  0x30639f8d, 0x29e2fa3d, 0x305f8298, 0x29e7ba30,
  0x305b652b, 0x29ec79bc, 0x30574747, 0x29f138e0,
  0x305328eb, 0x29f5f79d, 0x304f0a19, 0x29fab5f3,
  0x304aeacf, 0x29ff73e0, 0x3046cb0e, 0x2a043166,
  0x3042aad5, 0x2a08ee85, 0x303e8a26, 0x2a0dab3c,
  0x303a6900, 0x2a12678b, 0x30364763, 0x2a172372,
  0x3032254e, 0x2a1bdef1, 0x302e02c3, 0x2a209a09,
  0x3029dfc1, 0x2a2554b8, 0x3025bc48, 0x2a2a0f00,
  0x30219859, 0x2a2ec8df, 0x301d73f2, 0x2a338257,
  0x30194f15, 0x2a383b66, 0x301529c1, 0x2a3cf40d,
  0x301103f7, 0x2a41ac4c, 0x300cddb6, 0x2a466423,
  0x3008b6fe, 0x2a4b1b91, 0x30048fd0, 0x2a4fd297,
  0x3000682b, 0x2a548935, 0x2ffc4010, 0x2a593f6a,
  0x2ff8177f, 0x2a5df536, 0x2ff3ee77, 0x2a62aa9a,
  0x2fefc4f9, 0x2a675f96, 0x2feb9b04, 0x2a6c1429,
  0x2fe7709a, 0x2a70c853, 0x2fe345b9, 0x2a757c15,
  0x2fdf1a62, 0x2a7a2f6d, 0x2fdaee95, 0x2a7ee25d,
  0x2fd6c252, 0x2a8394e4, 0x2fd29598, 0x2a884702,
  0x2fce6869, 0x2a8cf8b8, 0x2fca3ac4, 0x2a91aa04,
  0x2fc60ca9, 0x2a965ae7, 0x2fc1de18, 0x2a9b0b61,
  0x2fbdaf11, 0x2a9fbb72, 0x2fb97f94, 0x2aa46b1a,
  0x2fb54fa2, 0x2aa91a59, 0x2fb11f3a, 0x2aadc92e,
  0x2facee5c, 0x2ab2779a, 0x2fa8bd09, 0x2ab7259d,
  0x2fa48b40, 0x2abbd336, 0x2fa05901, 0x2ac08066,
  0x2f9c264d, 0x2ac52d2c, 0x2f97f323, 0x2ac9d989,
  0x2f93bf84, 0x2ace857c, 0x2f8f8b70, 0x2ad33106,
  0x2f8b56e6, 0x2ad7dc26, 0x2f8721e7, 0x2adc86dc,
  0x2f82ec73, 0x2ae13129, 0x2f7eb689, 0x2ae5db0b,
  0x2f7a802b, 0x2aea8484, 0x2f764957, 0x2aef2d93,
  0x2f72120e, 0x2af3d638, 0x2f6dda50, 0x2af87e73,
  0x2f69a21d, 0x2afd2644, 0x2f656975, 0x2b01cdab,
  0x2f613058, 0x2b0674a8, 0x2f5cf6c6, 0x2b0b1b3b,
  0x2f58bcbf, 0x2b0fc163, 0x2f548243, 0x2b146722,
  0x2f504753, 0x2b190c75, 0x2f4c0bee, 0x2b1db15f,
  0x2f47d014, 0x2b2255de, 0x2f4393c6, 0x2b26f9f3,
  0x2f3f5702, 0x2b2b9d9d, 0x2f3b19cb, 0x2b3040dd,
  0x2f36dc1f, 0x2b34e3b2, 0x2f329dfe, 0x2b39861d,
  0x2f2e5f69, 0x2b3e281d, 0x2f2a205f, 0x2b42c9b2,
  0x2f25e0e1, 0x2b476add, 0x2f21a0ef, 0x2b4c0b9c,
  0x2f1d6088, 0x2b50abf1, 0x2f191fad, 0x2b554bdb,
  0x2f14de5e, 0x2b59eb5a, 0x2f109c9b, 0x2b5e8a6f,
  0x2f0c5a64, 0x2b632918, 0x2f0817b8, 0x2b67c756,
  0x2f03d499, 0x2b6c6529, 0x2eff9105, 0x2b710291,
  0x2efb4cfe, 0x2b759f8d, 0x2ef70883, 0x2b7a3c1f,
  0x2ef2c393, 0x2b7ed845, 0x2eee7e30, 0x2b837400,
  0x2eea3859, 0x2b880f4f, 0x2ee5f20f, 0x2b8caa33,
  0x2ee1ab50, 0x2b9144ac, 0x2edd641e, 0x2b95deb9,
  0x2ed91c79, 0x2b9a785a, 0x2ed4d45f, 0x2b9f1190,
  0x2ed08bd3, 0x2ba3aa5b, 0x2ecc42d2, 0x2ba842b9,
  0x2ec7f95e, 0x2bacdaac, 0x2ec3af77, 0x2bb17233,
  0x2ebf651d, 0x2bb6094f, 0x2ebb1a4f, 0x2bba9ffe,
  0x2eb6cf0d, 0x2bbf3642, 0x2eb28359, 0x2bc3cc19,
  0x2eae3731, 0x2bc86185, 0x2ea9ea96, 0x2bccf685,
  0x2ea59d88, 0x2bd18b18, 0x2ea15007, 0x2bd61f40,
  0x2e9d0213, 0x2bdab2fb, 0x2e98b3ac, 0x2bdf464a,
  0x2e9464d1, 0x2be3d92d, 0x2e901584, 0x2be86ba4,
  0x2e8bc5c4, 0x2becfdae, 0x2e877591, 0x2bf18f4c,
  0x2e8324ec, 0x2bf6207d, 0x2e7ed3d3, 0x2bfab142,
  0x2e7a8248, 0x2bff419a, 0x2e76304a, 0x2c03d186,
  0x2e71ddda, 0x2c086106, 0x2e6d8af7, 0x2c0cf018,
  0x2e6937a1, 0x2c117ebe, 0x2e64e3d9, 0x2c160cf7,
  0x2e608f9e, 0x2c1a9ac4, 0x2e5c3af1, 0x2c1f2823,
  0x2e57e5d2, 0x2c23b516, 0x2e539040, 0x2c28419c,
  0x2e4f3a3c, 0x2c2ccdb5, 0x2e4ae3c6, 0x2c315961,
  0x2e468cdd, 0x2c35e49f, 0x2e423582, 0x2c3a6f71,
  0x2e3dddb5, 0x2c3ef9d6, 0x2e398576, 0x2c4383cd,
  0x2e352cc5, 0x2c480d57, 0x2e30d3a2, 0x2c4c9674,
  0x2e2c7a0d, 0x2c511f24, 0x2e282006, 0x2c55a766,
  0x2e23c58d, 0x2c5a2f3b, 0x2e1f6aa3, 0x2c5eb6a3,
  0x2e1b0f46, 0x2c633d9d, 0x2e16b378, 0x2c67c429,
  0x2e125738, 0x2c6c4a48, 0x2e0dfa86, 0x2c70cff9,
  0x2e099d63, 0x2c75553d, 0x2e053fce, 0x2c79da13,
  0x2e00e1c8, 0x2c7e5e7b, 0x2dfc8350, 0x2c82e276,
  0x2df82466, 0x2c876602, 0x2df3c50c, 0x2c8be921,
  0x2def653f, 0x2c906bd2, 0x2deb0502, 0x2c94ee15,
  0x2de6a453, 0x2c996fe9, 0x2de24333, 0x2c9df150,
  0x2ddde1a1, 0x2ca27249, 0x2dd97f9f, 0x2ca6f2d4,
  0x2dd51d2b, 0x2cab72f0, 0x2dd0ba47, 0x2caff29e,
  0x2dcc56f1, 0x2cb471de, 0x2dc7f32a, 0x2cb8f0b0,
  0x2dc38ef2, 0x2cbd6f13, 0x2dbf2a4a, 0x2cc1ed08,
  0x2dbac530, 0x2cc66a8e, 0x2db65fa6, 0x2ccae7a6,
  0x2db1f9ab, 0x2ccf6450, 0x2dad933f, 0x2cd3e08b,
  0x2da92c62, 0x2cd85c57, 0x2da4c515, 0x2cdcd7b5,
  0x2da05d57, 0x2ce152a4, 0x2d9bf529, 0x2ce5cd24,
  0x2d978c8a, 0x2cea4735, 0x2d93237a, 0x2ceec0d8,
  0x2d8eb9fa, 0x2cf33a0c, 0x2d8a500a, 0x2cf7b2d0,
  0x2d85e5a9, 0x2cfc2b26, 0x2d817ad8, 0x2d00a30d,
  0x2d7d0f97, 0x2d051a85, 0x2d78a3e5, 0x2d09918e,
  0x2d7437c3, 0x2d0e0827, 0x2d6fcb32, 0x2d127e52,
  0x2d6b5e30, 0x2d16f40d, 0x2d66f0bd, 0x2d1b6959,
  0x2d6282db, 0x2d1fde36, 0x2d5e1489, 0x2d2452a3,
  0x2d59a5c7, 0x2d28c6a1, 0x2d553695, 0x2d2d3a30,
  0x2d50c6f3, 0x2d31ad4f, 0x2d4c56e2, 0x2d361ffe,
  0x2d47e661, 0x2d3a923e, 0x2d43756f, 0x2d3f040f,
  0x1fffff62, 0xfff9b781, 0x1ffffa73, 0xffed2685,
  0x1ffff094, 0xffe0958b, 0x1fffe1c6, 0xffd40496,
  0x1fffce09, 0xffc773a8, 0x1fffb55d, 0xffbae2c3,
  0x1fff97c1, 0xffae51e8, 0x1fff7536, 0xffa1c11a,
  0x1fff4dbc, 0xff95305a, 0x1fff2152, 0xff889fab,
  0x1ffeeffa, 0xff7c0f0e, 0x1ffeb9b2, 0xff6f7e86,
  0x1ffe7e7b, 0xff62ee14, 0x1ffe3e55, 0xff565dba,
  0x1ffdf940, 0xff49cd7a, 0x1ffdaf3c, 0xff3d3d57,
  0x1ffd6049, 0xff30ad51, 0x1ffd0c67, 0xff241d6c,
  0x1ffcb397, 0xff178da8, 0x1ffc55d7, 0xff0afe08,
  0x1ffbf329, 0xfefe6e8e, 0x1ffb8b8c, 0xfef1df3c,
  0x1ffb1f01, 0xfee55013, 0x1ffaad86, 0xfed8c116,
  0x1ffa371e, 0xfecc3247, 0x1ff9bbc7, 0xfebfa3a7,
  0x1ff93b82, 0xfeb31538, 0x1ff8b64e, 0xfea686fd,
  0x1ff82c2c, 0xfe99f8f7, 0x1ff79d1c, 0xfe8d6b28,
  0x1ff7091e, 0xfe80dd92, 0x1ff67033, 0xfe745037,
  0x1ff5d259, 0xfe67c31a, 0x1ff52f92, 0xfe5b363b,
  0x1ff487dc, 0xfe4ea99e, 0x1ff3db3a, 0xfe421d43,
  0x1ff329aa, 0xfe35912c, 0x1ff2732d, 0xfe29055d,
  0x1ff1b7c2, 0xfe1c79d6, 0x1ff0f76a, 0xfe0fee9a,
  0x1ff03226, 0xfe0363aa, 0x1fef67f4, 0xfdf6d909,
  0x1fee98d6, 0xfdea4eb8, 0x1fedc4cb, 0xfdddc4b9,
  0x1fecebd3, 0xfdd13b0f, 0x1fec0df0, 0xfdc4b1bb,
  0x1feb2b20, 0xfdb828be, 0x1fea4364, 0xfdaba01c,
  0x1fe956bb, 0xfd9f17d6, 0x1fe86528, 0xfd928fee,
  0x1fe76ea8, 0xfd860866, 0x1fe6733d, 0xfd79813f,
  0x1fe572e7, 0xfd6cfa7c, 0x1fe46da5, 0xfd60741f,
  0x1fe36378, 0xfd53ee29, 0x1fe25461, 0xfd47689d,
  0x1fe1405e, 0xfd3ae37c, 0x1fe02771, 0xfd2e5ec8,
  0x1fdf099a, 0xfd21da84, 0x1fdde6d8, 0xfd1556b1,
  0x1fdcbf2d, 0xfd08d351, 0x1fdb9297, 0xfcfc5067,
  0x1fda6118, 0xfcefcdf3, 0x1fd92ab0, 0xfce34bf8,
  0x1fd7ef5e, 0xfcd6ca78, 0x1fd6af23, 0xfcca4975,
  0x1fd569ff, 0xfcbdc8f0, 0x1fd41ff2, 0xfcb148ed,
  0x1fd2d0fc, 0xfca4c96b, 0x1fd17d1f, 0xfc984a6f,
  0x1fd02459, 0xfc8bcbf8, 0x1fcec6ab, 0xfc7f4e0a,
  0x1fcd6416, 0xfc72d0a7, 0x1fcbfc99, 0xfc6653cf,
  0x1fca9035, 0xfc59d786, 0x1fc91ee9, 0xfc4d5bcd,
  0x1fc7a8b7, 0xfc40e0a5, 0x1fc62d9e, 0xfc346612,
  0x1fc4ad9f, 0xfc27ec14, 0x1fc328ba, 0xfc1b72af,
  0x1fc19eef, 0xfc0ef9e2, 0x1fc0103e, 0xfc0281b2,
  0x1fbe7ca7, 0xfbf60a1f, 0x1fbce42c, 0xfbe9932b,
  0x1fbb46cb, 0xfbdd1cd9, 0x1fb9a486, 0xfbd0a72a,
  0x1fb7fd5c, 0xfbc43221, 0x1fb6514e, 0xfbb7bdbe,
  0x1fb4a05c, 0xfbab4a05, 0x1fb2ea87, 0xfb9ed6f6,
  0x1fb12fce, 0xfb926495, 0x1faf7031, 0xfb85f2e2,
  0x1fadabb2, 0xfb7981e0, 0x1fabe251, 0xfb6d1191,
  0x1faa140d, 0xfb60a1f6, 0x1fa840e7, 0xfb543311,
  0x1fa668df, 0xfb47c4e6, 0x1fa48bf6, 0xfb3b5774,
  0x1fa2aa2b, 0xfb2eeabf, 0x1fa0c380, 0xfb227ec7,
  0x1f9ed7f4, 0xfb161390, 0x1f9ce787, 0xfb09a91b,
  0x1f9af23b, 0xfafd3f6a, 0x1f98f80f, 0xfaf0d67f,
  0x1f96f903, 0xfae46e5b, 0x1f94f518, 0xfad80701,
  0x1f92ec4f, 0xfacba072, 0x1f90dea7, 0xfabf3ab1,
  0x1f8ecc21, 0xfab2d5c0, 0x1f8cb4bd, 0xfaa671a0,
  0x1f8a987b, 0xfa9a0e52, 0x1f88775d, 0xfa8dabda,
  0x1f865161, 0xfa814a39, 0x1f842689, 0xfa74e971,
  0x1f81f6d5, 0xfa688984, 0x1f7fc244, 0xfa5c2a74,
  0x1f7d88d9, 0xfa4fcc42, 0x1f7b4a92, 0xfa436ef1,
  0x1f790770, 0xfa371282, 0x1f76bf74, 0xfa2ab6f7,
  0x1f74729d, 0xfa1e5c53, 0x1f7220ed, 0xfa120297,
  0x1f6fca63, 0xfa05a9c6, 0x1f6d6f01, 0xf9f951e0,
  0x1f6b0ec5, 0xf9ecfae8, 0x1f68a9b1, 0xf9e0a4e0,
  0x1f663fc6, 0xf9d44fc9, 0x1f63d102, 0xf9c7fba6,
  0x1f615d68, 0xf9bba879, 0x1f5ee4f6, 0xf9af5643,
  0x1f5c67af, 0xf9a30507, 0x1f59e591, 0xf996b4c5,
  0x1f575e9d, 0xf98a6581, 0x1f54d2d4, 0xf97e173c,
  0x1f524236, 0xf971c9f7, 0x1f4facc4, 0xf9657db6,
  0x1f4d127d, 0xf9593279, 0x1f4a7363, 0xf94ce843,
  0x1f47cf76, 0xf9409f15, 0x1f4526b5, 0xf93456f1,
  0x1f427922, 0xf9280fda, 0x1f3fc6bd, 0xf91bc9d1,
  0x1f3d0f87, 0xf90f84d8, 0x1f3a537f, 0xf90340f2,
  0x1f3792a6, 0xf8f6fe1e, 0x1f34ccfd, 0xf8eabc61,
  0x1f320284, 0xf8de7bbb, 0x1f2f333b, 0xf8d23c2f,
  0x1f2c5f23, 0xf8c5fdbe, 0x1f29863d, 0xf8b9c06b,
  0x1f26a888, 0xf8ad8437, 0x1f23c606, 0xf8a14923,
  0x1f20deb6, 0xf8950f33, 0x1f1df299, 0xf888d668,
  0x1f1b01b0, 0xf87c9ec3, 0x1f180bfb, 0xf8706847,
  0x1f15117a, 0xf86432f5, 0x1f12122e, 0xf857fed0,
  0x1f0f0e18, 0xf84bcbd9, 0x1f0c0538, 0xf83f9a12,
  0x1f08f78d, 0xf833697d, 0x1f05e51a, 0xf8273a1c,
  0x1f02cdde, 0xf81b0bf1, 0x1effb1d9, 0xf80edefe,
  0x1efc910d, 0xf802b344, 0x1ef96b79, 0xf7f688c5,
  0x1ef6411f, 0xf7ea5f84, 0x1ef311fe, 0xf7de3782,
  0x1eefde18, 0xf7d210c1, 0x1eeca56c, 0xf7c5eb42,
  0x1ee967fb, 0xf7b9c709, 0x1ee625c6, 0xf7ada416,
  0x1ee2decd, 0xf7a1826c, 0x1edf9311, 0xf795620c,
  0x1edc4292, 0xf78942f9, 0x1ed8ed51, 0xf77d2533,
  0x1ed5934e, 0xf77108be, 0x1ed23489, 0xf764ed9b,
  0x1eced104, 0xf758d3cb, 0x1ecb68be, 0xf74cbb51,
  0x1ec7fbb9, 0xf740a42e, 0x1ec489f5, 0xf7348e65,
  0x1ec11372, 0xf72879f6, 0x1ebd9831, 0xf71c66e5,
  0x1eba1832, 0xf7105533, 0x1eb69376, 0xf70444e2,
  0x1eb309fe, 0xf6f835f3, 0x1eaf7bc9, 0xf6ec2869,
  0x1eabe8da, 0xf6e01c45, 0x1ea8512f, 0xf6d41189,
  0x1ea4b4ca, 0xf6c80838, 0x1ea113ac, 0xf6bc0052,
  0x1e9d6dd4, 0xf6aff9db, 0x1e99c343, 0xf6a3f4d2,
  0x1e9613fb, 0xf697f13c, 0x1e925ffb, 0xf68bef18,
  0x1e8ea744, 0xf67fee6a, 0x1e8ae9d7, 0xf673ef33,
  0x1e8727b3, 0xf667f175, 0x1e8360db, 0xf65bf532,
  0x1e7f954e, 0xf64ffa6b, 0x1e7bc50d, 0xf6440123,
  0x1e77f019, 0xf638095a, 0x1e741672, 0xf62c1315,
  0x1e703818, 0xf6201e53, 0x1e6c550d, 0xf6142b17,
  0x1e686d51, 0xf6083962, 0x1e6480e5, 0xf5fc4937,
  0x1e608fc8, 0xf5f05a98, 0x1e5c99fc, 0xf5e46d85,
  0x1e589f82, 0xf5d88202, 0x1e54a05a, 0xf5cc9810,
  0x1e509c84, 0xf5c0afb0, 0x1e4c9401, 0xf5b4c8e5,
  0x1e4886d3, 0xf5a8e3b0, 0x1e4474f8, 0xf59d0013,
  0x1e405e73, 0xf5911e11, 0x1e3c4344, 0xf5853daa,
  0x1e38236b, 0xf5795ee1, 0x1e33fee9, 0xf56d81b8,
  0x1e2fd5be, 0xf561a630, 0x1e2ba7ec, 0xf555cc4b,
  0x1e277573, 0xf549f40b, 0x1e233e53, 0xf53e1d72,
  0x1e1f028e, 0xf5324882, 0x1e1ac223, 0xf526753d,
  0x1e167d14, 0xf51aa3a3, 0x1e123361, 0xf50ed3b8,
  0x1e0de50b, 0xf503057d, 0x1e099212, 0xf4f738f3,
  0x1e053a78, 0xf4eb6e1d, 0x1e00de3c, 0xf4dfa4fd,
  0x1dfc7d60, 0xf4d3dd94, 0x1df817e4, 0xf4c817e4,
  0x1df3adc9, 0xf4bc53ef, 0x1def3f10, 0xf4b091b6,
  0x1deacbb9, 0xf4a4d13c, 0x1de653c4, 0xf4991282,
  0x1de1d734, 0xf48d558b, 0x1ddd5607, 0xf4819a57,
  0x1dd8d040, 0xf475e0e9, 0x1dd445de, 0xf46a2943,
  0x1dcfb6e3, 0xf45e7366, 0x1dcb234e, 0xf452bf55,
  0x1dc68b22, 0xf4470d10, 0x1dc1ee5e, 0xf43b5c9a,
  0x1dbd4d03, 0xf42fadf4, 0x1db8a713, 0xf4240121,
  0x1db3fc8d, 0xf4185623, 0x1daf4d72, 0xf40cacfa,
  0x1daa99c3, 0xf40105a9, 0x1da5e181, 0xf3f56031,
  0x1da124ad, 0xf3e9bc95, 0x1d9c6347, 0xf3de1ad6,
  0x1d979d50, 0xf3d27af7, 0x1d92d2c9, 0xf3c6dcf7,
  0x1d8e03b2, 0xf3bb40db, 0x1d89300c, 0xf3afa6a3,
  0x1d8457d9, 0xf3a40e50, 0x1d7f7b18, 0xf39877e6,
  0x1d7a99cb, 0xf38ce366, 0x1d75b3f1, 0xf38150d1,
  0x1d70c98d, 0xf375c029, 0x1d6bda9f, 0xf36a3170,
  0x1d66e727, 0xf35ea4a8, 0x1d61ef26, 0xf35319d3,
  0x1d5cf29d, 0xf34790f2, 0x1d57f18d, 0xf33c0a08,
  0x1d52ebf7, 0xf3308515, 0x1d4de1db, 0xf325021c,
  0x1d48d33a, 0xf319811f, 0x1d43c015, 0xf30e021f,
  0x1d3ea86d, 0xf302851e, 0x1d398c42, 0xf2f70a1d,
  0x1d346b95, 0xf2eb9120, 0x1d2f4668, 0xf2e01a27,
  0x1d2a1cba, 0xf2d4a533, 0x1d24ee8d, 0xf2c93248,
  0x1d1fbbe1, 0xf2bdc167, 0x1d1a84b8, 0xf2b25291,
  0x1d154911, 0xf2a6e5c8, 0x1d1008ef, 0xf29b7b0e,
  0x1d0ac451, 0xf2901264, 0x1d057b39, 0xf284abce,
  0x1d002da6, 0xf279474b, 0x1cfadb9b, 0xf26de4df,
  0x1cf58518, 0xf262848a, 0x1cf02a1e, 0xf257264f,
  0x1ceacaad, 0xf24bca2f, 0x1ce566c7, 0xf240702c,
  0x1cdffe6b, 0xf2351847, 0x1cda919c, 0xf229c284,
  0x1cd5205a, 0xf21e6ee2, 0x1ccfaaa6, 0xf2131d65,
  0x1cca3080, 0xf207ce0d, 0x1cc4b1e9, 0xf1fc80dd,
  0x1cbf2ee3, 0xf1f135d6, 0x1cb9a76e, 0xf1e5ecfa,
  0x1cb41b8b, 0xf1daa64a, 0x1cae8b3a, 0xf1cf61ca,
  0x1ca8f67e, 0xf1c41f79, 0x1ca35d56, 0xf1b8df5a,
  0x1c9dbfc3, 0xf1ada16f, 0x1c981dc7, 0xf1a265ba,
  0x1c927762, 0xf1972c3b, 0x1c8ccc94, 0xf18bf4f6,
  0x1c871d60, 0xf180bfea, 0x1c8169c5, 0xf1758d1c,
  0x1c7bb1c6, 0xf16a5c8b, 0x1c75f561, 0xf15f2e3a,
  0x1c703499, 0xf154022b, 0x1c6a6f6f, 0xf148d85f,
  0x1c64a5e2, 0xf13db0d7, 0x1c5ed7f5, 0xf1328b97,
  0x1c5905a7, 0xf127689f, 0x1c532efb, 0xf11c47f0,
  0x1c4d53f0, 0xf111298e, 0x1c477488, 0xf1060d79,
  0x1c4190c4, 0xf0faf3b4, 0x1c3ba8a4, 0xf0efdc3f,
  0x1c35bc29, 0xf0e4c71d, 0x1c2fcb55, 0xf0d9b450,
  0x1c29d628, 0xf0cea3d9, 0x1c23dca3, 0xf0c395b9,
  0x1c1ddec7, 0xf0b889f3, 0x1c17dc95, 0xf0ad8088,
  0x1c11d60e, 0xf0a2797a, 0x1c0bcb33, 0xf09774ca,
  0x1c05bc05, 0xf08c727b, 0x1bffa884, 0xf081728e,
  0x1bf990b3, 0xf0767504, 0x1bf37490, 0xf06b79e0,
  0x1bed541f, 0xf0608123, 0x1be72f5e, 0xf0558acf,
  0x1be10651, 0xf04a96e5, 0x1bdad8f6, 0xf03fa568,
  0x1bd4a750, 0xf034b658, 0x1bce715f, 0xf029c9b8,
  0x1bc83725, 0xf01edf89, 0x1bc1f8a1, 0xf013f7cd,
  0x1bbbb5d6, 0xf0091285, 0x1bb56ec4, 0xeffe2fb4,
  0x1baf236c, 0xeff34f5a, 0x1ba8d3cf, 0xefe8717a,
  0x1ba27fee, 0xefdd9616, 0x1b9c27cb, 0xefd2bd2e,
  0x1b95cb65, 0xefc7e6c6, 0x1b8f6abe, 0xefbd12dd,
  0x1b8905d7, 0xefb24176, 0x1b829cb1, 0xefa77293,
  0x1b7c2f4d, 0xef9ca636, 0x1b75bdac, 0xef91dc5f,
  0x1b6f47cf, 0xef871511, 0x1b68cdb7, 0xef7c504d,
  0x1b624f65, 0xef718e16, 0x1b5bccd9, 0xef66ce6b,
  0x1b554616, 0xef5c1150, 0x1b4ebb1b, 0xef5156c7,
  0x1b482beb, 0xef469ecf, 0x1b419885, 0xef3be96c,
  0x1b3b00ec, 0xef31369f, 0x1b34651f, 0xef268669,
  0x1b2dc520, 0xef1bd8cd, 0x1b2720f1, 0xef112dcb,
  0x1b207891, 0xef068566, 0x1b19cc03, 0xeefbdf9f,
  0x1b131b46, 0xeef13c78, 0x1b0c665d, 0xeee69bf2,
  0x1b05ad48, 0xeedbfe0f, 0x1afef008, 0xeed162d1,
  0x1af82e9f, 0xeec6ca39, 0x1af1690c, 0xeebc3449,
  0x1aea9f52, 0xeeb1a103, 0x1ae3d172, 0xeea71068,
  0x1adcff6c, 0xee9c827a, 0x1ad62941, 0xee91f73a,
  0x1acf4ef3, 0xee876eaa, 0x1ac87082, 0xee7ce8cd,
  0x1ac18df0, 0xee7265a2, 0x1abaa73e, 0xee67e52c,
  0x1ab3bc6d, 0xee5d676d, 0x1aaccd7d, 0xee52ec67,
  0x1aa5da70, 0xee48741a, 0x1a9ee348, 0xee3dfe88,
  0x1a97e804, 0xee338bb4, 0x1a90e8a6, 0xee291b9e,
  0x1a89e530, 0xee1eae49, 0x1a82dda2, 0xee1443b5,
  0x1a7bd1fe, 0xee09dbe5, 0x1a74c243, 0xedff76da,
  0x1a6dae75, 0xedf51495, 0x1a669693, 0xedeab519,
  0x1a5f7a9f, 0xede05867, 0x1a585a99, 0xedd5fe80,
  0x1a513684, 0xedcba767, 0x1a4a0e60, 0xedc1531c,
  0x1a42e22d, 0xedb701a1, 0x1a3bb1ee, 0xedacb2f8,
  0x1a347da4, 0xeda26723, 0x1a2d454e, 0xed981e23,
  0x1a2608f0, 0xed8dd7f9, 0x1a1ec889, 0xed8394a8,
  0x1a17841b, 0xed795430, 0x1a103ba7, 0xed6f1694,
  0x1a08ef2e, 0xed64dbd5, 0x1a019eb1, 0xed5aa3f4,
  0x19fa4a31, 0xed506ef3, 0x19f2f1b0, 0xed463cd4,
  0x19eb952e, 0xed3c0d99, 0x19e434ae, 0xed31e142,
  0x19dcd02e, 0xed27b7d1, 0x19d567b2, 0xed1d9149,
  0x19cdfb3b, 0xed136daa, 0x19c68ac8, 0xed094cf6,
  0x19bf165c, 0xecff2f2f, 0x19b79df7, 0xecf51456,
  0x19b0219b, 0xeceafc6d, 0x19a8a149, 0xece0e775,
  0x19a11d02, 0xecd6d570, 0x199994c7, 0xecccc65f,
  0x1992089a, 0xecc2ba45, 0x198a787b, 0xecb8b121,
  0x1982e46c, 0xecaeaaf7, 0x197b4c6d, 0xeca4a7c8,
  0x1973b081, 0xec9aa795, 0x196c10a8, 0xec90aa60,
  0x19646ce3, 0xec86b029, 0x195cc534, 0xec7cb8f4,
  0x1955199b, 0xec72c4c1, 0x194d6a1b, 0xec68d392,
  0x1945b6b3, 0xec5ee568, 0x193dff66, 0xec54fa45,
  0x19364434, 0xec4b122b, 0x192e851f, 0xec412d1a,
  0x1926c228, 0xec374b16, 0x191efb50, 0xec2d6c1e,
  0x19173098, 0xec239035, 0x190f6202, 0xec19b75b,
  0x19078f8e, 0xec0fe194, 0x18ffb93e, 0xec060edf,
  0x18f7df13, 0xebfc3f3f, 0x18f0010f, 0xebf272b6,
  0x18e81f32, 0xebe8a944, 0x18e0397e, 0xebdee2eb,
  0x18d84ff3, 0xebd51fad, 0x18d06294, 0xebcb5f8b,
  0x18c87161, 0xebc1a286, 0x18c07c5c, 0xebb7e8a1,
  0x18b88386, 0xebae31dd, 0x18b086e0, 0xeba47e3b,
  0x18a8866b, 0xeb9acdbc, 0x18a08228, 0xeb912063,
  0x18987a1a, 0xeb877630, 0x18906e40, 0xeb7dcf25,
  0x18885e9c, 0xeb742b44, 0x18804b30, 0xeb6a8a8f,
  0x187833fd, 0xeb60ed05, 0x18701904, 0xeb5752aa,
  0x1867fa46, 0xeb4dbb7f, 0x185fd7c5, 0xeb442784,
  0x1857b181, 0xeb3a96bd, 0x184f877c, 0xeb310929,
  0x184759b8, 0xeb277eca, 0x183f2835, 0xeb1df7a3,
  0x1836f2f4, 0xeb1473b4, 0x182eb9f8, 0xeb0af2ff,
  0x18267d41, 0xeb017585, 0x181e3cd1, 0xeaf7fb48,
  0x1815f8a9, 0xeaee8449, 0x180db0c9, 0xeae5108a,
  0x18056534, 0xeadba00d, 0x17fd15eb, 0xead232d1,
  0x17f4c2ef, 0xeac8c8da, 0x17ec6c41, 0xeabf6229,
  0x17e411e2, 0xeab5febf, 0x17dbb3d5, 0xeaac9e9d,
  0x17d35219, 0xeaa341c5, 0x17caecb1, 0xea99e838,
  0x17c2839e, 0xea9091f8, 0x17ba16e0, 0xea873f06,
  0x17b1a67a, 0xea7def65, 0x17a9326d, 0xea74a314,
  0x17a0bab9, 0xea6b5a15, 0x17983f61, 0xea62146b,
  0x178fc065, 0xea58d216, 0x17873dc7, 0xea4f9318,
  0x177eb788, 0xea465772, 0x17762daa, 0xea3d1f26,
  0x176da02d, 0xea33ea35, 0x17650f13, 0xea2ab8a0,
  0x175c7a5e, 0xea218a69, 0x1753e20f, 0xea185f92,
  0x174b4626, 0xea0f381b, 0x1742a6a6, 0xea061407,
  0x173a0390, 0xe9fcf356, 0x17315ce5, 0xe9f3d60a,
  0x1728b2a6, 0xe9eabc25, 0x172004d5, 0xe9e1a5a8,
  0x17175373, 0xe9d89293, 0x170e9e81, 0xe9cf82e9,
  0x1705e601, 0xe9c676ac, 0x16fd29f5, 0xe9bd6ddb,
  0x16f46a5c, 0xe9b4687a, 0x16eba73a, 0xe9ab6688,
  0x16e2e08e, 0xe9a26808, 0x16da165b, 0xe9996cfc,
  0x16d148a2, 0xe9907563, 0x16c87764, 0xe9878140,
  0x16bfa2a3, 0xe97e9095, 0x16b6ca5f, 0xe975a361,
  0x16adee9b, 0xe96cb9a8, 0x16a50f58, 0xe963d36a,
  0x169c2c96, 0xe95af0a8, 0x16934658, 0xe9521165,
  0x168a5c9f, 0xe94935a1, 0x16816f6b, 0xe9405d5d,
  0x16787ec0, 0xe937889c, 0x166f8a9d, 0xe92eb75e,
  0x16669304, 0xe925e9a5, 0x165d97f8, 0xe91d1f72,
  0x16549978, 0xe91458c6, 0x164b9786, 0xe90b95a4,
  0x16429225, 0xe902d60b, 0x16398954, 0xe8fa19ff,
  0x16307d17, 0xe8f1617f, 0x16276d6d, 0xe8e8ac8d,
  0x161e5a58, 0xe8dffb2b, 0x161543db, 0xe8d74d5a,
  0x160c29f6, 0xe8cea31b, 0x16030caa, 0xe8c5fc70,
  0x15f9ebf9, 0xe8bd595a, 0x15f0c7e5, 0xe8b4b9da,
  0x15e7a06e, 0xe8ac1df1, 0x15de7597, 0xe8a385a2,
  0x15d54760, 0xe89af0ed, 0x15cc15cb, 0xe8925fd3,
  0x15c2e0da, 0xe889d256, 0x15b9a88e, 0xe8814878,
  0x15b06ce8, 0xe878c239, 0x15a72dea, 0xe8703f9b,
  0x159deb95, 0xe867c09f, 0x1594a5eb, 0xe85f4547,
  0x158b5cec, 0xe856cd93, 0x1582109b, 0xe84e5986,
  0x1578c0fa, 0xe845e920, 0x156f6e08, 0xe83d7c62,
  0x156617c8, 0xe835134f, 0x155cbe3b, 0xe82cade7,
  0x15536163, 0xe8244c2b, 0x154a0141, 0xe81bee1e,
  0x15409dd7, 0xe81393bf, 0x15373726, 0xe80b3d11,
  0x152dcd2f, 0xe802ea15, 0x15245ff3, 0xe7fa9acc,
  0x151aef76, 0xe7f24f37, 0x15117bb7, 0xe7ea0757,
  0x150804b8, 0xe7e1c32f, 0x14fe8a7b, 0xe7d982bf,
  0x14f50d01, 0xe7d14608, 0x14eb8c4c, 0xe7c90d0c,
  0x14e2085d, 0xe7c0d7cb, 0x14d88136, 0xe7b8a648,
  0x14cef6d7, 0xe7b07884, 0x14c56943, 0xe7a84e7f,
  0x14bbd87c, 0xe7a0283b, 0x14b24481, 0xe79805ba,
  0x14a8ad56, 0xe78fe6fc, 0x149f12fb, 0xe787cc03,
  0x14957571, 0xe77fb4d0, 0x148bd4bc, 0xe777a164,
  0x148230db, 0xe76f91c0, 0x147889d0, 0xe76785e6,
  0x146edf9d, 0xe75f7dd8, 0x14653244, 0xe7577995,
  0x145b81c5, 0xe74f7920, 0x1451ce23, 0xe7477c7a,
  0x1448175f, 0xe73f83a4, 0x143e5d7a, 0xe7378e9f,
  0x1434a075, 0xe72f9d6c, 0x142ae053, 0xe727b00d,
  0x14211d15, 0xe71fc682, 0x141756bc, 0xe717e0ce,
  0x140d8d4a, 0xe70ffef1, 0x1403c0c1, 0xe70820ed,
  0x13f9f121, 0xe70046c2, 0x13f01e6c, 0xe6f87072,
  0x13e648a5, 0xe6f09dfe, 0x13dc6fcb, 0xe6e8cf68,
  0x13d293e2, 0xe6e104b0, 0x13c8b4ea, 0xe6d93dd8,
  0x13bed2e6, 0xe6d17ae1, 0x13b4edd5, 0xe6c9bbcc,
  0x13ab05bb, 0xe6c2009a, 0x13a11a98, 0xe6ba494d,
  0x13972c6e, 0xe6b295e5, 0x138d3b3f, 0xe6aae665,
  0x1383470c, 0xe6a33acc, 0x13794fd7, 0xe69b931d,
  0x136f55a0, 0xe693ef58, 0x1365586b, 0xe68c4f7f,
  0x135b5838, 0xe684b393, 0x13515509, 0xe67d1b94,
  0x13474edf, 0xe6758785, 0x133d45bb, 0xe66df766,
  0x133339a1, 0xe6666b39, 0x13292a90, 0xe65ee2fe,
  0x131f188b, 0xe6575eb7, 0x13150393, 0xe64fde65,
  0x130aebaa, 0xe6486209, 0x1300d0d1, 0xe640e9a4,
  0x12f6b30a, 0xe6397538, 0x12ec9256, 0xe63204c5,
  0x12e26eb7, 0xe62a984e, 0x12d8482f, 0xe6232fd2,
  0x12ce1ebe, 0xe61bcb52, 0x12c3f267, 0xe6146ad2,
  0x12b9c32c, 0xe60d0e50, 0x12af910d, 0xe605b5cf,
  0x12a55c0c, 0xe5fe614f, 0x129b242b, 0xe5f710d2,
  0x1290e96c, 0xe5efc459, 0x1286abd0, 0xe5e87be5,
  0x127c6b58, 0xe5e13777, 0x12722807, 0xe5d9f710,
  0x1267e1dd, 0xe5d2bab2, 0x125d98dd, 0xe5cb825c,
  0x12534d08, 0xe5c44e12, 0x1248fe5f, 0xe5bd1dd3,
  0x123eace4, 0xe5b5f1a0, 0x12345899, 0xe5aec97c,
  0x122a0180, 0xe5a7a567, 0x121fa799, 0xe5a08561,
  0x12154ae7, 0xe599696d, 0x120aeb6b, 0xe592518b,
  0x12008926, 0xe58b3dbd, 0x11f6241b, 0xe5842e02,
  0x11ebbc4b, 0xe57d225e, 0x11e151b7, 0xe5761ad0,
  0x11d6e462, 0xe56f175a, 0x11cc744c, 0xe56817fc,
  0x11c20178, 0xe5611cb8, 0x11b78be6, 0xe55a2590,
  0x11ad1399, 0xe5533283, 0x11a29893, 0xe54c4393,
  0x11981ad4, 0xe54558c2, 0x118d9a5e, 0xe53e7210,
  0x11831733, 0xe5378f7e, 0x11789156, 0xe530b10d,
  0x116e08c6, 0xe529d6bf, 0x11637d86, 0xe5230094,
  0x1158ef98, 0xe51c2e8e, 0x114e5efd, 0xe51560ae,
  0x1143cbb7, 0xe50e96f4, 0x113935c7, 0xe507d161,
  0x112e9d2f, 0xe5010ff8, 0x112401f1, 0xe4fa52b8,
  0x1119640e, 0xe4f399a3, 0x110ec388, 0xe4ece4ba,
  0x11042061, 0xe4e633fd, 0x10f97a9a, 0xe4df876f,
  0x10eed235, 0xe4d8df0f, 0x10e42733, 0xe4d23ae0,
  0x10d97997, 0xe4cb9ae1, 0x10cec961, 0xe4c4ff14,
  0x10c41694, 0xe4be677b, 0x10b96131, 0xe4b7d415,
  0x10aea939, 0xe4b144e5, 0x10a3eeb0, 0xe4aab9ea,
  0x10993195, 0xe4a43327, 0x108e71ea, 0xe49db09b,
  0x1083afb3, 0xe4973249, 0x1078eaef, 0xe490b831,
  0x106e23a1, 0xe48a4254, 0x106359ca, 0xe483d0b3,
  0x10588d6d, 0xe47d634f, 0x104dbe8a, 0xe476fa29,
  0x1042ed23, 0xe4709542, 0x1038193a, 0xe46a349b,
  0x102d42d2, 0xe463d835, 0x102269ea, 0xe45d8012,
  0x10178e86, 0xe4572c31, 0x100cb0a6, 0xe450dc94,
  0x1001d04c, 0xe44a913c, 0x0ff6ed7b, 0xe4444a2a,
  0x0fec0833, 0xe43e075f, 0x0fe12077, 0xe437c8db,
  0x0fd63648, 0xe4318ea1, 0x0fcb49a8, 0xe42b58b0,
  0x0fc05a98, 0xe425270a, 0x0fb5691b, 0xe41ef9af,
  0x0faa7531, 0xe418d0a2, 0x0f9f7edd, 0xe412abe1,
  0x0f948620, 0xe40c8b70, 0x0f898afc, 0xe4066f4d,
  0x0f7e8d72, 0xe400577c, 0x0f738d85, 0xe3fa43fb,
  0x0f688b36, 0xe3f434cd, 0x0f5d8686, 0xe3ee29f2,
  0x0f527f78, 0xe3e8236b, 0x0f47760d, 0xe3e22139,
  0x0f3c6a47, 0xe3dc235d, 0x0f315c27, 0xe3d629d8,
  0x0f264bb0, 0xe3d034ab, 0x0f1b38e3, 0xe3ca43d7,
  0x0f1023c1, 0xe3c4575c, 0x0f050c4c, 0xe3be6f3c,
  0x0ef9f287, 0xe3b88b78, 0x0eeed672, 0xe3b2ac10,
  0x0ee3b810, 0xe3acd105, 0x0ed89761, 0xe3a6fa59,
  0x0ecd7469, 0xe3a1280b, 0x0ec24f29, 0xe39b5a1e,
  0x0eb727a1, 0xe3959091, 0x0eabfdd5, 0xe38fcb67,
  0x0ea0d1c6, 0xe38a0a9f, 0x0e95a375, 0xe3844e3a,
  0x0e8a72e4, 0xe37e963b, 0x0e7f4016, 0xe378e2a0,
  0x0e740b0a, 0xe373336c, 0x0e68d3c5, 0xe36d889e,
  0x0e5d9a46, 0xe367e239, 0x0e525e91, 0xe362403d,
  0x0e4720a6, 0xe35ca2aa, 0x0e3be087, 0xe3570982,
  0x0e309e36, 0xe35174c6, 0x0e2559b6, 0xe34be475,
  0x0e1a1306, 0xe3465892, 0x0e0eca2a, 0xe340d11d,
  0x0e037f23, 0xe33b4e17, 0x0df831f3, 0xe335cf80,
  0x0dece29b, 0xe330555a, 0x0de1911e, 0xe32adfa6,
  0x0dd63d7c, 0xe3256e64, 0x0dcae7b9, 0xe3200195,
  0x0dbf8fd4, 0xe31a9939, 0x0db435d1, 0xe3153553,
  0x0da8d9b1, 0xe30fd5e2, 0x0d9d7b76, 0xe30a7ae8,
  0x0d921b21, 0xe3052465, 0x0d86b8b5, 0xe2ffd25a,
  0x0d7b5432, 0xe2fa84c7, 0x0d6fed9c, 0xe2f53baf,
  0x0d6484f2, 0xe2eff711, 0x0d591a38, 0xe2eab6ef,
  0x0d4dad6f, 0xe2e57b48, 0x0d423e99, 0xe2e0441f,
  0x0d36cdb8, 0xe2db1173, 0x0d2b5acd, 0xe2d5e346,
  0x0d1fe5d9, 0xe2d0b998, 0x0d146ee0, 0xe2cb946b,
  0x0d08f5e3, 0xe2c673be, 0x0cfd7ae2, 0xe2c15793,
  0x0cf1fde1, 0xe2bc3feb, 0x0ce67ee1, 0xe2b72cc6,
  0x0cdafde4, 0xe2b21e25, 0x0ccf7aeb, 0xe2ad1409,
  0x0cc3f5f8, 0xe2a80e73, 0x0cb86f0e, 0xe2a30d63,
  0x0cace62d, 0xe29e10da, 0x0ca15b58, 0xe29918d9,
  0x0c95ce90, 0xe2942561, 0x0c8a3fd7, 0xe28f3673,
  0x0c7eaf2f, 0xe28a4c0f, 0x0c731c9a, 0xe2856635,
  0x0c67881a, 0xe28084e8, 0x0c5bf1b0, 0xe27ba827,
  0x0c50595d, 0xe276cff4, 0x0c44bf25, 0xe271fc4e,
  0x0c392309, 0xe26d2d37, 0x0c2d8509, 0xe26862b0,
  0x0c21e52a, 0xe2639cb9, 0x0c16436b, 0xe25edb53,
  0x0c0a9fcf, 0xe25a1e7f, 0x0bfefa57, 0xe255663d,
  0x0bf35306, 0xe250b28e, 0x0be7a9dd, 0xe24c0373,
  0x0bdbfedf, 0xe24758ed, 0x0bd0520c, 0xe242b2fd,
  0x0bc4a366, 0xe23e11a2, 0x0bb8f2f0, 0xe23974de,
  0x0bad40ab, 0xe234dcb2, 0x0ba18c9a, 0xe230491d,
  0x0b95d6bd, 0xe22bba22, 0x0b8a1f17, 0xe2272fc0,
  0x0b7e65a9, 0xe222a9f9, 0x0b72aa75, 0xe21e28cc,
  0x0b66ed7e, 0xe219ac3c, 0x0b5b2ec4, 0xe2153447,
  0x0b4f6e4a, 0xe210c0f0, 0x0b43ac11, 0xe20c5237,
  0x0b37e81c, 0xe207e81c, 0x0b2c226c, 0xe20382a0,
  0x0b205b03, 0xe1ff21c4, 0x0b1491e3, 0xe1fac588,
  0x0b08c70d, 0xe1f66dee, 0x0afcfa83, 0xe1f21af5,
  0x0af12c48, 0xe1edcc9f, 0x0ae55c5d, 0xe1e982ec,
  0x0ad98ac3, 0xe1e53ddd, 0x0acdb77e, 0xe1e0fd72,
  0x0ac1e28e, 0xe1dcc1ad, 0x0ab60bf5, 0xe1d88a8d,
  0x0aaa33b5, 0xe1d45814, 0x0a9e59d0, 0xe1d02a42,
  0x0a927e48, 0xe1cc0117, 0x0a86a11f, 0xe1c7dc95,
  0x0a7ac256, 0xe1c3bcbc, 0x0a6ee1ef, 0xe1bfa18d,
  0x0a62ffed, 0xe1bb8b08, 0x0a571c50, 0xe1b7792d,
  0x0a4b371b, 0xe1b36bff, 0x0a3f5050, 0xe1af637c,
  0x0a3367f0, 0xe1ab5fa6, 0x0a277dfe, 0xe1a7607e,
  0x0a1b927b, 0xe1a36604, 0x0a0fa568, 0xe19f7038,
  0x0a03b6c9, 0xe19b7f1b, 0x09f7c69e, 0xe19792af,
  0x09ebd4e9, 0xe193aaf3, 0x09dfe1ad, 0xe18fc7e8,
  0x09d3eceb, 0xe18be98e, 0x09c7f6a6, 0xe1880fe7,
  0x09bbfedd, 0xe1843af3, 0x09b00595, 0xe1806ab2,
  0x09a40ace, 0xe17c9f25, 0x09980e8b, 0xe178d84d,
  0x098c10cd, 0xe1751629, 0x09801196, 0xe17158bc,
  0x097410e8, 0xe16da005, 0x09680ec4, 0xe169ec05,
  0x095c0b2e, 0xe1663cbd, 0x09500625, 0xe162922c,
  0x0943ffae, 0xe15eec54, 0x0937f7c8, 0xe15b4b36,
  0x092bee77, 0xe157aed1, 0x091fe3bb, 0xe1541726,
  0x0913d797, 0xe1508437, 0x0907ca0d, 0xe14cf602,
  0x08fbbb1e, 0xe1496c8a, 0x08efaacd, 0xe145e7ce,
  0x08e3991b, 0xe14267cf, 0x08d7860a, 0xe13eec8e,
  0x08cb719b, 0xe13b760b, 0x08bf5bd2, 0xe1380447,
  0x08b344af, 0xe1349742, 0x08a72c35, 0xe1312efc,
  0x089b1265, 0xe12dcb77, 0x088ef742, 0xe12a6cb2,
  0x0882dacd, 0xe12712af, 0x0876bd07, 0xe123bd6e,
  0x086a9df4, 0xe1206cef, 0x085e7d94, 0xe11d2133,
  0x08525bea, 0xe119da3a, 0x084638f7, 0xe1169805,
  0x083a14be, 0xe1135a94, 0x082def3f, 0xe11021e8,
  0x0821c87e, 0xe10cee02, 0x0815a07c, 0xe109bee1,
  0x0809773b, 0xe1069487, 0x07fd4cbc, 0xe1036ef3,
  0x07f12102, 0xe1004e27, 0x07e4f40f, 0xe0fd3222,
  0x07d8c5e4, 0xe0fa1ae6, 0x07cc9683, 0xe0f70873,
  0x07c065ee, 0xe0f3fac8, 0x07b43427, 0xe0f0f1e8,
  0x07a80130, 0xe0ededd2, 0x079bcd0b, 0xe0eaee86,
  0x078f97b9, 0xe0e7f405, 0x0783613d, 0xe0e4fe50,
  0x07772998, 0xe0e20d67, 0x076af0cd, 0xe0df214a,
  0x075eb6dd, 0xe0dc39fa, 0x07527bc9, 0xe0d95778,
  0x07463f95, 0xe0d679c3, 0x073a0242, 0xe0d3a0dd,
  0x072dc3d1, 0xe0d0ccc5, 0x07218445, 0xe0cdfd7c,
  0x0715439f, 0xe0cb3303, 0x070901e2, 0xe0c86d5a,
  0x06fcbf0e, 0xe0c5ac81, 0x06f07b28, 0xe0c2f079,
  0x06e4362f, 0xe0c03943, 0x06d7f026, 0xe0bd86de,
  0x06cba90f, 0xe0bad94b, 0x06bf60eb, 0xe0b8308a,
  0x06b317bd, 0xe0b58c9d, 0x06a6cd87, 0xe0b2ed83,
  0x069a824a, 0xe0b0533c, 0x068e3609, 0xe0adbdca,
  0x0681e8c4, 0xe0ab2d2c, 0x06759a7f, 0xe0a8a163,
  0x06694b3b, 0xe0a61a6f, 0x065cfaf9, 0xe0a39851,
  0x0650a9bd, 0xe0a11b0a, 0x06445787, 0xe09ea298,
  0x0638045a, 0xe09c2efe, 0x062bb037, 0xe099c03a,
  0x061f5b20, 0xe097564f, 0x06130518, 0xe094f13b,
  0x0606ae20, 0xe09290ff, 0x05fa563a, 0xe090359d,
  0x05edfd69, 0xe08ddf13, 0x05e1a3ad, 0xe08b8d63,
  0x05d54909, 0xe089408c, 0x05c8ed7e, 0xe086f890,
  0x05bc910f, 0xe084b56e, 0x05b033be, 0xe0827727,
  0x05a3d58c, 0xe0803dbc, 0x0597767c, 0xe07e092b,
  0x058b168f, 0xe07bd977, 0x057eb5c7, 0xe079ae9f,
  0x05725426, 0xe07788a3, 0x0565f1ae, 0xe0756785,
  0x05598e60, 0xe0734b43, 0x054d2a40, 0xe07133df,
  0x0540c54f, 0xe06f2159, 0x05345f8e, 0xe06d13b1,
  0x0527f8ff, 0xe06b0ae8, 0x051b91a5, 0xe06906fd,
  0x050f2981, 0xe06707f1, 0x0502c096, 0xe0650dc5,
  0x04f656e5, 0xe0631879, 0x04e9ec70, 0xe061280c,
  0x04dd8139, 0xe05f3c80, 0x04d11541, 0xe05d55d5,
  0x04c4a88c, 0xe05b740a, 0x04b83b1a, 0xe0599721,
  0x04abccef, 0xe057bf19, 0x049f5e0a, 0xe055ebf3,
  0x0492ee6f, 0xe0541daf, 0x04867e20, 0xe052544e,
  0x047a0d1e, 0xe0508fcf, 0x046d9b6b, 0xe04ed032,
  0x0461290a, 0xe04d1579, 0x0454b5fb, 0xe04b5fa4,
  0x04484242, 0xe049aeb2, 0x043bcddf, 0xe04802a4,
  0x042f58d6, 0xe0465b7a, 0x0422e327, 0xe044b935,
  0x04166cd5, 0xe0431bd4, 0x0409f5e1, 0xe0418359,
  0x03fd7e4e, 0xe03fefc2, 0x03f1061e, 0xe03e6111,
  0x03e48d51, 0xe03cd746, 0x03d813ec, 0xe03b5261,
  0x03cb99ee, 0xe039d262, 0x03bf1f5b, 0xe0385749,
  0x03b2a433, 0xe036e117, 0x03a6287a, 0xe0356fcb,
  0x0399ac31, 0xe0340367, 0x038d2f59, 0xe0329bea,
  0x0380b1f6, 0xe0313955, 0x03743408, 0xe02fdba7,
  0x0367b591, 0xe02e82e1, 0x035b3695, 0xe02d2f04,
  0x034eb713, 0xe02be00e, 0x03423710, 0xe02a9601,
  0x0335b68b, 0xe02950dd, 0x03293588, 0xe02810a2,
  0x031cb408, 0xe026d550, 0x0310320d, 0xe0259ee8,
  0x0303af99, 0xe0246d69, 0x02f72caf, 0xe02340d3,
  0x02eaa94f, 0xe0221928, 0x02de257c, 0xe020f666,
  0x02d1a138, 0xe01fd88f, 0x02c51c84, 0xe01ebfa2,
  0x02b89763, 0xe01dab9f, 0x02ac11d7, 0xe01c9c88,
  0x029f8be1, 0xe01b925b, 0x02930584, 0xe01a8d19,
  0x02867ec1, 0xe0198cc3, 0x0279f79a, 0xe0189158,
  0x026d7012, 0xe0179ad8, 0x0260e82a, 0xe016a945,
  0x02545fe4, 0xe015bc9c, 0x0247d742, 0xe014d4e0,
  0x023b4e45, 0xe013f210, 0x022ec4f1, 0xe013142d,
  0x02223b47, 0xe0123b35, 0x0215b148, 0xe011672a,
  0x020926f7, 0xe010980c, 0x01fc9c56, 0xe00fcdda,
  0x01f01166, 0xe00f0896, 0x01e3862a, 0xe00e483e,
  0x01d6faa3, 0xe00d8cd3, 0x01ca6ed4, 0xe00cd656,
  0x01bde2bd, 0xe00c24c6, 0x01b15662, 0xe00b7824,
  0x01a4c9c5, 0xe00ad06e, 0x01983ce6, 0xe00a2da7,
  0x018bafc9, 0xe0098fcd, 0x017f226e, 0xe008f6e2,
  0x017294d8, 0xe00862e4, 0x01660709, 0xe007d3d4,
  0x01597903, 0xe00749b2, 0x014ceac8, 0xe006c47e,
  0x01405c59, 0xe0064439, 0x0133cdb9, 0xe005c8e2,
  0x01273eea, 0xe005527a, 0x011aafed, 0xe004e0ff,
  0x010e20c4, 0xe0047474, 0x01019172, 0xe0040cd7,
  0x00f501f8, 0xe003aa29, 0x00e87258, 0xe0034c69,
  0x00dbe294, 0xe002f399, 0x00cf52af, 0xe0029fb7,
  0x00c2c2a9, 0xe00250c4, 0x00b63286, 0xe00206c0,
  0x00a9a246, 0xe001c1ab, 0x009d11ec, 0xe0018185,
  0x0090817a, 0xe001464e, 0x0083f0f2, 0xe0011006,
  0x00776055, 0xe000deae, 0x006acfa6, 0xe000b244,
  0x005e3ee6, 0xe0008aca, 0x0051ae18, 0xe000683f,
  0x00451d3d, 0xe0004aa3, 0x00388c58, 0xe00031f7,
  0x002bfb6a, 0xe0001e3a, 0x001f6a75, 0xe0000f6c,
  0x0012d97b, 0xe000058d, 0x0006487f, 0xe000009e,
};

static ogg_int16_t bitrevlook_8192[2048]={
  0x0ffe, 0x0000, 0x07fe, 0x0800,
  0x0bfe, 0x0400, 0x03fe, 0x0c00,
  0x0dfe, 0x0200, 0x05fe, 0x0a00,
  0x09fe, 0x0600, 0x01fe, 0x0e00,
  0x0efe, 0x0100, 0x06fe, 0x0900,
  0x0afe, 0x0500, 0x02fe, 0x0d00,
  0x0cfe, 0x0300, 0x04fe, 0x0b00,
  0x08fe, 0x0700, 0x00fe, 0x0f00,
  0x0f7e, 0x0080, 0x077e, 0x0880,
  0x0b7e, 0x0480, 0x037e, 0x0c80,
  0x0d7e, 0x0280, 0x057e, 0x0a80,
  0x097e, 0x0680, 0x017e, 0x0e80,
  0x0e7e, 0x0180, 0x067e, 0x0980,
  0x0a7e, 0x0580, 0x027e, 0x0d80,
  0x0c7e, 0x0380, 0x047e, 0x0b80,
  0x087e, 0x0780, 0x007e, 0x0f80,
  0x0fbe, 0x0040, 0x07be, 0x0840,
  0x0bbe, 0x0440, 0x03be, 0x0c40,
  0x0dbe, 0x0240, 0x05be, 0x0a40,
  0x09be, 0x0640, 0x01be, 0x0e40,
  0x0ebe, 0x0140, 0x06be, 0x0940,
  0x0abe, 0x0540, 0x02be, 0x0d40,
  0x0cbe, 0x0340, 0x04be, 0x0b40,
  0x08be, 0x0740, 0x00be, 0x0f40,
  0x0f3e, 0x00c0, 0x073e, 0x08c0,
  0x0b3e, 0x04c0, 0x033e, 0x0cc0,
  0x0d3e, 0x02c0, 0x053e, 0x0ac0,
  0x093e, 0x06c0, 0x013e, 0x0ec0,
  0x0e3e, 0x01c0, 0x063e, 0x09c0,
  0x0a3e, 0x05c0, 0x023e, 0x0dc0,
  0x0c3e, 0x03c0, 0x043e, 0x0bc0,
  0x083e, 0x07c0, 0x003e, 0x0fc0,
  0x0fde, 0x0020, 0x07de, 0x0820,
  0x0bde, 0x0420, 0x03de, 0x0c20,
  0x0dde, 0x0220, 0x05de, 0x0a20,
  0x09de, 0x0620, 0x01de, 0x0e20,
  0x0ede, 0x0120, 0x06de, 0x0920,
  0x0ade, 0x0520, 0x02de, 0x0d20,
  0x0cde, 0x0320, 0x04de, 0x0b20,
  0x08de, 0x0720, 0x00de, 0x0f20,
  0x0f5e, 0x00a0, 0x075e, 0x08a0,
  0x0b5e, 0x04a0, 0x035e, 0x0ca0,
  0x0d5e, 0x02a0, 0x055e, 0x0aa0,
  0x095e, 0x06a0, 0x015e, 0x0ea0,
  0x0e5e, 0x01a0, 0x065e, 0x09a0,
  0x0a5e, 0x05a0, 0x025e, 0x0da0,
  0x0c5e, 0x03a0, 0x045e, 0x0ba0,
  0x085e, 0x07a0, 0x005e, 0x0fa0,
  0x0f9e, 0x0060, 0x079e, 0x0860,
  0x0b9e, 0x0460, 0x039e, 0x0c60,
  0x0d9e, 0x0260, 0x059e, 0x0a60,
  0x099e, 0x0660, 0x019e, 0x0e60,
  0x0e9e, 0x0160, 0x069e, 0x0960,
  0x0a9e, 0x0560, 0x029e, 0x0d60,
  0x0c9e, 0x0360, 0x049e, 0x0b60,
  0x089e, 0x0760, 0x009e, 0x0f60,
  0x0f1e, 0x00e0, 0x071e, 0x08e0,
  0x0b1e, 0x04e0, 0x031e, 0x0ce0,
  0x0d1e, 0x02e0, 0x051e, 0x0ae0,
  0x091e, 0x06e0, 0x011e, 0x0ee0,
  0x0e1e, 0x01e0, 0x061e, 0x09e0,
  0x0a1e, 0x05e0, 0x021e, 0x0de0,
  0x0c1e, 0x03e0, 0x041e, 0x0be0,
  0x081e, 0x07e0, 0x001e, 0x0fe0,
  0x0fee, 0x0010, 0x07ee, 0x0810,
  0x0bee, 0x0410, 0x03ee, 0x0c10,
  0x0dee, 0x0210, 0x05ee, 0x0a10,
  0x09ee, 0x0610, 0x01ee, 0x0e10,
  0x0eee, 0x0110, 0x06ee, 0x0910,
  0x0aee, 0x0510, 0x02ee, 0x0d10,
  0x0cee, 0x0310, 0x04ee, 0x0b10,
  0x08ee, 0x0710, 0x00ee, 0x0f10,
  0x0f6e, 0x0090, 0x076e, 0x0890,
  0x0b6e, 0x0490, 0x036e, 0x0c90,
  0x0d6e, 0x0290, 0x056e, 0x0a90,
  0x096e, 0x0690, 0x016e, 0x0e90,
  0x0e6e, 0x0190, 0x066e, 0x0990,
  0x0a6e, 0x0590, 0x026e, 0x0d90,
  0x0c6e, 0x0390, 0x046e, 0x0b90,
  0x086e, 0x0790, 0x006e, 0x0f90,
  0x0fae, 0x0050, 0x07ae, 0x0850,
  0x0bae, 0x0450, 0x03ae, 0x0c50,
  0x0dae, 0x0250, 0x05ae, 0x0a50,
  0x09ae, 0x0650, 0x01ae, 0x0e50,
  0x0eae, 0x0150, 0x06ae, 0x0950,
  0x0aae, 0x0550, 0x02ae, 0x0d50,
  0x0cae, 0x0350, 0x04ae, 0x0b50,
  0x08ae, 0x0750, 0x00ae, 0x0f50,
  0x0f2e, 0x00d0, 0x072e, 0x08d0,
  0x0b2e, 0x04d0, 0x032e, 0x0cd0,
  0x0d2e, 0x02d0, 0x052e, 0x0ad0,
  0x092e, 0x06d0, 0x012e, 0x0ed0,
  0x0e2e, 0x01d0, 0x062e, 0x09d0,
  0x0a2e, 0x05d0, 0x022e, 0x0dd0,
  0x0c2e, 0x03d0, 0x042e, 0x0bd0,
  0x082e, 0x07d0, 0x002e, 0x0fd0,
  0x0fce, 0x0030, 0x07ce, 0x0830,
  0x0bce, 0x0430, 0x03ce, 0x0c30,
  0x0dce, 0x0230, 0x05ce, 0x0a30,
  0x09ce, 0x0630, 0x01ce, 0x0e30,
  0x0ece, 0x0130, 0x06ce, 0x0930,
  0x0ace, 0x0530, 0x02ce, 0x0d30,
  0x0cce, 0x0330, 0x04ce, 0x0b30,
  0x08ce, 0x0730, 0x00ce, 0x0f30,
  0x0f4e, 0x00b0, 0x074e, 0x08b0,
  0x0b4e, 0x04b0, 0x034e, 0x0cb0,
  0x0d4e, 0x02b0, 0x054e, 0x0ab0,
  0x094e, 0x06b0, 0x014e, 0x0eb0,
  0x0e4e, 0x01b0, 0x064e, 0x09b0,
  0x0a4e, 0x05b0, 0x024e, 0x0db0,
  0x0c4e, 0x03b0, 0x044e, 0x0bb0,
  0x084e, 0x07b0, 0x004e, 0x0fb0,
  0x0f8e, 0x0070, 0x078e, 0x0870,
  0x0b8e, 0x0470, 0x038e, 0x0c70,
  0x0d8e, 0x0270, 0x058e, 0x0a70,
  0x098e, 0x0670, 0x018e, 0x0e70,
  0x0e8e, 0x0170, 0x068e, 0x0970,
  0x0a8e, 0x0570, 0x028e, 0x0d70,
  0x0c8e, 0x0370, 0x048e, 0x0b70,
  0x088e, 0x0770, 0x008e, 0x0f70,
  0x0f0e, 0x00f0, 0x070e, 0x08f0,
  0x0b0e, 0x04f0, 0x030e, 0x0cf0,
  0x0d0e, 0x02f0, 0x050e, 0x0af0,
  0x090e, 0x06f0, 0x010e, 0x0ef0,
  0x0e0e, 0x01f0, 0x060e, 0x09f0,
  0x0a0e, 0x05f0, 0x020e, 0x0df0,
  0x0c0e, 0x03f0, 0x040e, 0x0bf0,
  0x080e, 0x07f0, 0x000e, 0x0ff0,
  0x0ff6, 0x0008, 0x07f6, 0x0808,
  0x0bf6, 0x0408, 0x03f6, 0x0c08,
  0x0df6, 0x0208, 0x05f6, 0x0a08,
  0x09f6, 0x0608, 0x01f6, 0x0e08,
  0x0ef6, 0x0108, 0x06f6, 0x0908,
  0x0af6, 0x0508, 0x02f6, 0x0d08,
  0x0cf6, 0x0308, 0x04f6, 0x0b08,
  0x08f6, 0x0708, 0x00f6, 0x0f08,
  0x0f76, 0x0088, 0x0776, 0x0888,
  0x0b76, 0x0488, 0x0376, 0x0c88,
  0x0d76, 0x0288, 0x0576, 0x0a88,
  0x0976, 0x0688, 0x0176, 0x0e88,
  0x0e76, 0x0188, 0x0676, 0x0988,
  0x0a76, 0x0588, 0x0276, 0x0d88,
  0x0c76, 0x0388, 0x0476, 0x0b88,
  0x0876, 0x0788, 0x0076, 0x0f88,
  0x0fb6, 0x0048, 0x07b6, 0x0848,
  0x0bb6, 0x0448, 0x03b6, 0x0c48,
  0x0db6, 0x0248, 0x05b6, 0x0a48,
  0x09b6, 0x0648, 0x01b6, 0x0e48,
  0x0eb6, 0x0148, 0x06b6, 0x0948,
  0x0ab6, 0x0548, 0x02b6, 0x0d48,
  0x0cb6, 0x0348, 0x04b6, 0x0b48,
  0x08b6, 0x0748, 0x00b6, 0x0f48,
  0x0f36, 0x00c8, 0x0736, 0x08c8,
  0x0b36, 0x04c8, 0x0336, 0x0cc8,
  0x0d36, 0x02c8, 0x0536, 0x0ac8,
  0x0936, 0x06c8, 0x0136, 0x0ec8,
  0x0e36, 0x01c8, 0x0636, 0x09c8,
  0x0a36, 0x05c8, 0x0236, 0x0dc8,
  0x0c36, 0x03c8, 0x0436, 0x0bc8,
  0x0836, 0x07c8, 0x0036, 0x0fc8,
  0x0fd6, 0x0028, 0x07d6, 0x0828,
  0x0bd6, 0x0428, 0x03d6, 0x0c28,
  0x0dd6, 0x0228, 0x05d6, 0x0a28,
  0x09d6, 0x0628, 0x01d6, 0x0e28,
  0x0ed6, 0x0128, 0x06d6, 0x0928,
  0x0ad6, 0x0528, 0x02d6, 0x0d28,
  0x0cd6, 0x0328, 0x04d6, 0x0b28,
  0x08d6, 0x0728, 0x00d6, 0x0f28,
  0x0f56, 0x00a8, 0x0756, 0x08a8,
  0x0b56, 0x04a8, 0x0356, 0x0ca8,
  0x0d56, 0x02a8, 0x0556, 0x0aa8,
  0x0956, 0x06a8, 0x0156, 0x0ea8,
  0x0e56, 0x01a8, 0x0656, 0x09a8,
  0x0a56, 0x05a8, 0x0256, 0x0da8,
  0x0c56, 0x03a8, 0x0456, 0x0ba8,
  0x0856, 0x07a8, 0x0056, 0x0fa8,
  0x0f96, 0x0068, 0x0796, 0x0868,
  0x0b96, 0x0468, 0x0396, 0x0c68,
  0x0d96, 0x0268, 0x0596, 0x0a68,
  0x0996, 0x0668, 0x0196, 0x0e68,
  0x0e96, 0x0168, 0x0696, 0x0968,
  0x0a96, 0x0568, 0x0296, 0x0d68,
  0x0c96, 0x0368, 0x0496, 0x0b68,
  0x0896, 0x0768, 0x0096, 0x0f68,
  0x0f16, 0x00e8, 0x0716, 0x08e8,
  0x0b16, 0x04e8, 0x0316, 0x0ce8,
  0x0d16, 0x02e8, 0x0516, 0x0ae8,
  0x0916, 0x06e8, 0x0116, 0x0ee8,
  0x0e16, 0x01e8, 0x0616, 0x09e8,
  0x0a16, 0x05e8, 0x0216, 0x0de8,
  0x0c16, 0x03e8, 0x0416, 0x0be8,
  0x0816, 0x07e8, 0x0016, 0x0fe8,
  0x0fe6, 0x0018, 0x07e6, 0x0818,
  0x0be6, 0x0418, 0x03e6, 0x0c18,
  0x0de6, 0x0218, 0x05e6, 0x0a18,
  0x09e6, 0x0618, 0x01e6, 0x0e18,
  0x0ee6, 0x0118, 0x06e6, 0x0918,
  0x0ae6, 0x0518, 0x02e6, 0x0d18,
  0x0ce6, 0x0318, 0x04e6, 0x0b18,
  0x08e6, 0x0718, 0x00e6, 0x0f18,
  0x0f66, 0x0098, 0x0766, 0x0898,
  0x0b66, 0x0498, 0x0366, 0x0c98,
  0x0d66, 0x0298, 0x0566, 0x0a98,
  0x0966, 0x0698, 0x0166, 0x0e98,
  0x0e66, 0x0198, 0x0666, 0x0998,
  0x0a66, 0x0598, 0x0266, 0x0d98,
  0x0c66, 0x0398, 0x0466, 0x0b98,
  0x0866, 0x0798, 0x0066, 0x0f98,
  0x0fa6, 0x0058, 0x07a6, 0x0858,
  0x0ba6, 0x0458, 0x03a6, 0x0c58,
  0x0da6, 0x0258, 0x05a6, 0x0a58,
  0x09a6, 0x0658, 0x01a6, 0x0e58,
  0x0ea6, 0x0158, 0x06a6, 0x0958,
  0x0aa6, 0x0558, 0x02a6, 0x0d58,
  0x0ca6, 0x0358, 0x04a6, 0x0b58,
  0x08a6, 0x0758, 0x00a6, 0x0f58,
  0x0f26, 0x00d8, 0x0726, 0x08d8,
  0x0b26, 0x04d8, 0x0326, 0x0cd8,
  0x0d26, 0x02d8, 0x0526, 0x0ad8,
  0x0926, 0x06d8, 0x0126, 0x0ed8,
  0x0e26, 0x01d8, 0x0626, 0x09d8,
  0x0a26, 0x05d8, 0x0226, 0x0dd8,
  0x0c26, 0x03d8, 0x0426, 0x0bd8,
  0x0826, 0x07d8, 0x0026, 0x0fd8,
  0x0fc6, 0x0038, 0x07c6, 0x0838,
  0x0bc6, 0x0438, 0x03c6, 0x0c38,
  0x0dc6, 0x0238, 0x05c6, 0x0a38,
  0x09c6, 0x0638, 0x01c6, 0x0e38,
  0x0ec6, 0x0138, 0x06c6, 0x0938,
  0x0ac6, 0x0538, 0x02c6, 0x0d38,
  0x0cc6, 0x0338, 0x04c6, 0x0b38,
  0x08c6, 0x0738, 0x00c6, 0x0f38,
  0x0f46, 0x00b8, 0x0746, 0x08b8,
  0x0b46, 0x04b8, 0x0346, 0x0cb8,
  0x0d46, 0x02b8, 0x0546, 0x0ab8,
  0x0946, 0x06b8, 0x0146, 0x0eb8,
  0x0e46, 0x01b8, 0x0646, 0x09b8,
  0x0a46, 0x05b8, 0x0246, 0x0db8,
  0x0c46, 0x03b8, 0x0446, 0x0bb8,
  0x0846, 0x07b8, 0x0046, 0x0fb8,
  0x0f86, 0x0078, 0x0786, 0x0878,
  0x0b86, 0x0478, 0x0386, 0x0c78,
  0x0d86, 0x0278, 0x0586, 0x0a78,
  0x0986, 0x0678, 0x0186, 0x0e78,
  0x0e86, 0x0178, 0x0686, 0x0978,
  0x0a86, 0x0578, 0x0286, 0x0d78,
  0x0c86, 0x0378, 0x0486, 0x0b78,
  0x0886, 0x0778, 0x0086, 0x0f78,
  0x0f06, 0x00f8, 0x0706, 0x08f8,
  0x0b06, 0x04f8, 0x0306, 0x0cf8,
  0x0d06, 0x02f8, 0x0506, 0x0af8,
  0x0906, 0x06f8, 0x0106, 0x0ef8,
  0x0e06, 0x01f8, 0x0606, 0x09f8,
  0x0a06, 0x05f8, 0x0206, 0x0df8,
  0x0c06, 0x03f8, 0x0406, 0x0bf8,
  0x0806, 0x07f8, 0x0006, 0x0ff8,
  0x0ffa, 0x0004, 0x07fa, 0x0804,
  0x0bfa, 0x0404, 0x03fa, 0x0c04,
  0x0dfa, 0x0204, 0x05fa, 0x0a04,
  0x09fa, 0x0604, 0x01fa, 0x0e04,
  0x0efa, 0x0104, 0x06fa, 0x0904,
  0x0afa, 0x0504, 0x02fa, 0x0d04,
  0x0cfa, 0x0304, 0x04fa, 0x0b04,
  0x08fa, 0x0704, 0x00fa, 0x0f04,
  0x0f7a, 0x0084, 0x077a, 0x0884,
  0x0b7a, 0x0484, 0x037a, 0x0c84,
  0x0d7a, 0x0284, 0x057a, 0x0a84,
  0x097a, 0x0684, 0x017a, 0x0e84,
  0x0e7a, 0x0184, 0x067a, 0x0984,
  0x0a7a, 0x0584, 0x027a, 0x0d84,
  0x0c7a, 0x0384, 0x047a, 0x0b84,
  0x087a, 0x0784, 0x007a, 0x0f84,
  0x0fba, 0x0044, 0x07ba, 0x0844,
  0x0bba, 0x0444, 0x03ba, 0x0c44,
  0x0dba, 0x0244, 0x05ba, 0x0a44,
  0x09ba, 0x0644, 0x01ba, 0x0e44,
  0x0eba, 0x0144, 0x06ba, 0x0944,
  0x0aba, 0x0544, 0x02ba, 0x0d44,
  0x0cba, 0x0344, 0x04ba, 0x0b44,
  0x08ba, 0x0744, 0x00ba, 0x0f44,
  0x0f3a, 0x00c4, 0x073a, 0x08c4,
  0x0b3a, 0x04c4, 0x033a, 0x0cc4,
  0x0d3a, 0x02c4, 0x053a, 0x0ac4,
  0x093a, 0x06c4, 0x013a, 0x0ec4,
  0x0e3a, 0x01c4, 0x063a, 0x09c4,
  0x0a3a, 0x05c4, 0x023a, 0x0dc4,
  0x0c3a, 0x03c4, 0x043a, 0x0bc4,
  0x083a, 0x07c4, 0x003a, 0x0fc4,
  0x0fda, 0x0024, 0x07da, 0x0824,
  0x0bda, 0x0424, 0x03da, 0x0c24,
  0x0dda, 0x0224, 0x05da, 0x0a24,
  0x09da, 0x0624, 0x01da, 0x0e24,
  0x0eda, 0x0124, 0x06da, 0x0924,
  0x0ada, 0x0524, 0x02da, 0x0d24,
  0x0cda, 0x0324, 0x04da, 0x0b24,
  0x08da, 0x0724, 0x00da, 0x0f24,
  0x0f5a, 0x00a4, 0x075a, 0x08a4,
  0x0b5a, 0x04a4, 0x035a, 0x0ca4,
  0x0d5a, 0x02a4, 0x055a, 0x0aa4,
  0x095a, 0x06a4, 0x015a, 0x0ea4,
  0x0e5a, 0x01a4, 0x065a, 0x09a4,
  0x0a5a, 0x05a4, 0x025a, 0x0da4,
  0x0c5a, 0x03a4, 0x045a, 0x0ba4,
  0x085a, 0x07a4, 0x005a, 0x0fa4,
  0x0f9a, 0x0064, 0x079a, 0x0864,
  0x0b9a, 0x0464, 0x039a, 0x0c64,
  0x0d9a, 0x0264, 0x059a, 0x0a64,
  0x099a, 0x0664, 0x019a, 0x0e64,
  0x0e9a, 0x0164, 0x069a, 0x0964,
  0x0a9a, 0x0564, 0x029a, 0x0d64,
  0x0c9a, 0x0364, 0x049a, 0x0b64,
  0x089a, 0x0764, 0x009a, 0x0f64,
  0x0f1a, 0x00e4, 0x071a, 0x08e4,
  0x0b1a, 0x04e4, 0x031a, 0x0ce4,
  0x0d1a, 0x02e4, 0x051a, 0x0ae4,
  0x091a, 0x06e4, 0x011a, 0x0ee4,
  0x0e1a, 0x01e4, 0x061a, 0x09e4,
  0x0a1a, 0x05e4, 0x021a, 0x0de4,
  0x0c1a, 0x03e4, 0x041a, 0x0be4,
  0x081a, 0x07e4, 0x001a, 0x0fe4,
  0x0fea, 0x0014, 0x07ea, 0x0814,
  0x0bea, 0x0414, 0x03ea, 0x0c14,
  0x0dea, 0x0214, 0x05ea, 0x0a14,
  0x09ea, 0x0614, 0x01ea, 0x0e14,
  0x0eea, 0x0114, 0x06ea, 0x0914,
  0x0aea, 0x0514, 0x02ea, 0x0d14,
  0x0cea, 0x0314, 0x04ea, 0x0b14,
  0x08ea, 0x0714, 0x00ea, 0x0f14,
  0x0f6a, 0x0094, 0x076a, 0x0894,
  0x0b6a, 0x0494, 0x036a, 0x0c94,
  0x0d6a, 0x0294, 0x056a, 0x0a94,
  0x096a, 0x0694, 0x016a, 0x0e94,
  0x0e6a, 0x0194, 0x066a, 0x0994,
  0x0a6a, 0x0594, 0x026a, 0x0d94,
  0x0c6a, 0x0394, 0x046a, 0x0b94,
  0x086a, 0x0794, 0x006a, 0x0f94,
  0x0faa, 0x0054, 0x07aa, 0x0854,
  0x0baa, 0x0454, 0x03aa, 0x0c54,
  0x0daa, 0x0254, 0x05aa, 0x0a54,
  0x09aa, 0x0654, 0x01aa, 0x0e54,
  0x0eaa, 0x0154, 0x06aa, 0x0954,
  0x0aaa, 0x0554, 0x02aa, 0x0d54,
  0x0caa, 0x0354, 0x04aa, 0x0b54,
  0x08aa, 0x0754, 0x00aa, 0x0f54,
  0x0f2a, 0x00d4, 0x072a, 0x08d4,
  0x0b2a, 0x04d4, 0x032a, 0x0cd4,
  0x0d2a, 0x02d4, 0x052a, 0x0ad4,
  0x092a, 0x06d4, 0x012a, 0x0ed4,
  0x0e2a, 0x01d4, 0x062a, 0x09d4,
  0x0a2a, 0x05d4, 0x022a, 0x0dd4,
  0x0c2a, 0x03d4, 0x042a, 0x0bd4,
  0x082a, 0x07d4, 0x002a, 0x0fd4,
  0x0fca, 0x0034, 0x07ca, 0x0834,
  0x0bca, 0x0434, 0x03ca, 0x0c34,
  0x0dca, 0x0234, 0x05ca, 0x0a34,
  0x09ca, 0x0634, 0x01ca, 0x0e34,
  0x0eca, 0x0134, 0x06ca, 0x0934,
  0x0aca, 0x0534, 0x02ca, 0x0d34,
  0x0cca, 0x0334, 0x04ca, 0x0b34,
  0x08ca, 0x0734, 0x00ca, 0x0f34,
  0x0f4a, 0x00b4, 0x074a, 0x08b4,
  0x0b4a, 0x04b4, 0x034a, 0x0cb4,
  0x0d4a, 0x02b4, 0x054a, 0x0ab4,
  0x094a, 0x06b4, 0x014a, 0x0eb4,
  0x0e4a, 0x01b4, 0x064a, 0x09b4,
  0x0a4a, 0x05b4, 0x024a, 0x0db4,
  0x0c4a, 0x03b4, 0x044a, 0x0bb4,
  0x084a, 0x07b4, 0x004a, 0x0fb4,
  0x0f8a, 0x0074, 0x078a, 0x0874,
  0x0b8a, 0x0474, 0x038a, 0x0c74,
  0x0d8a, 0x0274, 0x058a, 0x0a74,
  0x098a, 0x0674, 0x018a, 0x0e74,
  0x0e8a, 0x0174, 0x068a, 0x0974,
  0x0a8a, 0x0574, 0x028a, 0x0d74,
  0x0c8a, 0x0374, 0x048a, 0x0b74,
  0x088a, 0x0774, 0x008a, 0x0f74,
  0x0f0a, 0x00f4, 0x070a, 0x08f4,
  0x0b0a, 0x04f4, 0x030a, 0x0cf4,
  0x0d0a, 0x02f4, 0x050a, 0x0af4,
  0x090a, 0x06f4, 0x010a, 0x0ef4,
  0x0e0a, 0x01f4, 0x060a, 0x09f4,
  0x0a0a, 0x05f4, 0x020a, 0x0df4,
  0x0c0a, 0x03f4, 0x040a, 0x0bf4,
  0x080a, 0x07f4, 0x000a, 0x0ff4,
  0x0ff2, 0x000c, 0x07f2, 0x080c,
  0x0bf2, 0x040c, 0x03f2, 0x0c0c,
  0x0df2, 0x020c, 0x05f2, 0x0a0c,
  0x09f2, 0x060c, 0x01f2, 0x0e0c,
  0x0ef2, 0x010c, 0x06f2, 0x090c,
  0x0af2, 0x050c, 0x02f2, 0x0d0c,
  0x0cf2, 0x030c, 0x04f2, 0x0b0c,
  0x08f2, 0x070c, 0x00f2, 0x0f0c,
  0x0f72, 0x008c, 0x0772, 0x088c,
  0x0b72, 0x048c, 0x0372, 0x0c8c,
  0x0d72, 0x028c, 0x0572, 0x0a8c,
  0x0972, 0x068c, 0x0172, 0x0e8c,
  0x0e72, 0x018c, 0x0672, 0x098c,
  0x0a72, 0x058c, 0x0272, 0x0d8c,
  0x0c72, 0x038c, 0x0472, 0x0b8c,
  0x0872, 0x078c, 0x0072, 0x0f8c,
  0x0fb2, 0x004c, 0x07b2, 0x084c,
  0x0bb2, 0x044c, 0x03b2, 0x0c4c,
  0x0db2, 0x024c, 0x05b2, 0x0a4c,
  0x09b2, 0x064c, 0x01b2, 0x0e4c,
  0x0eb2, 0x014c, 0x06b2, 0x094c,
  0x0ab2, 0x054c, 0x02b2, 0x0d4c,
  0x0cb2, 0x034c, 0x04b2, 0x0b4c,
  0x08b2, 0x074c, 0x00b2, 0x0f4c,
  0x0f32, 0x00cc, 0x0732, 0x08cc,
  0x0b32, 0x04cc, 0x0332, 0x0ccc,
  0x0d32, 0x02cc, 0x0532, 0x0acc,
  0x0932, 0x06cc, 0x0132, 0x0ecc,
  0x0e32, 0x01cc, 0x0632, 0x09cc,
  0x0a32, 0x05cc, 0x0232, 0x0dcc,
  0x0c32, 0x03cc, 0x0432, 0x0bcc,
  0x0832, 0x07cc, 0x0032, 0x0fcc,
  0x0fd2, 0x002c, 0x07d2, 0x082c,
  0x0bd2, 0x042c, 0x03d2, 0x0c2c,
  0x0dd2, 0x022c, 0x05d2, 0x0a2c,
  0x09d2, 0x062c, 0x01d2, 0x0e2c,
  0x0ed2, 0x012c, 0x06d2, 0x092c,
  0x0ad2, 0x052c, 0x02d2, 0x0d2c,
  0x0cd2, 0x032c, 0x04d2, 0x0b2c,
  0x08d2, 0x072c, 0x00d2, 0x0f2c,
  0x0f52, 0x00ac, 0x0752, 0x08ac,
  0x0b52, 0x04ac, 0x0352, 0x0cac,
  0x0d52, 0x02ac, 0x0552, 0x0aac,
  0x0952, 0x06ac, 0x0152, 0x0eac,
  0x0e52, 0x01ac, 0x0652, 0x09ac,
  0x0a52, 0x05ac, 0x0252, 0x0dac,
  0x0c52, 0x03ac, 0x0452, 0x0bac,
  0x0852, 0x07ac, 0x0052, 0x0fac,
  0x0f92, 0x006c, 0x0792, 0x086c,
  0x0b92, 0x046c, 0x0392, 0x0c6c,
  0x0d92, 0x026c, 0x0592, 0x0a6c,
  0x0992, 0x066c, 0x0192, 0x0e6c,
  0x0e92, 0x016c, 0x0692, 0x096c,
  0x0a92, 0x056c, 0x0292, 0x0d6c,
  0x0c92, 0x036c, 0x0492, 0x0b6c,
  0x0892, 0x076c, 0x0092, 0x0f6c,
  0x0f12, 0x00ec, 0x0712, 0x08ec,
  0x0b12, 0x04ec, 0x0312, 0x0cec,
  0x0d12, 0x02ec, 0x0512, 0x0aec,
  0x0912, 0x06ec, 0x0112, 0x0eec,
  0x0e12, 0x01ec, 0x0612, 0x09ec,
  0x0a12, 0x05ec, 0x0212, 0x0dec,
  0x0c12, 0x03ec, 0x0412, 0x0bec,
  0x0812, 0x07ec, 0x0012, 0x0fec,
  0x0fe2, 0x001c, 0x07e2, 0x081c,
  0x0be2, 0x041c, 0x03e2, 0x0c1c,
  0x0de2, 0x021c, 0x05e2, 0x0a1c,
  0x09e2, 0x061c, 0x01e2, 0x0e1c,
  0x0ee2, 0x011c, 0x06e2, 0x091c,
  0x0ae2, 0x051c, 0x02e2, 0x0d1c,
  0x0ce2, 0x031c, 0x04e2, 0x0b1c,
  0x08e2, 0x071c, 0x00e2, 0x0f1c,
  0x0f62, 0x009c, 0x0762, 0x089c,
  0x0b62, 0x049c, 0x0362, 0x0c9c,
  0x0d62, 0x029c, 0x0562, 0x0a9c,
  0x0962, 0x069c, 0x0162, 0x0e9c,
  0x0e62, 0x019c, 0x0662, 0x099c,
  0x0a62, 0x059c, 0x0262, 0x0d9c,
  0x0c62, 0x039c, 0x0462, 0x0b9c,
  0x0862, 0x079c, 0x0062, 0x0f9c,
  0x0fa2, 0x005c, 0x07a2, 0x085c,
  0x0ba2, 0x045c, 0x03a2, 0x0c5c,
  0x0da2, 0x025c, 0x05a2, 0x0a5c,
  0x09a2, 0x065c, 0x01a2, 0x0e5c,
  0x0ea2, 0x015c, 0x06a2, 0x095c,
  0x0aa2, 0x055c, 0x02a2, 0x0d5c,
  0x0ca2, 0x035c, 0x04a2, 0x0b5c,
  0x08a2, 0x075c, 0x00a2, 0x0f5c,
  0x0f22, 0x00dc, 0x0722, 0x08dc,
  0x0b22, 0x04dc, 0x0322, 0x0cdc,
  0x0d22, 0x02dc, 0x0522, 0x0adc,
  0x0922, 0x06dc, 0x0122, 0x0edc,
  0x0e22, 0x01dc, 0x0622, 0x09dc,
  0x0a22, 0x05dc, 0x0222, 0x0ddc,
  0x0c22, 0x03dc, 0x0422, 0x0bdc,
  0x0822, 0x07dc, 0x0022, 0x0fdc,
  0x0fc2, 0x003c, 0x07c2, 0x083c,
  0x0bc2, 0x043c, 0x03c2, 0x0c3c,
  0x0dc2, 0x023c, 0x05c2, 0x0a3c,
  0x09c2, 0x063c, 0x01c2, 0x0e3c,
  0x0ec2, 0x013c, 0x06c2, 0x093c,
  0x0ac2, 0x053c, 0x02c2, 0x0d3c,
  0x0cc2, 0x033c, 0x04c2, 0x0b3c,
  0x08c2, 0x073c, 0x00c2, 0x0f3c,
  0x0f42, 0x00bc, 0x0742, 0x08bc,
  0x0b42, 0x04bc, 0x0342, 0x0cbc,
  0x0d42, 0x02bc, 0x0542, 0x0abc,
  0x0942, 0x06bc, 0x0142, 0x0ebc,
  0x0e42, 0x01bc, 0x0642, 0x09bc,
  0x0a42, 0x05bc, 0x0242, 0x0dbc,
  0x0c42, 0x03bc, 0x0442, 0x0bbc,
  0x0842, 0x07bc, 0x0042, 0x0fbc,
  0x0f82, 0x007c, 0x0782, 0x087c,
  0x0b82, 0x047c, 0x0382, 0x0c7c,
  0x0d82, 0x027c, 0x0582, 0x0a7c,
  0x0982, 0x067c, 0x0182, 0x0e7c,
  0x0e82, 0x017c, 0x0682, 0x097c,
  0x0a82, 0x057c, 0x0282, 0x0d7c,
  0x0c82, 0x037c, 0x0482, 0x0b7c,
  0x0882, 0x077c, 0x0082, 0x0f7c,
  0x0f02, 0x00fc, 0x0702, 0x08fc,
  0x0b02, 0x04fc, 0x0302, 0x0cfc,
  0x0d02, 0x02fc, 0x0502, 0x0afc,
  0x0902, 0x06fc, 0x0102, 0x0efc,
  0x0e02, 0x01fc, 0x0602, 0x09fc,
  0x0a02, 0x05fc, 0x0202, 0x0dfc,
  0x0c02, 0x03fc, 0x0402, 0x0bfc,
  0x0802, 0x07fc, 0x0002, 0x0ffc,
};

