
#include "kiconloader.h"
#ifdef DESKTOP_VERSION
#include <qdir.h>
#include <qapplication.h>

QPixmap KIconLoader::loadIcon( const QString& name, KIcon::Group, int,
                               int, QString *, bool ) const
{
    QPixmap pix;
    pix.load (  "./korganizer/" + name  );
    return pix;
}

QString KIconLoader::iconPath( const QString &, int )
{
  return QString::null;
}

QPixmap BarIcon( const QString &name )
{ 
    QPixmap pix;
    pix.load (  "./korganizer/" + name  );
    return pix;
  
}

QPixmap DesktopIcon( const QString &name, int )
{
  return SmallIcon( name );
}

#include <qmessagebox.h>
QPixmap SmallIcon( const QString &name )
{ 
    QPixmap pixmapLoader; 
    QString file;
#ifndef _WIN32_
    file =  qApp->applicationDirPath () + "/pics/";
#else
      file = qApp->applicationDirPath ()+ "\\pics\\";
#endif
    file +=  name+".png";
    pixmapLoader.load( file );
    return pixmapLoader;
  
}

QPixmap SmallIconSet( const QString &name )
{
  return SmallIcon( name );
}


#else

#include <qpe/resource.h>
QPixmap KIconLoader::loadIcon( const QString& name, KIcon::Group, int,
                               int, QString *, bool ) const
{
  return Resource::loadPixmap( "korganizer/" + name );
}

QString KIconLoader::iconPath( const QString &, int )
{
  return QString::null;
}

QPixmap BarIcon( const QString &name )
{
  return Resource::loadPixmap( "korganizer/" + name );
}

QPixmap DesktopIcon( const QString &name, int )
{
  return Resource::loadPixmap( "korganizer/" + name );
}

QPixmap SmallIcon( const QString &name )
{
  return Resource::loadPixmap( "korganizer/" + name );
}

QPixmap SmallIconSet( const QString &name )
{
  return Resource::loadPixmap( "korganizer/" + name );
}


#endif
