/*  This file is part of the KDE project
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2005 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kstdguiitem_h
#define __kstdguiitem_h

#include <qstring.h>
#include <klocale.h>

class KGuiItem : public QString
{
public:
    KGuiItem(const QString &text, const QString &iconName = QString::null);
};
 
class KStdGuiItem 
{
public:
    enum StdItem
    {
        Ok=1, Cancel, Yes, No, Discard, Save, DontSave, SaveAs,
        Apply, Clear, Help, Defaults, Close, Back, Forward, Print,
        Continue
    };

    static KGuiItem cont() 
        { return i18n("Continue"); }
    static KGuiItem cancel() 
        { return i18n("Cancel"); }
    static KGuiItem ok() 
        { return i18n("Ok"); }
    static KGuiItem yes() 
        { return i18n("Yes"); }
    static KGuiItem no() 
        { return i18n("No"); }
    // Needed by kdelibs 3.5
    static KGuiItem close() 
        { return i18n("Close"); }
};

inline 
KGuiItem::KGuiItem(const QString &text, const QString &) : QString(text)
{
}
#endif

