/*
 * Copyright (C) 1999,2000,2001 Carsten Pfeiffer <pfeiffer@kde.org>
 * Copyright (C) 2004 Fastweb SpA
 *
 * This file is part of the KDE project
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __kio_kurlrequester_h__
#define __kio_kurlrequester_h__
#include <klineedit.h>

#include <kurlcompletion.h>

class KURLCompletion;
// Dummy URLRequester to keep kdelibs 3.2 happy
class KURLRequester : public KLineEdit
{
public:
    KURLRequester(QWidget *parent, const char *name);
    KLineEdit *lineEdit();
    QString url() const;
    void setMode(unsigned int);
    KURLCompletion *completionObject() const;
private:
    KURLCompletion *myCompletion;
};

inline 
KURLRequester::KURLRequester(
	QWidget *parent, const char *name) : KLineEdit(parent, name)
{
	myCompletion = new KURLCompletion();
}

inline KLineEdit *
KURLRequester::lineEdit()
{
    return this;
}

inline QString
KURLRequester::url() const
{
	return text();
}

inline void
KURLRequester::setMode(unsigned int)
{
}

inline KURLCompletion *
KURLRequester::completionObject() const 
{ 
    return myCompletion; 
}

#endif // __kio_kurlrequester_h__

