/*
    This file is part of libkdepim.
    Copyright (c) 2004 Ulf Schenk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

/*
Enhanced Version of the file for platform independent KDE tools.
Copyright (c) 2004 Ulf Schenk

$Id: kpimglobalprefs.h,v 1.1 2004/08/10 16:10:42 ulf69 Exp $
*/

#ifndef KPIMGLOBALPREFS_H
#define KPIMGLOBALPREFS_H

#include "kprefs.h"

class KPimGlobalPrefs : public KPrefs
{
  public:

    static KPimGlobalPrefs *instance();


    virtual ~KPimGlobalPrefs();


    enum EMailClients {
      NONE_EMC = 0,
      OTHER_EMC = 1,
      OMPI_EMC = 2,
      QTOPIA_EMC = 3,
      OPIE_EMC = 4
    };

    enum PhoneClients {
      NONE_PHC = 0,
      OTHER_PHC = 1,
      KPPI_PHC = 2
    };

    enum FaxClients {
      NONE_FAC = 0,
      OTHER_FAC = 1
    };

    enum SMSClients {
      NONE_SMC = 0,
      OTHER_SMC = 1
    };

    enum PagerClients {
      NONE_PAC = 0,
      OTHER_PAC = 1
    };

  private:
    KPimGlobalPrefs( const QString &name = QString::null );

   static KPimGlobalPrefs *sInstance;


  public:
    int mEmailClient;
    QString mEmailOtherChannel;
    QString mEmailOtherMessage;
    QString mEmailOtherMessageParameters;
    QString mEmailOtherMessage2;
    QString mEmailOtherMessageParameters2;

    int mPhoneClient;
    QString mPhoneOtherChannel;
    QString mPhoneOtherMessage;
    QString mPhoneOtherMessageParameters;

    int mFaxClient;
    QString mFaxOtherChannel;
    QString mFaxOtherMessage;
    QString mFaxOtherMessageParameters;

    int mSMSClient;
    QString mSMSOtherChannel;
    QString mSMSOtherMessage;
    QString mSMSOtherMessageParameters;

    int mPagerClient;
    QString mPagerOtherChannel;
    QString mPagerOtherMessage;
    QString mPagerOtherMessageParameters;


};

#endif
