/*****************************************************************

Copyright (c) 2000 Bill Nagel

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __quicklauncher_h__
#define __quicklauncher_h__

#include <qstring.h>
#include <kpanelapplet.h>
#include <vector>

#include "quickbutton.h"
#include "flowgridmanager.h"

class QPopupMenu;
class QuickButtonGroup;

typedef QuickButtonGroup ButtonGroup;

class QuickLauncher: public KPanelApplet {
   Q_OBJECT
public:
   enum {DEFAULT_ICON_DIM=QuickButton::DEFAULT_ICON_DIM};
   enum {SIZE_AUTO=0};

   QuickLauncher(const QString& configFile, Type t = Normal, int actions = 0,
                 QWidget *parent = 0, const char *name = 0);
   ~QuickLauncher();
   int widthForHeight(int height) const;
   int heightForWidth(int width) const;
   void addApp(QString url,int index);
public slots:
   void addApp(QString url);
   void addAppBefore(QString url,QString sender);
   void removeApp(QuickButton *button);
   void removeApp(QString url);
   void removeApp(int index=-1);
   void about();
protected:

   int findApp(QString url);
   int findApp(QuickButton *button);

   void mousePressEvent(QMouseEvent *e);
   void resizeEvent(QResizeEvent*);
   void dragEnterEvent(QDragEnterEvent *e);
   void dragLeaveEvent(QDragLeaveEvent *e);
   void dragMoveEvent(QDragMoveEvent *e);
   void dropEvent(QDropEvent *e);
   void refreshContents();
   void setRefreshEnabled(bool enable);
   void setConserveSpace(bool conserve_space);
   void setDragEnabled(bool conserve_space);

   bool conserveSpace() const {return _manager->conserveSpace();}
   bool isDragEnabled() const {return _dragEnabled;}

   void buildPopupMenu();
   void saveConfig();
   void loadConfig();

   void mergeButtons(int index);
   void clearTempButtons();
   void updateMenus();
   int  dimension() const;

protected slots:
   void fillRemoveAppsMenu();
   void toggleLock(int val);
   void toggleConserveSpace(int val);
   void setIconDim(int idim);

protected:
   void _showButtons();
   std::vector<int> *_iconSizes;
   QPopupMenu *_popup;
   QPopupMenu *_appletPopup;
   QPopupMenu *_removeAppsMenu;
   QPopupMenu *_sizePopup;
   QuickButtonGroup *_buttons, *_newButtons, *_oldButtons, *_dragButtons;
   int _iconDim, _space, _border;
   QSize _buttonSize;
   FlowGridManager *_manager;
   int _dropLen, _dropPos, _minPanelDim;
   bool _dragEnabled, _dragAccepted, _refreshEnabled, _needsSave, _needsRefresh;
   int _lockMenuItem, _conserveMenuItem;
};

#endif
