/**************************************************************************************
//               INTEL CORPORATION PROPRIETARY INFORMATION
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Intel Corporation and may not be copied
//  or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2001 Intel Corporation. All Rights Reserved.
//
//  VSS:
//		$Workfile: oscr_xsc_mod.c $
//      $Revision: 1 $
//      $Date: 03-09-10 17:03 $
//      $Archive: /ipp_se/primitive/ipp4/ipp40/beta/cotulla/install/arm_linux/sample/OSCRTimer/oscr_xsc_mod.c $
//
//  Description:
//      OSCR performance timer device driver
//
/ *************************************************************************************
//
// Usage notes:
//
// 1. Compile using "arm-linux-gcc -DMODULE -D__KERNEL__ -Wall -O2 -c oscr_xsc_mod.c" 
// 2. Install lodable module using "insmod -f -o oscr oscr_xsc_mod.o"
// 3. Create symbolic device link using "mknod /dev/ixs_oscr c 59 0"
//
/ **************************************************************************************/

/* Standard definitions */
#include <linux/module.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/ioctl.h>
#include <asm/uaccess.h>
#include <asm/segment.h>

/* hardware.h should be used if it references appropriate CPU registers */
//#include <asm/hardware.h>

/* SA-1110 OSCR */
//#define		OSCR	(*((volatile Word *) io_p2v (0x900010)))

/* Cotulla OSCR */
/* The virtual address below should be replaced with an appropriate symbolic reference */
#define     io_p2v(x) (x)
//#define		OSCR	(*((unsigned int *) io_p2v (0xfca00010)))
#define		OSCR	(*((unsigned int *) io_p2v (0xf8a00010)))

/* Administratrivia */
 #ifndef OSCR_MAJOR
 #define OSCR_MAJOR 59
 #endif

 #ifndef COTULLA_OSCR_READ
 #define COTULLA_OSCR_READ 21
 #endif

/*
 *********************************************************************  
 * Function:  	cotulla_oscr_ioctl
 * Description: General ioctl routine.
 *********************************************************************
 */

int cotulla_oscr_ioctl(struct inode *inode, struct file * filp, 
					   unsigned int cmd, unsigned long arg)
{
	if (cmd==COTULLA_OSCR_READ)
	{	
		put_user(OSCR, (int *) arg);
		return(0); 
	}  
	else
		return(-EINVAL);
}

/*
 *********************************************************************  
 * Structure:  	file operations structure
 * Description: General I/O file operations functions.
 *********************************************************************
 */
 
#if 0
	struct file_operations oscr_fops = 
	{
		NULL,				/* oscr_lseek    */	
		NULL,				/* oscr_read     */
		NULL,				/* oscr_write    */
		NULL,				/* oscr_readdir  */
		NULL,				/* oscr_select   */
		cotulla_oscr_ioctl, /* oscr_ioctl    */
		NULL,				/* oscr_mmap     */
		NULL,				/* oscr_open     */
		NULL				/* oscr_release  */
 };
#endif
struct file_operations oscr_fops = 
{
	ioctl: cotulla_oscr_ioctl,		/* oscr_ioctl    */
};

/*
 *********************************************************************  
 * Function:  	init_oscr
 * Description: General I/O read initialization routine.
 *********************************************************************
 */
#ifdef MODULE
	int init_module(void)
#else
	int init_oscr (void)
#endif
{
	if (register_chrdev(OSCR_MAJOR,"oscr",&oscr_fops)) 
	{
		printk("oscr: unable to get major %d\n", OSCR_MAJOR);
		return -EIO;
	}
	else
		printk("oscr driver initialised\n");
	return 0;
 }

/*
 *********************************************************************  
 * Function:  	unregister_oscrdriver
 * Description: General I/O deregister routine.
 **********************************************************************
 */
 void unregister_oscrdriver(void)
 {
	 unregister_chrdev(OSCR_MAJOR,"oscr");
 }
 
 