/******************************************************************************
//             INTEL CORPORATION PROPRIETARY INFORMATION
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Intel Corporation and may not be copied
//  or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2001 Intel Corporation. All Rights Reserved.
//
//  VSS: 
//		$Workfile: vector.c $
//		$Revision: 1 $
//		$Date: 05-02-28 16:03 $
//
//  Description:
//		Vector manipulation examples 
//
//  History:
//		Date        Author		Changes
//		2001/10/26  Ted Painter	Created
******************************************************************************/

/* Standard IPP definitions */
#include <ippdefs.h>
#include <ippSP.h>

/* Interface */
#include "vector.h"

/* Fixed sinusoidal parameters */
#define		PHASE			0						/* 0, Q15 */
#define		LOG10			4716					/* for sf=-11 */

/* SNR computation parameters */
#define		LSF				4096				/* Scalefactor for ln() */
#define		LOGLSF			17035				/* ln(LSF)*2^sf (sf=11)

/* Random and tone generator states */
IppToneState_16s g_ToneState;
IppRandGaussState_16s g_GaussState;
int g_SNR;
int g_EnableNoise, g_EnableTone;
Ipp16s g_ToneAmplitude=DEFAULT_TONE_AMP, g_ToneFrq=DEFAULT_TONE_FRQ;

/* Adjust random signal parameters */
void SetNoiseSigma(int sigma)
{
	/* Establish 0-mean, 0 seed */
	ippsRandGaussInit_16s(&g_GaussState, 0, sigma, 0);
}

/* Adjust tone frequency */
void SetToneFrequency(Ipp16s frequency, int SampleRate)
{
	Ipp32s tmp;
	tmp=(frequency<<14)/(SampleRate/2);
	g_ToneFrq=tmp&0xffff;
	ippsToneInitQ15_16s(&g_ToneState, g_ToneAmplitude, g_ToneFrq, PHASE);
}

/* Adjust tone amplitude */
void SetToneAmplitude(Ipp16s a)
{
	g_ToneAmplitude=a;
	ippsToneInitQ15_16s(&g_ToneState,g_ToneAmplitude,g_ToneFrq,PHASE);
}

/* Generate signal */
void GenerateSignal(Ipp16s *signal, Ipp16s *noise, int length)
{
	Ipp32s NoiseEnergy, SignalEnergy;
	Ipp16s tmp;
	Ipp64s snr64;

	/* Generate signals, update SNR */
	ippsRandGauss_16s(noise,length,&g_GaussState);
	ippsNorm_L2_16s32s(noise,length,&NoiseEnergy);
	ippsToneQ15_16s(signal,length,&g_ToneState);
	ippsNorm_L2_16s32s(signal,length,&SignalEnergy);

	/* Mix as directed by state variables */
	if (!g_EnableTone)
		ippsZero_16s(signal,length);
	if (g_EnableNoise)
		ippsAdd_16s_I(noise,signal,length);

	/* Update SNR */
	if (NoiseEnergy!=0)
	{
		if (SignalEnergy>=NoiseEnergy)
		{
			g_SNR=SignalEnergy/NoiseEnergy;
			tmp=g_SNR&0xffff;
			ippsLn_16s_ISfs(&tmp,1,-11);
			g_SNR=((20*tmp)/LOG10);
		}
		/* Handle SigEng/NoiEng < 1 using log(ab)=log(a)+log(b)=>log(a)=log(ab)-log(b) */
		else
		{
			snr64=(Ipp64s)SignalEnergy*(Ipp64s)LSF/(Ipp64s)NoiseEnergy;
			g_SNR=snr64&0xffffffff;
			tmp=g_SNR&0xffff;
			ippsLn_16s_ISfs(&tmp,1,-11);
			tmp-=LOGLSF;
			g_SNR=((20*tmp)/LOG10);
		}
	}
	else
		g_SNR=100000;



}

void GetSNR(int *snr)
{
	*snr=g_SNR;
}

void SelectSignal(int type, int state)
{
	switch(type)
	{
		case TONE:
			g_EnableTone=state;
			break;
		case NOISE:
			g_EnableNoise=state;
			break;
	}
}

