/*
 * gdict Dictionary for UNIX
 * Copyright (C) 2003 Alexander Zapjagaev <frustum@frustum.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "about.h"

/*  
 */
static void about_destroy(GtkWidget *widget,GtkWidget **window) {
	gtk_widget_destroy(widget);
	*window = NULL;
}

/*   
 */
static void button_clicked(GtkWidget *widget,GtkWidget *window) {
	gtk_widget_destroy(window);
}

/*  
 */
void about_create(void) {
	static GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *label;
	GtkWidget *separator;
	GtkWidget *hbox;
	GtkWidget *button;
#ifdef HAVE_SYS_UTSNAME_H
	struct utsname utsbuf;
#endif
	char buf[1024];
	
	if(window) return;
	
	/* window */
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window),_("About"));
	gtk_window_set_policy(GTK_WINDOW(window),0,0,0);
	gtk_signal_connect(GTK_OBJECT(window),"destroy",
		GTK_SIGNAL_FUNC(about_destroy),&window);
	
	/* vbox */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER(window),10);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	
	/* label */
#ifdef HAVE_SYS_UTSNAME_H
	uname(&utsbuf);
	snprintf(buf,sizeof(buf),
		_("Dictionary for Unix\n\n"
		"(C) 2003-2004 Alexander Zaprjagaev <frustum@frustum.org>\n"
		"http://frustum.org\n\n"
		"GTK+ version %d.%d.%d\n"
		"Operating system: %s %s (%s)\n"),
		gtk_major_version,gtk_minor_version,gtk_micro_version,
		utsbuf.sysname,utsbuf.release,utsbuf.machine);
#else
	snprintf(buf,sizeof(buf),
		_("Dictionary for Unix\n\n"
		"(C) 2003-2004 Alexander Zaprjagaev <frustum@frustum.org>\n"
		"http://frustum.org\n\n"
		"GTK+ version %d.%d.%d\n"),
		gtk_major_version,gtk_minor_version,gtk_micro_version);
#endif
	label = gtk_label_new(buf);
	gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
	gtk_label_set_selectable(GTK_LABEL(label),TRUE);
	
	/* separator */
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,TRUE,0);
	
	/* hbox */
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,0);
	
	/* button */
	button = gtk_button_new_with_label(_("Continue"));
	gtk_box_pack_end(GTK_BOX(hbox),button,FALSE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
		GTK_SIGNAL_FUNC(button_clicked),window);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	
	gtk_widget_show_all(window);
}
