/***************************************************************************
 *                       Frame.h  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qpixmap.h>
#include <qpainter.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qapplication.h>
#include <stdio.h>

#define ALIGN_LEFT 0
#define ALIGN_CENTER 1
#define ALIGN_RIGHT 2
#define ALIGN_JUSTIFY 3

class Frame;
class QPainter;

struct pageWords {
    QString word;
    QString href;
    QFont font;
    QColor color;
    bool highlight;
    int width;
    int spaceWidth;
    int	x;
    bool img;
    double scaling; 
};

class Frame
{
    private:
	int width, height;
	int margin, upMargin, bottomMargin, spacing;
	int linePoints, spacePoints, wordsPoints,charsPoints,sumSpacePoints, spaceAdded;
	int indentPoints, maxFontHeight,lineHeight,rotation;
	double imageScaling;
	int lineAlign;
	int x,y;
	pageWords * wordsOnPage;
	int wordNumber;
	int wordStartNumber;
	int wordLineStartNumber[80];
	int wordCounterLines[80];
	int yAxis2Line[80];
	int maxLines;
	int linePointer;
	int tempCounter;
	int wordCounter;
	int wordToHighlight;
	bool lineIndent;
	bool frameCleared;
	QColor bgColor,penColor, highlightColor;
	QString href;
	QPixmap *frame, *scrolledFrame;
	QWMatrix matrix,scaleMatrix,fitMatrix;
	QPainter *painter;
	QFont font, defaultFont;
	QFontMetrics *fontMetrics;
	QString word;
	QPixmap *image,imageOrig,imageTrans;
	bool imageLoaded;
	int imageHeight;
	int imageWidth;
	int imgCounter;
	int imgPointer;
	QString imgFileName;
	QString imgAlt;
	QColor progressBarBgColor;
	QColor progressBarFgColor;
	QColor progressBarTextColor;
	int progressBarPercent;
	int progressBarPage;
	int progressBarPages;
	int progressBarHeight;
	bool progressBarVisible;
	bool progressBarPercentShow;

	void Frame::setLinepoints();
    public:
	Frame();
	~Frame();
	void	create();
	void	clear(bool);
	void	clearImage();
	void	setSize(int,int);
	bool	wordIn(QString);
	bool	imgIn(QString,QString,int);
	bool	processingImage();
	void	setWordProperties();
	void	highlightWord(int wordNumber);
	
	void	testHeightFit();
	bool	charIn(QChar);
	void	setMargin(int);
	void	setBottomMargin(int);
	void	setSpacing(int);
	void	setIndentPoints(int);
	void	setIndent(bool);
	bool	getIndent();
	void	setFont(QFont);
	void	applyFont();
	void	setPenColor(QColor);
	void	setBgColor(QColor);
	void	setHighlightColor(QColor);
	
	void	setLineAlign(int);
	void	setRotation(int);
	void	setDefaultFont(QFont);
	void	printLine();
	void	wordCounterUp();
	void	printWord(int, int, int);
	void	printPage(QPaintDevice *,int);
	int	getLineHeight();
	int	getPageHeight();
	void	setBold(bool);
	void	setItalic(bool);
	void	setFontSize(int);
	void	setFontFixedWidth(bool);
	void	setStrikeOut(bool);
	void	setUnderline(bool);
	void	setHref(QString);
	void	setImageScaling(double);
	bool	inBarArea(int);
	double	barPartForX(int);
	QString wordPropsForXY(int,int,int);

	bool pageComplete, wordAccepted, charAccepted, lineComplete, lineHeightFit;
	int imageHeightProcessed;
	void	setProgressBarVisible(bool, bool);
	void	setProgressBarHeight(int);
	void	setProgressBarProps(QColor,QColor,QColor,int,int,int);
	void	createScrollBuffer();
	void	destroyScrollBuffer();
	bool	newPage;
	bool	imageAsWord;
	bool	fakeBold;
};
