/*
	xresizewindow 0.0.1 - A small tool to resize other X11 windows,
	given their window name and new geometry.
	
	
	TODO:

	The X display is hardcoded as ":0". This should be settable as
	a command-line option or taken from the DISPLAY environment
	variable.
	
	Windows should be selectable by name or id, probably using a
	command-line option (--name or --id) like xwininfo does it.
	No need to have support for the root window. Resizing and
	moving the root window doesn't make much sense anyway.
	
	Currently, the geometry must be specified in full (including
	both width+height, as well as a position using positive
	coordinates). This should be relaxed so it can take the
	missing values from the window's current settings.
	
	Error checking is possibly incorrect.	
*/
   	

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

/*
 * Window_With_Name: routine to locate a window with a given name on a display.
 *                   If no window with the given name is found, 0 is returned.
 *                   If more than one window has the given name, the first
 *                   one found will be returned.  Only top and its subwindows
 *                   are looked at.  Normally, top should be the RootWindow.
 */

/* "borrowed" from xwininfo/dsimple.c */

Window Window_With_Name(dpy, top, name)
     Display *dpy;
     Window top;
     char *name;
{
	Window *children, dummy;
	unsigned int nchildren;
	int i;
	Window w=0;
	char *window_name;

	if (XFetchName(dpy, top, &window_name) && !strcmp(window_name, name))
	  return(top);

	if (!XQueryTree(dpy, top, &dummy, &dummy, &children, &nchildren))
	  return(0);

	for (i=0; i<nchildren; i++) {
		w = Window_With_Name(dpy, children[i], name);
		if (w)
		  break;
	}
	if (children) XFree ((char *)children);
	return(w);
}

#define REQUIRED_GEOMETRY_MASK (XValue | YValue | WidthValue | HeightValue | XNegative | YNegative)
#define REQUIRED_GEOMETRY (XValue | YValue | WidthValue | HeightValue)

int main(int argc, char **argv)
{
	Window window;
	Display *dpy;
	int geo, x, y;
	unsigned int width, height;
	
	if (argc < 3) {
		fprintf(stderr, "Usage: %s window-name geometry\n", argv[0]);
		exit(1);
	}
	
	geo = XParseGeometry(argv[2], &x, &y, &width, &height);
	if ((geo & REQUIRED_GEOMETRY_MASK) != REQUIRED_GEOMETRY) {
		fprintf(stderr, "Need a fully qualified, absolute geometry (eg. 320x240+20+40)\n");
		exit(1);
	}
	
	dpy = XOpenDisplay(":0");
	if (!dpy) {
		fprintf(stderr, "Cannot open display.\n");
		exit(1);
	}
	
	window = Window_With_Name(dpy, DefaultRootWindow(dpy), argv[1]);
	if (!window) {
		fprintf(stderr, "Cannot find a window by that name.\n");
		exit(1);
	}
	
	if (!XMoveResizeWindow(dpy, window, x, y, width, height)) {
		fprintf(stderr, "XMoveResizeWindow error?\n");
		exit(1);
	}
	
	XCloseDisplay(dpy);
	
	return 0;
}
