/* Associates a string with a function
 * Ben Lynn
 */
/*
Copyright (C) 2003 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdlib.h>
#include <string.h>

#include "jumptable.h"

typedef void (*funcptr)();
enum {
    jt_initsize = 8,
};


void jumptable_init(jumptable_ptr jt)
{
    jt->count = 0;
    jt->max = jt_initsize;
    jt->name = (char **) malloc(sizeof(char *) * jt->max);
    jt->function = (funcptr*) malloc(sizeof(funcptr) * jt->max);
}

void jumptable_free(jumptable_ptr jt)
{
    jt->count = 0;
    jt->max = 0;
    free(jt->name);
    free(jt->function);
}

void jumptable_add(jumptable_ptr jt, char *s, void (* function)())
{
    if (jt->count == jt->max) {
	//double the arrays
	char **newname;
	void (**newfunction)();

	jt->max *= 2;

	newname = (char **) malloc(sizeof(char *) * jt->max);
	newfunction = (funcptr *) malloc(sizeof(funcptr) * jt->max);

	newname = (char **) malloc(sizeof(char *) * jt->max);
	newfunction = (funcptr *) malloc(sizeof(funcptr) * jt->max);

	memcpy(newname, jt->name, jt->count * sizeof(char *));
	memcpy(newfunction, jt->function, jt->count * sizeof(funcptr));

	free(jt->name);
	free(jt->function);

	jt->name = newname;
	jt->function = newfunction;
    }
    jt->name[jt->count] = (char *) malloc(strlen(s) + 1);
    strcpy(jt->name[jt->count], s);
    jt->function[jt->count] = function;
    jt->count++;
}

void jumptable_execute(jumptable_ptr jt, char *s)
{
    int i;
    for (i=0; i<jt->count; i++) {
	if (!strcmp(s, jt->name[i])) {
	    jt->function[i]();
	    break;
	}
    }
}
