/*****************************************************************************
 * grab-dummy.c: dummy interface, for testing xdtv without a TV card
 *****************************************************************************
 * $Id: grab-dummy.c,v 1.5 2004/09/08 21:03:48 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2003 Alainjj
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * Original code:
 *
 *   (c) 1997,98 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <stdlib.h>

#include "config.h"
#include "strtab.h"
#include "grab.h"

/* prototypes */

static struct STRTAB norms[] = {
  {0,   "PAL"},
  {1,  "NTSC"},
  {2, "SECAM"},
  {-1, NULL}
};

static struct STRTAB inputs[] = {
  {0,   "Television"},
  {-1, NULL}
};

void *bufsnap = NULL;

static int
grab_open(struct device_t *device)
{
  return 0;
}

static int
grab_close ()
{
  return 0;
}


static int
grab_overlay (int x, int y, int width, int height, int format,
              struct OVERLAY_CLIP *oc, int count)
{
  return 0;
}


static void * get_img (video_fmt f, int width, int height)
{
  struct timeval tv;
  static long tpsprec=0;
  long tps,delay;
  
  int l=size_img(f,width,height);
  bufsnap=realloc(bufsnap,l);
  memset(bufsnap,17,l);
  /* simulate a 25 fps card with grab-v4l.c */
  gettimeofday (&tv, NULL);
  tps=1000000*tv.tv_sec+tv.tv_usec;
  delay=1000000/25-(tps-tpsprec);
  //printf("grab_scr %ld %ld %ld\n",tps,tpsprec,delay);
  if(tpsprec!=0 && delay>0) usleep(delay); 
  gettimeofday (&tv, NULL);
  tpsprec=1000000*tv.tv_sec+tv.tv_usec;
  videostampmin=videostampmax=tv.tv_usec/1000000.0+tv.tv_sec;
  return bufsnap;
}

static int fmt_available(video_fmt f) {
  return 1;
}

/* ---------------------------------------------------------------------- */

static int
grab_tune (unsigned long freq)
{
  return 0;
}

static int
grab_tuned ()
{
  return 1;
}

static int
grab_input (int input, int norm)
{
  return 0;
}

static int
grab_picture (int color, int bright, int hue, int contrast)
{
  return 0;
}

static int
grab_audio (int mute, int volume, int *mode)
{
  return 0;
}

static int is525(int norm) {
  return norm == 1;
}

static int issecam(int norm) {
  return norm == 2;
}

static void* get_buf(int i){
  return NULL;
}

struct GRABBER grab_dummy = {
  "dummy",
  norms, inputs,
  grab_open,
  grab_close,
  grab_overlay,
  fmt_available,
  get_img,
  grab_tune,
  grab_tuned,
  grab_input,
  grab_picture,
  grab_audio,
  is525,
  issecam,
  get_buf
};
