#include <qlistview.h>
#include <qfiledialog.h>
#include <qprocess.h>
#include <qcombobox.h>
#include <qtextview.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <qtimer.h>
#include <qregexp.h>
#include <qbutton.h>
#include <qpushbutton.h>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "config.h"
#include "pppdealer.h"

PPPDealer::PPPDealer(QWidget *parent, const char *name):
    PPPDealerBase(parent, name),isRunning(false),fConnected(false),firda(false)
{
    proc = new QProcess( this );
    connect( proc, SIGNAL(readyReadStderr()),
	    this, SLOT(readFromStderr()) );
    connect( proc, SIGNAL(readyReadStdout()),
	    this, SLOT(readFromStdout()) );
    connect( proc, SIGNAL(processExited()),
	    this, SLOT(pppdFinished()) );

    timer = new QTimer();
    connect( timer, SIGNAL(timeout()),
	    this, SLOT(timerEvent()));

    QDir d("/etc/ppp/peers");
    d.setFilter( QDir::Files );
    for (unsigned int i = 0; i < d.count(); i++)
	config_box->insertItem(d[i]);
    connect_button->setText(tr("Connect"));
}

PPPDealer::~PPPDealer()
{
}

void PPPDealer::readFromStdout()
{
    QString str = proc->readStdout();
    log_view->append( str );

    //qDebug(str);

    bool fail = false;

    if (str.find(QRegExp("\nlocal  IP address"))>=0) {
	connect_button->setText("Disconnect");
	fConnected = true;
	timer->start(1000);
	//qDebug("connected.");
	return;
    } else if (str.find(QRegExp("\nFailed"))>=0) {
	fail = true;
    } else if (str.find(QRegExp("\nNO DIALTONE"))>=0) {
	fail = true;
    } else if (str.find(QRegExp("\nNO CARRIER"))>=0) {
	fail = true;
    } else if (str.find(QRegExp("\nBUSY"))>=0) {
	fail = true;
    } else if (str.find(QRegExp("\nalarm"))>=0) {
	fail = true;
    } else if (str.find(QRegExp("\nFailed"))>=0) {
	fail = true;
    } else if (str.find(QRegExp("\nPAP authentication failed"))>=0) {
	fail = true;
    } else if (str.find(QRegExp("\nCHAP authentication failed"))>=0) {
	fail = true;
    }
    
    if (fail) {
	//qDebug("failed.");
	connect_button->setText("Connect");
	config_box->setEnabled(true);
	fConnected = false;
	if (firda) {
	    system("/etc/rc.d/init.d/irda stop");
	}
    }
}

void PPPDealer::timerEvent()
{
    QString d = "ppp";
    if ( !QFile::exists("/var/run/"+d+".pid") )
	d += "0";
    QFile pid("/var/run/"+d+".pid");
    if (!pid.exists()) {
	connect_button->setText("Connect");
	config_box->setEnabled(true);
	fConnected = false;
	timer->stop();
	if (firda) {
	    system("/etc/rc.d/init.d/irda stop");
	}
    }
}

void PPPDealer::readFromStderr()
{
    QString str = proc->readStderr();

    log_view->append( str );
}

void PPPDealer::pppdFinished()
{
    connect_button->setEnabled(true);
    config_box->setEnabled(true);
    isRunning = false;
}

void PPPDealer::connect_pressed()
{
    if (isRunning) return;

    if (fConnected) {
	QString d = "ppp";
	if ( !QFile::exists("/var/run/"+d+".pid") )
	    d += "0";
	QFile pid("/var/run/"+d+".pid");
	if ( pid.open(IO_ReadOnly) ) {
	    QString s(pid.readAll());
	    int p = s.toInt();
	    if ( p ) {
		kill(p,SIGTERM); // SIGHUP not enough for demand dialing pppd
		//system("cardctl suspend");
		//return;
	    }
	}
	if (firda) {
	    system("/etc/rc.d/init.d/irda stop");
	}
	connect_button->setText("Connect");
	config_box->setEnabled(true);
	fConnected = false;
	return;
    }
    
    //qDebug("Connect!");
    Config conf("Network-PPP-" + config_box->currentText());
    conf.setGroup("Properties");
    proc->clearArguments();
    proc->addArgument( "/usr/sbin/pppd" );
    proc->addArgument( "updetach" );
    proc->addArgument( conf.readEntry("device", "/dev/ttyS0"));
    proc->addArgument( "debug" );
    proc->addArgument( "call" );
    proc->addArgument( config_box->currentText() );
    proc->addArgument( "password" );
    proc->addArgument( "\"" + conf.readEntry("password") + "\"" );
    firda = conf.readBoolEntry("IrDA");
    if (firda) {
	system("/etc/rc.d/init.d/irda start");
	sleep(1);
    }

    if ( !conf.readBoolEntry("usepeerdns",TRUE) ) {
	QFile rc("/etc/ppp/resolv.conf");
	if ( rc.open(IO_WriteOnly) ) {
	    QTextStream stream(&rc);
	    for (int i=1; i<5; i++) {
		QString dns = conf.readEntry("dns"+QString::number(i));
		if ( !dns.isEmpty() )
		    stream << "nameserver " << dns << "\n";
	    }
	}
    }

    isRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	isRunning = false;
	if (firda) {
	    system("/etc/rc.d/init.d/irda stop");
	}
    } else {
	connect_button->setEnabled(false);
	config_box->setEnabled(false);
    }
}
