/*
 * Definitions for the System File Checker (Windows File Protection)
 *
 * Copyright 2006 Detlef Riekenberg
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __WINE_SFC_H
#define __WINE_SFC_H

#ifdef __cplusplus
extern "C" {
#endif

/* Types */

typedef struct _PROTECTED_FILE_DATA {
 WCHAR FileName[MAX_PATH];
 DWORD FileNumber;
} PROTECTED_FILE_DATA, *PPROTECTED_FILE_DATA;

/* Functions */

BOOL WINAPI SfcGetNextProtectedFile(HANDLE, PPROTECTED_FILE_DATA);
BOOL WINAPI SfcIsFileProtected(HANDLE, LPCWSTR);
BOOL WINAPI SfpVerifyFile(LPCSTR, LPSTR, DWORD);

#ifdef __cplusplus
}
#endif

#endif
