/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of the Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <qobjectlist.h>
#include <qwidgetstack.h>
#include <qwidgetlist.h>
#include <qscrollview.h>
#include <qtabwidget.h>

static void addScrollBars(QTabWidget* tw)
{
    // Put a scrollbar on every page.
    // Reasonably general. Works for QTabWidgets from Qt Designer.

    QWidgetStack* stack = (QWidgetStack*)tw->child(0,"QWidgetStack");

    const QObjectList *tabs = stack->children();
    if (tabs) {
	QObject *o;
	QWidgetList pages;
	QObjectListIt oi(*tabs);
	++oi; // skip QWidgetStackPrivate::Invisible
	for (; (o = *oi); ++oi) {
	    ASSERT(o->isWidgetType());
	    pages.append((QWidget*)o);
	}
	QWidget *w;
	QStringList pagelabs;
	QWidget *v = tw->currentPage();
	for (QWidgetListIt wi(pages); (w = *wi); ++wi) {
	    pagelabs.append(tw->tabLabel(w));
	    tw->removePage(w);
	}
	QStringList::ConstIterator li = pagelabs.begin();
	for (QWidgetListIt wi(pages); (w = *wi); ++wi) {
	    QScrollView* sv = new QScrollView(stack);
	    sv->setFrameStyle(QFrame::NoFrame);
	    sv->setResizePolicy(QScrollView::AutoOneFit);
	    sv->addChild(w);
	    tw->addTab(sv,*li); ++li;
	    if ( w == v )
		v = sv;
	}
	if ( v )
	    tw->showPage(v);
    }
}
