/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef WIDGETBOX_H
#define WIDGETBOX_H

#include "widgetbox_global.h"
#include "abstractwidgetbox.h"
#include "abstractformwindowmanager.h"

#include <QDomDocument>

class AbstractFormEditor;
class AbstractFormWindow;
class QStackedLayout;
class QDomElement;
class QEvent;
class QMenu;
class QAction;
class QActionGroup;
class WidgetCollectionModel;
class Scratchpad;
class WidgetBoxView;
class DomWidget;

class QT_WIDGETBOX_EXPORT WidgetBox : public AbstractWidgetBox
{
    Q_OBJECT

public:
    enum ViewMode { TreeMode, FormMode };

    WidgetBox(AbstractFormEditor *core, ViewMode mode = TreeMode, QWidget *parent = 0,
              Qt::WFlags flags = 0);
    virtual ~WidgetBox();

    AbstractFormEditor *core() const;

    virtual int categoryCount() const;
    virtual DomUI *category(int cat_idx) const;
    virtual int widgetCount(int cat_idx) const;
    virtual DomUI *widget(int cat_idx, int wgt_idx) const;

    virtual int addCategory(const QString &name, const QString &icon_file, DomUI *ui);
    virtual void removeCategory(int cat_idx);

    inline ViewMode viewMode() const { return m_mode; }
    void setViewMode(ViewMode mode);

private slots:
    void handleMousePress(const QDomElement &elt, const QRect &geometry, Qt::MouseButton button);
    void setViewMode(QAction *action);

private:
    AbstractFormEditor *m_core;
    WidgetCollectionModel *m_model;

    ViewMode m_mode;

    WidgetBoxView *m_view;

    QActionGroup *m_mode_action_group;
    QAction *m_tree_mode_action;
    QAction *m_form_mode_action;
};

#endif // WIDGETBOX_H
