/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the text module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QFONTDATABASE_H
#define QFONTDATABASE_H

#include "qwindowdefs.h"
#include "qstring.h"
#include "qfont.h"
#ifdef QT_COMPAT
#include "qstringlist.h"
#include "qlist.h"
#endif


#ifndef QT_NO_FONTDATABASE

class QStringList;
template <class T> class QList;
struct QFontDef;
class QFontEngine;

class QFontDatabasePrivate;

class Q_GUI_EXPORT QFontDatabase
{
public:
    static QList<int> standardSizes();

    QFontDatabase();

    QStringList families() const;
    QStringList families(QFont::Script) const;
    QStringList styles(const QString &) const;
    QList<int> pointSizes(const QString &, const QString & = QString::null);
    QList<int> smoothSizes(const QString &, const QString &);
    QString styleString(const QFont &);

    QFont font(const QString &, const QString &, int);

    bool isBitmapScalable(const QString &, const QString & = QString::null) const;
    bool isSmoothlyScalable(const QString &, const QString & = QString::null) const;
    bool isScalable(const QString &, const QString & = QString::null) const;
    bool isFixedPitch(const QString &, const QString & = QString::null) const;

    bool italic(const QString &, const QString &) const;
    bool bold(const QString &, const QString &) const;
    int weight(const QString &, const QString &) const;

    static QString scriptName(QFont::Script);
    static QString scriptSample(QFont::Script);

#ifdef QT_COMPAT
    inline QT_COMPAT QStringList families(bool) const;
    inline QT_COMPAT QStringList styles(const QString &, const QString &) const;
    inline QT_COMPAT QList<int> pointSizes(const QString &, const QString &, const QString &);
    inline QT_COMPAT QList<int> smoothSizes(const QString &, const QString &, const QString &);

    inline QT_COMPAT QFont font(const QString &, const QString &, int, const QString &);

    inline QT_COMPAT bool isBitmapScalable(const QString &, const QString &, const QString &) const;
    inline QT_COMPAT bool isSmoothlyScalable(const QString &, const QString &, const QString &) const;
    inline QT_COMPAT bool isScalable(const QString &, const QString &, const QString &) const;
    inline QT_COMPAT bool isFixedPitch(const QString &, const QString &, const QString &) const;

    inline QT_COMPAT bool italic(const QString &, const QString &, const QString &) const;
    inline QT_COMPAT bool bold(const QString &, const QString &, const QString &) const;
    inline QT_COMPAT int weight(const QString &, const QString &, const QString &) const;
#endif // QT_COMPAT

private:
    static QFontEngine *findFont(QFont::Script script, const QFontPrivate *fp,
                                  const QFontDef &request, int force_encoding_id = -1);

    static void createDatabase();

    static void parseFontName(const QString &name, QString &foundry, QString &family);

    friend struct QFontDef;
    friend class QFontPrivate;
    friend class QFontDialog;
    friend class QFontEngineLatinXLFD;

    QFontDatabasePrivate *d;
};

#ifdef QT_COMPAT
inline QStringList QFontDatabase::families(bool) const
{
    return families();
}

inline QStringList QFontDatabase::styles(const QString &family,
                                          const QString &) const
{
    return styles(family);
}

inline QList<int> QFontDatabase::pointSizes(const QString &family,
                                                  const QString &style ,
                                                  const QString &)
{
    return pointSizes(family, style);
}

inline QList<int> QFontDatabase::smoothSizes(const QString &family,
                                                   const QString &style,
                                                   const QString &)
{
    return smoothSizes(family, style);
}

inline QFont QFontDatabase::font(const QString &familyName,
                                  const QString &style,
                                  int pointSize,
                                  const QString &)
{
    return font(familyName, style, pointSize);
}

inline bool QFontDatabase::isBitmapScalable(const QString &family,
                                             const QString &style,
                                             const QString &) const
{
    return isBitmapScalable(family, style);
}

inline bool QFontDatabase::isSmoothlyScalable(const QString &family,
                                               const QString &style,
                                               const QString &) const
{
    return isSmoothlyScalable(family, style);
}

inline bool QFontDatabase::isScalable(const QString &family,
                                       const QString &style,
                                       const QString &) const
{
    return isScalable(family, style);
}

inline bool QFontDatabase::isFixedPitch(const QString &family,
                                         const QString &style,
                                         const QString &) const
{
    return isFixedPitch(family, style);
}

inline bool QFontDatabase::italic(const QString &family,
                                   const QString &style,
                                   const QString &) const
{
    return italic(family, style);
}

inline bool QFontDatabase::bold(const QString &family,
                                 const QString &style,
                                 const QString &) const
{
    return bold(family, style);
}

inline int QFontDatabase::weight(const QString &family,
                                  const QString &style,
                                  const QString &) const
{
    return weight(family, style);
}
#endif // QT_COMPAT

#endif // QT_NO_FONTDATABASE

#endif // QFONTDATABASE_H
