/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef DESIGNERAPP_H
#define DESIGNERAPP_H

#include <qapplication.h>

class QTcpServer;
class QTcpSocket;
class DesignerServer : public QObject
{
    Q_OBJECT
public:
    DesignerServer(QObject* parent);
    static void sendOpenRequest(int port, const QStringList &files);
    Q_UINT16 serverPort() const;
private slots:
    void handleNewConnection();
    void readFromClient();
    void socketClosed();
private:
    QTcpServer *m_server;
    QTcpSocket *m_socket;
};

class MainWindow;
class DesignerApplication : public QApplication
{
public:
    DesignerApplication(int &argc, char *argv[]);
    virtual ~DesignerApplication();
    void setMainWindow(MainWindow *mw);

protected:
    bool event(QEvent *ev);

private:
    MainWindow *mMainWindow;
};

#endif // DESIGNERAPP_H
